//HSC2      JOB ,'HSC',CLASS=A,MSGCLASS=H,                              00001052
//          NOTIFY=&SYSUID,MSGLEVEL=(1,1),REGION=8192K,TIME=1440        00002001
//*         /*ROUTE PRINT CARVM3/HSC                                    00003037
//*#################################################################### 00004001
//*         PROGRAM:   HSC2                                             00005001
//*         STEPS:     DB2 PRECOMPILE, CICS XLATE, COB2 COMPILE, LKED   00006001
//*         PURPOSE:   WITHDRAW DEPOSIT AND TRANSFER FROM ACCOUNT       00007001
//*         CUSTOMER:  IBM                                              00008001
//*#################################################################### 00009001
//DFHEITVL PROC SUFFIX=1$,INDEX='CICS330',INDEX2='CICS330',OUTC='*',    00009101
//       REG=2048K,LNKPARM='LIST,XREF',STUB='DFHEILIC',WORK=SYSDA       00009201
//*-------------------------------------------------------------------- 00009301
//TRN    EXEC PGM=DFHECP&SUFFIX,                                        00009401
//            PARM='COBOL2',                                            00009501
//            REGION=&REG                                               00009601
//STEPLIB  DD DSN=&INDEX2..SDFHLOAD,DISP=SHR                            00009701
//SYSPRINT DD SYSOUT=&OUTC                                              00009801
//SYSPUNCH DD DSN=&&SYSCIN,                                             00009901
//            DISP=(,PASS),UNIT=&WORK,                                  00010001
//            DCB=BLKSIZE=400,                                          00010101
//            SPACE=(400,(400,100))                                     00010201
//*-------------------------------------------------------------------- 00010301
//COB    EXEC PGM=IGYCRCTL,REGION=&REG,                                 00010401
//       PARM='NODYNAM,LIB,OBJECT,RENT,APOST,MAP,XREF,LIST'             00010501
//STEPLIB  DD DISP=SHR,DSN=IGY.V1R1M0.SIGYCOMP                          00010601
//SYSLIB   DD DSN=&INDEX..SDFHCOB,DISP=SHR                              00010701
//         DD DSN=&INDEX..SDFHMAC,DISP=SHR                              00010801
//         DD DSN=HSC.PGMLIB.SOURCE,DISP=SHR                            00010905
//SYSPRINT DD SYSOUT=&OUTC                                              00011001
//SYSIN    DD DSN=&&SYSCIN,DISP=(OLD,DELETE)                            00011101
//SYSLIN   DD DSN=&&LOADSET,DISP=(MOD,PASS),                            00011201
//            UNIT=&WORK,SPACE=(80,(250,100))                           00011301
//SYSUT1   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011401
//SYSUT2   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011501
//SYSUT3   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011601
//SYSUT4   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011701
//SYSUT5   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011801
//SYSUT6   DD UNIT=&WORK,SPACE=(460,(350,100))                          00011901
//SYSUT7   DD UNIT=&WORK,SPACE=(460,(350,100))                          00012001
//*-------------------------------------------------------------------- 00012101
//COPYLINK EXEC PGM=IEBGENER,COND=(7,LT,COB)                            00012201
//SYSUT1   DD DSN=&INDEX..SDFHCOB(&STUB),DISP=SHR                       00012301
//SYSUT2   DD DSN=&&COPYLINK,DISP=(NEW,PASS),                           00012401
//            DCB=(LRECL=80,BLKSIZE=400,RECFM=FB),                      00012501
//            UNIT=&WORK,SPACE=(400,(20,20))                            00012601
//SYSPRINT DD SYSOUT=&OUTC                                              00012701
//SYSIN    DD DUMMY                                                     00012801
//*-------------------------------------------------------------------- 00012901
//LKED   EXEC PGM=IEWL,REGION=&REG,                                     00013001
//            PARM='&LNKPARM',COND=(5,LT,COB)                           00013101
//SYSLIB   DD DSN=&INDEX2..SDFHLOAD,DISP=SHR                            00013201
//         DD DISP=SHR,DSN=IGY.V1R1M0.SIGYCOMP                          00013301
//         DD DSN=CEE.V1R3M0.SCEELKED,DISP=SHR                          00013401
//         DD DSN=DSNLNK.V3R1M0.SDSNLOAD,DISP=SHR                       00013501
//SYSLMOD  DD DSN=&INDEX2..SDFHLOAD,DISP=SHR                            00013601
//SYSUT1   DD UNIT=&WORK,DCB=BLKSIZE=1024,                              00013701
//            SPACE=(1024,(200,20))                                     00013801
//SYSPRINT DD SYSOUT=&OUTC                                              00013901
//SYSLIN   DD DSN=&&COPYLINK,DISP=(OLD,DELETE)                          00014001
//         DD DSN=&&LOADSET,DISP=(OLD,DELETE)                           00014101
//         DD DDNAME=SYSIN                                              00014201
//         PEND                                                         00014301
//*#################################################################### 00014401
//SQL      EXEC PGM=DSNHPC,PARM='HOST(COB2),XREF,SOURCE,FLAG(I),APOST'  00014501
//STEPLIB  DD  DSN=DSNLNK.V3R1M0.SDSNEXIT,DISP=SHR                      00014601
//         DD  DSN=DSNLNK.V3R1M0.SDSNLOAD,DISP=SHR                      00014701
//SYSPRINT DD  SYSOUT=*                                                 00014801
//SYSTERM  DD  SYSOUT=*                                                 00014901
//SYSUDUMP DD  SYSOUT=*                                                 00015001
//SYSUT1   DD  UNIT=SYSDA,SPACE=(TRK,(5,1))                             00015101
//SYSUT2   DD  UNIT=SYSDA,SPACE=(TRK,(5,1))                             00015201
//SYSLIB   DD  DSN=HSC.PGMLIB.SOURCE,DISP=SHR                           00015301
//DBRMLIB  DD  DSN=ABT.TPO3.CICS.DBRMLIB(HSC2),DISP=SHR                 00015401
//SYSCIN   DD  DSN=&&DB2OUT,DISP=(,PASS),SPACE=(TRK,(10,1)),            00015501
//             DCB=(RECFM=FB,LRECL=80,BLKSIZE=3120),UNIT=SYSDA          00015601
//SYSIN    DD  *                                                        00015701
       IDENTIFICATION DIVISION.                                         00015800
      *------------------------                                         00015900
       PROGRAM-ID. HSC2.                                                00016011
                                                                        00017000
      ********** HSC2 - SQL, CICS - COBOL ***************************** 00018000
      *                                                               * 00020000
      * MODULE NAME = HSC2                                            * 00030000
      *                                                               * 00040000
      * DESCRIPTIVE NAME = DB2  SAMPLE APPLICATION                    * 00050000
      *                    SQL                                        * 00060000
      *                    CICS                                       * 00070000
      *                    COBOL                                      * 00080000
      *                                                               * 00090000
      *                                                               * 00140000
      * FUNCTION = THIS MODULE PERFORMS THE WITHDRAN, DEPOSIT AND     * 00150000
      *            TRANSFER                                           * 00160000
      *                                                               * 00180000
      * NOTES =                                                       * 00190000
      *   DEPENDENCIES = CALLED BY HSC3                               * 00200000
      *   RESTRICTIONS = NONE                                         * 00210000
      *                                                               * 00220000
      *                                                               * 00230000
      * MODULE TYPE =                                                 * 00240000
      *    PROCESSOR   = DB2 PRECOMPILER,CICS TRANSLATOR,COBOL COMPILER 00250000
      *    MODULE SIZE = SEE LINK_EDIT                                * 00260000
      *    ATTRIBUTES  = REUSABLE                                     * 00270000
      *                                                               * 00280000
      * ENTRY POINT =  HSC2                                           * 00290000
      *    PURPOSE = SEE FUNCTION                                     * 00300000
      *                                                               * 00320000
      *    INPUT  = PARAMETERS EXPLICITLY PASSED TO THIS FUNCTION:    * 00330000
      *                                                               * 00340000
      *            SYMBOLIC LABEL/NAME = NONE                         * 00350000
      *            DESCRIPTION = NONE                                 * 00360000
      *                                                               * 00370000
      *    OUTPUT  = PARAMETERS EXPLICITLY RETURNED:                  * 00380000
      *                                                               * 00390000
      *             SYMBOLIC LABEL/NAME = NONE                        * 00400000
      *             DESCRIPTION = NONE                                * 00410000
      *                                                               * 00420000
      * EXIT-NORMAL = HSC3                                            * 00430000
      *                                                               * 00440000
      * EXIT-ERROR = HSC3                                             * 00450000
      *                                                               * 00460000
      *     RETURN CODE = NONE                                        * 00470000
      *                                                               * 00480000
      *     ABEND CODES = NONE                                        * 00490000
      *                                                               * 00500000
      *     ERROR-MESSAGES =  NONE                                    * 00510000
      *                                                               * 00520000
      * EXTERNAL REFERENCES =                                         * 00530000
      *   ROUTINES/SERVICES =  DSN8CC2                                * 00540000
      *                                                               * 00550000
      *   DATA-AREAS =                                                * 00560000
      *                                                               * 00660000
      *   CONTROL-BLOCKS =                                            * 00670000
      *       SQLCA             - SQL COMMUNICATION AREA              * 00680000
      *                                                               * 00690000
      * TABLES =                                                  *     00700000
      *        GUEST.NOVAPERM                                         * 00710000
      *        GUEST.NOVACUST                                         * 00711000
      *        GUEST.NOVAACCT                                         * 00712000
      *                                                               * 00713000
      * CHANGE-ACTIVITY = NONE                                        * 00720000
      *                                                               * 00730000
      *                                                               * 00740000
      *  *PSEUDOCODE*                                                 * 00750000
      *                                                               * 00760000
      *                                                               * 00910000
      *     END.                                                      * 00920000
      ***************************************************************** 00930000
       ENVIRONMENT DIVISION.                                            00980000
      *------------------------                                         00990000
                                                                        01000000
       DATA DIVISION.                                                   01010000
      *------------------------                                         01020000
       WORKING-STORAGE SECTION.                                         01030000
                                                                        01030100
      ***** EXEC SQL INCLUDE NOVAACCT END-EXEC ****                     01030223
      ***** EXEC SQL INCLUDE NOVACUST END-EXEC ****                     01030323
      ***** EXEC SQL INCLUDE NOVAPERM END-EXEC ****                     01030423
            EXEC SQL INCLUDE SQLCA    END-EXEC.                         01030507
                                                                        01031000
        01  WSTTRANSACTION.                                             01040006
            02  WSTCOMMAND        PICTURE X(10).                        01050000
            02  WSTACCTID1        PICTURE X(04).                        01070000
            02  WSTACCTID2        PICTURE X(04).                        01080000
            02  WSTUSERID         PICTURE X(04).                        01090000
            02  WSTPPIN           PICTURE X(06).                        01100016
            02  WSTAMOUNT         PICTURE S9(9)V9(2) COMP-3.            01110000
            02  WSTTYPE1          PICTURE X(10).                        01120000
            02  WSTBALANCE1       PICTURE S9(9)V9(2) COMP-3.            01130000
            02  WSTNAME1          PICTURE X(15).                        01140000
            02  WSTTYPE2          PICTURE X(10).                        01150000
            02  WSTBALANCE2       PICTURE S9(9)V9(2) COMP-3.            01160000
            02  WSTNAME2          PICTURE X(15).                        01170000
                                                                        01190000
       01  BDRCODE           PIC S9(3).                                 01191025
           88  OK            VALUE +0.                                  01192025
           88  NOTFND        VALUE +100.                                01193025
                                                                        01196025
       LINKAGE SECTION.                                                 01200000
       01  DFHCOMMAREA.                                                 01210000
           02  COMMAREA-FOR-TRANSACTION.                                01211000
               04  COMMAND        PICTURE X(10).                        01212006
               04  SSTATUS        PICTURE S9(8) COMP-3.                 01213043
               04  ACCTID1        PICTURE X(04).                        01214006
               04  ACCTID2        PICTURE X(04).                        01215006
               04  USERID         PICTURE X(04).                        01216006
               04  PPIN           PICTURE X(06).                        01217016
               04  AMOUNT         PICTURE S9(9)V9(2) COMP-3.            01218006
               04  TYPE1          PICTURE X(10).                        01219006
               04  BALANCE1       PICTURE S9(9)V9(2) COMP-3.            01219106
               04  NAME1          PICTURE X(15).                        01219206
               04  TYPE2          PICTURE X(10).                        01219306
               04  BALANCE2       PICTURE S9(9)V9(2) COMP-3.            01219406
               04  NAME2          PICTURE X(15).                        01219506
                                                                        01230000
       PROCEDURE DIVISION.                                              01240000
      *------------------------                                         01250000
                                                                        01260000
      **** EXEC SQL WHENEVER SQLERROR GO TO QUIT END-EXEC ****          01260231
      **** EXEC SQL WHENEVER SQLWARNING GO TO QUIT END-EXEC ***         01260331
                                                                        01260413
       MAINLINE-ROUTINE.                                                01261006
                                                                        01261142
           MOVE 0 TO SSTATUS.                                           01261242
                                                                        01261342
           EXEC CICS HANDLE CONDITION                                   01262006
                           ERROR(QUIT)                                  01263000
                END-EXEC.                                               01264006
           IF COMMAND = 'WITHDRAW'                                      01265006
              PERFORM WITHDRAW                                          01266006
                 THRU WITHDRAW-EXIT                                     01267006
           ELSE                                                         01268006
           IF COMMAND = 'DEPOSIT'                                       01269006
               PERFORM DEPOSIT                                          01269106
                  THRU DEPOSIT-EXIT                                     01269206
           ELSE                                                         01269306
           IF COMMAND = 'TRANSFER'                                      01269406
              PERFORM TRANSFER                                          01269529
                 THRU TRANSFER-EXIT.                                    01269629
                                                                        01269915
           PERFORM QUIT.                                                01270006
      *                                                                 01270137
       MAINLINE-ROUTINE-EXIT.                                           01270206
           EXIT.                                                        01270306
      *                                                                 01270437
       WITHDRAW.                                                        01270506
                                                                        01270600
           MOVE LOW-VALUES TO WSTTRANSACTION.                           01270718
                                                                        01271200
           EXEC SQL                                                     01271300
             SELECT A.*                                                 01271408
             INTO :WSTACCTID1, :WSTTYPE1, :WSTNAME1, :WSTBALANCE1       01271508
             FROM GUEST.NOVAACCT A, GUEST.NOVACUST B,                   01271608
                  GUEST.NOVAPERM C                                      01271708
             WHERE A.ACCTID = :ACCTID1 AND                              01271800
                   A.ACCTID = C.ACCTID AND                              01271900
                   B.CUSTID = :USERID AND                               01272000
                   C.CUSTID = B.CUSTID AND                              01272100
                   B.PIN = :PPIN                                        01272216
           END-EXEC.                                                    01272300
                                                                        01272425
           MOVE SQLCODE TO BDRCODE                                      01272543
           EVALUATE TRUE                                                01272643
             WHEN OK AND AMOUNT < WSTBALANCE1                           01272844
                     PERFORM WITHDRAW-UPDATE                            01272944
                     THRU WITHDRAW-UPDATE-EXIT                          01273044
                     MOVE 0 TO SSTATUS                                  01273148
             WHEN OK AND AMOUNT > WSTBALANCE1                           01273247
                     MOVE 2 TO SSTATUS                                  01273347
             WHEN NOTFND                                                01273444
                     MOVE 1 TO SSTATUS                                  01273544
             END-EVALUATE.                                              01273643
                                                                        01273743
                                                                        01273843
       WITHDRAW-EXIT.                                                   01273944
           EXIT.                                                        01274044
                                                                        01274144
       WITHDRAW-UPDATE.                                                 01274243
                                                                        01274343
             SUBTRACT AMOUNT FROM WSTBALANCE1                           01274444
             MOVE WSTBALANCE1 TO BALANCE1                               01274544
              EXEC SQL                                                  01274628
                UPDATE GUEST.NOVAACCT                                   01274728
                SET BAL = :WSTBALANCE1                                  01274828
                WHERE ACCTID = :WSTACCTID1                              01274928
              END-EXEC.                                                 01275043
                                                                        01275143
       WITHDRAW-UPDATE-EXIT.                                            01275243
            EXIT.                                                       01275344
                                                                        01275443
                                                                        01275500
                                                                        01275606
       DEPOSIT.                                                         01275707
                                                                        01275806
           MOVE LOW-VALUES TO WSTTRANSACTION.                           01275918
                                                                        01276018
           EXEC SQL                                                     01276118
             SELECT A.*                                                 01276218
             INTO :WSTACCTID1, :WSTTYPE1, :WSTNAME1, :WSTBALANCE1       01276336
             FROM GUEST.NOVAACCT A, GUEST.NOVACUST B,                   01276418
                  GUEST.NOVAPERM C                                      01276518
             WHERE A.ACCTID = :ACCTID1 AND                              01276636
                   A.ACCTID = C.ACCTID AND                              01276718
                   B.CUSTID = :USERID AND                               01276818
                   C.CUSTID = B.CUSTID AND                              01276918
                   B.PIN = :PPIN                                        01277018
           END-EXEC.                                                    01277118
                                                                        01277218
           MOVE SQLCODE TO BDRCODE                                      01277347
           EVALUATE TRUE                                                01277425
             WHEN OK                                                    01277647
                     PERFORM DEPOSIT-UPDATE                             01277747
                     THRU DEPOSIT-UPDATE-EXIT                           01277847
                     MOVE 0 TO SSTATUS                                  01277948
             WHEN NOTFND                                                01278047
                     MOVE 1 TO SSTATUS                                  01278147
           END-EVALUATE.                                                01278247
                                                                        01278347
       DEPOSIT-EXIT.                                                    01278447
           EXIT.                                                        01278547
                                                                        01278625
       DEPOSIT-UPDATE.                                                  01278747
                                                                        01278847
           COMPUTE WSTBALANCE1 = AMOUNT + WSTBALANCE1                   01278936
           MOVE WSTBALANCE1 TO BALANCE1                                 01279036
           EXEC SQL                                                     01279118
             UPDATE GUEST.NOVAACCT                                      01279218
             SET BAL = :WSTBALANCE1                                     01279336
             WHERE ACCTID = :WSTACCTID1                                 01279436
           END-EXEC.                                                    01279550
                                                                        01279647
       DEPOSIT-UPDATE-EXIT.                                             01279747
           EXIT.                                                        01279847
                                                                        01279947
                                                                        01280025
                                                                        01280106
       TRANSFER.                                                        01280206
                                                                        01280306
           MOVE LOW-VALUES TO WSTTRANSACTION.                           01280429
                                                                        01280536
      * ----- VERIFY THE FROM ACCOUNT ---------                         01280637
                                                                        01280736
           EXEC SQL                                                     01280829
             SELECT A.*                                                 01280929
             INTO :WSTACCTID1, :WSTTYPE1, :WSTNAME1, :WSTBALANCE1       01281029
             FROM GUEST.NOVAACCT A, GUEST.NOVACUST B,                   01281129
                  GUEST.NOVAPERM C                                      01281229
             WHERE A.ACCTID = :ACCTID1 AND                              01281329
                   A.ACCTID = C.ACCTID AND                              01281429
                   B.CUSTID = :USERID AND                               01281529
                   C.CUSTID = B.CUSTID AND                              01281629
                   B.PIN = :PPIN                                        01281729
           END-EXEC.                                                    01281829
                                                                        01281929
           MOVE SQLCODE TO BDRCODE                                      01282047
           EVALUATE TRUE                                                01282129
             WHEN OK AND AMOUNT < WSTBALANCE1                           01282230
                     PERFORM VERIFY-TO-ACCOUNT                          01282351
                     THRU VERIFY-TO-ACCOUNT-EXIT.                       01282451
                     MOVE SQLCODE TO BDRCODE                            01282551
                     EVALUATE TRUE                                      01282651
                                                                        01282751
      * ----- UPDATE THE ACCOUNTS ---------                             01282851
                                                                        01282951
                     WHEN OK AND AMOUNT < WSTBALANCE1                   01283051
                             PERFORM WITHDRAW-UPDATE                    01283151
                             THRU WITHDRAW-UPDATE-EXIT                  01283251
                             PERFORM TO-ACCOUNT-UPDATE                  01283351
                             THRU TO-ACCOUNT-UPDATE-EXIT                01283451
                             MOVE 0 TO SSTATUS                          01283551
             WHEN OK AND AMOUNT > WSTBALANCE1                           01283651
                     MOVE 2 TO SSTATUS                                  01283751
             WHEN NOTFND                                                01283851
                     MOVE 1 TO SSTATUS                                  01283951
             END-EVALUATE.                                              01284051
                                                                        01284136
       TRANSFER-EXIT.                                                   01284251
           EXIT.                                                        01284351
                                                                        01284451
      * ----- VERIFY THE TO ACCOUNT ---------                           01284536
                                                                        01284636
       VERIFY-TO-ACCOUNT.                                               01284751
                                                                        01284851
           EXEC SQL                                                     01284929
             SELECT A.*                                                 01285029
             INTO :WSTACCTID2, :WSTTYPE2, :WSTNAME2, :WSTBALANCE2       01285129
             FROM GUEST.NOVAACCT A, GUEST.NOVACUST B,                   01285229
                  GUEST.NOVAPERM C                                      01285329
             WHERE A.ACCTID = :ACCTID2 AND                              01285429
                   A.ACCTID = C.ACCTID AND                              01285529
                   B.CUSTID = :USERID AND                               01285629
                   C.CUSTID = B.CUSTID AND                              01285729
                   B.PIN = :PPIN                                        01285829
           END-EXEC.                                                    01285951
                                                                        01286051
       VERIFY-TO-ACCOUNT-EXIT.                                          01286151
           EXIT.                                                        01286251
                                                                        01286351
      * ----- UPDATE THE TO ACCOUNT ---------                           01286437
                                                                        01286536
       TO-ACCOUNT-UPDATE.                                               01286651
                                                                        01286751
           COMPUTE WSTBALANCE2 = AMOUNT + WSTBALANCE2                   01286829
           MOVE WSTBALANCE2 TO BALANCE2                                 01286929
           EXEC SQL                                                     01287129
             UPDATE GUEST.NOVAACCT                                      01287229
             SET BAL = :WSTBALANCE2                                     01287329
             WHERE ACCTID = :WSTACCTID2                                 01287429
           END-EXEC.                                                    01287551
                                                                        01287629
       TO-ACCOUNT-UPDATE-EXIT.                                          01287751
           EXIT.                                                        01287851
                                                                        01287951
                                                                        01288629
                                                                        01290006
       QUIT.                                                            01610106
                                                                        01610206
           EXEC CICS RETURN                                             01610406
                END-EXEC.                                               01610506
           GOBACK.                                                      01610618
      *                                                                 01610715
//*-------------------------------------------------------------------- 01611001
//CICS     EXEC DFHEITVL,INDEX='CICS.V3R3M0',INDEX2='CICS.V3R3M0'       01612001
//TRN.SYSIN    DD DSN=&&DB2OUT,DISP=(OLD,DELETE)                        01613001
//LKED.SYSLMOD DD DISP=SHR,DSN=ABT.DEV.LOADLIB                          01614052
//LKED.SYSIN   DD *                                                     01615001
  INCLUDE SYSLIB(DSNCLI)                                                01616001
  NAME HSC2(R)                                                          01617010
/*                                                                      01618001
//********************************************************************* 01619001
//*        BIND                                                       * 01620001
//********************************************************************* 01630001
//BIND     EXEC PGM=IKJEFT01,COND=(4,LT)                                01640001
//STEPLIB  DD  DSN=DSNLNK.V3R1M0.SDSNEXIT,DISP=SHR                      01650001
//         DD  DSN=DSNLNK.V3R1M0.SDSNLOAD,DISP=SHR                      01660001
//DBRMLIB  DD  DSN=ABT.TPO3.CICS.DBRMLIB,DISP=SHR                       01670001
//SYSPRINT DD  SYSOUT=*                                                 01680001
//SYSTSPRT DD  SYSOUT=*                                                 01690001
//SYSUDUMP DD  SYSOUT=*                                                 01700001
//SYSIN    DD  DUMMY                                                    01710001
//SYSTSIN  DD  *                                                        01720001
  DSN S(DSN)                                                            01730001
  BIND PLAN(HSC2) MEMBER(HSC2,NOVABANK) ACTION(REP) RETAIN ISOLATION(CS)01740035
  END                                                                   01750001
//********************************************************************* 01760001
//*        GRANT                                                      * 01770001
//********************************************************************* 01780001
//GRANT    EXEC PGM=IKJEFT01,COND=(4,LT)                                01790001
//STEPLIB  DD  DSN=DSNLNK.V3R1M0.SDSNEXIT,DISP=SHR                      01800001
//         DD  DSN=DSNLNK.V3R1M0.SDSNLOAD,DISP=SHR                      01810001
//         DD  DISP=SHR,DSN=DSNC310.RUNLIB.LOAD                         01820001
//         DD  DISP=SHR,DSN=PLI.V2R3M0.SIBMLINK                         01830001
//         DD  DISP=SHR,DSN=PLI.V2R3M0.PLILINK                          01840001
//DBRMLIB  DD  DSN=ABT.TPO3.CICS.DBRMLIB,DISP=SHR                       01850001
//SYSPRINT DD  SYSOUT=*                                                 01860001
//SYSTSPRT DD  SYSOUT=*                                                 01870001
//SYSUDUMP DD  SYSOUT=*                                                 01880001
//SYSTSIN  DD  *                                                        01890001
  DSN SYSTEM(DSN)                                                       01900001
  RUN PROGRAM(DSNTEP2)  PLAN(DSNTEP31)                                  01910001
//SYSIN    DD  *                                                        01920001
  GRANT EXECUTE ON PLAN HSC2 TO PUBLIC;                                 01930001
/*                                                                      01940001
