"=======================================================================
	Execute the following code to create the figures table used in the examples below
======================================================================="

	| sqlca |

	{exec sql create table figures 
		(	name				char(20) ,
			sides	 			smallint) }
	(sqlca sqlcode < 0) ifTrue: [sqlca halt].


"	| sqlca | {exec sql drop table figures }  "

"========================================================================
	 Execute the following code to fill the figures table used in the examples below.
========================================================================="

	| sqlca figures n i |

	{shape 
		n	char(20) ,
		i	smallint }

	figures := OrderedCollection new
					add: (Association key: 'Triangle'			value: 3);
					add: (Association key: 'Square'			value: 2);
					add: (Association key: 'Pentagon'		value: 5);
					add: (Association key: 'Rhombus'		value: 4);
					add: (Association key: 'Heptahedron'	value: 7);
					yourself.

	{exec sql delete from figures}
	(sqlca sqlcode < 0) ifTrue: [sqlca halt].

	figures do: [ :assoc |
		n := assoc key.
		i := assoc value.
		{exec sql insert into figures (name , sides) values( :n , :i ) }
		].
	
"=========================================================================
	 Execute the following code to query the figures table.
=========================================================================="

	| sqlca n i ws |

	{shape 
		n	char(20) ,
		i	smallint }

	{exec sql declare csr1 cursor for select name , sides from figures where sides > :i }

	ws := EtWorkspace new open.
	i := 1.
	{exec sql open csr1 using :i }
	(sqlca sqlcode < 0) ifTrue: [sqlca halt].

	{exec sql fetch csr1 into :n , :i}
	[sqlca sqlcode = 100] whileFalse: [ 

		ws cr; show: i printString,'	',n.

		{exec sql fetch csr1 into :n , :i}
		].

	ws resetTextChangeFlag.
	{exec sql close csr1 }


"=========================================================================
	 Execute the following code to update the figures table.
========================================================================="

	| sqlca n i ws |

	{shape 
		n	char(20) ,
		i	smallint }

	i := 4.
	n := 'Square'.

	{exec sql update figures set sides = :i where name = :n }
	(sqlca sqlcode < 0) ifTrue: [sqlca halt].


"=========================================================================
	 Display the following code to see the number of sides for a heptahedron .
========================================================================="

	| sqlca n i |

	{shape 
		n	char(20) ,
		i	smallint }

	n := 'Heptahedron'.

	{exec sql select sides into :i from figures where name = :n }
	(sqlca sqlcode < 0) ifTrue: [sqlca halt].
	i
