
/*
 * NAME:        abtmfmt.h - Declarations for Sample abtmfmt code
 * VERSION:     1.0
 *
 * COPYRIGHT:
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1993, 2000
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *
 *
 * DESCRIPTION: This header provides the declarations required by
 *              the sample abtmfmt code.
 */

#ifndef CICSMFMT_H

#define CICSMFMT_H                      /* prevent recursive inclusion  */


#include <cicstype.h>			          /* CICS-supplied typedefs             */
#include "abt_tdq.h"                    /* Queue record                  13171*/
#include <cics_samples.h>               /* CICS-supplied macro definitions    */

/*
 * The most/least significant 32-bits of a 64 bit quantity such as cics_uxlong_t will
 * depend on the big/little endian nature of the machine. The following #defines are
 * used to allow generic source code to be used for both instances.
 */

#ifdef BIG_ENDIAN
#  define MSL                     Low
#  define LSL                     High
#else
#  define MSL                     High
#  define LSL                     Low
#endif


/*
 * OBJECT: CICS_MFMT_Stream (stream) - Monitoring File Stream Structure
 */

struct CICS_MFMT_Stream
{
    int FileHandle;
    size_t CurrentSize;
    size_t MaxSize;
    CICS_EMP_TDQ_RecordDetails_t *FileBuffer;
};

typedef struct CICS_MFMT_Stream CICS_MFMT_Stream_t;

/*
 * DESCRIPTION:
 * This structure is used by the MFMT functions to access the current
 * Monitoring record/file.
 * :ul.
 * :li.
 * :hp2.FileHandler:ehp2. -  The File Descriptor returned by :hp2.open:ehp2.
 * when the file was opened.
 * :li.
 * :hp2.CurrentSize:ehp2. - The size of the current record.
 * :li.
 * :hp2.MaxSize:ehp2. - The maximum record size which has been read.  This
 * defines the amount of memory :hp4.malloc:ehp4.'ed for the
 * :hp2.CICS_EMP_TDQ_RecordDetail:ehp2. structure.
 * :li.
 * :hp2.FileBuffer:ehp2. - The current record.
 * :eul.
 */

/*
 * OBJECT: CICS_MFMT_Status (status)
 * Return codes from :hp2.CICS_MFMT_ReadNext:ehp2.
 * and :hp2.CICS_MFMT_OpenMonitorFile:ehp2..
 */

enum CICS_MFMT_Status
{
    CICS_MFMT_STATUS_OK,                /* Function successful          */
    CICS_MFMT_STATUS_EOF,               /* End of file detected         */
    CICS_MFMT_STATUS_SYS_ERROR,         /* I/O or memory failure        */
    CICS_MFMT_STATUS_FILE_EOF,          /* Unexpected end of file       */
    CICS_MFMT_STATUS_FILE_ERROR         /* Invalid file format          */
};

/*
 * DESCRIPTION:
 * This enum defines the return status from :hp2.CICS_MFMT_ReadNext:ehp2. and
 * :hp2.CICS_MFMT_OpenMonitorFile:ehp2. as follows:
 * :ul.
 * :li.
 * :hp2.CICS_MFMT_STATUS_OK:ehp2. - function completed successfully;
 * :li.
 * :hp2.CICS_MFMT_STATUS_EOF:ehp2. - the end of the file was detected;
 * :li.
 * :hp2.CICS_MFMT_STATUS_SYS_ERROR:ehp2. - a system error (I/O error or out
 * of memory) was detected.  The global variable, :hp2.errno:ehp2. contains
 * the &os. error code.
 * :li.
 * :hp2.CICS_MFMT_STATUS_FILE_EOF:ehp2. - the function unexpectedly
 * detected end of file.  This normally indicates a short file.
 * :li.
 * :hp2.CICS_MFMT_STATUS_FILE_ERROR:ehp2. - the function read a record
 * whose header does not match that of monitoring records.
 * :eul.
 */

#if !defined(TRUE)
#define TRUE (1==1)
#endif

#if !defined(FALSE)
#define FALSE (!TRUE)
#endif

#if defined(MFMT_DEBUG_ON)
#define MFMT_DEBUG(x) printf("TRACE: "); printf x
#else
#define MFMT_DEBUG(x)
#endif

/*
 * Function Prototypes:
 */

CICS_EMP_TDQ_RecordDetails_t *CICS_MFMT_FindField(cics_ulong_t,
                                                  CICS_MFMT_Stream_t *);
enum CICS_MFMT_Status CICS_MFMT_ReadNext(CICS_MFMT_Stream_t *);
CICS_MFMT_Stream_t *CICS_MFMT_OpenMonitorFile(cics_char_t *, enum CICS_MFMT_Status *);
int CICS_MFMT_CloseMonitorFile(CICS_MFMT_Stream_t *);

#define CICS_MFMT_GetMessage(MessageNumber, SetNumber) \
strdup((CICS_MFMT_MessageArray[(SetNumber)])[(MessageNumber)])

#define CICS_MFMT_FreeMessage(Message)  free((void *)Message)

#define CICS_MFMT_ReleaseCatalogue()

#endif

