
/*
 * NAME:        abt_msg.h - Declarations for Sample cicsmfmt msg catalogue
 * VERSION:     1.0
 *
 * COPYRIGHT:
 *
 *   (C) COPYRIGHT International Business Machines Corp. 1993, 2000
 *   All Rights Reserved
 *   Licensed Materials - Property of IBM
 *
 *   US Government Users Restricted Rights - Use, duplication or
 *   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *
 *
 * DESCRIPTION: This header provides the message catalogue declarations
 *              required by the sample abtmfmt code.
 *
 */

#ifndef _H_CICSMFMT_MSG

#define _H_CICSMFMT_MSG


#include <limits.h>

#define CICS_MFMT_ERROR_SET     0
#define CICS_MFMT_FIELD_SET     1
#define CICS_MFMT_REPORT_SET    2

/*
 * DESCRIPTION:
 * The message catalogue definitions for cicsmfmt.
 * :ul.
 * :li. :hp2.CICS_MFMT_ERROR_SET:ehp2. - Error message message set;
 * :li. :hp2.CICS_MFMT_FIELD_SET:ehp2. - Field ID Description message set;
 * :li. :hp2.CICS_MFMT_REPORT_SET:ehp2. - Sample report header/footer text set.
 * :eul.
 */

/* definitions for set 0 - cicsmfmt Error messages */

#define ERZ065001E                1
#define ERZ065002E                2
#define ERZ065003E                3
#define ERZ065004E                4
#define ERZ065005E                5

static cics_char_t *CICS_MFMT_ErrorMessages[] =
{
    NULL,
    "ERZ065001E: usage: %s [ -? ] filename",
    "ERZ065002E: Cannot open Monitoring Data file <%s>",
    "ERZ065003E: Monitoring Data file <%s> - read error",
    "ERZ065004E: Monitoring Data file <%s> - unexpected EOF",
    "ERZ065005E: Monitoring Data file <%s> - invalid monitoring queue"
};

static cics_char_t *CICS_MFMT_FieldNames[] =
{
    "Transaction ID",
    "Terminal ID",
    "Operator ID",
    "Transaction Type",
    "Recording start time",
    "Recording stop time",
    "Elapsed time whilst task was executing",
    "CPU time used by task",
    "Elapsed time waiting for Terminal I/O.",
    "Elapsed time waiting for Journal I/O",
    "Elapsed time waiting for Temporary Storage I/O",
    "Elapsed time in Terminal Manager.",
    "System time in Terminal Manager.",
    "Elapsed time in Transaction scheduler.",
    "Elapsed time during which voluntarily suspended",
    "Non IO Page fault count",
    "IO Page fault count",
    "TCA Sequence number",
    "Maximum Data Segment size",
    "Primary Terminal Facility message in count",
    "Primary Terminal Facility message out count",
    "File GET count",
    "File PUT count",
    "File BROWSE count",
    "File ADD count",
    "File DELETE count",
    "Transient Data GET count",
    "Transient Data PUT count",
    "Transient Data PURGE count",
    "Temporary Storage GET count",
    "Auxiliary Temporary Storage PUT count",
    "Main Temporary Storage PUT count",
    "BMS MAP count",
    "BMS IN count",
    "BMS OUT count",
    "GETMAIN requests count",
    "LINK requests count",
    "XCTL requests count",
    "LOAD requests count",
    "Journal output requests count",
    "START/INITIATE requests count",
    "SYNCPOINT requests count",
    "Swap Out count",
    "Elapsed time waiting for File I/O",
    "Task Condition flags",
    "Alternate Terminal Facility message in count",
    "Alternate Terminal Facility message out count",
    "Program name",
    "Primary Terminal Facility characters in count",
    "Primary Terminal Facility characters out count",
    "Alternate Terminal Facility characters in count",
    "Alternate Terminal Facility characters out count",
    "Maximum Text Segment size",
    "Total memory released",
    "User ID",
    "Total BMS requests",
    "Total Transient Data requests",
    "Total Temporary Storage requests",
    "Total File requests",
    "Elapsed time waiting for memory to be released",
    "The Data Segment occupancy",
    "Elapsed time in CICS space",
    "Originating System or Local Terminal name",
    "Unit of Work ID",
    "Elapsed time waiting for Transient Data IO",
    "Elapsed time waiting for Temporary Storage/Memory",
    "Text Segment occupancy",
    "Transaction priority",
    "Record Type",
    "First abend code recorded",
    "The most recent abend code",
    "Elapsed time waiting for program load",
    "Elapsed time in File manager",
    "Total FREEMAIN requests",
    "Total memory obtained via GETMAIN requests",
    "Elapsed time waiting on SNA link",
    "Elapsed time waiting on TCP/IP link",
    "ISC messages received count",
    "ISC messages send count",
    "Task CPU time",
    "Voluntary Context Switch count",
    "Involuntary Context Switch count",
    "Signals received count",
    "File system I/O actions count",
    "System/User time in CICS space"
};

/* definitions for set 2 - cicsmfmt sample report header/footers */

#define CICS_MFMT_NO_TEXT       0
#define CICS_MFMT_SRF_FILE      1
#define CICS_MFMT_SRF_DATE      2
#define CICS_MFMT_SRF_PAGE      3
#define CICS_MFMT_SRH_NAME      4
#define CICS_MFMT_SRH_DATE      5
#define CICS_MFMT_SRH_START     6
#define CICS_MFMT_SRH_END       7
#define CICS_MFMT_SRH_FILE      8
#define CICS_MFMT_SRH_REQUEST   9
#define CICS_MFMT_SRH_ELAPSED   10
#define CICS_MFMT_SRH_DATA      11
#define CICS_MFMT_SRH_OCCUPANCY 12
#define CICS_MFMT_SRH_ABEND     13
#define CICS_MFMT_SRH_CODE      14
#define CICS_MFMT_SRH_TRANID    15
#define CICS_MFMT_SRH_TERMID    16
#define CICS_MFMT_SRH_PROGID    17
#define CICS_MFMT_SRH_COUNTER	18
#define CICS_MFMT_ENTRYNAME		19
#define CICS_MFMT_CLOCK1		20
#define CICS_MFMT_CLOCK2		21
#define CICS_MFMT_CLOCK3		22
#define CICS_MFMT_CLOCK4		23
#define CICS_MFMT_CLOCK5		24
#define CICS_MFMT_COUNTERS		25
#define CICS_MFMT_COUNTERS2		26

static cics_char_t *CICS_MFMT_ReportHeaders[] =
{
    NULL,
    "Monitoring Filename: ",
    "Last written on %.2d/%.2d/%.2d at %.2d:%.2d:%.2d",
    "Page: ",
    "CICS Event Monitoring Sample Report",
    "Date: %.2d/%.2d/%.2d",
    "Start Time",
    "End Time",
    "File I/O",
    "Request",
    "Elapsed Time",
    "Data Segment",
    "Occupancy",
    "First ABEND",
    "Code",
    "Transaction Id",
    "Terminal Id",
    "Program Id",
	"Counter",
	"Entry Name",
	"Clock 1 Value",
	"Clock 2 Value",
	"Clock 3 Value",
	"Clock 4 Value",
	"Clock 5 Value",
	"-1-   -2-   -3-"
	"   -4-   -5-"
};

static cics_char_t **CICS_MFMT_MessageArray[] =
{
    CICS_MFMT_ErrorMessages,
    CICS_MFMT_FieldNames,
    CICS_MFMT_ReportHeaders
};

#endif


