
#ifndef espriv_h
#define espriv_h

#define	EsLowBit(o)		(((U_32) (o)) & 1)
#define	EsLow2Bits(o)		(((U_32) (o)) & 3)
#define	EsLow4Bits(o)		(((U_32) (o)) & 15)
#define	EsTagSmallInteger	1
#define	EsTagCharacter		6
#define	EsShiftSmallInteger	1
#define	EsShiftCharacter	4
#define	EsFlags(o)		(((EsObject) (o))->flags)
#define	EsReadOnlyBit		0x80000000
#define	EsIndexableBit		1
#define	EsObjectData(o)		((EsObject *) (((EsObject) (o)) + 1))
#define	EsSmallestSmallInteger	(-1073741824)
#define	EsLargestSmallInteger	1073741823
#define	EsPrivateClass(o)	((EsBehavior) ((o)->class))
#define	EsPrivateSize(o)	((o)->size)
#define	EsRegistryClass(vm, class)	((EsBehavior) ((vm)->registry->class->value))
#define	EsPrivateInstSize(o)	((U_32) EsSmallIntegerToI32(EsPrivateClass(o)->namedInstVarSize))
#define	EsVMClass(vm, cl)	((EsBehavior) ((vm)->cl))
#define	EsPrivateHash(o)	((EsFlags(o) >> 16) & 0x7FFF)

/* For C JNI */

#define	EsCurrentJavaException(vmContext) ((vmContext)->unwindObject)
#define	EsClearJavaException(vmContext) (((vmContext)->unwindObject = EsNil), ((vmContext)->unwinding = 0))

/* public-prototypes */
/* for file PRIMHELP.C */
#if !defined(ES_DYNAMIC_LINK_USER_PRIMS) || !defined(ESVM_DYNAMIC_LINK_USER_PRIMS)

U_32 VMCALL EsMakeSignedInteger PROTOTYPE((I_32, EsObject *, EsVMContext));

U_32 VMCALL EsMakeUnsignedInteger PROTOTYPE((U_32, EsObject *, EsVMContext));

U_32 VMCALL EsMakeDouble PROTOTYPE((double, EsObject *, EsVMContext));

U_32 VMCALL EsGetI32 PROTOTYPE((EsObject, I_32 *, EsVMContext));

U_32 VMCALL EsGetU32 PROTOTYPE((EsObject, U_32 *, EsVMContext));

U_32 VMCALL EsGetDouble PROTOTYPE((EsObject, double *, EsVMContext));

EsBehavior VMCALL EsGetClass PROTOTYPE((EsObject, EsVMContext));

BOOLEAN VMCALL EsPrivateIsCharacters PROTOTYPE((EsVMContext, EsObject));

I_32 VMCALL EsDaysFrom1901 PROTOTYPE((void));
#endif
#endif /* espriv_h */

