/*----------------------------------------------------------------------------
 *
 *  mainvio.c
 *  ---------
 *
 *  Purpose: Provide the startup processing for VisualAge Smalltalk Enterprise
 *           headless execution
 *
 *  Commandline switches:
 *     -singleinstance  Allow multiple copies of the executable to run at the
 *                same time
 *
 *  Licensed Materials - Property of IBM
 *
 *  (C) Copyright International Business Machines Corp., 1999
 *  All rights reserved
 *
 *  US Government Users Restricted Rights -
 *  Use, duplication, or disclosure restricted
 *  by GSA ADP Schedule Contract with IBM Corp.
 *
 *  Modifications:
 *    5.5.0.0 19Jan00(jok) Update to 5.1.0 w/2000 copyright
 *    5.5.0.1 02Mar00(jok) ES40MD30 rebuild
 *
 *----------------------------------------------------------------------------*/

#define PRODUCT_NAME    "VisualAge Smalltalk Enterprise"
#define PRODUCT_VERSION "Version 5.5"
#define PRODUCT_STATUS  ""
#define PRODUCT_EDITION "03/23/2000"
#define PRODUCT_COPYR   "(C) Copyright International Business Machines Corporation  1994, 2000.\nAll Rights Reserved."

#define	INCL_WIN
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSSEMAPHORES
#define INCL_ERRORS

#include <os2.h>
#include <string.h>
#include "esrc.h"
#include "esuser.h"

/*--------------------------------------------------------------------------*/
/*      DEBUG support							                                  */
/*--------------------------------------------------------------------------*/

#ifdef DEBUG01
#define dbg_printf( x ) { printf x ; fflush( stdout ); }
#else
#define dbg_printf( x )
#endif


PFNWP StaticProc;
HBITMAP hBitmap;

extern EsPrimitiveTable filePrimitiveTable;
extern EsPrimitiveTable WindowProcPrimitiveTable;
extern EsSplashShutDown (EsGlobalInfo *);

BOOLEAN EsParseCommandLineOptions(int argc, char *argv[], char *envp[], EsGlobalInfo * info);


EsDefinePrimitiveTable(EsExePrimitiveTable)
	EsSubTable(WindowProcPrimitiveTable)
	EsSubTable(filePrimitiveTable)
EsEndPrimitiveTable



main(int argc, char ** argv, char ** envp)
{
	BOOLEAN mutexEnabled=FALSE;
	I_32 rc,i;
	EsGlobalInfo *globalInfo;
	TID		tid;
	HMTX startupMutex;
	char mutexNameBuffer[1024] = "\\SEM32\\";
	char *exeName, *exeExtension, *ptr;

	/* Walk the command line looking VA specific command line options */
	dbg_printf( ("Entering main, %d commandline arguments\n", argc) );
	for(i=1; i < argc; i++) {
		dbg_printf( ("\t%s\n", argv[i]) );
		if(strcmp(argv[i],"-singleinstance") == 0) {
			mutexEnabled = TRUE;
		}
	}
	dbg_printf( ("mutexEnabled: %d\n", mutexEnabled) );

	if (mutexEnabled) {
		/* strip the path and extension from the program name */
		exeName = strrchr(argv[0], '\\');
		if(exeName)
			exeName++;
		else
			exeName = argv[0];

		strcat(mutexNameBuffer, exeName);
		/* uppercase everything */
		for (ptr = mutexNameBuffer; *ptr; ptr++)
			*ptr = toupper(*ptr);
		exeExtension = strrchr(mutexNameBuffer, '.');
		if (exeExtension && 0 == strcmp(exeExtension, ".EXE"))
			*exeExtension = '\0';
		strcat(mutexNameBuffer, "SINGLE_START_MUTEX");

		rc = DosCreateMutexSem(mutexNameBuffer, &startupMutex, 0L, FALSE);
		if(NO_ERROR != rc)
			return 0;	/* not first instance, go away. */
	}

	globalInfo = EsInitializeImage();
	if (globalInfo == NULL) {
		EsReportError(EsPrimErrNotEnoughMemory, globalInfo);
		if (mutexEnabled) DosCloseMutexSem(startupMutex);
		return EsPrimErrNotEnoughMemory;
	}
	globalInfo->imagePrimitives = (U_32) EsExePrimitiveTable;

	if ((rc = EsInitializeTargetInterface(argc, argv, envp, globalInfo)) != EsPrimErrNoError) {
		EsSplashShutDown(globalInfo);
		EsReportError(rc, globalInfo);
		EsShutdownImage(globalInfo);
		if (mutexEnabled) DosCloseMutexSem(startupMutex);
		return rc;
	}

	EsPrintf ("\n%s, %s %s - %s\nVM Timestamp: %s\n%s\n%s\n",
			PRODUCT_NAME,PRODUCT_VERSION,PRODUCT_STATUS,PRODUCT_EDITION,
			EsVMVersionString(),
			PRODUCT_COPYR,
			0,0,0,0);

	globalInfo->messageLevel = ESVM_MSG_LEVEL_NONE;

	if(!EsParseCommandLineOptions(argc, argv, envp, globalInfo)) {
		EsSplashShutDown(globalInfo);
		EsReportError(EsPrimErrImageFileOpenError, globalInfo);
		EsShutdownImage(globalInfo);
		if (mutexEnabled) DosCloseMutexSem(startupMutex);
		return EsPrimErrImageFileOpenError;
	}

	rc = EsLoadFileImage(argc, argv, envp, globalInfo);
	if (rc != EsPrimErrNoError) {
		EsSplashShutDown(globalInfo);
		EsReportError (rc, globalInfo);
	}

	if (rc == EsPrimErrNoError) {
		rc = EsExecuteImage(globalInfo);
		if (rc != EsPrimErrNoError) {
			if (rc < 9000 || (rc > 9100))
				EsReportError (rc, globalInfo);
		}
	}

	EsShutDownTargetInterface (globalInfo);
	EsShutdownImage(globalInfo);
	if (mutexEnabled) DosCloseMutexSem(startupMutex);
	return rc;
}
