/
create or replace package sampleproc as
    type charArrayTyp is table of varchar2(9)
        index by binary_integer;
    procedure get_staff (
        deptno  in   integer,
        batch_size  in     integer,
        found       in out integer,
        done_fetch  out    integer,
        name    out    charArrayTyp);
end sampleproc; 
/
create or replace package body sampleproc as            
    cursor get_emp (deptno integer) is              
        select name from staff
            where dept = deptno;
    procedure get_staff (
       deptno in  integer,
        batch_size  in     integer,
        found       in out integer,
        done_fetch  out    integer,
        name    out    charArrayTyp) is
    begin

        if not get_emp%isopen then
            open get_emp(deptno);
        end if;
        done_fetch := 0;
        found := 0;
        for i in 1..batch_size loop
            fetch get_emp into name(i);
            if get_emp%notfound then
                close get_emp;
                done_fetch := 1;
                exit;
            else
                found := found + 1;
            end if;
        end loop;
    end get_staff;
end sampleproc;
