#ifndef _KFILLST_
  #define _KFILLST_

#ifndef _ILISTBOX_
  #include <ilistbox.hpp>
#endif

#ifndef _KLSTHDR_
  #include <klsthdr.hpp>
#endif

#ifndef _ISTRING_
  #include <istring.hpp>
#endif


class _Export KFileListHandler : public IHandler
{
  public:
    virtual Boolean dispatchHandlerEvent(IEvent &event);

  protected:
    virtual Boolean fillList(IEvent &event) = 0;
};


class _Export KFileListBox : public IListBox
                           , public KListHandler
                           , public KFileListHandler
{
  public:
    KFileListBox(unsigned long windowId, 
                 IWindow *parentWin, 
                 IWindow *ownerWin, 
                 const IRectangle &rect=IRectangle(),
                 const char *files = "*.*",
                 ITextControl *targetWin=0,
                 const IListBox::Style &style=defaultStyle())
      : IListBox(windowId, parentWin, ownerWin, rect, style)
      , KListHandler(targetWin)
      , spec(files)
    {
      KListHandler::handleEventsFor(this);
      KFileListHandler::handleEventsFor(this);
    }

    Boolean fill();

    const char *fileSpec() const 
    { 
      return spec; 
    }

    KFileListBox &setFileSpec(const char *fileSpec) 
    { 
      spec = fileSpec; 
      return *this; 
    }

  protected:
    virtual Boolean fillList(IEvent &event);

  private:
    IString                        spec;
};

#endif
