/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.MsgBoxListener;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;

public class UniqueListPanel
extends ListPanel
implements MsgBoxListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int HOST_FIELD = 0;
    private ListPanelUser parent;
    private ResourceBundle resources;
    private String messageText;
    private msgBox okMsgBox;
    private msgBox yNMsgBox;
    private String[] staticDupCheck;
    private String[] dynamicDupCheck;
    private String[] reservedDupCheck;

    public UniqueListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n) {
        super((Container)((Object)listPanelUser), resourceBundle, string, resourceBundle.getString("NAME_FIELD_LABEL"), n);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
    }

    public UniqueListPanel(ListPanelUser listPanelUser, ResourceBundle resourceBundle, String string, int n, String string2) {
        super((Container)((Object)listPanelUser), resourceBundle, string, resourceBundle.getString("NAME_FIELD_LABEL"), n, string2);
        this.parent = listPanelUser;
        this.resources = resourceBundle;
    }

    public void setStaticNameCheck(String[] stringArray) {
        this.staticDupCheck = stringArray;
    }

    public void setDynamicNameCheck(String[] stringArray) {
        this.dynamicDupCheck = stringArray;
    }

    public void setReservedNameCheck(String[] stringArray) {
        this.reservedDupCheck = stringArray;
    }

    public void msgBoxSelection(int n, int n2) {
        if (n2 == 2) {
            String[] stringArray = new String[]{this.getName()};
            super.handleAdd(stringArray);
        }
    }

    public String getName() {
        return this.getFirstTextField().toLowerCase();
    }

    public void setName(String string) {
        this.setFirstTextField(string.toLowerCase());
    }

    public String[] getNameList() {
        return super.getItemList();
    }

    public void setNameList(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                super.addItem(stringArray[n].toLowerCase());
                ++n;
            }
        }
    }

    public void setMessageText(String string) {
        if (string != null && string.length() > 0) {
            this.messageText = new String(string);
            return;
        }
        this.messageText = new String(this.resources.getString("INVALID_HOST_NAME_TEXT"));
    }

    private void handleButton(Button button) {
        if (button == super.getAddButton()) {
            this.handleAdd();
            return;
        }
        if (button == super.getRemoveButton()) {
            super.handleRemove();
        }
    }

    protected void handleAdd() {
        boolean bl = true;
        String string = new String(this.getName());
        if (!TcpipValidation.IsValidNonFQTcpipName(string)) {
            this.setMessageText(this.resources.getString("INVALID_HOST_NAME_TEXT"));
            this.okMsgBox = new msgBox(this.resources, this.resources.getString("GKF_FRAME_NAME"), this.messageText, 1, true);
            bl = false;
        }
        if (!this.isUniqueName(string)) {
            this.setMessageText(this.resources.getString("ULP_DUPLICATE_TEXT"));
            this.okMsgBox = new msgBox(this.resources, this.resources.getString("GKF_FRAME_NAME"), this.messageText, 1, true);
            bl = false;
        }
        if (!this.isUniqueNameOfStaticList(string)) {
            this.setMessageText(this.resources.getString("ULP_STATIC_TEXT"));
            this.okMsgBox = new msgBox(this.resources, this.resources.getString("GKF_FRAME_NAME"), this.messageText, 1, true);
            bl = false;
        }
        if (!this.isUniqueNameOfDynamicList(string) || !this.isUniqueNameOfReservedList(string)) {
            this.setMessageText(this.resources.getString("ULP_OVERWRITE_TEXT"));
            this.yNMsgBox = new msgBox(this.resources, this.resources.getString("GKF_FRAME_NAME"), this.messageText, 2, true);
            bl = false;
        }
        if (!bl) {
            this.selectAll(0);
            this.requestFocus(0);
        }
        if (bl) {
            String[] stringArray = new String[]{this.getName()};
            super.handleAdd(stringArray);
        }
    }

    private boolean isUniqueName(String string) {
        String[] stringArray = this.getNameList();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean isUniqueNameOfStaticList(String string) {
        if (this.staticDupCheck != null && this.staticDupCheck.length > 0) {
            int n = 0;
            while (n < this.staticDupCheck.length) {
                if (this.staticDupCheck[n].equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean isUniqueNameOfDynamicList(String string) {
        if (this.dynamicDupCheck != null && this.dynamicDupCheck.length > 0) {
            int n = 0;
            while (n < this.dynamicDupCheck.length) {
                if (this.dynamicDupCheck[n].equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    private boolean isUniqueNameOfReservedList(String string) {
        if (this.reservedDupCheck != null && this.reservedDupCheck.length > 0) {
            int n = 0;
            while (n < this.reservedDupCheck.length) {
                if (this.reservedDupCheck[n].equalsIgnoreCase(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

