/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandlerUser;
import java.applet.Applet;
import java.util.Date;

public class TraceClient
implements NetworkHandlerUser {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String TRACE_EYECATCHER = "*****";
    public static final boolean START = true;
    public static final boolean STOP = false;
    private static final String EMPTY_STRING = "";
    private static final String TRACE_STARTED = "***** Trace started *****";
    private static final String NULL_STRING_ERROR = "***** Error:  null string encountered";
    private static final String CLASS_NAME = "TraceClient";
    private Date traceDate;
    private boolean traceActive = false;
    private NetworkHandler traceHandler;
    private boolean handlerCreated = false;
    private StringBuffer traceString;

    public TraceClient(String string, boolean bl, int n, String string2) {
        this(EMPTY_STRING, EMPTY_STRING, string, bl, null, n, string2);
    }

    public TraceClient(String string, String string2, boolean bl, int n, String string3) {
        this(string, EMPTY_STRING, string2, bl, null, n, string3);
    }

    public TraceClient(String string, String string2, String string3, boolean bl, int n, String string4) {
        this(string, string2, string3, bl, null, n, string4);
    }

    public TraceClient(String string, boolean bl, Applet applet, int n, String string2) {
        this(EMPTY_STRING, EMPTY_STRING, string, bl, applet, n, string2);
    }

    public TraceClient(String string, String string2, boolean bl, Applet applet, int n, String string3) {
        this(string, EMPTY_STRING, string2, bl, applet, n, string3);
    }

    public TraceClient(String string, String string2, String string3, boolean bl, Applet applet, int n, String string4) {
        String string5 = "constructor";
        this.traceString = new StringBuffer();
        this.traceDate = new Date();
        this.traceHandler = applet != null ? new NetworkHandler(applet, this, n, this, string4) : new NetworkHandler(this, n, this, string4);
        if (this.traceHandler != null && this.traceHandler.socketCreated()) {
            this.handlerCreated = true;
            this.setTraceState(bl);
        } else {
            this.handlerCreated = false;
            this.setTraceState(false);
        }
        if (this.traceActive) {
            this.traceString.append(String.valueOf(this.traceDate) + " " + TRACE_STARTED);
            if (string3 != null) {
                boolean bl2 = true;
                if (string != null && !string.equals(EMPTY_STRING)) {
                    this.traceString.append(" " + string);
                    bl2 = false;
                }
                if (string2 != null && !string2.equals(EMPTY_STRING)) {
                    this.traceString.append("." + string2 + "():");
                    bl2 = false;
                }
                if (!bl2) {
                    this.traceString.append(" ");
                }
                this.traceString.append(string3);
            } else {
                this.traceString.append("TraceClient." + string5 + "(): " + NULL_STRING_ERROR + "startTraceString");
            }
            this.sendTraceString();
        }
        this.traceString = null;
    }

    public final void trace(String string) {
        if (this.traceActive) {
            this.sendTracePoint(EMPTY_STRING, EMPTY_STRING, string);
        }
    }

    public final void trace(String string, String string2) {
        if (this.traceActive) {
            this.sendTracePoint(string, EMPTY_STRING, string2);
        }
    }

    public final void trace(String string, String string2, String string3) {
        if (this.traceActive) {
            this.sendTracePoint(string, string2, string3);
        }
    }

    public final void traceTime(String string) {
        if (this.traceActive) {
            this.buildTraceTimeStamp();
            this.sendTracePoint(EMPTY_STRING, EMPTY_STRING, string);
        }
    }

    public final void traceTime(String string, String string2) {
        if (this.traceActive) {
            this.buildTraceTimeStamp();
            this.sendTracePoint(string, EMPTY_STRING, string2);
        }
    }

    public final void traceTime(String string, String string2, String string3) {
        if (this.traceActive) {
            this.buildTraceTimeStamp();
            this.sendTracePoint(string, string2, string3);
        }
    }

    public final boolean getTraceState() {
        return this.traceActive;
    }

    public final void setTraceState(boolean bl) {
        this.traceActive = bl;
        if (this.traceActive) {
            this.traceTime(CLASS_NAME, "setTraceState", TRACE_STARTED);
        }
    }

    public final void close() {
        this.traceHandler.closeStreams();
    }

    public boolean isHandlerCreated() {
        return this.handlerCreated;
    }

    private void sendTraceString() {
        if (this.traceHandler != null && this.handlerCreated && this.traceString != null) {
            this.traceHandler.sendToServer(this.traceString.toString());
        }
    }

    private void sendTracePoint(String string, String string2, String string3) {
        String string4 = "trace";
        if (this.traceString == null) {
            this.traceString = new StringBuffer();
        }
        boolean bl = true;
        if (string != null && string2 != null && string3 != null) {
            if (!string.equals(EMPTY_STRING)) {
                this.traceString.append(string);
                bl = false;
            }
            if (!string2.equals(EMPTY_STRING)) {
                this.traceString.append("." + string2 + "():");
                bl = false;
            }
            if (!bl) {
                this.traceString.append(" ");
            }
            this.traceString.append(string3);
        } else {
            this.traceString.append("TraceClient." + string4 + "(): " + NULL_STRING_ERROR);
        }
        this.sendTraceString();
        this.traceString = null;
    }

    private void buildTraceTimeStamp() {
        this.traceDate = new Date();
        this.traceString = new StringBuffer();
        this.traceString.append(String.valueOf(this.traceDate) + " ");
    }

    public void networkExceptionOccurred(Exception exception) {
        this.close();
    }
}

