/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.AnIncludeFile;
import COM.ibm.raleigh.ddnssgui.common.ChildNameServer;
import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.DDNSfile;
import COM.ibm.raleigh.ddnssgui.common.DomainObject;
import COM.ibm.raleigh.ddnssgui.common.FileEntry;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.ReservedName;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class TheDomainFile
extends DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String DOMAIN_FILE_ORIGIN_STMT = "$ORIGIN ";
    private static final String DOMAIN_FILE_INCLUDE_STMT = "$INCLUDE ";
    protected static final String DOMAIN_FILE_NO_ADDRESS = "-";
    String theCurrentName;
    Object theCurrentObject;
    String theDomain;
    Vector ignoredLines;
    Vector errorLines;
    Vector pendingComments;
    Vector pendingObjects;
    Vector nameServerRecords;
    Vector dottedNames;
    Vector includeFileNames;
    TheDomainFile parent;
    TraceClient theTrace;

    public TheDomainFile(String string, TraceClient traceClient, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.theDomain = new String(string);
        this.ignoredLines = new Vector();
        this.errorLines = new Vector();
        this.pendingObjects = new Vector();
        this.dottedNames = new Vector();
        this.nameServerRecords = new Vector();
        this.includeFileNames = new Vector();
        this.theTrace = traceClient;
        this.setTrace(traceClient, "TheDomainFile");
    }

    public String getStaticIncludeFileName() {
        if (this.includeFileNames.isEmpty()) {
            return null;
        }
        Object[] objectArray = new String[this.includeFileNames.size()];
        this.includeFileNames.copyInto(objectArray);
        return objectArray[0];
    }

    public void addDotted(FileEntry fileEntry) {
        if (fileEntry.getRecType() == "A") {
            if (TcpipValidation.IsValidTcpipAddr(fileEntry.getRecordData())) {
                this.dottedNames.addElement(fileEntry);
                return;
            }
            this.addErrors(fileEntry);
            return;
        }
        this.dottedNames.addElement(fileEntry);
    }

    public void addIgnored(FileEntry fileEntry) {
        this.ignoredLines.addElement(fileEntry);
    }

    public void addErrors(FileEntry fileEntry) {
        this.errorLines.addElement(fileEntry);
    }

    public void addNSRec(FileEntry fileEntry) {
        this.nameServerRecords.addElement(fileEntry);
    }

    public void addPendingO(FileEntry fileEntry) {
        this.pendingObjects.addElement(fileEntry);
    }

    public void addIncl(String string) {
        this.includeFileNames.addElement(DDNSUtility.stripFileName(string));
    }

    public boolean readFile(String string) {
        return this.readFile(string, String.valueOf(this.theDomain) + ".");
    }

    public boolean readFile(String string, String string2) {
        boolean bl = false;
        new File(string);
        String string3 = string2;
        BufferedReader bufferedReader = this.setInputFile(string);
        if (bufferedReader != null) {
            String string4 = this.getNextLine(bufferedReader);
            while (string4 != null) {
                if (!(string4.startsWith(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")) || string4.startsWith(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_HEADER"), 20) || string4.startsWith(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("INVALID_ITEMS_HEADER")))) {
                    string3 = this.processLineFromFile(string4, string3, string);
                }
                string4 = this.getNextLine(bufferedReader);
                bl = true;
            }
            this.closeInput();
        } else {
            this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("FILE_NOT_FOUND_ERROR")) + string);
        }
        return bl;
    }

    public String processLineFromFile(String string, String string2, String string3) {
        String string4 = string2;
        FileEntry fileEntry = new FileEntry(string, string4, this.theStrings);
        if (fileEntry.getRecType().equals("$INCLUDE")) {
            if (this.isUniqueIncludeFileName(fileEntry.getRecordData(), string3)) {
                this.addIncl(fileEntry.getRecordData());
                string4 = fileEntry.getOriginFromInclude(string4);
                AnIncludeFile anIncludeFile = new AnIncludeFile(this.theDomain, this.theTrace, this, this.theStrings);
                boolean bl = anIncludeFile.readFile(DDNSUtility.stripFileName(fileEntry.getRecordData()), string4);
                if (!bl) {
                    this.addErrors(fileEntry);
                }
            } else {
                this.addErrors(fileEntry);
            }
        } else if (fileEntry.getRecType().equals("$ORIGIN")) {
            string4 = fileEntry.getRecordData();
            if (string4.equals("@")) {
                string4 = new String(String.valueOf(this.theDomain) + ".");
            }
        } else if (fileEntry.areErrors()) {
            this.addErrors(fileEntry);
        } else {
            this.addToFile(fileEntry.getRecType(), fileEntry);
        }
        return string4;
    }

    public boolean loadDataModel(ConfigurationManager configurationManager) {
        this.pendingComments = new Vector();
        boolean bl = this.theDomain.toLowerCase().endsWith("in-addr.arpa");
        if (this.theFileData.isEmpty()) {
            this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_DATA_NOT_FOUND_ERROR")) + this.theDomain);
        } else {
            if (bl) {
                return this.loadDataModelFromPTRs(configurationManager);
            }
            Enumeration enumeration = this.theFileData.elements();
            String string = null;
            while (enumeration.hasMoreElements()) {
                try {
                    FileEntry fileEntry;
                    ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                    if (parsedObject.getKey().equals("CMT")) {
                        FileEntry fileEntry2 = (FileEntry)parsedObject.getValue();
                        this.pendingComments.addElement(fileEntry2.getRecordData());
                        continue;
                    }
                    if (parsedObject.getKey().equals("PTR")) {
                        fileEntry = (FileEntry)parsedObject.getValue();
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addIgnored(fileEntry);
                        continue;
                    }
                    fileEntry = (FileEntry)parsedObject.getValue();
                    if (fileEntry.doesSpanLines()) {
                        fileEntry = this.handleMultLines(enumeration, fileEntry);
                    }
                    if (fileEntry == null) continue;
                    string = fileEntry.getUnqualifiedOwnerName(this.theDomain);
                    if (string == null && !parsedObject.getKey().equals("A")) {
                        this.addIgnored(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        continue;
                    }
                    int n = fileEntry.getTTL();
                    HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string, this.theDomain);
                    if (string == null || string != null && string.indexOf(".") >= 0 && !string.equals(this.theDomain)) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addDotted(fileEntry);
                        continue;
                    }
                    if (fileEntry.getRecType().equals("SOA")) {
                        if (!string.equals(this.theDomain) && !string.equals(String.valueOf(this.theDomain) + ".")) {
                            this.giveCommentsToEntry(fileEntry, null);
                            this.addErrors(fileEntry);
                            continue;
                        }
                        DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                        this.parseSOA(enumeration, fileEntry, domainObject);
                        this.giveCommentsToEntry(domainObject, fileEntry);
                        continue;
                    }
                    this.parseRecord(string, fileEntry, configurationManager, hostOrAlias, n);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_FILE_LOAD_ERROR")) + this.theDomain);
                }
            }
        }
        this.finishResolving(configurationManager);
        this.theFileData.removeAllElements();
        this.theFileData = null;
        return true;
    }

    public boolean loadDataModelFromPTRs(ConfigurationManager configurationManager) {
        this.pendingComments = new Vector();
        if (this.theFileData.isEmpty()) {
            this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_DATA_NOT_FOUND_ERROR")) + this.theDomain);
        } else {
            Enumeration enumeration = this.theFileData.elements();
            String string = "";
            while (enumeration.hasMoreElements()) {
                try {
                    Object object;
                    ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                    if (parsedObject.getKey().equals("CMT")) {
                        FileEntry fileEntry = (FileEntry)parsedObject.getValue();
                        this.pendingComments.addElement(fileEntry.getRecordData());
                        continue;
                    }
                    FileEntry fileEntry = (FileEntry)parsedObject.getValue();
                    if (fileEntry.doesSpanLines()) {
                        fileEntry = this.handleMultLines(enumeration, fileEntry);
                    }
                    if (fileEntry == null) continue;
                    string = fileEntry.getUnqualifiedOwnerName(this.theDomain);
                    if (string == null && !parsedObject.getKey().equals("A")) {
                        this.addIgnored(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        continue;
                    }
                    if (string == null && parsedObject.getKey().equals("A")) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addDotted(fileEntry);
                        continue;
                    }
                    int n = fileEntry.getTTL();
                    ReverseHost reverseHost = (ReverseHost)configurationManager.getAHost(ReverseHost.getAddressFromHostName(string, this.theDomain), this.theDomain);
                    if (parsedObject.getKey().equals("SOA")) {
                        if (string.equals("")) {
                            string = new String(this.theDomain);
                        }
                        if (!string.equals(this.theDomain) && !string.equals(String.valueOf(this.theDomain) + ".")) {
                            this.giveCommentsToEntry(fileEntry, null);
                            this.addErrors(fileEntry);
                            continue;
                        }
                        this.parseSOA(enumeration, fileEntry, configurationManager.getADomain(this.theDomain));
                        continue;
                    }
                    if (parsedObject.getKey().equals("A")) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addErrors(fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("MX")) {
                        if (string.equals(this.theDomain) || string.equals(String.valueOf(this.theDomain) + ".")) {
                            object = configurationManager.getADomain(this.theDomain);
                            if (object == null) continue;
                            ((DomainObject)object).addMailExchange(fileEntry.getRecordData());
                            ((DomainObject)object).setGreaterMailTTL(n);
                            this.giveCommentsToEntry((FileItem)object, fileEntry);
                            continue;
                        }
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addIgnored(fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("CNAME") || parsedObject.getKey().equals("HINFO") || parsedObject.getKey().equals("WKS") || parsedObject.getKey().equals("TXT")) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addIgnored(fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("NS")) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addNSRec(fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("SIG")) {
                        if (reverseHost == null) {
                            this.giveCommentsToEntry(fileEntry, null);
                            this.addPendingO(fileEntry);
                            continue;
                        }
                        reverseHost.addSIGRec(fileEntry.getRecordData());
                        this.giveCommentsToEntry(reverseHost, fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("KEY")) {
                        if (reverseHost == null) {
                            this.giveCommentsToEntry(fileEntry, null);
                            this.addPendingO(fileEntry);
                            continue;
                        }
                        reverseHost.addKEYRec(fileEntry.getRecordData());
                        this.giveCommentsToEntry(reverseHost, fileEntry);
                        continue;
                    }
                    if (parsedObject.getKey().equals("OTHER")) {
                        if (!(reverseHost instanceof ReverseHost)) {
                            this.giveCommentsToEntry(fileEntry, null);
                            this.addErrors(fileEntry);
                            continue;
                        }
                        if (reverseHost == null) {
                            object = new ReverseHost(ReverseHost.getAddressFromHostName(string, this.theDomain), fileEntry.getRecordData(), this.theDomain);
                            if (configurationManager.giveAHost((HostOrAlias)object, this.theDomain, "TheDomainFile")) {
                                configurationManager.linkHost((HostOrAlias)object, this.theDomain);
                            }
                            this.giveCommentsToEntry(reverseHost, fileEntry);
                            continue;
                        }
                        reverseHost.addOtherRec(fileEntry.getRecordData());
                        this.giveCommentsToEntry(reverseHost, fileEntry);
                        continue;
                    }
                    if (!parsedObject.getKey().equals("PTR")) continue;
                    if (reverseHost == null) {
                        object = fileEntry.getRecordData();
                        if (TcpipValidation.IsValidFQTcpipName((String)object)) {
                            ReverseHost reverseHost2 = new ReverseHost(ReverseHost.getAddressFromHostName(string, this.theDomain), (String)object, this.theDomain);
                            reverseHost2.setGreaterPTRttl(n);
                            if (configurationManager.giveAHost(reverseHost2, this.theDomain, "TheDomainFile")) {
                                configurationManager.linkHost(reverseHost2, this.theDomain);
                            }
                            this.giveCommentsToEntry(reverseHost2, fileEntry);
                            continue;
                        }
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addErrors(fileEntry);
                        continue;
                    }
                    if (!(reverseHost instanceof ReverseHost)) {
                        this.giveCommentsToEntry(fileEntry, null);
                        this.addErrors(fileEntry);
                        continue;
                    }
                    if (TcpipValidation.IsValidFQTcpipName(fileEntry.getRecordData())) {
                        reverseHost.setPTRhostname(fileEntry.getRecordData());
                        reverseHost.setGreaterPTRttl(n);
                        this.giveCommentsToEntry(reverseHost, fileEntry);
                        continue;
                    }
                    this.giveCommentsToEntry(fileEntry, null);
                    this.addErrors(fileEntry);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_FILE_LOAD_ERROR")) + this.theDomain);
                }
            }
        }
        this.finishResolving(configurationManager);
        this.theFileData.removeAllElements();
        this.theFileData = null;
        return true;
    }

    public boolean writeTwoDomainFiles(ConfigurationManager configurationManager, String string, String string2, boolean bl) {
        PrimaryDomain primaryDomain = (PrimaryDomain)configurationManager.getADomain(string2);
        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
        Enumeration enumeration = primaryDomain.getHosts();
        String string3 = !string2.equals(".") ? new String(DOMAIN_FILE_ORIGIN_STMT + string2 + ".") : new String(DOMAIN_FILE_ORIGIN_STMT + string2);
        HostOrAlias hostOrAlias = null;
        boolean bl2 = false;
        BufferedWriter bufferedWriter = null;
        Object[] objectArray = new Object[]{new Date()};
        String[] stringArray = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
        boolean bl3 = false;
        BufferedWriter bufferedWriter2 = this.setOutputFile(string);
        if (bufferedWriter2 != null) {
            FileEntry fileEntry;
            int n;
            this.writeOutput(bufferedWriter2, stringArray);
            this.writeOutput(bufferedWriter2, string3);
            bufferedWriter = this.setOutputFile(primaryDomain.getStaticFileName());
            this.writeOutput(bufferedWriter, stringArray);
            this.writeOutput(bufferedWriter, string3);
            this.writeDomainSOAdata(bufferedWriter2, primaryDomain, nameServerObject.firstName(), nameServerObject.getJustFQNames());
            this.writeNameServersForDomain(bufferedWriter2, primaryDomain, configurationManager, nameServerObject.getJustFQNames());
            this.writeGlueForNameServersForDomain(bufferedWriter, primaryDomain, configurationManager, nameServerObject);
            this.writeOutput(bufferedWriter2, new String(DOMAIN_FILE_INCLUDE_STMT + DDNSUtility.padFileName(primaryDomain.getStaticFileName())));
            this.writeChildNameServers(bufferedWriter, primaryDomain, configurationManager);
            while (enumeration.hasMoreElements()) {
                try {
                    hostOrAlias = (HostOrAlias)enumeration.nextElement();
                    if (hostOrAlias.isDynamic()) {
                        this.writeOutput(bufferedWriter2, hostOrAlias.getComments());
                        this.writeOutput(bufferedWriter2, hostOrAlias.writeDataRecords());
                        continue;
                    }
                    this.writeOutput(bufferedWriter, hostOrAlias.getComments());
                    this.writeOutput(bufferedWriter, hostOrAlias.writeDataRecords());
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            if (this.pendingComments != null && !this.pendingComments.isEmpty()) {
                n = 0;
                while (n < this.pendingComments.size()) {
                    this.writeOutput(bufferedWriter, (String)this.pendingComments.elementAt(n));
                    ++n;
                }
            }
            String[] stringArray2 = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("INVALID_ITEMS_HEADER"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
            if (!this.errorLines.isEmpty() && bl) {
                this.writeOutput(bufferedWriter, stringArray2);
                bl3 = true;
                n = 0;
                while (n < this.errorLines.size()) {
                    fileEntry = (FileEntry)this.errorLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_ERROR") + fileEntry.toString());
                    ++n;
                }
            }
            if (!this.ignoredLines.isEmpty() && bl) {
                if (!bl3) {
                    this.writeOutput(bufferedWriter, stringArray2);
                }
                n = 0;
                while (n < this.ignoredLines.size()) {
                    fileEntry = (FileEntry)this.ignoredLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_IGNORED") + fileEntry.toString());
                    ++n;
                }
            }
            this.closeOutput();
        }
        return bl2;
    }

    public boolean writeStaticDomainFileOnly(ConfigurationManager configurationManager, String string, String string2, boolean bl) {
        PrimaryDomain primaryDomain = (PrimaryDomain)configurationManager.getADomain(string2);
        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
        Enumeration enumeration = primaryDomain.getHosts();
        String string3 = !string2.equals(".") ? new String(DOMAIN_FILE_ORIGIN_STMT + string2 + ".") : new String(DOMAIN_FILE_ORIGIN_STMT + string2);
        HostOrAlias hostOrAlias = null;
        boolean bl2 = false;
        BufferedWriter bufferedWriter = null;
        Object[] objectArray = new Object[]{new Date()};
        String[] stringArray = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
        boolean bl3 = false;
        bufferedWriter = this.setOutputFile(primaryDomain.getStaticFileName());
        if (bufferedWriter != null) {
            FileEntry fileEntry;
            int n;
            this.writeOutput(bufferedWriter, stringArray);
            this.writeOutput(bufferedWriter, string3);
            this.writeGlueForNameServersForDomain(bufferedWriter, primaryDomain, configurationManager, nameServerObject);
            this.writeChildNameServers(bufferedWriter, primaryDomain, configurationManager);
            while (enumeration.hasMoreElements()) {
                try {
                    hostOrAlias = (HostOrAlias)enumeration.nextElement();
                    if (hostOrAlias.isDynamic()) continue;
                    this.writeOutput(bufferedWriter, hostOrAlias.getComments());
                    this.writeOutput(bufferedWriter, hostOrAlias.writeDataRecords());
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            String[] stringArray2 = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("INVALID_ITEMS_HEADER"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
            if (!this.errorLines.isEmpty() && bl) {
                this.writeOutput(bufferedWriter, stringArray2);
                bl3 = true;
                n = 0;
                while (n < this.errorLines.size()) {
                    fileEntry = (FileEntry)this.errorLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_ERROR") + fileEntry.toString());
                    ++n;
                }
            }
            if (!this.ignoredLines.isEmpty() && bl) {
                if (!bl3) {
                    this.writeOutput(bufferedWriter, stringArray2);
                }
                n = 0;
                while (n < this.ignoredLines.size()) {
                    fileEntry = (FileEntry)this.ignoredLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_IGNORED") + fileEntry.toString());
                    ++n;
                }
            }
            if (this.pendingComments != null && !this.pendingComments.isEmpty()) {
                n = 0;
                while (n < this.pendingComments.size()) {
                    this.writeOutput(bufferedWriter, (String)this.pendingComments.elementAt(n));
                    ++n;
                }
            }
            this.closeOutput();
        }
        return bl2;
    }

    public boolean writeOneDomainFile(ConfigurationManager configurationManager, String string, String string2, boolean bl) {
        PrimaryDomain primaryDomain = (PrimaryDomain)configurationManager.getADomain(string2);
        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
        Enumeration enumeration = primaryDomain.getHosts();
        String string3 = !string2.equals(".") ? new String(DOMAIN_FILE_ORIGIN_STMT + string2 + ".") : new String(DOMAIN_FILE_ORIGIN_STMT + string2);
        HostOrAlias hostOrAlias = null;
        boolean bl2 = false;
        Object[] objectArray = new Object[]{new Date()};
        String[] stringArray = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
        boolean bl3 = false;
        BufferedWriter bufferedWriter = this.setOutputFile(string);
        if (bufferedWriter != null) {
            FileEntry fileEntry;
            int n;
            this.writeOutput(bufferedWriter, stringArray);
            this.writeOutput(bufferedWriter, string3);
            this.writeDomainSOAdata(bufferedWriter, primaryDomain, nameServerObject.firstName(), nameServerObject.getJustFQNames());
            this.writeNameServersForDomain(bufferedWriter, primaryDomain, configurationManager, nameServerObject.getJustFQNames());
            this.writeGlueForNameServersForDomain(bufferedWriter, primaryDomain, configurationManager, nameServerObject);
            this.writeChildNameServers(bufferedWriter, primaryDomain, configurationManager);
            while (enumeration.hasMoreElements()) {
                try {
                    hostOrAlias = (HostOrAlias)enumeration.nextElement();
                    this.writeOutput(bufferedWriter, hostOrAlias.getComments());
                    this.writeOutput(bufferedWriter, hostOrAlias.writeDataRecords());
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            String[] stringArray2 = new String[]{String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("INVALID_ITEMS_HEADER"), String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE")};
            if (!this.errorLines.isEmpty() && bl) {
                this.writeOutput(bufferedWriter, stringArray2);
                bl3 = true;
                n = 0;
                while (n < this.errorLines.size()) {
                    fileEntry = (FileEntry)this.errorLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_ERROR") + fileEntry.toString());
                    ++n;
                }
            }
            if (!this.ignoredLines.isEmpty() && bl) {
                if (!bl3) {
                    this.writeOutput(bufferedWriter, stringArray2);
                }
                n = 0;
                while (n < this.ignoredLines.size()) {
                    fileEntry = (FileEntry)this.ignoredLines.elementAt(n);
                    this.writeOutput(bufferedWriter, fileEntry.getComments());
                    this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_IGNORED") + fileEntry.toString());
                    ++n;
                }
            }
            if (this.pendingComments != null && !this.pendingComments.isEmpty()) {
                n = 0;
                while (n < this.pendingComments.size()) {
                    this.writeOutput(bufferedWriter, (String)this.pendingComments.elementAt(n));
                    ++n;
                }
            }
            this.closeOutput();
        }
        return bl2;
    }

    private void parseSOA(Enumeration enumeration, FileEntry fileEntry, DomainObject domainObject) {
        String string;
        this.examineSOAfields(fileEntry.getRecordData(), domainObject);
        if (domainObject instanceof PrimaryDomain && (string = ((PrimaryDomain)domainObject).getAdminEmail()).indexOf("@") >= 0) {
            this.addErrors(fileEntry);
        }
        domainObject.setSoaTTL(fileEntry.getTTL());
    }

    private void examineSOAfields(String string, DomainObject domainObject) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        if (stringTokenizer.hasMoreElements()) {
            try {
                String string3 = (String)stringTokenizer.nextElement();
                if (stringTokenizer.hasMoreElements()) {
                    string3 = (String)stringTokenizer.nextElement();
                    if (!Character.isDigit(string3.charAt(0)) || string3.endsWith(".")) {
                        string2 = string3;
                        string3 = stringTokenizer.hasMoreElements() ? (String)stringTokenizer.nextElement() : null;
                    }
                    if (string3 != null) {
                        Integer n8 = Integer.valueOf(string3);
                        n = n8;
                        n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                        n2 = n8;
                        n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                        n3 = n8;
                        n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                        n4 = n8;
                        n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                        n5 = n8;
                        if (stringTokenizer.hasMoreElements()) {
                            n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                            n6 = n8;
                        }
                        if (stringTokenizer.hasMoreElements()) {
                            n8 = Integer.valueOf((String)stringTokenizer.nextElement());
                            n7 = n8;
                        }
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_FILE_SOA_ERROR")) + this.theDomain);
            }
        }
        if (domainObject instanceof PrimaryDomain) {
            if (string2 != null) {
                if (string2.endsWith(".")) {
                    ((PrimaryDomain)domainObject).setAdminEmail(string2.substring(0, string2.length() - 1));
                } else {
                    ((PrimaryDomain)domainObject).setAdminEmail(string2);
                }
            }
            if (((PrimaryDomain)domainObject).isDynamic()) {
                if (n6 >= 0) {
                    ((PrimaryDomain)domainObject).setUpdateTime(n6);
                }
                if (n7 >= 0) {
                    ((PrimaryDomain)domainObject).setNoOfUpds(n7);
                }
            }
        }
        if (n >= 0) {
            domainObject.setSerialNo(n);
        }
        if (n2 >= 0) {
            domainObject.setRefreshRt(n2);
        }
        if (n3 >= 0) {
            domainObject.setRetryInterval(n3);
        }
        if (n4 >= 0) {
            domainObject.setExpirationTime(n4);
        }
        if (n5 >= 0) {
            domainObject.setTTL(n5);
        }
    }

    protected HostOrAlias findCorrespondingHost(String string, String string2, HostOrAlias hostOrAlias, ConfigurationManager configurationManager) {
        if (hostOrAlias == null) {
            HostObject hostObject = new HostObject();
            hostObject.setHostName(string);
            if (configurationManager.giveAHost(hostObject, string2, "TheDomainFile")) {
                configurationManager.linkHost(hostObject, string2);
            }
            return hostObject;
        }
        return hostOrAlias;
    }

    protected HostOrAlias findCorrespondingAlias(String string, String string2, HostOrAlias hostOrAlias, ConfigurationManager configurationManager) {
        if (hostOrAlias == null) {
            AliasHostObject aliasHostObject = new AliasHostObject();
            aliasHostObject.setHostName(string);
            if (configurationManager.giveAHost(aliasHostObject, string2, "TheDomainFile")) {
                configurationManager.linkHost(aliasHostObject, string2);
            }
            return aliasHostObject;
        }
        return hostOrAlias;
    }

    protected void giveCommentsToEntry(FileItem fileItem, FileEntry fileEntry) {
        String[] stringArray;
        if (fileEntry != null && (stringArray = fileEntry.getComments()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.pendingComments.addElement(stringArray[n]);
                ++n;
            }
        }
        fileItem.addComments(this.pendingComments);
        this.pendingComments = new Vector();
    }

    protected boolean notReverseOrAlias(HostOrAlias hostOrAlias, FileEntry fileEntry) {
        if (hostOrAlias instanceof AliasHostObject || hostOrAlias instanceof ReverseHost) {
            this.giveCommentsToEntry(fileEntry, null);
            this.addIgnored(fileEntry);
            return false;
        }
        return true;
    }

    protected boolean notReverseOrHost(HostOrAlias hostOrAlias, FileEntry fileEntry) {
        if (hostOrAlias instanceof HostObject || hostOrAlias instanceof ReverseHost) {
            this.giveCommentsToEntry(fileEntry, null);
            this.addIgnored(fileEntry);
            return false;
        }
        return true;
    }

    protected boolean isUniqueIncludeFileName(String string, String string2) {
        if (DDNSUtility.stripFileName(string).equals(DDNSUtility.stripFileName(string2))) {
            return false;
        }
        if (this.includeFileNames != null) {
            int n = 0;
            while (n < this.includeFileNames.size()) {
                String string3 = (String)this.includeFileNames.elementAt(n);
                if (string3.equals(string)) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }

    public void finishResolving(ConfigurationManager configurationManager) {
        Object object;
        String string;
        String string2;
        FileEntry fileEntry;
        int n;
        DomainObject domainObject = configurationManager.getADomain(this.theDomain);
        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
        if (!this.nameServerRecords.isEmpty()) {
            n = 0;
            while (n < this.nameServerRecords.size()) {
                Object object2;
                Object object3;
                fileEntry = (FileEntry)this.nameServerRecords.elementAt(n);
                string2 = fileEntry.getRecordData();
                string = fileEntry.getUnqualifiedRecordData(this.theDomain);
                object = fileEntry.getOwnerName();
                int n2 = fileEntry.getTTL();
                if (string != null && string.indexOf(".") < 0) {
                    HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string2);
                    object3 = DOMAIN_FILE_NO_ADDRESS;
                    if (hostOrAlias == null) {
                        this.addErrors(fileEntry);
                    } else if (hostOrAlias instanceof HostObject) {
                        object3 = ((HostObject)hostOrAlias).getAnIpAddress();
                    }
                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                        if (!nameServerObject.isMyNameServerName(string2)) {
                            domainObject.addNameServerforDomain(string2, (String)object3);
                        }
                        domainObject.setGreaterNameServerTTL(n2);
                    } else {
                        domainObject.addChildNameServer(string2, (String)object3, (String)object, fileEntry.getAllComments());
                        domainObject.setGreaterNameServerTTL(n2);
                    }
                } else if (string == null) {
                    String string3 = DOMAIN_FILE_NO_ADDRESS;
                    object3 = this.findCorrespondingA(string2);
                    if (!((Vector)object3).isEmpty()) {
                        object2 = ((Vector)object3).elements();
                        string3 = (String)object2.nextElement();
                    }
                    if ((object2 = (HostOrAlias)configurationManager.getAHost(string2)) != null) {
                        string3 = ((HostObject)object2).getAnIpAddress();
                    }
                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                        if (!nameServerObject.isMyNameServerName(string2)) {
                            domainObject.addNameServerforDomain(string2, string3);
                        }
                        domainObject.setGreaterNameServerTTL(n2);
                    } else {
                        domainObject.addChildNameServer(string2, string3, (String)object, fileEntry.getAllComments());
                        domainObject.setGreaterNameServerTTL(n2);
                    }
                } else {
                    int n3 = string.lastIndexOf(".");
                    if (n3 <= 0) {
                        this.addErrors(fileEntry);
                    } else {
                        object3 = string.substring(n3 + 1);
                        object2 = this.findCorrespondingA(string2);
                        if (domainObject.isAChildDomain((String)object3) || this.isLaterInList(String.valueOf(object3) + "." + this.theDomain)) {
                            if (((Vector)object2).isEmpty()) {
                                String string4 = domainObject.getNameServerAddrFor(string2);
                                if (string4 == null) {
                                    string4 = domainObject.getChildNameServerAddrFor(string2);
                                }
                                if (string4 == null) {
                                    this.addErrors(fileEntry);
                                } else {
                                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                        if (!nameServerObject.isMyNameServerName(string2)) {
                                            domainObject.addNameServerforDomain(string2, string4);
                                        }
                                    } else {
                                        domainObject.addChildNameServer(string2, string4, (String)object, fileEntry.getAllComments());
                                    }
                                    domainObject.setGreaterNameServerTTL(n2);
                                }
                            } else {
                                int n4 = 0;
                                while (n4 < ((Vector)object2).size()) {
                                    if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                        if (!nameServerObject.isMyNameServerName(string2)) {
                                            domainObject.addNameServerforDomain(string2, (String)((Vector)object2).elementAt(n4));
                                        }
                                    } else {
                                        domainObject.addChildNameServer(string2, (String)((Vector)object2).elementAt(n4), (String)object, fileEntry.getAllComments());
                                    }
                                    domainObject.setGreaterNameServerTTL(n2);
                                    ++n4;
                                }
                            }
                        } else if (((Vector)object2).isEmpty()) {
                            String string5 = domainObject.getNameServerAddrFor(string2);
                            if (string5 == null) {
                                string5 = domainObject.getChildNameServerAddrFor(string2);
                            }
                            if (string5 == null) {
                                this.addErrors(fileEntry);
                            } else {
                                if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                    if (!nameServerObject.isMyNameServerName(string2)) {
                                        domainObject.addNameServerforDomain(string2, string5);
                                    }
                                } else {
                                    domainObject.addChildNameServer(string2, string5, (String)object, fileEntry.getAllComments());
                                }
                                domainObject.setGreaterNameServerTTL(n2);
                            }
                        } else {
                            int n5 = 0;
                            while (n5 < ((Vector)object2).size()) {
                                HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string2);
                                if (hostOrAlias != null) {
                                    ((HostObject)hostOrAlias).addIpAddress((String)((Vector)object2).elementAt(n5));
                                } else {
                                    HostObject hostObject = new HostObject();
                                    hostObject.setHostName(string);
                                    hostObject.addIpAddress((String)((Vector)object2).elementAt(n5));
                                }
                                if (this.theDomain.equals(object) || ((String)object).equals("@")) {
                                    if (!nameServerObject.isMyNameServerName(string2)) {
                                        domainObject.addNameServerforDomain(string2, (String)((Vector)object2).elementAt(n5));
                                    }
                                } else {
                                    domainObject.addChildNameServer(string2, (String)((Vector)object2).elementAt(n5), (String)object, fileEntry.getAllComments());
                                }
                                domainObject.setGreaterNameServerTTL(n2);
                                ++n5;
                            }
                        }
                    }
                }
                ++n;
            }
        }
        if (!this.pendingObjects.isEmpty()) {
            n = 0;
            while (n < this.pendingObjects.size()) {
                fileEntry = (FileEntry)this.pendingObjects.elementAt(n);
                string2 = fileEntry.getRecordData();
                string = fileEntry.getUnqualifiedOwnerName(this.theDomain);
                if (string.equalsIgnoreCase(this.theDomain)) {
                    object = configurationManager.getADomain(this.theDomain);
                    if (object != null) {
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry((FileItem)object, fileEntry);
                        if (fileEntry.getRecType().equals("SIG")) {
                            ((FileItem)object).addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            ((FileItem)object).addKEYRec(string2);
                        }
                        ((FileItem)object).setDataDynamic(true);
                    } else {
                        this.addErrors(fileEntry);
                    }
                } else {
                    object = (HostOrAlias)configurationManager.getAHost(string, this.theDomain);
                    if (object == null) {
                        ReservedName reservedName = new ReservedName(string);
                        reservedName.setDataDynamic(true);
                        if (fileEntry.getRecType().equals("SIG")) {
                            reservedName.addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            reservedName.addKEYRec(string2);
                        }
                        if (configurationManager.giveAHost(reservedName, this.theDomain, "TheDomainFile")) {
                            configurationManager.linkHost(reservedName, this.theDomain);
                        }
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry(reservedName, fileEntry);
                    } else {
                        ((FileItem)object).setDataDynamic(true);
                        if (fileEntry.getRecType().equals("SIG")) {
                            ((FileItem)object).addSIGRec(string2);
                        } else if (fileEntry.getRecType().equals("KEY")) {
                            ((FileItem)object).addKEYRec(string2);
                        }
                        this.pendingComments = new Vector();
                        this.giveCommentsToEntry((FileItem)object, fileEntry);
                    }
                }
                ++n;
            }
        }
        if (!this.dottedNames.isEmpty()) {
            n = 0;
            while (n < this.dottedNames.size()) {
                fileEntry = (FileEntry)this.dottedNames.elementAt(n);
                fileEntry.getOwnerName();
                string2 = fileEntry.getUnqualifiedOwnerName(this.theDomain);
                if (string2 == null) {
                    this.addIgnored(fileEntry);
                } else {
                    int n6 = string2.lastIndexOf(".");
                    if (n6 <= 0) {
                        this.addErrors(fileEntry);
                    } else {
                        object = string2.substring(n6 + 1);
                        if (!domainObject.isAChildDomain((String)object)) {
                            HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string2, this.theDomain);
                            if (this.theDomain.endsWith("in-addr.arpa")) {
                                if (hostOrAlias == null) {
                                    if (TcpipValidation.IsValidFQTcpipName(fileEntry.getRecordData())) {
                                        ReverseHost reverseHost = new ReverseHost(ReverseHost.getAddressFromHostName(string2, this.theDomain), fileEntry.getRecordData(), this.theDomain);
                                        reverseHost.setGreaterPTRttl(fileEntry.getTTL());
                                        reverseHost.setPTRhostname(fileEntry.getRecordData());
                                        if (configurationManager.giveAHost(reverseHost, this.theDomain, "TheDomainFile")) {
                                            configurationManager.linkHost(reverseHost, this.theDomain);
                                        }
                                    } else {
                                        this.addErrors(fileEntry);
                                    }
                                } else if (TcpipValidation.IsValidFQTcpipName(fileEntry.getRecordData())) {
                                    ((ReverseHost)hostOrAlias).setPTRhostname(fileEntry.getRecordData());
                                } else {
                                    this.addErrors(fileEntry);
                                }
                            } else {
                                this.parseRecord(string2, fileEntry, configurationManager, hostOrAlias, fileEntry.getTTL());
                            }
                        } else {
                            this.addIgnored(fileEntry);
                        }
                    }
                }
                ++n;
            }
        }
    }

    public Vector getInvalidLines() {
        Enumeration enumeration;
        Vector<String> vector = new Vector<String>();
        if (!this.ignoredLines.isEmpty()) {
            enumeration = this.ignoredLines.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement("\"" + DDNSfile.COMMENT_DELIMITER + this.theStrings.getString("FILE_IGNORED") + ((FileEntry)enumeration.nextElement()).toString() + "\"");
            }
        }
        if (!this.errorLines.isEmpty()) {
            enumeration = this.errorLines.elements();
            while (enumeration.hasMoreElements()) {
                vector.addElement("\"" + DDNSfile.COMMENT_DELIMITER + this.theStrings.getString("FILE_ERROR") + ((FileEntry)enumeration.nextElement()).toString() + "\"");
            }
        }
        if (vector.isEmpty()) {
            vector.addElement("\"" + this.theStrings.getString("NO_DOMAIN_FILE_ERRORS") + "\"");
        }
        return vector;
    }

    protected boolean isLaterInList(String string) {
        Enumeration enumeration = this.nameServerRecords.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements() && !bl) {
            FileEntry fileEntry = (FileEntry)enumeration.nextElement();
            if (!string.equals(fileEntry.getOwnerName())) continue;
            bl = true;
        }
        return bl;
    }

    protected Vector findCorrespondingA(String string) {
        Enumeration enumeration = this.dottedNames.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            FileEntry fileEntry = (FileEntry)enumeration.nextElement();
            if (!string.equals(fileEntry.getOwnerName()) || !fileEntry.getRecType().equals("A")) continue;
            vector.addElement(fileEntry.getRecordData());
            this.dottedNames.removeElement(fileEntry);
        }
        return vector;
    }

    protected void parseRecord(String string, FileEntry fileEntry, ConfigurationManager configurationManager, HostOrAlias hostOrAlias, int n) {
        if (fileEntry.getRecType().equals("A")) {
            if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                if (TcpipValidation.IsValidTcpipAddr(fileEntry.getRecordData())) {
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    ((HostObject)hostOrAlias).addIpAddress(fileEntry.getRecordData());
                    ((HostObject)hostOrAlias).setGreaterATTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                this.giveCommentsToEntry(fileEntry, null);
                this.addErrors(fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("CNAME")) {
            if (this.notReverseOrHost(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingAlias(string, this.theDomain, hostOrAlias, configurationManager);
                ((AliasHostObject)hostOrAlias).setRealHostName(fileEntry.getRecordData());
                ((AliasHostObject)hostOrAlias).setGreaterCNAMEttl(n);
                this.giveCommentsToEntry(hostOrAlias, fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("HINFO")) {
            if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                Platform platform = this.validateHINFOrecord(fileEntry.getRecordData());
                if (platform != null) {
                    ((HostObject)hostOrAlias).addCpuOpSys(platform);
                    ((HostObject)hostOrAlias).setGreaterHINFOTTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                this.addErrors(fileEntry);
                return;
            }
        } else if (fileEntry.getRecType().equals("MX")) {
            if (string.equals(this.theDomain) || string.equals(String.valueOf(this.theDomain) + ".")) {
                DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                if (domainObject != null) {
                    domainObject.addMailExchange(fileEntry.getRecordData());
                    domainObject.setGreaterMailTTL(n);
                    this.giveCommentsToEntry(domainObject, fileEntry);
                    return;
                }
            } else if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                ((HostObject)hostOrAlias).addMailExchange(fileEntry.getRecordData());
                ((HostObject)hostOrAlias).setGreaterMXTTL(n);
                this.giveCommentsToEntry(hostOrAlias, fileEntry);
                return;
            }
        } else {
            if (fileEntry.getRecType().equals("NS")) {
                this.giveCommentsToEntry(fileEntry, null);
                this.addNSRec(fileEntry);
                return;
            }
            if (fileEntry.getRecType().equals("TXT")) {
                if (this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                    String string2 = null;
                    String string3 = this.stripExteriorQuotes(fileEntry.getRecordData().trim());
                    if (string3 != null) {
                        DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(string3);
                        string2 = dDNSStringTranslator.toEscapedString();
                    }
                    if (string3 == null || string2 == null || !string2.equals(string3) || string2.indexOf(10) >= 0) {
                        this.addErrors(fileEntry);
                        return;
                    }
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    ((HostObject)hostOrAlias).addTextEntry(string2);
                    ((HostObject)hostOrAlias).setGreaterTXTTTL(n);
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
            } else {
                if (fileEntry.getRecType().equals("SIG")) {
                    if (hostOrAlias == null) {
                        if (string.equals(this.theDomain)) {
                            DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                            if (domainObject != null) {
                                domainObject.addSIGRec(fileEntry.getRecordData());
                                return;
                            }
                            this.addPendingO(fileEntry);
                            this.giveCommentsToEntry(fileEntry, null);
                            return;
                        }
                        this.addPendingO(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        return;
                    }
                    hostOrAlias.addSIGRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                if (fileEntry.getRecType().equals("KEY")) {
                    if (hostOrAlias == null) {
                        if (string.equals(this.theDomain)) {
                            DomainObject domainObject = configurationManager.getADomain(this.theDomain);
                            if (domainObject != null) {
                                domainObject.addKEYRec(fileEntry.getRecordData());
                                return;
                            }
                            this.addPendingO(fileEntry);
                            this.giveCommentsToEntry(fileEntry, null);
                            return;
                        }
                        this.addPendingO(fileEntry);
                        this.giveCommentsToEntry(fileEntry, null);
                        return;
                    }
                    hostOrAlias.addKEYRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                    return;
                }
                if (fileEntry.getRecType().equals("OTHER") && this.notReverseOrAlias(hostOrAlias, fileEntry)) {
                    hostOrAlias = this.findCorrespondingHost(string, this.theDomain, hostOrAlias, configurationManager);
                    hostOrAlias.addOtherRec(fileEntry.getRecordData());
                    this.giveCommentsToEntry(hostOrAlias, fileEntry);
                }
            }
        }
    }

    private FileEntry handleMultLines(Enumeration enumeration, FileEntry fileEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String[] stringArray = fileEntry.getComments();
        if (stringArray != null) {
            this.pendingComments.addElement(stringArray[0]);
        }
        String string = fileEntry.getRecordData();
        string = string.replace('(', ' ');
        if (fileEntry.isEndOfMultLines()) {
            string = string.replace(')', ' ');
            bl = true;
        }
        stringBuffer.append(string);
        while (!bl) {
            if (enumeration.hasMoreElements()) {
                try {
                    ParsedObject parsedObject = (ParsedObject)enumeration.nextElement();
                    FileEntry fileEntry2 = (FileEntry)parsedObject.getValue();
                    string = fileEntry2.getRecordData();
                    stringArray = fileEntry2.getComments();
                    if (stringArray != null) {
                        this.pendingComments.addElement(stringArray[0]);
                    }
                    if (fileEntry2.isEndOfMultLines()) {
                        string = string.replace(')', ' ');
                        bl = true;
                    }
                    stringBuffer.append(" " + string);
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.theTrace.traceTime("TheDomainFile", String.valueOf(this.theStrings.getString("DOMAIN_FILE_MULT_LINES_ERROR")) + fileEntry);
                    return null;
                }
            }
            this.errorLines.addElement(fileEntry);
            return null;
        }
        if (bl) {
            fileEntry.setRecordData(stringBuffer.toString());
            fileEntry.setSpanLines(false);
        }
        return fileEntry;
    }

    private String stripInteriorQuotes(String string) {
        int n = string.indexOf(34, 1);
        if (n < 0) {
            return string;
        }
        if (n == string.length() - 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        stringBuffer.append(cArray[0]);
        int n2 = 1;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\"' && n2 < cArray.length - 1) {
                if (cArray[n2 - 1] == '\\') {
                    stringBuffer.append(cArray[n2]);
                }
            } else {
                stringBuffer.append(cArray[n2]);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected String stripExteriorQuotes(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        if (string.indexOf(" ") >= 0) {
            return null;
        }
        return string;
    }

    private void writeDomainSOAdata(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, String string, String[] stringArray) {
        String[] stringArray2;
        Vector<String> vector = new Vector<String>();
        this.writeOutput(bufferedWriter, primaryDomain.getComments());
        this.writeOutput(bufferedWriter, primaryDomain.writeSOARec(string, true));
        this.writeOutput(bufferedWriter, primaryDomain.writeDynamicRecs());
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement("@     IN    NS  " + stringArray[n] + ".");
                ++n;
            }
        }
        if ((stringArray2 = primaryDomain.getMailExchange()) != null) {
            int n = 0;
            while (n < stringArray2.length) {
                int n2 = primaryDomain.getMailTTL();
                if (n2 < 0) {
                    vector.addElement(String.valueOf(this.theDomain) + "." + " IN MX   " + stringArray2[n] + ".");
                } else {
                    vector.addElement(String.valueOf(this.theDomain) + "." + "  " + n2 + " IN MX   " + stringArray2[n] + ".");
                }
                ++n;
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.writeOutput(bufferedWriter, (String[])objectArray);
    }

    protected boolean alreadyWritten(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void writeNameServersForDomain(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, ConfigurationManager configurationManager, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        NameAndIpAddressList nameAndIpAddressList = primaryDomain.getNameServerSetforDomain();
        if (nameAndIpAddressList != null) {
            Enumeration enumeration = nameAndIpAddressList.elements();
            while (enumeration.hasMoreElements()) {
                NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
                String string = nameAndIpAddress.getFqName();
                if (this.alreadyWritten(stringArray, string)) continue;
                int n = primaryDomain.getNameServerTTL();
                if (n < 0) {
                    vector.addElement(String.valueOf(this.theDomain) + "." + "   IN NS   " + string + ".");
                    continue;
                }
                vector.addElement(String.valueOf(this.theDomain) + "." + "   " + n + " IN NS   " + string + ".");
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.writeOutput(bufferedWriter, (String[])objectArray);
        }
    }

    private void writeGlueForNameServersForDomain(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, ConfigurationManager configurationManager, NameServerObject nameServerObject) {
        NameAndIpAddressList nameAndIpAddressList = null;
        boolean bl = true;
        nameAndIpAddressList = nameServerObject.getFQNames();
        if (nameAndIpAddressList != null) {
            bl = true;
            this.writeARecordForGlue(bufferedWriter, primaryDomain, configurationManager, nameServerObject, nameAndIpAddressList, bl);
        }
        if ((nameAndIpAddressList = primaryDomain.getNameServerSetforDomain()) != null) {
            bl = false;
            this.writeARecordForGlue(bufferedWriter, primaryDomain, configurationManager, nameServerObject, nameAndIpAddressList, bl);
        }
    }

    private void writeARecordForGlue(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, ConfigurationManager configurationManager, NameServerObject nameServerObject, NameAndIpAddressList nameAndIpAddressList, boolean bl) {
        Vector<String> vector = new Vector<String>();
        boolean bl2 = true;
        Enumeration enumeration = nameAndIpAddressList.elements();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            NameAndIpAddress nameAndIpAddress = (NameAndIpAddress)enumeration.nextElement();
            String string3 = nameAndIpAddress.getFqName();
            if (!bl && this.alreadyWritten(nameServerObject.getJustFQNames(), string3)) continue;
            HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(string3);
            int n = primaryDomain.getNameServerTTL();
            bl2 = true;
            if (hostOrAlias != null && (string2 = string3.substring((string = hostOrAlias.getHostName()).length() + 1, string3.length())).equals(primaryDomain.getDomName())) {
                bl2 = false;
            }
            if (nameAndIpAddress.getIpAddress().equals(DOMAIN_FILE_NO_ADDRESS) || !bl2) continue;
            if (n < 0) {
                vector.addElement(String.valueOf(string3) + "." + " IN A   " + nameAndIpAddress.getIpAddress());
                continue;
            }
            vector.addElement(String.valueOf(string3) + "." + "   " + n + " IN A   " + nameAndIpAddress.getIpAddress());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.writeOutput(bufferedWriter, (String[])objectArray);
    }

    private void writeChildNameServers(BufferedWriter bufferedWriter, PrimaryDomain primaryDomain, ConfigurationManager configurationManager) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = primaryDomain.getChildNameServers();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                ChildNameServer childNameServer = (ChildNameServer)enumeration.nextElement();
                int n = primaryDomain.getNameServerTTL();
                if (n < 0) {
                    vector.addElement(String.valueOf(childNameServer.getDomForNameServer()) + "." + "   IN NS   " + childNameServer.getServerName() + ".");
                } else {
                    vector.addElement(String.valueOf(childNameServer.getDomForNameServer()) + "." + "   " + n + " IN NS   " + childNameServer.getServerName() + ".");
                }
                HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(childNameServer.getServerName());
                if (hostOrAlias != null || childNameServer.getServerIPaddress().equals(DOMAIN_FILE_NO_ADDRESS)) continue;
                if (n < 0) {
                    vector.addElement(String.valueOf(childNameServer.getServerName()) + "." + " IN A   " + childNameServer.getServerIPaddress());
                    continue;
                }
                vector.addElement(String.valueOf(childNameServer.getServerName()) + "." + "   " + n + " IN A   " + childNameServer.getServerIPaddress());
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            this.writeOutput(bufferedWriter, (String[])objectArray);
        }
    }

    private int getNextHinfoString(StringBuffer stringBuffer, String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        while (!bl && n < cArray.length) {
            if (cArray[n] == '\"' && !bl2) {
                bl3 = !bl3;
            } else if (cArray[n] == '\\') {
                stringBuffer.append(cArray[n]);
                bl2 = true;
            } else if (bl2) {
                stringBuffer.append(cArray[n]);
                bl2 = false;
            } else if (cArray[n] == ' ') {
                if (!bl3) {
                    bl = true;
                } else {
                    stringBuffer.append(cArray[n]);
                }
            } else {
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        return n;
    }

    protected Platform validateHINFOrecord(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getNextHinfoString(stringBuffer, string);
        string2 = stringBuffer.toString();
        string4 = string.substring(n).trim();
        stringBuffer = new StringBuffer();
        int n2 = this.getNextHinfoString(stringBuffer, string4);
        string3 = stringBuffer.toString();
        string4 = string4.substring(n2).trim();
        if (string2 == null || string3 == null || string3.equals("") || !string4.equals("")) {
            return null;
        }
        DDNSStringTranslator dDNSStringTranslator = new DDNSStringTranslator(string2);
        String string5 = dDNSStringTranslator.toEscapedString();
        if (!string5.equals(string2)) {
            return null;
        }
        dDNSStringTranslator = new DDNSStringTranslator(string3);
        string5 = dDNSStringTranslator.toEscapedString();
        if (!string5.equals(string3)) {
            return null;
        }
        return new Platform(string2, string3);
    }
}

