/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import java.util.StringTokenizer;

public class TcpipValidation {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    static final String IllegalCharacters = " \t\n!@#$%^&*()_+=~`{}[]|\\:;\"'<>?,/";
    static final String AddressIllegalCharacters = " \t\n!@#$%^&*-()_+=~`{}[]|\\:;\"'<>?,/abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public static boolean IsValidFQTcpipName(String string) {
        String string2;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("")) {
            return false;
        }
        if (string.equals(".")) {
            return true;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (string.startsWith(".")) {
            return false;
        }
        if (string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, IllegalCharacters, true);
        if (stringTokenizer.hasMoreTokens() && ((string2 = stringTokenizer.nextToken()) == null || !string2.equals(string))) {
            return false;
        }
        stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (string2 != null) {
                char c;
                if ((n = n + string2.length() + 1) > 255) {
                    return false;
                }
                if (string2.length() > 63) {
                    return false;
                }
                try {
                    c = string2.charAt(0);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    break;
                }
                if (Character.isDigit(c) && !string.endsWith("in-addr.arpa")) {
                    if (!bl2) {
                        bl = TcpipValidation.isValidLastLabel(string);
                        bl2 = true;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                break;
            }
        } else {
            if (string.equals(".")) {
                return false;
            }
            if (string.indexOf("..") >= 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean IsValidNonFQTcpipName(String string) {
        String string2;
        int n = 0;
        if (string.equals("")) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (string.startsWith(".")) {
            return false;
        }
        if (string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, IllegalCharacters, true);
        if (stringTokenizer.hasMoreTokens() && ((string2 = stringTokenizer.nextToken()) == null || !string2.equals(string))) {
            return false;
        }
        stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            while (string2 != null) {
                if ((n = n + string2.length() + 1) > 255) {
                    return false;
                }
                if (string2.length() > 63) {
                    return false;
                }
                try {
                    char c = string2.charAt(0);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    break;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    continue;
                }
                break;
            }
        } else {
            if (string.equals(".")) {
                return false;
            }
            if (string.indexOf("..") >= 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean IsValidTcpipAddr(String string) {
        String string2;
        int n = 0;
        if (string.equals("")) {
            return false;
        }
        if (string.endsWith(".")) {
            return false;
        }
        if (string.startsWith(".")) {
            return false;
        }
        if (string.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, AddressIllegalCharacters, true);
        if (stringTokenizer.hasMoreTokens() && ((string2 = stringTokenizer.nextToken()) == null || !string2.equals(string))) {
            return false;
        }
        stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n = 1;
            while (string2 != null) {
                Integer n2 = new Integer(string2);
                int n3 = n2;
                if (n3 < 0 || n3 > 255 || n > 4) {
                    return false;
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            if (string.equals(".")) {
                return false;
            }
            if (string.indexOf("..") >= 0) {
                return false;
            }
        }
        return n == 4;
    }

    public static boolean IsValidTTL(int n) {
        boolean bl = true;
        if (n > Integer.MAX_VALUE || n < 0) {
            bl = false;
        }
        return bl;
    }

    public static boolean IsValidTTL(int n, int n2) {
        boolean bl = true;
        if (n > Integer.MAX_VALUE || n < 0 && n != n2) {
            bl = false;
        }
        return bl;
    }

    public static boolean IsLessThanMaxIntegerValue(String string) {
        boolean bl = true;
        String string2 = new String(Integer.toString(Integer.MAX_VALUE));
        String string3 = TcpipValidation.getDigits(string);
        if (string3 != null) {
            int n;
            int n2 = string3.length();
            if (n2 > (n = string2.length())) {
                bl = false;
            } else if (n2 == n) {
                if (string3.charAt(0) > string2.charAt(0)) {
                    bl = false;
                } else if (string3.charAt(0) == string2.charAt(0)) {
                    int n3 = 0;
                    while (n3 < n && bl) {
                        if (string3.charAt(n3) > string2.charAt(n3)) {
                            bl = false;
                        } else if (string3.charAt(n3) < string2.charAt(n3)) break;
                        ++n3;
                    }
                }
            }
        }
        return bl;
    }

    public static String getDigits(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (Character.isDigit(c)) {
                    stringBuffer.append(c);
                }
                ++n;
            }
            string2 = new String(stringBuffer.toString());
        }
        return string2;
    }

    public static boolean validateInteger(int n) {
        boolean bl = true;
        if (n > Integer.MAX_VALUE || n < 0) {
            bl = false;
        }
        return bl;
    }

    private static boolean isValidLastLabel(String string) {
        int n;
        boolean bl = false;
        if (string != null && (n = string.length()) > 0) {
            int n2 = string.lastIndexOf(".", n);
            String string2 = null;
            string2 = n2 != -1 ? string.substring(n2, n) : string;
            if (string2 != null) {
                int n3 = 0;
                while (n3 < string2.length() && !bl) {
                    if (Character.isLetter(string2.charAt(n3))) {
                        bl = true;
                    }
                    ++n3;
                }
            }
        }
        return bl;
    }
}

