/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.FileItem;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class SyslogFileEntry
extends FileItem {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String fe_tag = "FE";
    public static final String COMMENT_REC = "CMT";
    public static final String IGNORED_REC = "IGN_ENTRY";
    public static final String ERROR_REC = "ERR_ENTRY";
    public static final String number = "numLogFiles";
    public static final String size = "logFileSize";
    public static final String name = "logFileName";
    public static final String logItem = "logItem";
    public static final String logDebug = "LOG_DEBUG";
    protected String theRecType;
    protected String recordData;
    private ResourceBundle theStrings;

    public SyslogFileEntry(String string, ResourceBundle resourceBundle) {
        this.theStrings = resourceBundle;
        String string2 = new String(string.trim());
        if (!this.isComment(string2)) {
            this.parseLine(string2);
        }
    }

    public String getRecType() {
        return this.theRecType;
    }

    public String getRecordData() {
        return this.recordData;
    }

    public void setRecordData(String string) {
        this.recordData = new String(string);
    }

    private boolean isComment(String string) {
        if (string == null || string.equals("")) {
            this.theRecType = IGNORED_REC;
            this.recordData = "";
            return true;
        }
        try {
            if (string.charAt(0) == '#') {
                this.theRecType = COMMENT_REC;
                this.recordData = string.trim();
                return true;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            this.addError(String.valueOf(this.theStrings.getString("ERROR_PARSE_COMMENT")) + string);
        }
        return false;
    }

    private void parseLine(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        } else {
            this.setRecordData(string);
            this.setRecType(IGNORED_REC);
        }
        this.setRecType(string2);
        if (stringTokenizer.hasMoreTokens()) {
            this.setRecordData(stringTokenizer.nextToken());
            return;
        }
        this.setRecordData(string);
        this.setRecType(IGNORED_REC);
    }

    public void setRecType(String string) {
        if (string.equalsIgnoreCase(number)) {
            this.theRecType = new String(number);
            return;
        }
        if (string.equalsIgnoreCase(size)) {
            this.theRecType = new String(size);
            return;
        }
        if (string.equalsIgnoreCase(name)) {
            this.theRecType = new String(name);
            return;
        }
        if (string.equalsIgnoreCase(logItem)) {
            this.theRecType = new String(logItem);
            return;
        }
        this.theRecType = new String(IGNORED_REC);
    }
}

