/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.FileEntry;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class RootDomainFileEntry
extends FileEntry {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";

    public RootDomainFileEntry(String string, String string2, ResourceBundle resourceBundle) {
        super(string, string2, resourceBundle);
    }

    protected void buildRecordData(String string) {
        this.recordData = new String(string.trim());
        if ((this.theRecType == "CNAME" || this.theRecType == "NS" || this.theRecType == "PTR" || this.theRecType == "MX") && this.recordData.endsWith(".")) {
            this.recordData = new String(this.recordData.substring(0, this.recordData.length() - 1));
        }
        if (this.theRecType == "OTHER") {
            StringBuffer stringBuffer = this.theTTL >= 0 ? new StringBuffer(" " + this.theTTL + " IN " + FileEntry.theRecord) : new StringBuffer("  IN " + FileEntry.theRecord);
            stringBuffer.append(" " + this.recordData);
            this.recordData = new String(stringBuffer.toString());
        }
        if (this.recordData.indexOf("(") >= 0) {
            this.spanMultipleLines = true;
        }
        if (this.recordData.indexOf(")") >= 0) {
            this.endOfMultLines = true;
        }
    }

    protected String parseOwnerName(String string) {
        String string2;
        if (string == null || string.equals("")) {
            this.theOwnerName = null;
            return string;
        }
        if (Character.isWhitespace(string.charAt(0))) {
            this.theOwnerName = null;
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            try {
                string2 = (String)stringTokenizer.nextElement();
                if (!string2.equals("@")) {
                    if (!string2.equals(".")) {
                        if (!string2.endsWith(".")) {
                            if (this.theOrigin.equals("")) {
                                this.addError(this.theStrings.getString("UNQUAL_NAME"));
                            }
                        } else {
                            string2 = new String(string2.substring(0, string2.length() - 1));
                        }
                    }
                    if (TcpipValidation.IsValidFQTcpipName(string2) || string2.equals(".")) {
                        this.theOwnerName = new String(string2.toLowerCase());
                    } else {
                        this.addError(String.valueOf(this.theStrings.getString("INVAL_NAME")) + string);
                    }
                } else {
                    this.theOwnerName = new String("@");
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            try {
                string2 = (String)stringTokenizer.nextElement();
                return string2;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.addError(String.valueOf(this.theStrings.getString("ERR_DOMAIN_PARSE")) + string);
            }
        }
        return null;
    }

    public String getUnqualifiedOwnerName(String string) {
        if (this.theOwnerName.equals("@")) {
            return string;
        }
        int n = this.theOwnerName.indexOf(string.toLowerCase());
        if (n < 0) {
            if (this.theOwnerName.equals(".")) {
                return "123-ROOT-321";
            }
            if (this.theOwnerName.endsWith(".")) {
                return new String(this.theOwnerName.substring(0, this.theOwnerName.length() - 1));
            }
            return this.theOwnerName;
        }
        if (n == 0) {
            return string;
        }
        return new String(this.theOwnerName.substring(0, n - 1));
    }

    public String getUnqualifiedRecordData(String string) {
        if (this.recordData.equals("@")) {
            return string;
        }
        int n = this.recordData.indexOf(string);
        if (n < 0) {
            if (this.recordData.endsWith(".")) {
                return new String(this.recordData.substring(0, this.recordData.length() - 1));
            }
            return this.recordData;
        }
        if (n == 0) {
            return "";
        }
        return new String(this.recordData.substring(0, n - 1));
    }
}

