/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.NetworkHandler;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.io.File;

public class Question {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String QUEST_tag = "QUEST";
    public static final String EQUEST_tag = "EQUEST";
    public static final String reqtype_tag = "ReqTyp";
    public static final String chkName_tag = "ChkName";
    public static final String chkName2_tag = "ChkName2";
    public static final int q_DomainIsPrimary = 1;
    public static final int q_IsUniqueDomainName = 2;
    public static final int q_IsUniqueHostName = 3;
    public static final int q_ReverseDomainExists = 4;
    public static final int q_DomainIsStatic = 5;
    public static final int q_IsANameServer = 6;
    public static final int q_DomainExists = 7;
    public static final int q_readConfig = 8;
    public static final int q_ETCvariable = 10;
    public static final int q_UniqueDomFileName = 11;
    public static final int q_UniqueStaFileName = 12;
    public static final int q_IsAHost = 13;
    public static final int q_IsAnAlias = 14;
    public static final int q_IsARevHost = 15;
    public static final int q_NeedToWriteFile = 16;
    public static final int q_NameServerNamesChanged = 17;
    public static final int q_ServerIsUp = 18;
    public static final int q_FileSeparator = 19;
    private static final String ans_tag = "Ans";
    private int requestNum;
    private String checkName;
    private String checkName2;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getResponse(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        Question question;
        boolean bl;
        block23: {
            int n;
            block22: {
                String string2;
                n = 0;
                bl = false;
                ParsedObject parsedObject2 = parsedVector.getElement(reqtype_tag);
                if (parsedObject2 != null && (string2 = (String)parsedObject2.getValue()) != null) {
                    Integer n2 = Integer.valueOf(string2);
                    n = n2;
                }
                string2 = (parsedObject2 = parsedVector.getElement(chkName_tag)) != null ? new String((String)parsedObject2.getValue()) : null;
                if (n == 0 || string2 == null) break block22;
                question = new Question(n, string2);
                switch (n) {
                    case 1: {
                        bl = configurationManager.domainIsPrimary(string2);
                        break block23;
                    }
                    case 2: {
                        bl = configurationManager.isUniqueDomainName(string2);
                        break block23;
                    }
                    case 3: {
                        parsedObject2 = parsedVector.getElement(chkName2_tag);
                        String string3 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : null;
                        question = new Question(n, string2, string3);
                        bl = configurationManager.isUniqueHostName(string2, string3);
                        break block23;
                    }
                    case 4: {
                        int n3 = configurationManager.reverseDomExist(string2);
                        return question.toString(n3);
                    }
                    case 5: {
                        bl = configurationManager.domainIsStatic(string2);
                        break block23;
                    }
                    case 6: {
                        bl = configurationManager.isANameServer(string2);
                        break block23;
                    }
                    case 7: {
                        bl = configurationManager.domainExists(string2);
                        break block23;
                    }
                    case 8: {
                        bl = configurationManager.readConfig(string2);
                        break block23;
                    }
                    case 13: {
                        bl = configurationManager.hostExists(string2);
                        break block23;
                    }
                    case 14: {
                        bl = configurationManager.aliasExists(string2);
                        break block23;
                    }
                    case 15: {
                        bl = configurationManager.revHostExists(string2);
                        break block23;
                    }
                    case 16: {
                        int n4 = configurationManager.shouldWriteDynamicFile(string2);
                        return question.toString(n4);
                    }
                    case 17: {
                        NameServerObject nameServerObject = configurationManager.getFirstNameServer();
                        bl = nameServerObject.nameServerNamesHaveChanged();
                        break block23;
                    }
                    default: {
                        if (!bl) return question.toString(false);
                    }
                }
            }
            question = new Question(n);
            if (n == 8 && !(bl = configurationManager.readConfig(String.valueOf(configurationManager.getETCpath()) + File.separator + "namedb" + File.separator + "named.bt"))) {
                bl = configurationManager.readConfig(String.valueOf(configurationManager.getETCpath()) + File.separator + "namedb" + File.separator + "named.boot");
            }
            if (n == 10) {
                return question.toString(configurationManager.getETCpath());
            }
            if (n == 19) {
                return question.toString(File.separator);
            }
            if (n == 11) {
                return question.toString(configurationManager.theFileGenerator.getDomFileName());
            }
            if (n == 12) {
                return question.toString(configurationManager.theFileGenerator.getStaticFileName());
            }
            if (n == 18) {
                return question.toString(configurationManager.serverIsUp());
            }
        }
        if (!bl) return question.toString(false);
        return question.toString(true);
    }

    public Question(int n, String string) {
        this.requestNum = n;
        this.checkName = new String(string);
        this.checkName2 = null;
    }

    public Question(int n, String string, String string2) {
        this.requestNum = n;
        this.checkName = new String(string);
        this.checkName2 = new String(string2);
    }

    public Question(int n) {
        this.requestNum = n;
        this.checkName = null;
    }

    public Question(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(QUEST_tag);
        stringBuffer.append(this.buildRestOfString());
        if (bl) {
            stringBuffer.append(",Ans=t");
        } else {
            stringBuffer.append(",Ans=f");
        }
        stringBuffer.append(",EQUEST,");
        return stringBuffer.toString();
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(QUEST_tag);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",Ans=" + string);
        stringBuffer.append(",EQUEST,");
        return stringBuffer.toString();
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(QUEST_tag);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",Ans=" + String.valueOf(n));
        stringBuffer.append(",EQUEST,");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(QUEST_tag);
        stringBuffer.append(this.buildRestOfString());
        stringBuffer.append(",EQUEST,");
        return stringBuffer.toString();
    }

    private String buildRestOfString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(",ReqTyp=" + String.valueOf(this.requestNum));
        if (this.checkName != null) {
            stringBuffer.append(",ChkName=" + this.checkName);
        }
        if (this.checkName2 != null) {
            stringBuffer.append(",ChkName2=" + this.checkName2);
        }
        return stringBuffer.toString();
    }

    public boolean fromString(ParsedVector parsedVector) {
        ParsedObject parsedObject = parsedVector.getElement(ans_tag);
        String string = (String)parsedObject.getValue();
        return string.equals("t");
    }

    public int getIntFromString(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
        ParsedObject parsedObject = parsedVector.getElement(ans_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            Integer n = Integer.valueOf(string);
            return n;
        }
        return 0;
    }

    public String getStringFromString(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        ParsedVector parsedVector = dDNSNetworkStringParser.getParsed();
        ParsedObject parsedObject = parsedVector.getElement(ans_tag);
        String string = (String)parsedObject.getValue();
        if (string != null) {
            return string;
        }
        return null;
    }

    public boolean getReturnedTrueOrFalse(NetworkHandler networkHandler) {
        networkHandler.sendToServer(this.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = networkHandler.receiveFromServer();
        return this.fromString(dDNSNetworkStringParser.getParsed());
    }
}

