/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class PlatformList {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String PFL_tag = new String("PFL");
    public static final String EPFL_tag = new String("EPFL");
    private static final String numEntries_tag = new String("NumEntries");
    private Vector theList = new Vector();

    public PlatformList() {
    }

    public PlatformList(ParsedVector parsedVector) {
        this.fromString(parsedVector);
    }

    public PlatformList(PlatformList platformList) {
        if (platformList != null && !platformList.isEmpty()) {
            int n = 0;
            while (n < platformList.size()) {
                Platform platform = platformList.getPlatform(n);
                if (platform != null) {
                    this.addPlatform(platform);
                }
                ++n;
            }
        }
    }

    public Enumeration elements() {
        return this.theList.elements();
    }

    public int size() {
        return this.theList.size();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public void addPlatform(Platform platform) {
        this.theList.addElement(platform);
    }

    public void deletePlatform(Platform platform) {
        Enumeration enumeration = this.theList.elements();
        while (enumeration.hasMoreElements()) {
            Platform platform2 = (Platform)enumeration.nextElement();
            if (!platform2.equals(platform)) continue;
            this.theList.removeElement(platform2);
        }
    }

    public void clearPlatformList() {
        this.theList.removeAllElements();
    }

    public Platform getPlatform(int n) {
        Platform platform = null;
        try {
            platform = (Platform)this.theList.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        return platform;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(PFL_tag);
        stringBuffer.append("," + numEntries_tag + "=" + String.valueOf(this.theList.size()));
        Enumeration enumeration = this.theList.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Platform platform = (Platform)enumeration.nextElement();
                stringBuffer.append("," + platform.toString());
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
        }
        stringBuffer.append("," + EPFL_tag);
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        Object[] objectArray = parsedVector.getValues();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].equals(numEntries_tag) && stringArray[n].equals("PF")) {
                Platform platform = new Platform();
                n += platform.fromString(stringArray, objectArray, n);
                this.theList.addElement(platform);
            }
            ++n;
        }
    }
}

