/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.StringTokenizer;

public class NetworkStringParser {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String EQUALS_DELIMITER = "=";
    private static final String COMMA_DELIMITER = ",";
    private static final String DELIMITERS = "=,";
    private static final String QUOTE_DELIMITER = "\"";
    private static final String BACKSLASH_DELIMITER = "\\";
    private static final boolean RETURN_TOKENS = true;
    private ParsedVector networkVector;
    private String workString;
    private String commaString = new String(",");
    private String equalsString = new String("=");
    private String quoteString = new String("\"");
    private String backslashString = new String("\\");

    public NetworkStringParser(String string) {
        if (string != null) {
            this.networkVector = new ParsedVector();
            this.parseString(string);
        }
    }

    public ParsedVector getParsed() {
        return this.networkVector;
    }

    private void parseString(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string != null) {
            new String(string);
            this.workString = new String(string);
            while (this.workString != null) {
                string2 = this.getKey();
                string3 = this.getDelimiter();
                string4 = this.getValue(string3);
                ParsedObject parsedObject = new ParsedObject(string2, string4);
                this.networkVector.append(parsedObject);
            }
        }
    }

    private String getDelimiter() {
        String string = null;
        if (this.workString != null) {
            string = this.workString.substring(0, 1);
            this.workString = this.workString.length() > 1 ? this.workString.substring(1, this.workString.length()) : null;
        }
        return string;
    }

    private String getKey() {
        String string = null;
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (this.workString != null) {
            n2 = this.workString.indexOf(this.equalsString, 0);
            n3 = this.workString.indexOf(this.commaString, 0);
            if (n2 != -1 && n2 < n3) {
                n = n2;
            } else if (n3 != -1) {
                n = n3;
            } else if (n2 != -1) {
                n = n2;
            }
            if (n != -1 && n > 0) {
                string = this.workString.substring(0, n);
                this.workString = this.workString.substring(n, this.workString.length());
            }
        }
        return string;
    }

    private String getValue(String string) {
        String string2 = null;
        int n = 0;
        if (string.compareTo(this.commaString) == 0) {
            string2 = null;
        } else if (string.compareTo(this.equalsString) == 0) {
            if (this.workString.charAt(0) == this.commaString.charAt(0)) {
                string2 = null;
                n = this.commaString.length();
            } else if (this.workString.charAt(0) == this.quoteString.charAt(0)) {
                string2 = this.getQuotedString();
                if (this.workString.charAt(0) == this.commaString.charAt(0)) {
                    n = this.commaString.length();
                }
            } else {
                string2 = this.getUnquotedString();
                if (this.workString.charAt(0) == this.commaString.charAt(0)) {
                    n = this.commaString.length();
                }
            }
        } else {
            string2 = null;
            n = 1;
        }
        if (this.workString != null) {
            this.workString = this.workString.substring(n, this.workString.length());
        }
        return string2;
    }

    private String getUnquotedString() {
        int n;
        String string = null;
        if (this.workString != null && (n = this.workString.indexOf(this.commaString, 0)) != -1) {
            string = new String(this.workString.substring(0, n));
            this.workString = this.workString.substring(n, this.workString.length());
        }
        return string;
    }

    private String getQuotedString() {
        String string = null;
        StringBuffer stringBuffer = null;
        if (this.workString != null && this.workString.charAt(0) == this.quoteString.charAt(0)) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.workString, this.commaString, true);
            if (stringTokenizer.countTokens() > 1) {
                String string2 = new String(stringTokenizer.nextToken());
                stringBuffer = new StringBuffer();
                while (string2 != null && string2.charAt(string2.length() - 1) != this.quoteString.charAt(0) || string2.charAt(string2.length() - 1) == this.quoteString.charAt(0) && string2.charAt(string2.length() - 2) == this.backslashString.charAt(0)) {
                    stringBuffer.append(string2);
                    string2 = new String(stringTokenizer.nextToken());
                }
                if (string2 != null) {
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
                string = string.substring(1, string.length() - 1);
                this.workString = this.workString.substring(string.length() + 2, this.workString.length());
            } else {
                string = new String(this.workString.substring(1, this.workString.length() - 1));
                this.workString = null;
            }
        }
        return string;
    }

    private void nspTrace(String string) {
    }
}

