/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.ListPanelGrid;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import java.util.Vector;

public class ListPanel
extends BorderPanel
implements ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String FIELD_SEPARATOR = "     ";
    public static final boolean MULTIPLE_SELECTIONS_ON = true;
    public static final boolean MULTIPLE_SELECTIONS_OFF = false;
    private static final int NUM_ROWS_VISIBLE = 4;
    private static final int NUM_TEXT_COLUMNS = 10;
    private static final int ONE_FIELD = 1;
    private static final int TWO_FIELDS = 2;
    private static final int THREE_FIELDS = 3;
    public static final int FIRST_FIELD = 0;
    public static final int SECOND_FIELD = 1;
    public static final int THIRD_FIELD = 2;
    public static final int MAX_FIELDS = 3;
    private Container parent;
    private ResourceBundle resources;
    private Label[] fieldLabels;
    private TextField[] fields;
    private int numFields;
    private List items;
    private Button addButton;
    private Button removeButton;
    private Button optionalButton;
    private msgBox okBox;
    private String separator = "     ";
    private WrappedTextPanel textPanel;
    private int textLines;

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String string2, int n) {
        this(container, resourceBundle, string, string2, null, n, "");
    }

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String string2, int n, String string3) {
        this(container, resourceBundle, string, string2, null, n, string3);
    }

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String string2, String string3, int n) {
        this(container, resourceBundle, string, string2, string3, n, "");
    }

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String string2, String string3, int n, String string4) {
        super(string);
        this.parent = container;
        this.resources = resourceBundle;
        Vector<String> vector = new Vector<String>();
        this.numFields = 1;
        vector.addElement(string2);
        if (string3 != null) {
            vector.addElement(string3);
            this.numFields = 2;
        }
        this.initComponents(vector, n, string4, null);
        this.addComponentsToGrid();
    }

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String[] stringArray, int n, String string2, ListPanelGrid listPanelGrid) {
        this(container, resourceBundle, string, stringArray, n, string2, listPanelGrid, null);
    }

    public ListPanel(Container container, ResourceBundle resourceBundle, String string, String[] stringArray, int n, String string2, ListPanelGrid listPanelGrid, String string3) {
        super(string);
        this.parent = container;
        this.resources = resourceBundle;
        this.numFields = stringArray.length;
        if (this.numFields > 3) {
            this.numFields = 3;
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < this.numFields) {
            if (stringArray[n2] != null) {
                vector.addElement(stringArray[n2]);
            }
            ++n2;
        }
        this.numFields = vector.size();
        this.initComponents(vector, n, string2, string3);
        if (listPanelGrid != null) {
            this.addComponentsToGrid(listPanelGrid);
            return;
        }
        this.addComponentsToGrid();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.dispatchEvent(actionEvent);
        }
    }

    public String getTextSeparator() {
        return this.separator;
    }

    public void setTextSeparator(String string) {
        this.separator = new String(string);
    }

    public void setExplanationText(String string) {
        if (string != null) {
            this.textPanel.relayoutText(string);
        }
    }

    public boolean setFieldLabels(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null && stringArray.length == this.numFields) {
            int n = 0;
            while (n < this.numFields) {
                this.fieldLabels[n].setText(stringArray[n]);
                bl = true;
                ++n;
            }
        }
        return bl;
    }

    public String getFirstTextField() {
        return this.fields[0].getText().trim();
    }

    public void setFirstTextField(String string) {
        ((TextComponent)this.fields[0]).setText(string.trim());
    }

    public String getSecondTextField() {
        return this.fields[1].getText().trim();
    }

    public void setSecondTextField(String string) {
        ((TextComponent)this.fields[1]).setText(string.trim());
    }

    public String getTextField(int n) {
        String string = null;
        if (this.isFieldIndexValid(n)) {
            string = new String(this.fields[n].getText().trim());
        }
        return string;
    }

    public void setTextField(int n, String string) {
        if (this.isFieldIndexValid(n)) {
            ((TextComponent)this.fields[n]).setText(string.trim());
        }
    }

    public boolean isTextFieldEmpty(int n) {
        boolean bl = true;
        if (this.isFieldIndexValid(n) && this.getTextField(n).compareTo("") != 0) {
            bl = false;
        }
        return bl;
    }

    public void requestFocus(int n) {
        if (this.isFieldIndexValid(n)) {
            this.fields[n].requestFocus();
        }
    }

    public void selectAll(int n) {
        if (this.isFieldIndexValid(n) && this.fields[n].isEnabled()) {
            this.fields[n].selectAll();
        }
    }

    public String[] getAllTextFields() {
        String[] stringArray = null;
        if (this.numFields > 0) {
            stringArray = new String[this.numFields];
            int n = 0;
            while (n < this.numFields) {
                stringArray[n] = new String(this.getTextField(n));
                ++n;
            }
        }
        return stringArray;
    }

    public void addItem(String string) {
        this.items.addItem(string.trim());
        int n = this.items.getItemCount();
        this.items.makeVisible(n - 1);
    }

    public String getItem(int n) {
        return this.items.getItem(n).trim();
    }

    public void replaceItem(String string, int n) {
        this.items.replaceItem(string.trim(), n);
    }

    public int getItemCount() {
        return this.items.getItemCount();
    }

    public void remove(int n) {
        this.items.remove(n);
    }

    public synchronized void removeAll() {
        this.items.removeAll();
    }

    public String[] getItemList() {
        int n = 0;
        String[] stringArray = null;
        n = this.items.getItemCount();
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.items.getItem(n2).trim();
            ++n2;
        }
        return stringArray;
    }

    public int getItemIndex(String string) {
        int n = -1;
        if (string != null && string.length() > 0) {
            int n2 = 0;
            while (n2 < this.getItemCount()) {
                if (string.trim().compareTo(this.getItem(n2)) == 0) {
                    n = n2;
                }
                ++n2;
            }
        }
        return n;
    }

    public synchronized int getSelectedIndex() {
        return this.items.getSelectedIndex();
    }

    public synchronized int[] getSelectedIndexes() {
        return this.items.getSelectedIndexes();
    }

    public void setMultipleMode(boolean bl) {
        this.items.setMultipleMode(bl);
    }

    public Button getAddButton() {
        return this.addButton;
    }

    public Button getRemoveButton() {
        return this.removeButton;
    }

    public Button getOptionalButton() {
        return this.optionalButton;
    }

    public void setEnabled(boolean bl) {
        int n = 0;
        while (n < this.numFields) {
            if (this.fieldLabels[n] != null) {
                this.fieldLabels[n].setEnabled(bl);
            }
            if (this.fields[n] != null) {
                this.fields[n].setEnabled(bl);
                if (!bl) {
                    ((Component)this.fields[n]).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
                } else {
                    ((Component)this.fields[n]).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
                }
            }
            ++n;
        }
        this.items.setEnabled(bl);
        if (!bl) {
            this.items.setBackground(DDNSUtility.BACKGROUND_COLOR);
        } else {
            this.items.setBackground(Color.white);
        }
        this.addButton.setEnabled(bl);
        this.removeButton.setEnabled(bl);
        this.setEnabledOptionalButton(bl);
        super.setEnabled(bl);
    }

    public void setEnabledOptionalButton(boolean bl) {
        if (this.optionalButton != null) {
            this.optionalButton.setEnabled(bl);
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void handleButton(Button button) {
        if (button == this.getAddButton()) {
            this.handleAdd(this.getAllTextFields());
            return;
        }
        if (button == this.getRemoveButton()) {
            this.handleRemove();
        }
    }

    protected void handleAdd(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.numFields >= 2 && this.fields[1] != null) {
            stringBuffer.append(this.separator);
        }
        if (string != null && string.compareTo("") == 0 || this.numFields >= 2 && this.fields[1] != null && string2 != null && string2.compareTo("") == 0) {
            this.okBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("LIST_PANEL_OK_BOX_TEXT"), 1, true);
            if (string.compareTo("") == 0) {
                this.setFirstTextField("");
                this.requestFocus(0);
                return;
            }
            if (this.fields[1] != null && string2 != null && string2.compareTo("") == 0) {
                this.setSecondTextField("");
                this.requestFocus(1);
                return;
            }
        } else {
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            this.setFirstTextField("");
            if (this.numFields >= 2 && this.fields[1] != null) {
                this.setSecondTextField("");
            }
            this.addItem(stringBuffer.toString());
        }
    }

    protected void handleAdd() {
        this.handleAdd(this.getAllTextFields());
    }

    protected void handleAdd(String[] stringArray) {
        boolean bl = true;
        if (this.numFields > 0) {
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 0;
            while (n < this.numFields && bl) {
                if (stringArray[n] != null && stringArray[n].compareTo("") == 0) {
                    bl = false;
                    this.okBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("LIST_PANEL_OK_BOX_TEXT"), 1, true);
                    if (stringArray[n].compareTo("") == 0) {
                        this.setTextField(n, "");
                        this.requestFocus(n);
                    }
                } else if (bl && stringArray[n] != null) {
                    stringBuffer.append(stringArray[n]);
                    if (n + 1 != this.numFields) {
                        stringBuffer.append(this.separator);
                    }
                }
                ++n;
            }
            if (bl) {
                this.addItem(stringBuffer.toString());
                int n2 = 0;
                while (n2 < this.numFields) {
                    this.setTextField(n2, "");
                    ++n2;
                }
            }
        }
    }

    protected void handleRemove() {
        int[] nArray = this.items.getSelectedIndexes();
        int n = nArray.length - 1;
        while (n >= 0) {
            this.items.delItem(nArray[n]);
            --n;
        }
    }

    private void initComponents(Vector vector, int n, String string, String string2) {
        this.textLines = 0;
        this.textPanel = new WrappedTextPanel(string);
        this.textLines = this.textPanel.getNumDividedTextLines();
        this.fieldLabels = new Label[this.numFields];
        this.fields = new TextField[this.numFields];
        int n2 = 0;
        while (n2 < this.numFields) {
            this.fieldLabels[n2] = new Label((String)vector.elementAt(n2), 0);
            this.fields[n2] = new TextField("", 10);
            ++n2;
        }
        if (n < 1) {
            n = 4;
        }
        this.items = new List(n, true);
        this.items.setBackground(Color.white);
        this.addButton = new Button(this.resources.getString("ADD_LABEL"));
        this.addButton.addKeyListener(this);
        this.removeButton = new Button(this.resources.getString("REMOVE_LABEL"));
        this.removeButton.addKeyListener(this);
        if (string2 != null && string2.length() > 0 && string2.compareTo("") != 0) {
            this.optionalButton = new Button(string2);
            this.optionalButton.addKeyListener(this);
        } else {
            this.optionalButton = null;
        }
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        if (this.optionalButton != null) {
            this.optionalButton.addActionListener(this);
        }
    }

    private void addComponentsToGrid() {
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.textPanel, gridBagLayout, gridBagConstraints, 0, 0, 0, this.textLines);
        int n2 = 0;
        while (n2 < this.numFields) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            n = n2 * 2;
            this.add(this.fieldLabels[n2], gridBagLayout, gridBagConstraints, n, this.textLines, 1, 1);
            gridBagConstraints.fill = 2;
            this.add(this.fields[n2], gridBagLayout, gridBagConstraints, ++n, this.textLines, 1, 1);
            ++n2;
        }
        gridBagConstraints.fill = 0;
        this.add(this.addButton, gridBagLayout, gridBagConstraints, n += 2, this.textLines, 0, 1);
        gridBagConstraints.fill = 1;
        this.add(this.items, gridBagLayout, gridBagConstraints, 0, 1 + this.textLines, n, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.add(this.removeButton, gridBagLayout, gridBagConstraints, n, 1 + this.textLines, 0, 1);
        if (this.optionalButton != null) {
            this.add(this.optionalButton, gridBagLayout, gridBagConstraints, n, 2 + this.textLines, 0, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addComponentsToGrid(ListPanelGrid var1_1) {
        block5: {
            var2_2 = 0;
            var3_3 = 0;
            var4_4 = 0;
            var5_5 = 0;
            var6_6 = this.textLines;
            var7_7 = new GridBagLayout();
            var8_8 = new GridBagConstraints();
            this.setLayout(var7_7);
            var8_8.fill = 0;
            var8_8.anchor = 17;
            var8_8.weightx = 1.0;
            var8_8.weighty = 1.0;
            this.add(this.textPanel, var7_7, var8_8, 0, 0, 0, this.textLines);
            var3_3 = var1_1.getTotalFields();
            if (this.numFields > var3_3) break block5;
            var9_9 = var1_1.startField;
            ** GOTO lbl36
            {
                ++var2_2;
                var5_5 += 2;
                if (++var4_4 >= var1_1.columns) {
                    ++var6_6;
                    var5_5 = 0;
                    var4_4 = 0;
                }
                do {
                    if (!var1_1.positions.get(var2_2)) continue block0;
                    if (var2_2 < var3_3) {
                        var8_8.fill = 0;
                        var8_8.anchor = 17;
                        this.add(this.fieldLabels[var9_9], var7_7, var8_8, var5_5, var6_6, 1, 1);
                        var8_8.fill = 2;
                        this.add(this.fields[var9_9], var7_7, var8_8, ++var5_5, var6_6, 1, 1);
                        ++var5_5;
                    }
                    ++var4_4;
                    ++var2_2;
                    ++var9_9;
lbl36:
                    // 2 sources

                } while (var9_9 < this.numFields && var2_2 < var3_3);
            }
        }
        var8_8.fill = 0;
        this.add(this.addButton, var7_7, var8_8, var5_5, var6_6, 0, 1);
        var8_8.fill = 1;
        this.add(this.items, var7_7, var8_8, 0, 1 + var6_6, var5_5, 0);
        var8_8.fill = 0;
        var8_8.anchor = 18;
        this.add(this.removeButton, var7_7, var8_8, var5_5, 1 + var6_6, 0, 1);
        if (this.optionalButton != null) {
            this.add(this.optionalButton, var7_7, var8_8, var5_5, 2 + var6_6, 0, 1);
        }
    }

    private boolean isFieldIndexValid(int n) {
        boolean bl = false;
        if (n >= 0 && n < 3) {
            bl = true;
        }
        return bl;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
            this.parent.dispatchEvent(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

