/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import java.awt.Color;
import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;

public class DDNSUtility {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String DRIVE_DELIMITER = ":";
    public static final String FILE_EXTENSION_DELIMITER = ".";
    public static final String REVERSE_DOMAIN = "in-addr.arpa";
    public static final String FULLY_QUALIFIED_DELIMITER = ".";
    public static final int NOT_FOUND = -1;
    public static final String DEFAULT_TEXT = "";
    public static final String FRAME_NAME_SEPARATOR = " -- ";
    public static final Color BACKGROUND_COLOR = Color.lightGray;
    public static final Color TEXT_COLOR = Color.black;
    public static final Color TEXT_FIELD_DISABLE_COLOR = Color.gray;
    public static final Color TEXT_FIELD_ENABLE_COLOR = Color.white;
    public static final Color CHOICE_ENABLE_COLOR = Color.white;
    public static final Color HIGHLIGHT_COLOR = Color.black;
    public static final String SANS_SERIF_FONT = "sansserif";
    public static final String SERIF_FONT = "serif";
    public static final String COURIER_FONT = "monospaced";

    public static int getCountryFontSize() {
        if (DDNSUtility.isDoubleByteLocale()) {
            return 12;
        }
        return 10;
    }

    private static boolean isDoubleByteLocale() {
        String string = Locale.getDefault().getLanguage();
        return string.equalsIgnoreCase("ja") || string.equalsIgnoreCase("ko") || string.equalsIgnoreCase("zh");
    }

    public static boolean hasDriveDelimiter(String string) {
        boolean bl = false;
        bl = string.indexOf(DRIVE_DELIMITER, 0) != -1;
        return bl;
    }

    public static boolean hasFileExtensionDelimiter(String string) {
        boolean bl = false;
        bl = string.indexOf(".", 0) != -1;
        return bl;
    }

    public static String stripFileName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        if (string != null) {
            while (true) {
                if ((n = string.indexOf(String.valueOf(File.separator) + File.separator, n2)) < 0) {
                    if (n2 == 0 || n2 >= string.length()) break;
                    stringBuffer.append(string.substring(n2));
                    break;
                }
                try {
                    stringBuffer.append(String.valueOf(string.substring(n2, n)) + File.separator);
                    n2 = n + 2;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
            }
            if (stringBuffer.length() > 0) {
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String padFileName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator, false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(String.valueOf(stringTokenizer.nextElement()) + File.separator + File.separator);
        }
        String string2 = stringBuffer.toString();
        if (string2.endsWith(String.valueOf(File.separator) + File.separator)) {
            return string2.substring(0, string2.length() - 2);
        }
        return string2;
    }
}

