/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.HostList;
import COM.ibm.raleigh.ddnssgui.common.NetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.PlatformList;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;

public class DDNSNetworkStringParser
extends NetworkStringParser {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String CLASS_NAME = "DDNSNetworkStringParser";
    private static final int NO_OBJECT = -1;
    private static final String validReturnCodeKey = "RC";
    private static final String[] validStartObjectKeys = new String[]{"NSO", "NAIL", "PDOM", "DOM", "SDOM", "HOST", "HOA", "ALIAS", ReverseHost.REVH_tag, "QUEST", "REQLIST", HostList.HLIST_tag, "CMDSRVR", "RN", "CHILDL", "NSetL", "USRSET", "TND", PlatformList.PFL_tag, "RFS", "RFileList", "REI"};
    private static final String[] validEndObjectKeys = new String[]{"ENSO", "ENAIL", "EPDOM", "EDOM", "ESDOM", "EHOST", "EHOA", "EALIAS", ReverseHost.EREVH_tag, "EQUEST", "EREQLLIST", HostList.EHLIST_tag, "ECMDSRVR", "ERN", "ECHILDL", "ENSetL", "EUSRSET", "ETND", PlatformList.EPFL_tag, "ERFS", "eRFileList", "EREI"};
    private static final String[] validBaseObjectKeys = new String[]{"NSO", "PDOM", "SDOM", "HOST", "ALIAS", ReverseHost.REVH_tag, "QUEST", "REQLIST", HostList.HLIST_tag, "CMDSRVR", "RN", "USRSET", "RFS", "REI"};
    private ParsedVector ddnsVector;
    private ParsedObject ddnsReturnCode;
    private TraceClient tracer;
    private String thisMethod;

    public DDNSNetworkStringParser(String string, TraceClient traceClient) {
        super(string);
        this.tracer = traceClient;
        this.createParsedVector(super.getParsed());
    }

    public ParsedVector getParsed() {
        return this.ddnsVector;
    }

    public ParsedObject getReturnCode() {
        return this.ddnsReturnCode;
    }

    private void createParsedVector(ParsedVector parsedVector) {
        this.thisMethod = "createParsedVector";
        if (!parsedVector.isEmpty()) {
            String[] stringArray = parsedVector.getKeys();
            int n = this.countObjectKeys(stringArray);
            if (n > 0) {
                this.ddnsVector = new ParsedVector();
                this.separateObjects(parsedVector, stringArray, n);
                return;
            }
            this.ddnsVector = null;
            return;
        }
        this.ddnsVector = null;
    }

    private void separateObjects(ParsedVector parsedVector, String[] stringArray, int n) {
        String string;
        int n2;
        this.thisMethod = "separateObjects";
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        ParsedVector[] parsedVectorArray = null;
        String string2 = null;
        if (n > 0) {
            parsedVectorArray = new ParsedVector[n];
            n2 = 0;
            while (n2 < n) {
                parsedVectorArray[n2] = null;
                ++n2;
            }
        }
        this.ddnsReturnCode = null;
        n2 = 0;
        while (n2 < stringArray.length) {
            string = stringArray[n2];
            if (this.isReturnCodeKey(string)) {
                this.ddnsReturnCode = parsedVector.get(n2);
            } else if (this.isStartObjectKey(string)) {
                n4 = ++n3;
                if (this.isBaseObjectKey(string)) {
                    n6 = n5 = n4;
                    parsedVectorArray[n5] = new ParsedVector();
                    parsedVectorArray[n5].append(parsedVector.get(n2));
                } else {
                    parsedVectorArray[n4] = new ParsedVector();
                    parsedVectorArray[n4].append(parsedVector.get(n2));
                    String string3 = null;
                    if (string2 != null) {
                        parsedVectorArray[n6].removeElementAt(parsedVectorArray[n6].lastIndexOf(parsedVectorArray[n6].lastElement()));
                        string3 = new String(string2);
                        string2 = null;
                    } else {
                        string3 = new String(string);
                    }
                    ParsedObject parsedObject = new ParsedObject(string3, parsedVectorArray[n4]);
                    parsedVectorArray[n6].append(parsedObject);
                    ++n6;
                }
            } else if (this.isEndObjectKey(string)) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                n4 = --n6;
            } else if (n4 != -1) {
                parsedVectorArray[n4].append(parsedVector.get(n2));
                string2 = new String(string);
            }
            ++n2;
        }
        this.ddnsVector = parsedVectorArray[n5];
        string = null;
        if (this.ddnsReturnCode != null) {
            string = new String(this.ddnsReturnCode.toString());
        }
    }

    private int countObjectKeys(String[] stringArray) {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.isStartObjectKey(stringArray[n2])) {
                    ++n;
                }
                ++n2;
            }
        }
        return n;
    }

    private boolean isStartObjectKey(String string) {
        this.thisMethod = "isStartObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validStartObjectKeys.length && !bl) {
            if (string.equals(validStartObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isEndObjectKey(String string) {
        this.thisMethod = "isEndObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validEndObjectKeys.length && !bl) {
            if (string.equals(validEndObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isBaseObjectKey(String string) {
        this.thisMethod = "isBaseObjectKey";
        boolean bl = false;
        int n = 0;
        while (n < validBaseObjectKeys.length && !bl) {
            if (string.equals(validBaseObjectKeys[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private boolean isReturnCodeKey(String string) {
        this.thisMethod = "isReturnCodeKey";
        boolean bl = false;
        if (string.equals(validReturnCodeKey)) {
            bl = true;
        }
        return bl;
    }
}

