/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.CacheFileItem;
import COM.ibm.raleigh.ddnssgui.common.DDNSfile;
import COM.ibm.raleigh.ddnssgui.common.FileEntry;
import COM.ibm.raleigh.ddnssgui.common.FileItem;
import COM.ibm.raleigh.ddnssgui.common.InvalidCacheFileItem;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.NameServerObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.TraceClient;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;

public class CacheFile
extends DDNSfile {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String CLASS_NAME = "CacheFile";
    private static final String ROOT_SERVER_INDICATOR = ".";
    private static final String FULLY_QUALIFIED_INDICATOR = ".";
    private static final int ROOT_SERVER_TTL_VALUE = 3600000;
    private TraceClient tracer;
    private String cacheOrigin;
    private Vector cacheFileItemList;
    private Vector invalidCacheFileItemList;
    private Vector nameServersWritten;

    public CacheFile(TraceClient traceClient, ResourceBundle resourceBundle) {
        super(resourceBundle);
        this.tracer = traceClient;
        this.cacheFileItemList = new Vector();
        this.invalidCacheFileItemList = new Vector();
        this.nameServersWritten = new Vector();
        this.setTrace(traceClient, CLASS_NAME);
    }

    public boolean readFile(String string, NameServerObject nameServerObject) {
        boolean bl = false;
        String string2 = "readFile";
        new String(string2);
        bl = this.buildFileVector(string);
        if (bl) {
            this.parseFileVector();
            this.loadDataModel(nameServerObject);
        }
        return bl;
    }

    public boolean writeFile(String string, NameServerObject nameServerObject, boolean bl) {
        boolean bl2 = false;
        NameAndIpAddressList nameAndIpAddressList = null;
        String string2 = "writeFile";
        if (nameServerObject != null && string != null && string.length() > 0) {
            nameAndIpAddressList = nameServerObject.getRootServers();
            bl2 = this.writeCacheFile(string, nameAndIpAddressList, bl);
            this.clearNameServersWritten();
            this.deleteZeroLengthFile(string);
        } else {
            this.tracer.traceTime(CLASS_NAME, string2, this.theStrings.getString("CACHE_FILE_NULL"));
        }
        return bl2;
    }

    public String[] getInvalidCacheItems() {
        String[] stringArray = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (this.invalidCacheFileItemList != null && !this.invalidCacheFileItemList.isEmpty()) {
            int n2 = this.invalidCacheFileItemList.size();
            InvalidCacheFileItem invalidCacheFileItem = null;
            if (n2 == 0) {
                vector.addElement(this.theStrings.getString("NO_INVALID_ITEMS"));
            } else {
                n = 0;
                while (n < n2) {
                    invalidCacheFileItem = (InvalidCacheFileItem)this.invalidCacheFileItemList.elementAt(n);
                    String string = this.invalidEntryToString(invalidCacheFileItem);
                    if (string != null && string.trim().compareTo("") != 0) {
                        vector.addElement(new String(string));
                    }
                    ++n;
                }
            }
        } else {
            vector.addElement(this.theStrings.getString("NO_INVALID_ITEMS"));
        }
        if (!vector.isEmpty()) {
            stringArray = new String[vector.size()];
            n = 0;
            while (n < vector.size()) {
                stringArray[n] = new String((String)vector.elementAt(n));
                ++n;
            }
        } else {
            stringArray = new String[]{this.theStrings.getString("NO_INVALID_ITEMS")};
        }
        return stringArray;
    }

    private boolean buildFileVector(String string) {
        boolean bl = false;
        String string2 = null;
        FileEntry fileEntry = null;
        InvalidCacheFileItem invalidCacheFileItem = null;
        Integer n = null;
        String string3 = "buildFileVector";
        this.cacheOrigin = null;
        BufferedReader bufferedReader = this.setInputFile(string);
        if (bufferedReader != null) {
            string2 = this.getNextLine(bufferedReader);
            while (string2 != null && string2.trim().compareTo("") != 0) {
                try {
                    string2 = string2.trim();
                    fileEntry = new FileEntry(string2, this.cacheOrigin, this.theStrings);
                    if (!fileEntry.areErrors()) {
                        if (fileEntry.getRecType().equals("$ORIGIN")) {
                            this.cacheOrigin = new String(fileEntry.getRecordData());
                        }
                        super.addToFile(fileEntry.getRecType(), fileEntry);
                    } else {
                        if (n == null) {
                            n = new Integer(1);
                        }
                        invalidCacheFileItem = new InvalidCacheFileItem(string2, n);
                        this.invalidCacheFileItemList.addElement(invalidCacheFileItem);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    this.tracer.traceTime(CLASS_NAME, string3, this.theStrings.getString("ARRAY_ERROR_EXCEPTION"));
                    this.closeInput();
                    return bl;
                }
                string2 = this.getNextLine(bufferedReader);
                bl = true;
            }
        } else {
            this.tracer.traceTime(CLASS_NAME, string3, String.valueOf(this.theStrings.getString("FILE_NOT_FOUND_EXCEPTION")) + string);
            return bl;
        }
        this.closeInput();
        return bl;
    }

    private void parseFileVector() {
        ParsedObject parsedObject = null;
        FileEntry fileEntry = null;
        Vector<FileEntry> vector = new Vector<FileEntry>();
        CacheFileItem cacheFileItem = null;
        InvalidCacheFileItem invalidCacheFileItem = null;
        String string = null;
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Integer n3 = null;
        n = 0;
        while (n < this.theFileData.size()) {
            bl = false;
            n3 = null;
            parsedObject = this.theFileData.get(n);
            fileEntry = (FileEntry)parsedObject.getValue();
            string = fileEntry.getRecType();
            if (!bl && string.equals("CMT")) {
                vector.addElement(fileEntry);
                bl = true;
            }
            if (!bl && string.equals("$ORIGIN")) {
                bl = true;
            }
            if (!bl && string.equals("NS")) {
                if (fileEntry.getOwnerName().equals(".")) {
                    cacheFileItem = new CacheFileItem(fileEntry.getRecordData());
                    cacheFileItem.setRootServerFlag(true);
                    this.addComments(vector, cacheFileItem);
                    this.cacheFileItemList.addElement(cacheFileItem);
                    bl = true;
                } else {
                    n3 = new Integer(0);
                    bl = false;
                }
            }
            if (!bl && string.equals("A")) {
                int n4 = this.getCacheFileItemIndex(fileEntry.getOwnerName());
                if (n4 == -1) {
                    n3 = new Integer(0);
                    bl = false;
                } else {
                    cacheFileItem = (CacheFileItem)this.cacheFileItemList.elementAt(n4);
                    if (cacheFileItem != null) {
                        cacheFileItem.addIPAddress(fileEntry.getRecordData());
                    }
                    if (!vector.isEmpty()) {
                        n2 = 0;
                        while (n2 < vector.size()) {
                            cacheFileItem.AddComment(((FileEntry)vector.elementAt(n2)).getRecordData());
                            ++n2;
                        }
                        vector.removeAllElements();
                    }
                    bl = true;
                }
            }
            if (!bl) {
                if (n3 == null) {
                    n3 = new Integer(1);
                }
                invalidCacheFileItem = new InvalidCacheFileItem(fileEntry.toString(), n3);
                this.addComments(vector, invalidCacheFileItem);
                this.invalidCacheFileItemList.addElement(invalidCacheFileItem);
                bl = false;
            }
            ++n;
        }
        if (!vector.isEmpty()) {
            invalidCacheFileItem = new InvalidCacheFileItem("", 0);
            this.addComments(vector, invalidCacheFileItem);
            this.invalidCacheFileItemList.addElement(invalidCacheFileItem);
        }
    }

    private int getCacheFileItemIndex(String string) {
        int n = -1;
        boolean bl = false;
        CacheFileItem cacheFileItem = null;
        if (this.cacheFileItemList != null && string != null) {
            int n2 = 0;
            while (n2 < this.cacheFileItemList.size() && !bl) {
                cacheFileItem = (CacheFileItem)this.cacheFileItemList.elementAt(n2);
                if (string.equals(cacheFileItem.getNameServerName().toLowerCase()) && cacheFileItem.isRootServer()) {
                    n = n2;
                    bl = true;
                }
                ++n2;
            }
        }
        return n;
    }

    private void loadDataModel(NameServerObject nameServerObject) {
        CacheFileItem cacheFileItem = null;
        InvalidCacheFileItem invalidCacheFileItem = null;
        String string = null;
        String[] stringArray = null;
        String string2 = "loadDataModel";
        if (nameServerObject != null) {
            int n = 0;
            while (n < this.cacheFileItemList.size()) {
                cacheFileItem = (CacheFileItem)this.cacheFileItemList.elementAt(n);
                string = cacheFileItem.getNameServerName();
                if (string != null && cacheFileItem.isRootServer()) {
                    stringArray = cacheFileItem.getIPAddressList();
                    if (stringArray != null) {
                        int n2 = 0;
                        while (n2 < stringArray.length) {
                            nameServerObject.addRootServer(string, stringArray[n2]);
                            ++n2;
                        }
                    } else {
                        invalidCacheFileItem = new InvalidCacheFileItem(this.buildFileEntryLine(".", Integer.toString(3600000), "NS", String.valueOf(string) + "."), 1);
                        invalidCacheFileItem.setComments(cacheFileItem.getComments());
                        this.tracer.traceTime(CLASS_NAME, string2, String.valueOf(this.theStrings.getString("INVAL_CACHE_ITEM")) + invalidCacheFileItem.toString());
                        this.invalidCacheFileItemList.addElement(invalidCacheFileItem);
                    }
                }
                ++n;
            }
        }
    }

    private boolean writeCacheFile(String string, NameAndIpAddressList nameAndIpAddressList, boolean bl) {
        boolean bl2 = true;
        BufferedWriter bufferedWriter = this.setOutputFile(string);
        if (bl2 && bufferedWriter != null) {
            bl2 = this.writeCacheFileHeader(bufferedWriter);
            if (nameAndIpAddressList != null) {
                int n = 0;
                while (n < nameAndIpAddressList.size()) {
                    NameAndIpAddress nameAndIpAddress = nameAndIpAddressList.getAPair(n);
                    String string2 = nameAndIpAddress.getFqName();
                    if (string2 != null && !this.isNameServerRecordWritten(string2)) {
                        if (this.cacheFileItemList != null && string2 != null) {
                            bl2 = this.writeComments(bufferedWriter, string2);
                        }
                        if (string2 != null) {
                            bl2 = this.writeNSRecord(bufferedWriter, string2);
                        }
                        bl2 = this.writeAllARecords(bufferedWriter, nameAndIpAddressList, string2);
                    }
                    ++n;
                }
            }
            if (bl) {
                bl2 = this.writeInvalidCacheItems(bufferedWriter);
            }
        }
        this.closeOutput();
        return bl2;
    }

    private String buildFileEntryLine(String string, String string2, String string3, String string4) {
        String string5 = null;
        if (string != null && string2 != null && string3 != null && string4 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("  ");
            stringBuffer.append(string2);
            stringBuffer.append("  ");
            stringBuffer.append("IN");
            stringBuffer.append("  ");
            stringBuffer.append(string3);
            stringBuffer.append("  ");
            stringBuffer.append(string4);
            string5 = new String(stringBuffer.toString());
        }
        return string5;
    }

    private void addNameServerRecordWritten(String string) {
        if (string != null) {
            this.nameServersWritten.addElement(string);
        }
    }

    private void clearNameServersWritten() {
        this.nameServersWritten.removeAllElements();
    }

    private boolean isNameServerRecordWritten(String string) {
        boolean bl = false;
        String string2 = null;
        if (string != null) {
            int n = 0;
            while (n < this.nameServersWritten.size() && !bl) {
                string2 = (String)this.nameServersWritten.elementAt(n);
                if (string2.equals(string)) {
                    bl = true;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean writeComments(BufferedWriter bufferedWriter, String string) {
        boolean bl = true;
        CacheFileItem cacheFileItem = null;
        String[] stringArray = null;
        int n = 0;
        while (n < this.cacheFileItemList.size()) {
            cacheFileItem = (CacheFileItem)this.cacheFileItemList.elementAt(n);
            if (string.equals(cacheFileItem.getNameServerName()) && (stringArray = cacheFileItem.getComments()) != null) {
                int n2 = 0;
                while (n2 < stringArray.length) {
                    if (stringArray[n2].indexOf(this.theStrings.getString("PROGRAM_TITLE"), 0) == -1) {
                        this.writeOutput(bufferedWriter, stringArray[n2]);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return bl;
    }

    private void deleteZeroLengthFile(String string) {
        boolean bl = false;
        String string2 = "deleteZeroLengthFile";
        File file = new File(string);
        if (file != null && file.exists() && file.length() == 0L && !(bl = file.delete())) {
            this.tracer.trace(CLASS_NAME, string2, this.theStrings.getString("COULD_NOT_REMOVE_ZERO_LENGTH_FILE"));
        }
    }

    private boolean writeNSRecord(BufferedWriter bufferedWriter, String string) {
        boolean bl = true;
        if (!this.isNameServerRecordWritten(string)) {
            this.writeOutput(bufferedWriter, this.buildFileEntryLine(".", Integer.toString(3600000), "NS", String.valueOf(string) + "."));
            this.addNameServerRecordWritten(string);
        }
        return bl;
    }

    private boolean writeAllARecords(BufferedWriter bufferedWriter, NameAndIpAddressList nameAndIpAddressList, String string) {
        boolean bl = true;
        int n = 0;
        while (n < nameAndIpAddressList.size()) {
            NameAndIpAddress nameAndIpAddress = nameAndIpAddressList.getAPair(n);
            String string2 = nameAndIpAddress.getFqName();
            String string3 = nameAndIpAddress.getIpAddress();
            if (string2 != null && string2.equals(string) && string3 != null) {
                this.writeOutput(bufferedWriter, this.buildFileEntryLine(String.valueOf(string) + ".", Integer.toString(3600000), "A", string3));
            }
            ++n;
        }
        return bl;
    }

    private void addComments(Vector vector, FileItem fileItem) {
        String string = null;
        if (vector != null && !vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                string = ((FileEntry)vector.elementAt(n)).getRecordData();
                if (fileItem != null) {
                    fileItem.AddComment(string);
                }
                ++n;
            }
            vector.removeAllElements();
        }
    }

    private boolean writeInvalidCacheItems(BufferedWriter bufferedWriter) {
        boolean bl = true;
        InvalidCacheFileItem invalidCacheFileItem = null;
        String[] stringArray = null;
        int n = this.invalidCacheFileItemList.size();
        if (n > 0) {
            bl = this.writeInvalidItemsHeader(bufferedWriter);
            int n2 = 0;
            while (n2 < n) {
                String string;
                invalidCacheFileItem = (InvalidCacheFileItem)this.invalidCacheFileItemList.elementAt(n2);
                stringArray = invalidCacheFileItem.getComments();
                if (stringArray != null) {
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        if (stringArray[n3].indexOf(this.theStrings.getString("PROGRAM_TITLE"), 0) == -1) {
                            this.writeOutput(bufferedWriter, stringArray[n3]);
                        }
                        ++n3;
                    }
                }
                if ((string = this.invalidEntryToString(invalidCacheFileItem)) != null && string.trim().compareTo("") != 0) {
                    this.writeOutput(bufferedWriter, string);
                }
                ++n2;
            }
        }
        return bl;
    }

    private boolean writeCacheFileHeader(BufferedWriter bufferedWriter) {
        boolean bl = true;
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
        Object[] objectArray = new Object[]{new Date()};
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + MessageFormat.format(this.theStrings.getString("FILE_HEADER"), objectArray));
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
        return bl;
    }

    private boolean writeInvalidItemsHeader(BufferedWriter bufferedWriter) {
        boolean bl = true;
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("INVALID_ITEMS_HEADER"));
        this.writeOutput(bufferedWriter, String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("COMMENT_BLOCK_LINE"));
        return bl;
    }

    private String invalidEntryToString(InvalidCacheFileItem invalidCacheFileItem) {
        String string;
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (invalidCacheFileItem != null && (string = invalidCacheFileItem.getInvalidCacheData()) != null && string.trim().compareTo("") != 0) {
            if (invalidCacheFileItem.getInvalidType() == 0) {
                stringBuffer.append(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_IGNORED"));
            } else {
                stringBuffer.append(String.valueOf(DDNSfile.COMMENT_DELIMITER) + this.theStrings.getString("FILE_ERROR"));
            }
            stringBuffer.append(string.trim());
            stringBuffer.append("\n");
            string2 = new String(stringBuffer.toString());
        }
        return string2;
    }
}

