/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.common;

import COM.ibm.raleigh.ddnssgui.common.ConfigurationManager;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class AliasHostObject
extends HostOrAlias {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String ALIAS_tag = "ALIAS";
    public static final String EALIAS_tag = "EALIAS";
    private static final String realName_tag = "RealName";
    private static final String ttl_tag = "ttl";
    private static final String base_tag = "super";
    private String realHostName;
    private int cNAMEttl;

    public static String handleAliasActions(ParsedVector parsedVector, ParsedObject parsedObject, String string, ConfigurationManager configurationManager) {
        AliasHostObject aliasHostObject;
        StringBuffer stringBuffer = new StringBuffer(string);
        boolean bl = false;
        ParsedObject parsedObject2 = parsedVector.getElement("dname");
        String string2 = parsedObject2 != null ? new String((String)parsedObject2.getValue()) : new String("");
        if (parsedObject.getValue().equals("ADD")) {
            AliasHostObject aliasHostObject2 = new AliasHostObject(parsedVector);
            bl = configurationManager.giveAHost(aliasHostObject2, string2);
        } else if (parsedObject.getValue().equals("MOD")) {
            AliasHostObject aliasHostObject3 = new AliasHostObject(parsedVector);
            bl = configurationManager.updateAHost(aliasHostObject3, string2, parsedVector);
        } else if (parsedObject.getValue().equals("DEL")) {
            parsedObject = parsedVector.getElement("name");
            if (parsedObject != null) {
                bl = configurationManager.deleteAHost((String)parsedObject.getValue(), string2);
            }
        } else if (parsedObject.getValue().equals("LNK")) {
            AliasHostObject aliasHostObject4 = new AliasHostObject(parsedVector);
            HostOrAlias hostOrAlias = (HostOrAlias)configurationManager.getAHost(aliasHostObject4.getHostName(), string2);
            if (hostOrAlias != null) {
                configurationManager.linkHost(hostOrAlias, string2);
            }
            bl = true;
        } else if (parsedObject.getValue().equals("GET") && (parsedObject = parsedVector.getElement("name")) != null && (aliasHostObject = (AliasHostObject)configurationManager.getAHost((String)parsedObject.getValue(), string2)) != null) {
            stringBuffer = new StringBuffer(aliasHostObject.toString("GET"));
            bl = true;
        }
        if (bl) {
            try {
                stringBuffer.insert(0, "RC=ACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        } else {
            try {
                stringBuffer.insert(0, "RC=NACK,");
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return stringBuffer.toString();
    }

    public AliasHostObject(String string, String string2) {
        this.hostName = string;
        this.realHostName = string2;
        this.cNAMEttl = -1;
    }

    public AliasHostObject(ParsedVector parsedVector) {
        this.cNAMEttl = -1;
        this.fromString(parsedVector);
    }

    public AliasHostObject(String string, String string2, boolean bl) {
        super(bl);
        this.realHostName = string2;
        this.cNAMEttl = -1;
    }

    public AliasHostObject() {
        this.realHostName = new String();
        this.cNAMEttl = -1;
    }

    public AliasHostObject(HostOrAlias hostOrAlias) {
        this.realHostName = new String();
        this.cNAMEttl = -1;
        this.hostName = hostOrAlias.getHostName();
        this.dynamicData = hostOrAlias.isDynamic();
        String[] stringArray = hostOrAlias.getKEYRecs();
        int n = 0;
        while (n < stringArray.length) {
            this.kEYRecords.addElement(stringArray[n]);
            ++n;
        }
        stringArray = hostOrAlias.getSIGRecs();
        n = 0;
        while (n < stringArray.length) {
            this.sIGRecords.addElement(stringArray[n]);
            ++n;
        }
        stringArray = hostOrAlias.getOtherRecs();
        n = 0;
        while (n < stringArray.length) {
            this.otherRecords.addElement(stringArray[n]);
            ++n;
        }
    }

    public void setRealHostName(String string) {
        this.realHostName = string;
    }

    public String getRealHostName() {
        return this.realHostName;
    }

    public void setCNAMEttl(int n) {
        this.cNAMEttl = n;
    }

    public void setGreaterCNAMEttl(int n) {
        if (this.cNAMEttl < n) {
            this.cNAMEttl = n;
        }
    }

    public int getCNAMEttl() {
        return this.cNAMEttl;
    }

    public String[] writeDataRecords() {
        Enumeration enumeration;
        Object[] objectArray = null;
        Vector<String> vector = new Vector<String>();
        if (this.cNAMEttl >= 0) {
            vector.addElement(new String(String.valueOf(this.hostName) + " " + String.valueOf(this.cNAMEttl) + " IN    CNAME " + this.realHostName + "."));
        } else {
            vector.addElement(new String(String.valueOf(this.hostName) + " IN    CNAME " + this.realHostName + "."));
        }
        if (!this.sIGRecords.isEmpty()) {
            enumeration = this.sIGRecords.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    vector.addElement(new String("     " + (String)enumeration.nextElement()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
        }
        if (!this.kEYRecords.isEmpty()) {
            enumeration = this.kEYRecords.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    vector.addElement(new String("     " + (String)enumeration.nextElement()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer("ALIAS=" + string);
        stringBuffer.append(",super," + super.toString());
        stringBuffer.append(",ttl=" + String.valueOf(this.cNAMEttl));
        stringBuffer.append(",RealName=" + this.realHostName);
        stringBuffer.append(",EALIAS,");
        return stringBuffer.toString();
    }

    public String toString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("ALIAS=" + string);
        stringBuffer.append("," + string2);
        stringBuffer.append(",super," + super.toString());
        stringBuffer.append(",ttl=" + String.valueOf(this.cNAMEttl));
        stringBuffer.append(",RealName=" + this.realHostName);
        stringBuffer.append(",EALIAS,");
        return stringBuffer.toString();
    }

    public void fromString(ParsedVector parsedVector) {
        String[] stringArray = parsedVector.getKeys();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            ParsedObject parsedObject;
            if (stringArray[n].equals(base_tag)) {
                parsedObject = parsedVector.getElement(base_tag);
                ParsedVector parsedVector2 = (ParsedVector)parsedObject.getValue();
                if (parsedVector2 != null) {
                    super.fromString(parsedVector2);
                }
            } else if (stringArray[n].equals(ttl_tag)) {
                parsedObject = parsedVector.getElement(ttl_tag);
                string = (String)parsedObject.getValue();
                if (string != null) {
                    Integer n2 = Integer.valueOf(string);
                    this.cNAMEttl = n2;
                }
            } else if (stringArray[n].equals(realName_tag)) {
                parsedObject = parsedVector.getElement(realName_tag);
                string = (String)parsedObject.getValue();
                this.realHostName = string != null ? new String(string) : new String("");
            }
            ++n;
        }
    }
}

