/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.HostObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.RecordsPanel;
import COM.ibm.raleigh.ddnssgui.client.TTLPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class ReverseHostFrame
extends Frame
implements WindowListener,
ActionListener,
TabViewEventListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int IP_ADDR_FIELD = 0;
    public static final int HOST_NAME_FIELD = 1;
    public static final int TTL_PTR_FIELD = 2;
    private static final int TABVIEW_REVM_CFG_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_TTL_INDEX = 1;
    private static final int TABVIEW_COMMENTS_INDEX = 2;
    private static final int TABVIEW_SIG_KEY_INDEX = 3;
    private static final int NUM_TABS = 4;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 20;
    private static final int NUM_ADDR_FIELD_COLUMNS = 3;
    private HostObjectMgr parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private Panel cfgPanel;
    private Label addressLabel;
    private Label addressPrefix;
    private TextField ipAddress;
    private TextField ipAddress2;
    private TextField ipAddress3;
    private Label hostNameLabel;
    private TextField hostName;
    private Panel ttlPanel;
    private WrappedTextPanel ttlExplanation;
    private TTLPanel ttlPtrPanel;
    private String[] theAddressParts = new String[4];
    int numOfPartsFound;
    private Label dotLabel;
    private Label dotLabel2;
    private RecordsPanel commentsPanel;
    private RecordsPanel sigAndKeyPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private msgBox okBox;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;
    private msgBox invalidBox;

    public ReverseHostFrame(HostObjectMgr hostObjectMgr, String string) {
        this.setResizable(false);
        this.parent = hostObjectMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("REVERSE_HOST_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.setAddressParts(string);
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public void noModificationsAllowed() {
        this.cfgPanel.setEnabled(false);
        this.ttlPanel.setEnabled(false);
        this.commentsPanel.setEnabled(false);
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.ipAddress.requestFocus();
                return;
            }
            case 1: {
                this.hostName.requestFocus();
                return;
            }
            case 2: {
                this.ttlPtrPanel.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.ipAddress.isEnabled()) break;
                this.ipAddress.selectAll();
                return;
            }
            case 1: {
                if (!this.hostName.isEnabled()) break;
                this.hostName.selectAll();
                return;
            }
            case 2: {
                this.ttlPtrPanel.selectAll(0);
                return;
            }
        }
    }

    public String getIPaddress() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.numOfPartsFound == 3) {
            stringBuffer = new StringBuffer(this.ipAddress.getText().trim());
        }
        if (this.numOfPartsFound == 2) {
            stringBuffer = new StringBuffer(String.valueOf(this.ipAddress2.getText().trim()) + "." + this.ipAddress.getText().trim());
        }
        if (this.numOfPartsFound == 1) {
            stringBuffer = new StringBuffer(String.valueOf(this.ipAddress3.getText().trim()) + "." + this.ipAddress2.getText().trim() + "." + this.ipAddress.getText().trim());
        }
        if (stringBuffer.toString().equals(".") || stringBuffer.toString().equals("..")) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getFqIPaddress() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.addressPrefix.getText()) + this.ipAddress.getText().trim());
        if (this.numOfPartsFound == 2) {
            stringBuffer.append("." + this.ipAddress2.getText().trim());
        }
        if (this.numOfPartsFound == 1) {
            stringBuffer.append("." + this.ipAddress2.getText().trim() + "." + this.ipAddress3.getText().trim());
        }
        return stringBuffer.toString();
    }

    public void setIPaddress(String string) {
        if (this.numOfPartsFound == 2) {
            String[] stringArray = new String[2];
            int n = 0;
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    stringArray[n++] = string2;
                }
                ((TextComponent)this.ipAddress).setText(stringArray[1]);
                ((TextComponent)this.ipAddress2).setText(stringArray[0]);
            }
        } else if (this.numOfPartsFound == 1) {
            String[] stringArray = new String[3];
            int n = 0;
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    stringArray[n++] = string3;
                }
                ((TextComponent)this.ipAddress).setText(stringArray[2]);
                ((TextComponent)this.ipAddress2).setText(stringArray[1]);
                ((TextComponent)this.ipAddress3).setText(stringArray[0]);
            }
        } else {
            ((TextComponent)this.ipAddress).setText(string);
        }
        if (!string.equals("")) {
            this.ipAddress.setEnabled(false);
            if (this.numOfPartsFound <= 2) {
                this.ipAddress2.setEnabled(false);
            }
            if (this.numOfPartsFound == 1) {
                this.ipAddress3.setEnabled(false);
            }
            this.setTitle(String.valueOf(this.resources.getString("REVERSE_HOST_FRAME_NAME")) + " -- " + this.getFqIPaddress());
            return;
        }
        this.ipAddress.setEnabled(true);
        if (this.numOfPartsFound <= 2) {
            this.ipAddress2.setEnabled(true);
        }
        if (this.numOfPartsFound == 1) {
            this.ipAddress3.setEnabled(true);
        }
    }

    public String getHostName() {
        return this.hostName.getText();
    }

    public void setHostName(String string) {
        if (string != null) {
            ((TextComponent)this.hostName).setText(string);
        }
    }

    public String[] getComments() {
        return this.commentsPanel.getRecords();
    }

    public void setComments(String[] stringArray) {
        if (stringArray != null) {
            this.commentsPanel.setRecords(stringArray);
        }
    }

    public void setEnabledComments(boolean bl) {
        this.commentsPanel.setEnabled(bl);
    }

    public String[] getSigAndKeyRecords() {
        return this.sigAndKeyPanel.getRecords();
    }

    public void setSigAndKeyRecords(String[] stringArray) {
        if (stringArray != null) {
            this.sigAndKeyPanel.setRecords(stringArray);
        }
    }

    public int getPtrTTL() {
        return this.ttlPtrPanel.getTTL();
    }

    public void setPtrTTL(int n) {
        this.ttlPtrPanel.setTTL(n);
    }

    public void setEnabled(boolean bl) {
        this.cfgPanel.setEnabled(bl);
        this.ipAddress.setEnabled(bl);
        this.ipAddress2.setEnabled(bl);
        this.ipAddress3.setEnabled(bl);
        this.hostName.setEnabled(bl);
        this.ttlPanel.setEnabled(bl);
        this.ttlExplanation.setEnabled(bl);
        this.ttlPtrPanel.setEnabled(bl);
        this.setEnabledComments(bl);
        if (bl) {
            this.checkToDisableNames();
        }
        if (!bl) {
            this.sigAndKeyPanel.setEnabled(false);
        }
    }

    public void setEnabledAll(boolean bl) {
        if (bl) {
            this.cfgPanel.setEnabled(true);
            this.ipAddress.setEnabled(true);
            this.ipAddress2.setEnabled(true);
            this.ipAddress3.setEnabled(true);
            this.hostName.setEnabled(true);
            this.ttlPanel.setEnabled(true);
            this.ttlExplanation.setEnabled(true);
            this.ttlPtrPanel.setEnabled(true);
            this.setEnabledComments(true);
            this.sigAndKeyPanel.setEnabled(false);
        }
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.cfgPanel = new Panel();
        this.addressLabel = new Label(this.resources.getString("RHF_ADDRESS_LABEL"), 0);
        this.ipAddress = new TextField("", 3);
        this.ipAddress2 = new TextField("", 3);
        this.ipAddress3 = new TextField("", 3);
        this.dotLabel = new Label(".", 0);
        this.dotLabel2 = new Label(".", 0);
        this.addressPrefix = this.numOfPartsFound == 2 ? new Label(String.valueOf(this.theAddressParts[1]) + "." + this.theAddressParts[0] + ".") : (this.numOfPartsFound == 1 ? new Label(String.valueOf(this.theAddressParts[0]) + ".") : new Label(String.valueOf(this.theAddressParts[2]) + "." + this.theAddressParts[1] + "." + this.theAddressParts[0] + "."));
        this.hostNameLabel = new Label(this.resources.getString("HOST_NAME_LABEL"), 0);
        this.hostName = new TextField("", 20);
        this.ttlPanel = new Panel();
        this.ttlExplanation = new WrappedTextPanel(this.resources.getString("RHF_TTL_EXPLANATION_LABEL"));
        this.ttlPtrPanel = new TTLPanel(this.resources, this.resources.getString("PTR_TTL_LABEL"));
        this.commentsPanel = new RecordsPanel(this.resources.getString("RHF_COMMENTS_EXPLANATION_LABEL"));
        this.sigAndKeyPanel = new RecordsPanel(this.resources.getString("RHF_SIG_KEY_EXPLANATION_LABEL"));
        this.sigAndKeyPanel.setEnabled(false);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("RHF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("RHF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 0;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.layoutCfgPanel();
        this.layoutTTLPanel();
        this.add((Component)this.tabView, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private boolean checkRequiredFields() {
        boolean bl = true;
        String string = new String(this.ipAddress.getText().trim());
        String string2 = new String(this.getHostName());
        if (string == null || string.length() <= 0) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.okBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("ADDRESS_REQUIRED_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else {
            if (this.numOfPartsFound <= 2 && ((string = new String(this.ipAddress2.getText().trim())) == null || string.length() <= 0)) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[0]);
                this.okBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("ADDRESS_REQUIRED_TEXT"), 1, true, this);
                this.selectAll(0);
                this.requestFocus(0);
                bl = false;
            }
            if (this.numOfPartsFound == 1 && ((string = new String(this.ipAddress3.getText().trim())) == null || string.length() <= 0)) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[0]);
                this.okBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("ADDRESS_REQUIRED_TEXT"), 1, true, this);
                this.selectAll(0);
                this.requestFocus(0);
                bl = false;
            }
            if (string2 == null || string2.length() <= 0) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[0]);
                this.okBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("HOST_NAME_REQUIRED_TEXT"), 1, true, this);
                this.selectAll(1);
                this.requestFocus(1);
                bl = false;
            }
        }
        return bl;
    }

    private void layoutCfgPanel() {
        this.constraintsPanel.fill = 0;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.cfgPanel.setLayout(this.gridBagPanel);
        this.constrain(this.addressLabel, this.gridBagPanel, this.constraintsPanel, 0, 0, 1, 1);
        this.cfgPanel.add(this.addressLabel);
        this.constraintsPanel.fill = 2;
        this.constrain(this.addressPrefix, this.gridBagPanel, this.constraintsPanel, 1, 0, 1, 1);
        this.cfgPanel.add(this.addressPrefix);
        if (this.numOfPartsFound == 3) {
            this.constrain(this.ipAddress, this.gridBagPanel, this.constraintsPanel, 2, 0, 0, 1);
            this.cfgPanel.add(this.ipAddress);
        } else if (this.numOfPartsFound == 2) {
            this.constrain(this.ipAddress, this.gridBagPanel, this.constraintsPanel, 2, 0, 1, 1);
            this.cfgPanel.add(this.ipAddress);
            this.constrain(this.dotLabel, this.gridBagPanel, this.constraintsPanel, 3, 0, 1, 1);
            this.cfgPanel.add(this.dotLabel);
            this.constrain(this.ipAddress2, this.gridBagPanel, this.constraintsPanel, 4, 0, 0, 1);
            this.cfgPanel.add(this.ipAddress2);
        } else {
            this.constrain(this.ipAddress, this.gridBagPanel, this.constraintsPanel, 2, 0, 1, 1);
            this.cfgPanel.add(this.ipAddress);
            this.constrain(this.dotLabel, this.gridBagPanel, this.constraintsPanel, 3, 0, 1, 1);
            this.cfgPanel.add(this.dotLabel);
            this.constrain(this.ipAddress2, this.gridBagPanel, this.constraintsPanel, 4, 0, 1, 1);
            this.cfgPanel.add(this.ipAddress2);
            this.constrain(this.dotLabel2, this.gridBagPanel, this.constraintsPanel, 5, 0, 1, 1);
            this.cfgPanel.add(this.dotLabel2);
            this.constrain(this.ipAddress3, this.gridBagPanel, this.constraintsPanel, 6, 0, 0, 1);
            this.cfgPanel.add(this.ipAddress3);
        }
        this.constraintsPanel.fill = 0;
        this.constrain(this.hostNameLabel, this.gridBagPanel, this.constraintsPanel, 0, 1, 1, 1);
        this.cfgPanel.add(this.hostNameLabel);
        this.constraintsPanel.fill = 2;
        this.constrain(this.hostName, this.gridBagPanel, this.constraintsPanel, 1, 1, 0, 1);
        this.cfgPanel.add(this.hostName);
    }

    private void layoutTTLPanel() {
        int n = this.ttlExplanation.getNumDividedTextLines();
        this.constraintsPanel.fill = 0;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.constraintsPanel.anchor = 17;
        this.constraintsPanel.fill = 0;
        this.ttlPanel.setLayout(this.gridBagPanel);
        this.constrain(this.ttlExplanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, n);
        this.ttlPanel.add(this.ttlExplanation);
        this.constraintsPanel.fill = 2;
        this.constrain(this.ttlPtrPanel, this.gridBagPanel, this.constraintsPanel, 0, n, 0, 1);
        this.ttlPanel.add(this.ttlPtrPanel);
    }

    private int getTTLValue(String string) {
        if (!string.equals("")) {
            if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
                try {
                    Integer n = new Integer(string);
                    return n;
                }
                catch (NumberFormatException numberFormatException) {
                    return Integer.MIN_VALUE;
                }
            }
            return Integer.MIN_VALUE;
        }
        return -1;
    }

    private void setTTLValue(int n, TextField textField) {
        if (n > -1) {
            ((TextComponent)textField).setText(Integer.toString(n));
            return;
        }
        ((TextComponent)textField).setText("");
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.checkRequiredFields() && this.validateFields()) {
            this.parent.SaveAndExit(this);
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            int n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.MyParent.handleHelp("ddscnbrc.htm#HDRNBATC");
                return;
            }
            if (n == 1) {
                this.parent.MyParent.handleHelp("ddscnbrt.htm#HDRNBATT");
                return;
            }
            if (n == 2) {
                this.parent.MyParent.handleHelp("ddscnbrx.htm#HDRNBATX");
                return;
            }
            if (n == 3) {
                this.parent.MyParent.handleHelp("ddscnbrk.htm#HDRNBATK");
                return;
            }
            this.parent.MyParent.handleHelp("ddscnbr.htm#HDRNBR");
        }
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!TcpipValidation.IsValidTcpipAddr(this.getFqIPaddress())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("INVALID_IP_ADDR_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else if (!TcpipValidation.IsValidFQTcpipName(this.getHostName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        } else {
            int n = this.getPtrTTL();
            if (!TcpipValidation.IsValidTTL(n, -1)) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[1]);
                this.invalidBox = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), this.resources.getString("INVALID_PTR_TTL_TEXT"), 1, true, this);
                this.selectAll(2);
                this.requestFocus(2);
                bl = false;
            }
        }
        return bl;
    }

    private void setAddressParts(String string) {
        String string2 = string.substring(0, string.length() - 12);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.theAddressParts[this.numOfPartsFound++] = string3;
        }
        int n = this.numOfPartsFound;
        while (n < 4) {
            this.theAddressParts[n] = "0";
            ++n;
        }
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    private void checkToDisableNames() {
        if (this.getIPaddress().compareTo("") != 0) {
            this.ipAddress.setEnabled(false);
            if (this.numOfPartsFound <= 2) {
                this.ipAddress2.setEnabled(false);
            }
            if (this.numOfPartsFound == 1) {
                this.ipAddress3.setEnabled(false);
                return;
            }
        } else {
            this.ipAddress.setEnabled(true);
            if (this.numOfPartsFound <= 2) {
                this.ipAddress2.setEnabled(true);
            }
            if (this.numOfPartsFound == 1) {
                this.ipAddress3.setEnabled(true);
            }
        }
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[4];
        int n = 0;
        while (n < 4) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_REVM_CFG_LABEL"));
        this.tabNodes[0].setPanel(this.cfgPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_RHF_TTL_LABEL"));
        this.tabNodes[1].setPanel(this.ttlPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_RHF_COMMENTS_LABEL"));
        this.tabNodes[2].setPanel((Panel)this.commentsPanel);
        this.tabNodes[3].setText(this.resources.getString("TABVIEW_RHF_SIG_KEY_LABEL"));
        this.tabNodes[3].setPanel((Panel)this.sigAndKeyPanel);
        int n = 0;
        while (n < 4) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        String string = this.getFqIPaddress();
        if (string.compareTo("") != 0) {
            this.setTitle(String.valueOf(this.resources.getString("REVERSE_HOST_FRAME_NAME")) + " -- " + string);
        } else {
            this.setTitle(this.resources.getString("REVERSE_HOST_FRAME_NAME"));
        }
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.ttlPtrPanel.selectAll(0);
                this.ttlPtrPanel.requestFocus(0);
                return;
            }
            if (tabViewNode != this.tabNodes[2] && tabViewNode != this.tabNodes[3]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
        } else {
            this.selectTabForError = false;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

