/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class PromptForReinitFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic Ip Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    private static final int NUM_BUTTONS = 3;
    public static final int YES_BUTTON = 0;
    public static final int NO_BUTTON = 1;
    public static final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 40;
    private MainFrame parent;
    private WrappedTextPanel reinitExplanation;
    private Panel serverReinitPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;

    public PromptForReinitFrame(MainFrame mainFrame) {
        this.parent = mainFrame;
        this.setTitle(this.parent.clientResources.getString("REINIT_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.buttonPanel.requestFocus(this.buttons[0]);
                return;
            }
            case 1: {
                this.buttonPanel.requestFocus(this.buttons[1]);
                return;
            }
            case 2: {
                this.buttonPanel.requestFocus(this.buttons[2]);
                return;
            }
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.serverReinitPanel = new Panel();
        this.reinitExplanation = new WrappedTextPanel(this.parent.clientResources.getString("REINIT_EXPLANATION_LABEL"));
        this.initButtonPanel();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraintsPanel.fill = 2;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.serverReinitPanel.setLayout(this.gridBagPanel);
        this.constrain(this.reinitExplanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, 1);
        this.serverReinitPanel.add(this.reinitExplanation);
        this.add(this.serverReinitPanel, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.parent.clientResources.getString("YES_BUTTON");
        this.buttonLabels[1] = this.parent.clientResources.getString("NO_BUTTON");
        this.buttonLabels[2] = this.parent.clientResources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.parent.restartTheServer();
            this.dispose();
            this.parent.requestFocus();
        }
        if (button == this.buttons[1]) {
            this.parent.checkToExit();
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscwnz.htm#HDRWNZ");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

