/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.LogPanel;
import COM.ibm.raleigh.ddnssgui.client.NameServerMgr;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.IPListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.NameAndIPListPanel;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddress;
import COM.ibm.raleigh.ddnssgui.common.NameAndIpAddressList;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

class NameServerFrame
extends Frame
implements WindowListener,
ActionListener,
TabViewEventListener,
ListPanelUser,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    private static final int TABVIEW_SERVERS_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_ROOTS_AND_FORWARDERS_INDEX = 1;
    private static final int TABVIEW_LOGGING_INDEX = 2;
    private static final int TABVIEW_FILES_INDEX = 3;
    private static final int NUM_TABS = 4;
    private static final int NUM_TEXT_COLUMNS = 10;
    private static final int NUM_LIST_ROWS = 3;
    private static final int NUM_BUTTONS = 3;
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private NameServerMgr parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private Panel serverCfgPanel;
    private NameAndIPListPanel serverPanel;
    private LogPanel logPanel;
    private Panel filePanel;
    private String etcPath;
    private BorderPanel bootFilePanel;
    private WrappedTextPanel bootFileText;
    private Label bootFileLabel;
    private TextField bootFileName;
    private BorderPanel cacheFilePanel;
    private WrappedTextPanel cacheFileText;
    private Label cacheFileLabel;
    private TextField cacheFileName;
    private Panel forwardPanel;
    private Checkbox slaveServer;
    private IPListPanel forwardServersPanel;
    private NameAndIPListPanel rootServPanel;
    private Button cacheFileImportButton;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox okBox;
    private msgBox logFileSizeBox;
    private msgBox numLogFilesBox;
    private msgBox invalidFileNameBox;

    public NameServerFrame(NameServerMgr nameServerMgr) {
        this.setResizable(false);
        this.parent = nameServerMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("NS_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.etcPath = new String("");
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.serverPanel.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.serverPanel.selectAll(0);
                return;
            }
        }
    }

    public NameAndIpAddressList getServerList() {
        return this.serverPanel.getNameAndIPList();
    }

    public void setServerList(NameAndIpAddressList nameAndIpAddressList) {
        this.serverPanel.removeAll();
        if (nameAndIpAddressList != null) {
            this.serverPanel.setNameAndIPList(nameAndIpAddressList);
        }
        this.checkOK();
    }

    public NameAndIpAddress getServer() {
        return this.serverPanel.getNameAndIP();
    }

    public void setServer(NameAndIpAddress nameAndIpAddress) {
        if (nameAndIpAddress != null) {
            this.serverPanel.setNameAndIP(nameAndIpAddress);
        }
    }

    public NameAndIpAddressList getRootServerList() {
        return this.rootServPanel.getNameAndIPList();
    }

    public void setRootServerList(NameAndIpAddressList nameAndIpAddressList) {
        this.rootServPanel.removeAll();
        if (nameAndIpAddressList != null) {
            this.rootServPanel.setNameAndIPList(nameAndIpAddressList);
        }
    }

    public NameAndIpAddress getRootServer() {
        return this.rootServPanel.getNameAndIP();
    }

    public void setRootServer(NameAndIpAddress nameAndIpAddress) {
        if (nameAndIpAddress != null) {
            this.rootServPanel.setNameAndIP(nameAndIpAddress);
        }
    }

    public boolean getLogDebugMessagesState() {
        return this.logPanel.getLogDebugMessagesState();
    }

    public void setLogDebugMessagesState(boolean bl) {
        this.logPanel.setLogDebugMessagesState(bl);
    }

    public int getNumLogFiles() {
        return this.logPanel.getNumLogFiles();
    }

    public void setNumLogFiles(int n) {
        this.logPanel.setNumLogFiles(n);
    }

    public int getLogFileSize() {
        return this.logPanel.getFileSize();
    }

    public void setLogFileSize(int n) {
        this.logPanel.setFileSize(n);
    }

    public String getLogFileName() {
        return this.logPanel.getLogFileName();
    }

    public void setLogFileName(String string) {
        if (string != null) {
            this.logPanel.setLogFileName(string);
        }
    }

    public void setEtcPath(String string) {
        if (string != null) {
            this.etcPath = new String(string.trim());
        }
        Object[] objectArray = new Object[]{this.etcPath};
        this.bootFileText.relayoutText(String.valueOf(this.resources.getString("BOOT_FILE_TEXT")) + "  " + MessageFormat.format(this.resources.getString("ETC_PATH_TEXT"), objectArray));
        this.logPanel.setEtcPath(string.trim());
    }

    public String getCacheFileName() {
        return this.cacheFileName.getText().trim();
    }

    public void setCacheFileName(String string) {
        if (string != null) {
            ((TextComponent)this.cacheFileName).setText(string.trim());
        }
    }

    public String getBootFileName() {
        return this.bootFileName.getText().trim();
    }

    public void setBootFileName(String string) {
        if (string != null) {
            ((TextComponent)this.bootFileName).setText(string.trim());
        }
    }

    public boolean getSlaveServerState() {
        return this.slaveServer.getState();
    }

    public void setSlaveServerState(boolean bl) {
        this.slaveServer.setState(bl);
    }

    public String[] getForwardServerList() {
        return this.forwardServersPanel.getIPAddrList();
    }

    public void setForwardServerList(String[] stringArray) {
        this.forwardServersPanel.removeAll();
        if (stringArray != null) {
            this.forwardServersPanel.setIPAddrList(stringArray);
        }
    }

    public void setEnabled(boolean bl) {
        this.serverCfgPanel.setEnabled(bl);
        this.logPanel.setEnabled(bl);
        this.filePanel.setEnabled(bl);
        this.forwardPanel.setEnabled(bl);
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.checkOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.serverCfgPanel = new Panel();
        this.serverPanel = new NameAndIPListPanel(this, this.resources, this.resources.getString("NAME_SERVER_PANEL_LABEL"), 3, this.resources.getString("NAME_SERVER_TEXT"));
        this.logPanel = new LogPanel(this, this.resources);
        this.initButtonPanel();
        this.filePanel = new Panel();
        this.bootFilePanel = new BorderPanel(this.resources.getString("BOOT_FILE_LABEL"));
        Object[] objectArray = new Object[]{this.etcPath};
        this.bootFileText = new WrappedTextPanel(String.valueOf(this.resources.getString("BOOT_FILE_TEXT")) + MessageFormat.format(this.resources.getString("ETC_PATH_TEXT"), objectArray));
        this.bootFileLabel = new Label(this.resources.getString("NSF_FILE_NAME_LABEL"), 0);
        this.bootFileName = new TextField("", 10);
        this.setEtcPath("");
        this.cacheFilePanel = new BorderPanel(this.resources.getString("CACHE_FILE_LABEL"));
        this.cacheFileText = new WrappedTextPanel(this.resources.getString("CACHE_FILE_TEXT"));
        this.cacheFileLabel = new Label(this.resources.getString("NSF_FILE_NAME_LABEL"), 0);
        this.cacheFileName = new TextField("", 10);
        this.cacheFileImportButton = new Button(this.resources.getString("IMPORT_BUTTON_TEXT"));
        this.cacheFileImportButton.addActionListener(this);
        this.cacheFileImportButton.addKeyListener(this);
        this.forwardPanel = new Panel();
        this.rootServPanel = new NameAndIPListPanel(this, this.resources, this.resources.getString("ROOT_SERVER_PANEL_LABEL"), 3, this.resources.getString("ROOT_SERVER_TEXT"));
        this.forwardServersPanel = new IPListPanel(this, this.resources, this.resources.getString("FORWARD_SERVER_PANEL_LABEL"), 3, this.resources.getString("FORWARDERS_TEXT"));
        this.forwardServersPanel.setInvalidAddrText(this.resources.getString("INVALID_IP_ADDR_TEXT"));
        this.slaveServer = new Checkbox(this.resources.getString("SLAVE_SERVER_LABEL"));
        this.slaveServer.setEnabled(false);
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("NSF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("NSF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        this.serverCfgPanel.setLayout(gridBagLayout2);
        this.constrain(this.serverPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 1);
        this.serverCfgPanel.add(this.serverPanel);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.bootFilePanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        this.constrain(this.bootFileText, gridBagLayout2, gridBagConstraints2, 0, 0, 3, 2);
        this.bootFilePanel.add(this.bootFileText);
        gridBagConstraints2.fill = 0;
        this.constrain(this.bootFileLabel, gridBagLayout2, gridBagConstraints2, 0, 2, 1, 1);
        this.bootFilePanel.add(this.bootFileLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.bootFileName, gridBagLayout2, gridBagConstraints2, 1, 2, 2, 1);
        this.bootFilePanel.add(this.bootFileName);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.cacheFilePanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        this.constrain(this.cacheFileText, gridBagLayout2, gridBagConstraints2, 0, 0, 3, 2);
        this.cacheFilePanel.add(this.cacheFileText);
        gridBagConstraints2.fill = 0;
        this.constrain(this.cacheFileLabel, gridBagLayout2, gridBagConstraints2, 0, 2, 1, 1);
        this.cacheFilePanel.add(this.cacheFileLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.cacheFileName, gridBagLayout2, gridBagConstraints2, 1, 2, 1, 1);
        this.cacheFilePanel.add(this.cacheFileName);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        this.constrain(this.cacheFileImportButton, gridBagLayout2, gridBagConstraints2, 2, 2, 1, 1);
        this.cacheFilePanel.add(this.cacheFileImportButton);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 17;
        this.filePanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 2;
        this.constrain(this.bootFilePanel, gridBagLayout2, gridBagConstraints2, 0, 0, 2, 2);
        this.filePanel.add(this.bootFilePanel);
        this.constrain(this.cacheFilePanel, gridBagLayout2, gridBagConstraints2, 0, 2, 2, 2);
        this.filePanel.add(this.cacheFilePanel);
        this.forwardPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        this.constrain(this.rootServPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 1, 1);
        this.forwardPanel.add(this.rootServPanel);
        this.constrain(this.forwardServersPanel, gridBagLayout2, gridBagConstraints2, 0, 1, 1, 1);
        this.forwardPanel.add(this.forwardServersPanel);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.constrain(this.slaveServer, gridBagLayout2, gridBagConstraints2, 0, 2, 1, 1);
        this.forwardPanel.add(this.slaveServer);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
        this.disableOK();
    }

    public void handleButton(Button button) {
        if (button == this.buttons[0] && this.validateFields()) {
            this.parent.SaveAndExit();
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit();
        }
        if (button == this.buttons[2]) {
            int n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.MyParent.handleHelp("ddscnbns.htm#HDRNBNTS");
            } else if (n == 2) {
                this.parent.MyParent.handleHelp("ddscnbnl.htm#HDRNBNTL");
            } else if (n == 3) {
                this.parent.MyParent.handleHelp("ddscnbnf.htm#HDRNBNTF");
            } else if (n == 1) {
                this.parent.MyParent.handleHelp("ddscnbnr.htm#HDRNBNTR");
            } else {
                this.parent.MyParent.handleHelp("ddscnbn.htm#HDRNBN");
            }
        }
        if (button == this.cacheFileImportButton) {
            this.parent.requestImport();
        }
        if (button == this.serverPanel.getAddButton()) {
            this.checkOK();
        }
        if (button == this.serverPanel.getRemoveButton()) {
            this.checkOK();
        }
        if (button == this.forwardServersPanel.getAddButton() || button == this.forwardServersPanel.getRemoveButton()) {
            this.handleSlaveServerBox();
        }
    }

    private void checkOK() {
        if (this.serverPanel.getItemCount() > 0) {
            NameAndIpAddressList nameAndIpAddressList = this.serverPanel.getNameAndIPList();
            NameAndIpAddress nameAndIpAddress = nameAndIpAddressList.getAPair(0);
            this.setTitle(String.valueOf(this.resources.getString("NS_FRAME_NAME")) + " -- " + nameAndIpAddress.getFqName());
            this.enableOK();
            return;
        }
        this.setTitle(this.resources.getString("NS_FRAME_NAME"));
        this.disableOK();
    }

    private void enableOK() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[0]);
    }

    private void disableOK() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[0]);
    }

    private void enableCancel() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[1]);
    }

    private void disableCancel() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[1]);
    }

    private void enableHelp() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[2]);
    }

    private void disableHelp() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[2]);
    }

    private void handleSlaveServerBox() {
        if (this.forwardServersPanel.getItemCount() > 0) {
            this.slaveServer.setEnabled(true);
            return;
        }
        this.setSlaveServerState(false);
        this.slaveServer.setEnabled(false);
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!this.logPanel.validateLogFileSize()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[2]);
            this.logFileSizeBox = new msgBox(this.resources, this.resources.getString("NS_FRAME_NAME"), this.resources.getString("INVALID_LOG_FILE_SIZE_TEXT"), 1, true, this);
            this.logPanel.selectAll(0);
            this.logPanel.requestFocus(0);
            bl = false;
        } else if (!this.logPanel.validateNumLogFiles()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[2]);
            this.numLogFilesBox = new msgBox(this.resources, this.resources.getString("NS_FRAME_NAME"), this.resources.getString("INVALID_NUM_LOG_FILES_TEXT"), 1, true, this);
            this.logPanel.selectAll(1);
            this.logPanel.requestFocus(1);
            bl = false;
        } else if (DDNSUtility.hasDriveDelimiter(this.getBootFileName()) || this.getBootFileName().compareTo("") == 0) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[3]);
            this.invalidFileNameBox = new msgBox(this.resources, this.resources.getString("NS_FRAME_NAME"), this.resources.getString("INVALID_BOOT_FILE_NAME_TEXT"), 1, true, this);
            bl = false;
        } else if (!DDNSUtility.hasDriveDelimiter(this.getCacheFileName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[3]);
            this.invalidFileNameBox = new msgBox(this.resources, this.resources.getString("NS_FRAME_NAME"), this.resources.getString("INVALID_CACHE_FILE_NAME_TEXT"), 1, true, this);
            this.cacheFileName.select(0, 0);
            this.bootFileName.selectAll();
            this.bootFileName.requestFocus();
            bl = false;
        } else {
            String string = this.getLogFileName();
            if (DDNSUtility.hasDriveDelimiter(string) || DDNSUtility.hasFileExtensionDelimiter(string)) {
                this.selectTabForError = true;
                this.tabView.selectTab(this.tabNodes[2]);
                this.invalidFileNameBox = new msgBox(this.resources, this.resources.getString("NS_FRAME_NAME"), this.resources.getString("INVALID_LOG_FILE_NAME_TEXT"), 1, true, this);
                this.logPanel.selectAll(2);
                this.logPanel.requestFocus(2);
                this.bootFileName.select(0, 0);
                this.cacheFileName.selectAll();
                this.cacheFileName.requestFocus();
                bl = false;
            }
        }
        return bl;
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[4];
        int n = 0;
        while (n < 4) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_SERVERS_LABEL"));
        this.tabNodes[0].setPanel(this.serverCfgPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_ROOTS_AND_FORWARDERS_LABEL"));
        this.tabNodes[1].setPanel(this.forwardPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_LOGGING_LABEL"));
        this.tabNodes[2].setPanel((Panel)this.logPanel);
        this.tabNodes[3].setText(this.resources.getString("TABVIEW_FILES_LABEL"));
        this.tabNodes[3].setPanel(this.filePanel);
        int n = 0;
        while (n < 4) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.rootServPanel.selectAll(0);
                this.rootServPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[2]) {
                this.logPanel.selectAll(0);
                this.logPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[3]) {
                this.bootFileName.selectAll();
                this.bootFileName.requestFocus();
                return;
            }
            this.selectAll(0);
            this.requestFocus(0);
            return;
        }
        this.selectTabForError = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

