/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.NameServerFrame;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.text.MessageFormat;
import java.util.ResourceBundle;

class LogPanel
extends Panel {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int LOG_FIRST_FIELD = 0;
    public static final int LOG_FILE_SIZE_FIELD = 0;
    public static final int LOG_NUM_FILES_FIELD = 1;
    public static final int LOG_FILE_NAME_FIELD = 2;
    private static final int NUM_TEXT_COLUMNS = 10;
    private NameServerFrame parent;
    private ResourceBundle resources;
    private WrappedTextPanel SomeText;
    private Label fileSizeLabel;
    private TextField fileSize;
    private Label fileBytesLabel;
    private Label numFilesLabel;
    private TextField numFiles;
    private BorderPanel logFilePanel;
    private WrappedTextPanel fileNameText;
    private String etcPath;
    private Label fileNameLabel;
    private TextField fileName;
    private Checkbox logDebugMessages;

    public LogPanel(NameServerFrame nameServerFrame, ResourceBundle resourceBundle) {
        this.parent = nameServerFrame;
        this.resources = resourceBundle;
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.fileSize.requestFocus();
                return;
            }
            case 1: {
                this.numFiles.requestFocus();
                return;
            }
            case 2: {
                this.fileName.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                if (!this.fileSize.isEnabled()) break;
                this.fileSize.selectAll();
                return;
            }
            case 1: {
                if (!this.numFiles.isEnabled()) break;
                this.numFiles.selectAll();
                return;
            }
            case 2: {
                if (!this.fileName.isEnabled()) break;
                this.fileName.selectAll();
                return;
            }
        }
    }

    public boolean getLogDebugMessagesState() {
        return this.logDebugMessages.getState();
    }

    public void setLogDebugMessagesState(boolean bl) {
        this.logDebugMessages.setState(bl);
    }

    public int getNumLogFiles() {
        String string = this.numFiles.getText();
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public void setNumLogFiles(int n) {
        if (n < 0) {
            n = 0;
        }
        ((TextComponent)this.numFiles).setText(Integer.toString(n));
    }

    public int getFileSize() {
        String string = this.fileSize.getText();
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(this.fileSize.getText());
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public void setFileSize(int n) {
        if (n < 0) {
            n = 0;
        }
        ((TextComponent)this.fileSize).setText(Integer.toString(n));
    }

    public String getLogFileName() {
        return this.fileName.getText().trim();
    }

    public void setLogFileName(String string) {
        if (string != null) {
            ((TextComponent)this.fileName).setText(string.trim());
        }
    }

    public void setEtcPath(String string) {
        if (string != null) {
            this.etcPath = new String(string.trim());
        }
        Object[] objectArray = new Object[]{this.etcPath};
        this.fileNameText.relayoutText(MessageFormat.format(this.resources.getString("LP_FILE_TEXT_LABEL"), objectArray));
    }

    public boolean validateLogFileSize() {
        boolean bl = true;
        int n = this.getFileSize();
        if (n > Integer.MAX_VALUE || n < 0) {
            bl = false;
        }
        return bl;
    }

    public boolean validateNumLogFiles() {
        boolean bl = true;
        int n = this.getNumLogFiles();
        if (n > Integer.MAX_VALUE || n < 0) {
            bl = false;
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        this.SomeText.setEnabled(bl);
        this.fileSizeLabel.setEnabled(bl);
        this.fileSize.setEnabled(bl);
        this.fileBytesLabel.setEnabled(bl);
        this.numFilesLabel.setEnabled(bl);
        this.numFiles.setEnabled(bl);
        this.logFilePanel.setEnabled(bl);
        this.fileNameText.setEnabled(bl);
        this.fileNameLabel.setEnabled(bl);
        this.fileName.setEnabled(bl);
        this.logDebugMessages.setEnabled(bl);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.SomeText = new WrappedTextPanel(this.resources.getString("LP_EXPL_TEXT"));
        this.fileSizeLabel = new Label(this.resources.getString("LP_FILE_SIZE_LABEL"), 0);
        this.fileSize = new TextField("", 10);
        this.fileBytesLabel = new Label(this.resources.getString("LP_BYTES_LABEL"), 0);
        this.numFilesLabel = new Label(this.resources.getString("LP_NUM_FILES_LABEL"), 0);
        this.numFiles = new TextField("", 10);
        this.logFilePanel = new BorderPanel(this.resources.getString("LOG_FILE_LABEL"));
        this.fileNameText = new WrappedTextPanel(this.resources.getString("LP_FILE_TEXT_LABEL"));
        this.fileNameLabel = new Label(this.resources.getString("LP_FILE_NAME_LABEL"), 0);
        this.fileName = new TextField("", 10);
        this.logDebugMessages = new Checkbox(this.resources.getString("LOG_DEBUG_MESSAGES_LABEL"));
    }

    private void addComponentsToGrid() {
        int n = this.SomeText.getNumDividedTextLines();
        int n2 = this.fileNameText.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.add(this.SomeText, gridBagLayout, gridBagConstraints, 0, 0, 0, n);
        gridBagConstraints.fill = 0;
        int n3 = n;
        this.add(this.fileSizeLabel, gridBagLayout, gridBagConstraints, 0, n3, 1, 1);
        this.add(this.fileSize, gridBagLayout, gridBagConstraints, 1, n3, 1, 1);
        this.add(this.fileBytesLabel, gridBagLayout, gridBagConstraints, 2, n3, 0, 1);
        this.add(this.numFilesLabel, gridBagLayout, gridBagConstraints, 0, ++n3, 1, 1);
        this.add(this.numFiles, gridBagLayout, gridBagConstraints, 1, n3, 0, 1);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.logFilePanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 1;
        this.constrain(this.fileNameText, gridBagLayout2, gridBagConstraints2, 0, 0, 2, n2);
        this.logFilePanel.add(this.fileNameText);
        gridBagConstraints2.fill = 0;
        this.constrain(this.fileNameLabel, gridBagLayout2, gridBagConstraints2, 0, 1 + n2, 1, 1);
        this.logFilePanel.add(this.fileNameLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.fileName, gridBagLayout2, gridBagConstraints2, 1, 1 + n2, 0, 1);
        this.logFilePanel.add(this.fileName);
        this.add(this.logFilePanel, gridBagLayout, gridBagConstraints, 0, ++n3, 0, 2);
        this.add(this.logDebugMessages, gridBagLayout, gridBagConstraints, 0, n3 += 2, 0, 1);
    }
}

