/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.DDNSManager;
import COM.ibm.raleigh.ddnssgui.client.HostCfgPanel;
import COM.ibm.raleigh.ddnssgui.client.RecordsPanel;
import COM.ibm.raleigh.ddnssgui.client.TTLPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSStringTranslator;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.IPListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanel;
import COM.ibm.raleigh.ddnssgui.common.ListPanelUser;
import COM.ibm.raleigh.ddnssgui.common.MailExchangeListPanel;
import COM.ibm.raleigh.ddnssgui.common.Platform;
import COM.ibm.raleigh.ddnssgui.common.PlatformList;
import COM.ibm.raleigh.ddnssgui.common.PlatformListPanel;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class HostFrame
extends Frame
implements WindowListener,
ActionListener,
TabViewEventListener,
ListPanelUser,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int FIRST_FIELD = 0;
    public static final int HOST_NAME_FIELD = 0;
    public static final int IP_ADDRESS_FIELD = 1;
    public static final int TTL_HOST_NAME_FIELD = 2;
    public static final int TTL_IP_ADDR_FIELD = 3;
    public static final int TTL_TEXT_FIELD = 4;
    public static final int TTL_MAIL_FIELD = 5;
    public static final int TTL_PLATFORM_FIELD = 6;
    private static final int TABVIEW_HOST_CFG_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_TEXT_INDEX = 1;
    private static final int TABVIEW_MAIL_PANEL_INDEX = 2;
    private static final int TABVIEW_PLATFORM_INDEX = 3;
    private static final int TABVIEW_TTL_INDEX = 4;
    private static final int TABVIEW_COMMENTS_INDEX = 5;
    private static final int TABVIEW_SIG_KEY_INDEX = 6;
    private static final int TABVIEW_OTHER_RECORDS_INDEX = 7;
    private static final int NUM_TABS = 8;
    private static final int NUM_ROWS_VISIBLE = 4;
    private static final int NUM_TEXT_TIME_RANGES = 6;
    private static final int NUM_TEXT_FIELD_COLUMNS = 10;
    private static final int NUM_TEXT_LIST_ROWS = 10;
    private static final int NUM_BUTTONS = 3;
    private final int OK_BUTTON = 0;
    private final int CANCEL_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private DDNSManager parent;
    private ResourceBundle resources;
    private boolean selectTabForError = false;
    private Panel hostPanel;
    private HostCfgPanel cfgPanel;
    private Panel addrPanel;
    private IPListPanel ipPanel;
    private Panel textPanel;
    private ListPanel textListPanel;
    private MailExchangeListPanel mailPanel;
    private PlatformListPanel platformPanel;
    private Panel ttlPanel;
    private WrappedTextPanel ttlExplanation;
    private TTLPanel ttlHostNamePanel;
    private TTLPanel ttlIPAddrPanel;
    private TTLPanel ttlTextPanel;
    private TTLPanel ttlMailPanel;
    private TTLPanel ttlPlatformPanel;
    private RecordsPanel commentsPanel;
    private RecordsPanel sigAndKeyPanel;
    private RecordsPanel otherRecordsPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private msgBox okBox;
    private msgBox invalidBox;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);

    public HostFrame(DDNSManager dDNSManager) {
        this.setResizable(false);
        this.parent = dDNSManager;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("HOST_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
        this.selectTabForError = false;
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.cfgPanel.requestFocus(0);
                return;
            }
            case 1: {
                this.ipPanel.requestFocus(0);
                return;
            }
            case 2: {
                this.ttlHostNamePanel.requestFocus(0);
                return;
            }
            case 3: {
                this.ttlIPAddrPanel.requestFocus(0);
                return;
            }
            case 4: {
                this.ttlTextPanel.requestFocus(0);
                return;
            }
            case 5: {
                this.ttlMailPanel.requestFocus(0);
                return;
            }
            case 6: {
                this.ttlPlatformPanel.requestFocus(0);
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 0: {
                this.cfgPanel.selectAll(0);
                return;
            }
            case 1: {
                this.ipPanel.selectAll(0);
                return;
            }
            case 2: {
                this.ttlHostNamePanel.selectAll(0);
                return;
            }
            case 3: {
                this.ttlIPAddrPanel.selectAll(0);
                return;
            }
            case 4: {
                this.ttlTextPanel.selectAll(0);
                return;
            }
            case 5: {
                this.ttlMailPanel.selectAll(0);
                return;
            }
            case 6: {
                this.ttlPlatformPanel.selectAll(0);
                return;
            }
        }
    }

    public String getHostName() {
        return this.cfgPanel.getHostName();
    }

    public void setHostName(String string) {
        if (string != null) {
            this.cfgPanel.setHostName(string);
            if (string.trim().compareTo("") == 0) {
                this.setTitle(this.resources.getString("HOST_FRAME_NAME"));
                return;
            }
            this.setTitle(String.valueOf(this.resources.getString("HOST_FRAME_NAME")) + " -- " + this.getHostName());
        }
    }

    public String getFullyQualifiedDomainName() {
        return this.cfgPanel.getFullyQualifiedDomainName();
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null) {
            this.cfgPanel.setFullyQualifiedDomainName(string);
        }
    }

    public String[] getFullyQualifiedDomainNameList() {
        return this.cfgPanel.getFullyQualifiedDomainNameList();
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            this.cfgPanel.setFullyQualifiedDomainNameList(stringArray);
        }
    }

    public String[] getIPAddrList() {
        return this.ipPanel.getItemList();
    }

    public void setIPAddrList(String[] stringArray) {
        this.ipPanel.removeAll();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.ipPanel.addItem(stringArray[n]);
                ++n;
            }
        }
    }

    public Platform getPlatform() {
        return this.platformPanel.getPlatform();
    }

    public void setPlatform(Platform platform) {
        this.platformPanel.setPlatform(platform);
    }

    public PlatformList getPlatformList() {
        return this.platformPanel.getPlatformList();
    }

    public void setPlatformList(PlatformList platformList) {
        this.platformPanel.setPlatformList(platformList);
    }

    public String getMailHost() {
        return this.mailPanel.getMailHost();
    }

    public void setMailHost(String string) {
        this.mailPanel.setMailHost(string);
    }

    public int getMailPreference() {
        return this.mailPanel.getMailPreference();
    }

    public void setMailPreference(String string) {
        this.mailPanel.setMailPreference(string);
    }

    public String[] getMailList() {
        return this.mailPanel.getMailList();
    }

    public void setMailList(String[] stringArray) {
        this.mailPanel.removeAll();
        this.mailPanel.setMailList(stringArray);
    }

    public String[] getHostTextList() {
        String[] stringArray = this.textListPanel.getItemList();
        int n = this.textListPanel.getItemCount();
        if (n > 0) {
            DDNSStringTranslator dDNSStringTranslator = null;
            int n2 = 0;
            while (n2 < n) {
                dDNSStringTranslator = new DDNSStringTranslator(stringArray[n2]);
                stringArray[n2] = new String(dDNSStringTranslator.toEscapedString());
                ++n2;
            }
        }
        return stringArray;
    }

    public void setHostTextList(String[] stringArray) {
        this.textListPanel.removeAll();
        if (stringArray != null) {
            DDNSStringTranslator dDNSStringTranslator = null;
            int n = 0;
            while (n < stringArray.length) {
                dDNSStringTranslator = new DDNSStringTranslator(stringArray[n].trim());
                this.textListPanel.addItem(dDNSStringTranslator.fromEscapedString());
                ++n;
            }
        }
    }

    public int getTTLForHostName() {
        return this.ttlHostNamePanel.getTTL();
    }

    public void setTTLForHostName(int n) {
        this.ttlHostNamePanel.setTTL(n);
    }

    public int getTTLForIPAddr() {
        return this.ttlIPAddrPanel.getTTL();
    }

    public void setTTLForIPAddr(int n) {
        this.ttlIPAddrPanel.setTTL(n);
    }

    public int getTTLForText() {
        return this.ttlTextPanel.getTTL();
    }

    public void setTTLForText(int n) {
        this.ttlTextPanel.setTTL(n);
    }

    public int getTTLForMail() {
        return this.ttlMailPanel.getTTL();
    }

    public void setTTLForMail(int n) {
        this.ttlMailPanel.setTTL(n);
    }

    public int getTTLForPlatform() {
        return this.ttlPlatformPanel.getTTL();
    }

    public void setTTLForPlatform(int n) {
        this.ttlPlatformPanel.setTTL(n);
    }

    public String[] getComments() {
        return this.commentsPanel.getRecords();
    }

    public void setComments(String[] stringArray) {
        if (stringArray != null) {
            this.commentsPanel.setRecords(stringArray);
        }
    }

    public void setEnabledComments(boolean bl) {
        this.commentsPanel.setEnabled(bl);
    }

    public String[] getSigAndKeyRecords() {
        return this.sigAndKeyPanel.getRecords();
    }

    public void setSigAndKeyRecords(String[] stringArray) {
        if (stringArray != null) {
            this.sigAndKeyPanel.setRecords(stringArray);
        }
    }

    public String[] getOtherRecords() {
        return this.otherRecordsPanel.getRecords();
    }

    public void setOtherRecords(String[] stringArray) {
        if (stringArray != null) {
            this.otherRecordsPanel.setRecords(stringArray);
        }
    }

    public void setEnabledOtherRecords(boolean bl) {
        this.otherRecordsPanel.setEnabled(bl);
    }

    public void setEnabled(boolean bl) {
        this.hostPanel.setEnabled(bl);
        this.cfgPanel.setEnabled(bl);
        this.addrPanel.setEnabled(bl);
        this.ipPanel.setEnabled(bl);
        this.textPanel.setEnabled(bl);
        this.textListPanel.setEnabled(bl);
        this.mailPanel.setEnabled(bl);
        this.platformPanel.setEnabled(bl);
        this.ttlPanel.setEnabled(bl);
        this.ttlExplanation.setEnabled(bl);
        this.ttlHostNamePanel.setEnabled(bl);
        this.ttlIPAddrPanel.setEnabled(bl);
        this.ttlTextPanel.setEnabled(bl);
        this.ttlMailPanel.setEnabled(bl);
        this.ttlPlatformPanel.setEnabled(bl);
        this.setEnabledComments(bl);
        this.setEnabledOtherRecords(bl);
        if (!bl) {
            this.sigAndKeyPanel.setEnabled(false);
        }
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.hostPanel = new Panel();
        this.cfgPanel = new HostCfgPanel(this, this.resources);
        this.addrPanel = new Panel();
        this.ipPanel = new IPListPanel(this, this.resources, this.resources.getString("IP_PANEL_LABEL"), 4, this.resources.getString("IP_PANEL_TEXT"));
        this.ipPanel.setInvalidAddrText(this.resources.getString("INVALID_IP_ADDR_TEXT"));
        this.textPanel = new Panel();
        this.textListPanel = new ListPanel((Container)this, this.resources, "", this.resources.getString("TEXT_LABEL"), 10, this.resources.getString("TEXT_EXPLANATION_LABEL"));
        this.mailPanel = new MailExchangeListPanel(this, this.resources, this.resources.getString("HOST_FRAME_NAME"), 4);
        this.platformPanel = new PlatformListPanel(this, this.resources, 4);
        this.ttlPanel = new Panel();
        this.ttlExplanation = new WrappedTextPanel(this.resources.getString("HF_TTL_EXPLANATION_LABEL"));
        this.ttlHostNamePanel = new TTLPanel(this.resources, this.resources.getString("TTL_HOST_NAME_LABEL"));
        this.ttlIPAddrPanel = new TTLPanel(this.resources, this.resources.getString("TTL_IP_ADDR_LABEL"));
        this.ttlTextPanel = new TTLPanel(this.resources, this.resources.getString("TTL_TEXT_LABEL"));
        this.ttlMailPanel = new TTLPanel(this.resources, this.resources.getString("TTL_MAIL_LABEL"));
        this.ttlPlatformPanel = new TTLPanel(this.resources, this.resources.getString("TTL_PLATFORM_LABEL"));
        this.commentsPanel = new RecordsPanel(this.resources.getString("HF_COMMENTS_EXPLANATION_LABEL"));
        this.sigAndKeyPanel = new RecordsPanel(this.resources.getString("HF_SIG_KEY_EXPLANATION_LABEL"));
        this.sigAndKeyPanel.setEnabled(false);
        this.otherRecordsPanel = new RecordsPanel(this.resources.getString("HF_OTHER_RECORDS_EXPLANATION_LABEL"));
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("HF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("HF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        int n = this.ttlExplanation.getNumDividedTextLines();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.addrPanel.setLayout(gridBagLayout2);
        this.constrain(this.ipPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 0);
        this.addrPanel.add(this.ipPanel);
        this.hostPanel.setLayout(gridBagLayout2);
        this.constrain(this.cfgPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 1, 1);
        this.hostPanel.add(this.cfgPanel);
        this.constrain(this.addrPanel, gridBagLayout2, gridBagConstraints2, 0, 1, 0, 0);
        this.hostPanel.add(this.addrPanel);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        this.textPanel.setLayout(gridBagLayout2);
        this.constrain(this.textListPanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 0);
        this.textPanel.add(this.textListPanel);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 0;
        this.ttlPanel.setLayout(gridBagLayout2);
        this.constrain(this.ttlExplanation, gridBagLayout2, gridBagConstraints2, 0, 0, 0, n);
        this.ttlPanel.add(this.ttlExplanation);
        gridBagConstraints2.fill = 2;
        this.constrain(this.ttlHostNamePanel, gridBagLayout2, gridBagConstraints2, 0, n, 0, 1);
        this.ttlPanel.add(this.ttlHostNamePanel);
        this.constrain(this.ttlIPAddrPanel, gridBagLayout2, gridBagConstraints2, 0, 1 + n, 0, 1);
        this.ttlPanel.add(this.ttlIPAddrPanel);
        this.constrain(this.ttlTextPanel, gridBagLayout2, gridBagConstraints2, 0, 2 + n, 0, 1);
        this.ttlPanel.add(this.ttlTextPanel);
        this.constrain(this.ttlMailPanel, gridBagLayout2, gridBagConstraints2, 0, 3 + n, 0, 1);
        this.ttlPanel.add(this.ttlMailPanel);
        this.constrain(this.ttlPlatformPanel, gridBagLayout2, gridBagConstraints2, 0, 4 + n, 0, 1);
        this.ttlPanel.add(this.ttlPlatformPanel);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private boolean checkRequiredFields() {
        boolean bl = false;
        String string = new String(this.getHostName());
        if (string != null && string.length() > 0) {
            bl = true;
        } else {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.okBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("HOST_NAME_REQUIRED_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
        }
        if (bl && this.ipPanel.getItemCount() == 0 && this.textListPanel.getItemCount() == 0 && this.mailPanel.getItemCount() == 0 && this.platformPanel.getItemCount() == 0 && this.otherRecordsPanel.isEmpty()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.okBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("AT_LEAST_ONE_REQUIRED_TEXT"), 1, true, this);
            this.selectAll(1);
            this.requestFocus(1);
            bl = false;
        }
        return bl;
    }

    private void enableOK() {
        this.buttonPanel.setEnabled(true, this.buttons[0]);
    }

    private void disableOK() {
        this.buttonPanel.setEnabled(false, this.buttons[0]);
    }

    private void enableCancel() {
        this.buttonPanel.setEnabled(true, this.buttons[1]);
    }

    private void disableCancel() {
        this.buttonPanel.setEnabled(false, this.buttons[1]);
    }

    private void enableHelp() {
        this.buttonPanel.setEnabled(true, this.buttons[2]);
    }

    private void disableHelp() {
        this.buttonPanel.setEnabled(false, this.buttons[2]);
    }

    private boolean validateFields() {
        boolean bl = true;
        if (!TcpipValidation.IsValidFQTcpipName(this.getHostName())) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("INVALID_HOST_NAME_TITLE"), this.resources.getString("INVALID_HOST_NAME_TEXT"), 1, true, this);
            this.selectAll(0);
            this.requestFocus(0);
            bl = false;
        } else {
            bl = this.validateTTLs();
        }
        return bl;
    }

    private boolean validateTTLs() {
        boolean bl = true;
        if (!this.ttlHostNamePanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("INVALID_HOST_TTL_TEXT"), 1, true, this);
            this.selectAll(2);
            this.requestFocus(2);
            bl = false;
        }
        if (bl && !this.ttlIPAddrPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("INVALID_IP_ADDR_TTL_TEXT"), 1, true, this);
            this.selectAll(3);
            this.requestFocus(3);
            bl = false;
        }
        if (bl && !this.ttlTextPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("INVALID_TEXT_TTL_TEXT"), 1, true, this);
            this.selectAll(4);
            this.requestFocus(4);
            bl = false;
        }
        if (bl && !this.ttlMailPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("INVALID_MAIL_TTL_TEXT"), 1, true, this);
            this.selectAll(5);
            this.requestFocus(5);
            bl = false;
        }
        if (bl && !this.ttlPlatformPanel.isValidTTL()) {
            this.selectTabForError = true;
            this.tabView.selectTab(this.tabNodes[4]);
            this.invalidBox = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), this.resources.getString("INVALID_PLATFORM_TTL_TEXT"), 1, true, this);
            this.selectAll(6);
            this.requestFocus(6);
            bl = false;
        }
        return bl;
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[8];
        int n = 0;
        while (n < 8) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_HOST_CFG_LABEL"));
        this.tabNodes[0].setPanel(this.hostPanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_TEXT_LABEL"));
        this.tabNodes[1].setPanel(this.textPanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_MAIL_PANEL_LABEL"));
        this.tabNodes[2].setPanel((Panel)this.mailPanel);
        this.tabNodes[3].setText(this.resources.getString("TABVIEW_PLATFORM_LABEL"));
        this.tabNodes[3].setPanel((Panel)this.platformPanel);
        this.tabNodes[4].setText(this.resources.getString("HF_TABVIEW_TTL_LABEL"));
        this.tabNodes[4].setPanel(this.ttlPanel);
        this.tabNodes[5].setText(this.resources.getString("TABVIEW_COMMENTS_LABEL"));
        this.tabNodes[5].setPanel((Panel)this.commentsPanel);
        this.tabNodes[6].setText(this.resources.getString("TABVIEW_SIG_KEY_LABEL"));
        this.tabNodes[6].setPanel((Panel)this.sigAndKeyPanel);
        this.tabNodes[7].setText(this.resources.getString("TABVIEW_OTHER_RECORDS_LABEL"));
        this.tabNodes[7].setPanel((Panel)this.otherRecordsPanel);
        int n = 0;
        while (n < 8) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        String string = this.getHostName();
        if (string.compareTo("") == 0) {
            this.setTitle(this.resources.getString("HOST_FRAME_NAME"));
        } else {
            this.setTitle(String.valueOf(this.resources.getString("HOST_FRAME_NAME")) + " -- " + string);
        }
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
        if (!this.selectTabForError) {
            if (tabViewNode == this.tabNodes[0]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[1]) {
                this.textListPanel.selectAll(0);
                this.textListPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[2]) {
                this.mailPanel.selectAll(0);
                this.mailPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[3]) {
                this.platformPanel.selectAll(0);
                this.platformPanel.requestFocus(0);
                return;
            }
            if (tabViewNode == this.tabNodes[4]) {
                this.ttlHostNamePanel.selectAll(0);
                this.ttlHostNamePanel.requestFocus(0);
                return;
            }
            if (tabViewNode != this.tabNodes[5] && tabViewNode != this.tabNodes[6] && tabViewNode != this.tabNodes[7]) {
                this.selectAll(0);
                this.requestFocus(0);
                return;
            }
        } else {
            this.selectTabForError = false;
        }
    }

    public void handleButton(Button button) {
        if (button == this.buttons[0] && this.checkRequiredFields() && this.validateFields()) {
            this.parent.SaveAndExit(this);
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            int n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.MyParent.handleHelp("ddscnbhc.htm#HDRNBHTC");
                return;
            }
            if (n == 1) {
                this.parent.MyParent.handleHelp("ddscnbhy.htm#HDRNBHTY");
                return;
            }
            if (n == 2) {
                this.parent.MyParent.handleHelp("ddscnbhm.htm#HDRNBHTM");
                return;
            }
            if (n == 3) {
                this.parent.MyParent.handleHelp("ddscnbhp.htm#HDRNBHTP");
                return;
            }
            if (n == 4) {
                this.parent.MyParent.handleHelp("ddscnbht.htm#HDRNBHTT");
                return;
            }
            if (n == 5) {
                this.parent.MyParent.handleHelp("ddscnbhx.htm#HDRNBHTX");
                return;
            }
            if (n == 6) {
                this.parent.MyParent.handleHelp("ddscnbhk.htm#HDRNBHTK");
                return;
            }
            if (n == 7) {
                this.parent.MyParent.handleHelp("ddscnbhr.htm#HDRNBHTR");
                return;
            }
            this.parent.MyParent.handleHelp("ddscnbh.htm#HDRNBH");
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

