/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;

class FileSaveDialog
extends Dialog
implements WindowListener,
ActionListener,
KeyListener,
ItemListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int TABVIEW_SAVE_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_DETAILS_INDEX = 1;
    private static final int NUM_TABS = 2;
    private static final int NUM_BUTTONS = 3;
    private final int YES_BUTTON = 0;
    private final int NO_BUTTON = 1;
    private final int HELP_BUTTON = 2;
    private static final int NUM_TEXT_FIELD_COLUMNS = 40;
    public static final int FIRST_FIELD = 0;
    private MainFrame parent;
    private ResourceBundle resources;
    private WrappedTextPanel saveExplanation;
    private List fileList;
    private Label detailLabel;
    private Panel fileSavePanel;
    private Panel fileDetailsPanel;
    private Checkbox notifyMe;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private GridBagLayout gridBag;
    private GridBagConstraints constraints;
    private GridBagLayout gridBagPanel;
    private GridBagConstraints constraintsPanel;
    private GridBagLayout gridBagPanel2;
    private GridBagConstraints constraintsPanel2;

    public FileSaveDialog(MainFrame mainFrame) {
        super(mainFrame.getFrame(), true);
        this.setResizable(false);
        this.parent = mainFrame;
        this.resources = this.parent.clientResources;
        this.setTitle(this.resources.getString("FILE_SAVE_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public boolean anyFilesExist() {
        return this.fileList.getItemCount() > 0;
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.notifyMe.requestFocus();
                return;
            }
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.fileSavePanel = new Panel();
        this.detailLabel = new Label(this.resources.getString("DETAILS_LABEL"));
        this.fileDetailsPanel = new Panel();
        this.saveExplanation = new WrappedTextPanel(this.resources.getString("FILE_SAVE_EXPLANATION_LABEL"));
        this.notifyMe = new Checkbox(this.resources.getString("NOTIFY_ME_LABEL"));
        this.notifyMe.addKeyListener(this);
        this.notifyMe.addItemListener(this);
        this.fileList = new List();
        RequestList requestList = new RequestList(13);
        String[] stringArray = requestList.getReturnedList(this.resources, this.parent.dataOut);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.fileList.addItem(stringArray[n]);
                ++n;
            }
        }
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("FSF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("FSF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.createTabs();
        this.gridBag = new GridBagLayout();
        this.constraints = new GridBagConstraints();
        this.gridBagPanel = new GridBagLayout();
        this.constraintsPanel = new GridBagConstraints();
        this.gridBagPanel2 = new GridBagLayout();
        this.constraintsPanel2 = new GridBagConstraints();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        this.setLayout(this.gridBag);
        this.constraints.fill = 2;
        this.constraints.anchor = 10;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraintsPanel.fill = 2;
        this.constraintsPanel.anchor = 10;
        this.constraintsPanel.weightx = 1.0;
        this.constraintsPanel.weighty = 1.0;
        this.constraintsPanel2.fill = 2;
        this.constraintsPanel2.anchor = 10;
        this.constraintsPanel2.weightx = 1.0;
        this.constraintsPanel2.weighty = 1.0;
        this.fileSavePanel.setLayout(this.gridBagPanel);
        this.fileDetailsPanel.setLayout(this.gridBagPanel2);
        this.constrain(this.saveExplanation, this.gridBagPanel, this.constraintsPanel, 0, 0, 0, 1);
        this.fileSavePanel.add(this.saveExplanation);
        this.constrain(this.notifyMe, this.gridBagPanel, this.constraintsPanel, 0, 1, 0, 1);
        this.fileSavePanel.add(this.notifyMe);
        this.constrain(this.detailLabel, this.gridBagPanel2, this.constraintsPanel2, 0, 0, 0, 1);
        this.fileDetailsPanel.add(this.detailLabel);
        this.constrain(this.fileList, this.gridBagPanel2, this.constraintsPanel2, 0, 1, 0, 0);
        this.fileDetailsPanel.add(this.fileList);
        this.add((Component)this.tabView, this.gridBag, this.constraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.add(this.buttonPanel, this.gridBag, this.constraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("YES_BUTTON");
        this.buttonLabels[1] = this.resources.getString("NO_BUTTON");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleCheckbox() {
        this.parent.setWarnOfOverwrite(!this.notifyMe.getState());
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.parent.requestFocus();
            this.parent.writeFiles();
            this.dispose();
        }
        if (button == this.buttons[1]) {
            this.parent.requestFocus();
            this.dispose();
        }
        if (button == this.buttons[2]) {
            this.parent.handleHelp("ddscnbz.htm#HDRNBZ");
        }
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[2];
        int n = 0;
        while (n < 2) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_SAVE_LABEL"));
        this.tabNodes[0].setPanel(this.fileSavePanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_DETAILS_LABEL"));
        this.tabNodes[1].setPanel(this.fileDetailsPanel);
        int n = 0;
        while (n < 2) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.requestFocus();
        this.dispose();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

