/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewEventListener;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.DomainObjectMgr;
import COM.ibm.raleigh.ddnssgui.client.GenerateKeysFrame;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

class DynamicOptionsFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
TabViewEventListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int SECURED = 0;
    public static final int PRESECURED = 1;
    public static final int FIRST_FIELD = 0;
    public static final int SECURED_FIELD = 0;
    private static final int SIG_EXPIRE_HOUR_MIN = 0;
    private static final int SIG_EXPIRE_HOUR_MAX = 23;
    private static final int BACKUP_COUNT_MIN = 0;
    private static final int BACKUP_COUNT_MAX = 10;
    private static final int NUM_TEXT_COLUMNS = 10;
    private static final int NUM_TEXT_FIELDS = 5;
    private static final int TABVIEW_DYNAMIC_OPTIONS_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int NUM_TABS = 1;
    private static final int NUM_BUTTONS = 3;
    private static final int OK_BUTTON = 0;
    private static final int CANCEL_BUTTON = 1;
    private static final int HELP_BUTTON = 2;
    private DomainObjectMgr parent;
    private ResourceBundle resources;
    private BorderPanel securityModePanel;
    private int securityMode = 0;
    private CheckboxGroup cbgForSecurityMode;
    private Checkbox secured;
    private Checkbox preSecured;
    private Button generateKeysButton;
    private Checkbox noKeyToSec;
    private Checkbox backup;
    private Checkbox expiredSIG;
    private Label expiredSIGTimeLabel;
    private TextField expiredSIGTime;
    private Checkbox timeSync;
    private Checkbox forwardTime;
    private Checkbox override;
    private Label overrideTimeLabel;
    private TextField overrideTime;
    private Label timeRange;
    private Panel optionsPanel;
    private GenerateKeysFrame genKeys;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);
    private msgBox invalidFieldBox;
    private String[] hostsForKeysList;
    private String directoryForKeys;

    public DynamicOptionsFrame(DomainObjectMgr domainObjectMgr) {
        this.setResizable(false);
        this.parent = domainObjectMgr;
        this.resources = this.parent.MyParent.clientResources;
        this.setTitle(this.resources.getString("DYNAMIC_OPTIONS_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.secured.requestFocus();
                return;
            }
        }
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public boolean getBackupState() {
        return this.backup.getState();
    }

    public void setBackupState(boolean bl) {
        this.backup.setState(bl);
    }

    public int getSecurityMode() {
        Checkbox checkbox = this.cbgForSecurityMode.getSelectedCheckbox();
        this.securityMode = checkbox == this.preSecured ? 1 : 0;
        return this.securityMode;
    }

    public void setSecurityMode(int n) {
        this.securityMode = n;
        if (this.securityMode == 1) {
            this.cbgForSecurityMode.setSelectedCheckbox(this.preSecured);
            String string = this.parent.getCurrentDomainName();
            if (!string.trim().toLowerCase().endsWith("in-addr.arpa")) {
                this.generateKeysButton.setEnabled(true);
                return;
            }
            this.generateKeysButton.setEnabled(false);
            return;
        }
        this.cbgForSecurityMode.setSelectedCheckbox(this.secured);
        this.generateKeysButton.setEnabled(false);
    }

    public boolean getExpireTimeState() {
        return this.expiredSIG.getState();
    }

    public void setExpireTimeState(boolean bl) {
        this.expiredSIG.setState(bl);
        if (this.getExpireTimeState()) {
            this.setEnabledExpiredSIGTime(true);
            return;
        }
        this.setEnabledExpiredSIGTime(false);
    }

    public int getExpireTime() {
        return this.getNumber(this.expiredSIGTime.getText().trim());
    }

    public void setExpireTime(int n) {
        if (n >= 0 && n <= 23) {
            ((TextComponent)this.expiredSIGTime).setText(Integer.toString(n).trim());
        }
    }

    public boolean getTimeSyncState() {
        return this.timeSync.getState();
    }

    public void setTimeSyncState(boolean bl) {
        this.timeSync.setState(bl);
        if (this.getTimeSyncState()) {
            this.forwardTime.setEnabled(true);
            return;
        }
        this.forwardTime.setEnabled(false);
    }

    public boolean getForwardTimeState() {
        return this.forwardTime.getState();
    }

    public void setForwardTimeState(boolean bl) {
        this.forwardTime.setState(bl);
    }

    public boolean getOverrideTTLState() {
        return this.override.getState();
    }

    public void setOverrideTTLState(boolean bl) {
        this.override.setState(bl);
        if (this.getOverrideTTLState()) {
            this.setEnabledOverrideTime(true);
            return;
        }
        this.setEnabledOverrideTime(false);
    }

    public int getOverrideTTL() {
        return this.getNumber(this.overrideTime.getText().trim());
    }

    public void setOverrideTTL(int n) {
        if (TcpipValidation.validateInteger(n)) {
            ((TextComponent)this.overrideTime).setText(Integer.toString(n).trim());
        }
    }

    public boolean getSendKeyState() {
        return this.noKeyToSec.getState();
    }

    public void setSendKeyState(boolean bl) {
        this.noKeyToSec.setState(bl);
    }

    public String[] getGenKeyList() {
        if (this.genKeys != null) {
            return this.genKeys.getListOfNames();
        }
        return null;
    }

    public String getDirectory() {
        if (this.genKeys != null) {
            return this.genKeys.getDirectory();
        }
        return null;
    }

    public void setDirectory(String string) {
        if (this.genKeys != null) {
            this.genKeys.setDirectory(string);
        }
        this.directoryForKeys = string;
    }

    public void setGenKeyList(String[] stringArray) {
        if (this.genKeys != null) {
            this.genKeys.setListOfNames(stringArray);
            this.hostsForKeysList = null;
            return;
        }
        this.hostsForKeysList = stringArray;
    }

    public void setEnabled(boolean bl) {
        this.optionsPanel.setEnabled(bl);
    }

    public void setEnabledButtons(boolean bl) {
        if (bl) {
            this.enableOK();
            this.enableCancel();
            this.enableHelp();
            return;
        }
        this.disableOK();
        this.disableCancel();
        this.disableHelp();
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.timeRange = new Label(this.resources.getString("SECONDS_LABEL"), 0);
        this.securityModePanel = new BorderPanel(this.resources.getString("SECURITY_MODE_LABEL"));
        this.cbgForSecurityMode = new CheckboxGroup();
        this.secured = new Checkbox(this.resources.getString("SECURED_LABEL"), this.cbgForSecurityMode, false);
        this.secured.addItemListener(this);
        this.secured.addKeyListener(this);
        this.preSecured = new Checkbox(this.resources.getString("PRESECURED_LABEL"), this.cbgForSecurityMode, false);
        this.preSecured.addItemListener(this);
        this.preSecured.addKeyListener(this);
        this.generateKeysButton = new Button(this.resources.getString("GENERATE_KEYS_BUTTON_LABEL"));
        this.generateKeysButton.addActionListener(this);
        this.generateKeysButton.addKeyListener(this);
        this.noKeyToSec = new Checkbox(this.resources.getString("NO_KEY_TO_SEC_LABEL"));
        this.noKeyToSec.addKeyListener(this);
        this.backup = new Checkbox(this.resources.getString("BACKUP_CHECKBOX_LABEL"));
        this.backup.addKeyListener(this);
        this.expiredSIG = new Checkbox(this.resources.getString("EXPIRED_SIG_LABEL"));
        this.expiredSIG.addItemListener(this);
        this.expiredSIG.addKeyListener(this);
        this.expiredSIGTimeLabel = new Label(this.resources.getString("EXPIRED_SIG_TIME_LABEL"), 0);
        this.expiredSIGTime = new TextField("", 10);
        this.setEnabledExpiredSIGTime(false);
        this.timeSync = new Checkbox(this.resources.getString("TIME_SYNC_LABEL"));
        this.timeSync.addItemListener(this);
        this.timeSync.addKeyListener(this);
        this.forwardTime = new Checkbox(this.resources.getString("FORWARD_TIME_LABEL"));
        this.forwardTime.addKeyListener(this);
        this.forwardTime.setEnabled(false);
        this.override = new Checkbox(this.resources.getString("OVERRIDE_CHECKBOX_LABEL"));
        this.override.addItemListener(this);
        this.override.addKeyListener(this);
        this.overrideTimeLabel = new Label(this.resources.getString("OVERRIDE_TIME_LABEL"), 0);
        this.overrideTime = new TextField("", 10);
        this.setEnabledOverrideTime(false);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("DOF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("DOF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.tabView.addTabViewEventListener((TabViewEventListener)this);
        this.createTabs();
        this.addWindowListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.optionsPanel = new Panel();
        this.optionsPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.anchor = 17;
        this.securityModePanel.setLayout(gridBagLayout2);
        gridBagConstraints2.insets = new Insets(0, 25, 0, 0);
        this.constrain(this.secured, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 1);
        this.securityModePanel.add(this.secured);
        this.constrain(this.preSecured, gridBagLayout2, gridBagConstraints2, 0, 1, 1, 1);
        this.securityModePanel.add(this.preSecured);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.generateKeysButton, gridBagLayout2, gridBagConstraints2, 1, 1, 0, 1);
        this.securityModePanel.add(this.generateKeysButton);
        this.constrain(this.securityModePanel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 2);
        this.optionsPanel.add(this.securityModePanel);
        this.constrain(this.noKeyToSec, gridBagLayout2, gridBagConstraints2, 0, 3, 0, 1);
        this.optionsPanel.add(this.noKeyToSec);
        this.constrain(this.backup, gridBagLayout2, gridBagConstraints2, 0, 4, 0, 1);
        this.optionsPanel.add(this.backup);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.expiredSIG, gridBagLayout2, gridBagConstraints2, 0, 8, 0, 1);
        this.optionsPanel.add(this.expiredSIG);
        gridBagConstraints2.insets = new Insets(0, 50, 0, 0);
        this.constrain(this.expiredSIGTimeLabel, gridBagLayout2, gridBagConstraints2, 0, 9, 1, 1);
        this.optionsPanel.add(this.expiredSIGTimeLabel);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.expiredSIGTime, gridBagLayout2, gridBagConstraints2, 1, 9, 1, 1);
        this.optionsPanel.add(this.expiredSIGTime);
        this.constrain(this.timeSync, gridBagLayout2, gridBagConstraints2, 0, 10, 0, 1);
        this.optionsPanel.add(this.timeSync);
        gridBagConstraints2.insets = new Insets(0, 50, 0, 0);
        this.constrain(this.forwardTime, gridBagLayout2, gridBagConstraints2, 0, 11, 0, 1);
        this.optionsPanel.add(this.forwardTime);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.override, gridBagLayout2, gridBagConstraints2, 0, 12, 0, 1);
        this.optionsPanel.add(this.override);
        gridBagConstraints2.insets = new Insets(0, 50, 0, 0);
        this.constrain(this.overrideTimeLabel, gridBagLayout2, gridBagConstraints2, 0, 13, 1, 1);
        this.optionsPanel.add(this.overrideTimeLabel);
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        this.constrain(this.overrideTime, gridBagLayout2, gridBagConstraints2, 1, 13, 1, 1);
        this.optionsPanel.add(this.overrideTime);
        this.constrain(this.timeRange, gridBagLayout2, gridBagConstraints2, 2, 13, 0, 0);
        this.optionsPanel.add(this.timeRange);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
        this.secured.requestFocus();
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0] && this.validateFields()) {
            this.parent.SaveAndExit(this);
        }
        if (button == this.buttons[1]) {
            this.parent.CancelAndExit(this);
        }
        if (button == this.buttons[2]) {
            this.parent.MyParent.handleHelp("ddscnbd.htm#HDRNBD");
        }
        if (button == this.generateKeysButton) {
            if (this.genKeys == null) {
                this.genKeys = this.hostsForKeysList != null ? new GenerateKeysFrame(this.hostsForKeysList, this.parent.getCurrentDomName(), this.parent, this) : new GenerateKeysFrame(this.parent.getCurrentDomName(), this.parent, this);
                if (this.directoryForKeys != null) {
                    this.genKeys.setDirectory(this.directoryForKeys);
                }
                Dimension dimension = this.genKeys.getMinSize();
                ((Component)this.genKeys).setSize(dimension);
                ((Component)this.genKeys).setVisible(true);
            } else if (this.genKeys.isVisible()) {
                this.genKeys.requestFocus();
            } else {
                this.genKeys.reShow();
            }
            this.genKeys.selectAll(0);
            this.genKeys.requestFocus(0);
        }
    }

    private void handleCheckbox(Checkbox checkbox) {
        boolean bl = checkbox.getState();
        if (this.cbgForSecurityMode.getSelectedCheckbox() == this.preSecured) {
            String string = this.parent.getCurrentDomainName();
            if (!string.trim().toLowerCase().endsWith("in-addr.arpa")) {
                this.generateKeysButton.setEnabled(true);
            } else {
                this.generateKeysButton.setEnabled(false);
            }
        }
        if (this.cbgForSecurityMode.getSelectedCheckbox() == this.secured) {
            this.generateKeysButton.setEnabled(false);
        }
        if (checkbox == this.expiredSIG) {
            if (bl) {
                this.setEnabledExpiredSIGTime(true);
            } else {
                this.setEnabledExpiredSIGTime(false);
            }
        }
        if (checkbox == this.timeSync) {
            if (bl) {
                this.forwardTime.setEnabled(true);
            } else {
                this.forwardTime.setEnabled(false);
            }
        }
        if (checkbox == this.override) {
            if (bl) {
                this.setEnabledOverrideTime(true);
                return;
            }
            this.setEnabledOverrideTime(false);
        }
    }

    private boolean validateFields() {
        int n;
        boolean bl = true;
        if (bl && this.getExpireTimeState() && (!TcpipValidation.validateInteger(n = this.getExpireTime()) || n < 0 || n > 23)) {
            this.tabView.selectTab(this.tabNodes[0]);
            Object[] objectArray = new Object[]{new Integer(0), new Integer(23)};
            this.invalidFieldBox = new msgBox(this.resources, this.resources.getString("DYNAMIC_OPTIONS_FRAME_NAME"), MessageFormat.format(this.resources.getString("INVALID_EXPIRE_TIME_TEXT"), objectArray), 1, true, this);
            this.expiredSIGTime.selectAll();
            this.expiredSIGTime.requestFocus();
            bl = false;
        }
        if (bl && this.getOverrideTTLState() && !TcpipValidation.validateInteger(this.getOverrideTTL())) {
            this.tabView.selectTab(this.tabNodes[0]);
            this.invalidFieldBox = new msgBox(this.resources, this.resources.getString("DYNAMIC_OPTIONS_FRAME_NAME"), this.resources.getString("INVALID_OVERRIDE_TTL_TEXT"), 1, true, this);
            this.overrideTime.selectAll();
            this.overrideTime.requestFocus();
            bl = false;
        }
        return bl;
    }

    private int getNumber(String string) {
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    private void enableOK() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[0]);
    }

    private void disableOK() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[0]);
    }

    private void enableCancel() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[1]);
    }

    private void disableCancel() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[1]);
    }

    private void enableHelp() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(true, buttonArray[2]);
    }

    private void disableHelp() {
        Button[] buttonArray = this.buttonPanel.getButtons();
        this.buttonPanel.setEnabled(false, buttonArray[2]);
    }

    private void setEnabledExpiredSIGTime(boolean bl) {
        this.expiredSIGTimeLabel.setEnabled(bl);
        this.expiredSIGTime.setEnabled(bl);
        if (!bl) {
            ((Component)this.expiredSIGTime).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            return;
        }
        ((Component)this.expiredSIGTime).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
    }

    private void setEnabledOverrideTime(boolean bl) {
        this.overrideTimeLabel.setEnabled(bl);
        this.overrideTime.setEnabled(bl);
        this.timeRange.setEnabled(bl);
        if (!bl) {
            ((Component)this.overrideTime).setBackground(DDNSUtility.TEXT_FIELD_DISABLE_COLOR);
            return;
        }
        ((Component)this.overrideTime).setBackground(DDNSUtility.TEXT_FIELD_ENABLE_COLOR);
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[1];
        int n = 0;
        while (n < 1) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_DYNAMIC_OPTIONS_LABEL"));
        this.tabNodes[0].setPanel(this.optionsPanel);
        int n = 0;
        while (n < 1) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[3];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_CANCEL");
        this.buttonLabels[2] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable instanceof Checkbox) {
            this.handleCheckbox((Checkbox)itemSelectable);
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.parent.CancelAndExit(this);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public boolean preTabSelected(TabView tabView, TabViewNode tabViewNode) {
        return true;
    }

    public void postTabSelected(TabView tabView, TabViewNode tabViewNode) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Button) {
                this.handleButton((Button)object);
                return;
            }
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox(checkbox);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

