/**************************************************************************************************/
/* IBM Save Utility/2                                                                             */
/**************************************************************************************************/
/* SU2BDSK2.CMD                                                                                   */
/* Build Subscriber Install diskettes Version Check Function with 386hpfs check                   */
/**************************************************************************************************/
/*                                                                                                */
/*  (c) Copyright IBM Corp. 1992  All rights reserved.                                            */
/*  U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted           */
/*  by GSA ADP Schedule Contract with IBM Corp.                                                   */
/*                                                                                                */
/**************************************************************************************************/

copyr = 'Copyright IBM Corporation 1992';                  /* Set a copyright variable            */
call init;                                                 /* Initialize                          */

parse upper arg cmdline;                                   /* Extract command line string         */

if parmq('/VB',cmdline) then
   call vbset;                                             /* Set trace values for verbose mode   */
if parmq('/DEBUG') then
   call debset;                                            /* Set trace values for debug mode     */
if debug then
   trace ?r;                                               /* Set Interactive trace mode          */

call logo;                                                 /* Put up IBM logo and copyright stmt  */

/**************************************************************************************************/
/* Execute Customization and find out whether we are 2.0 or 2.1                                   */
/**************************************************************************************************/

subscr_drv = value('SAVEU2',,env);
subscr_path = subscr_drv'\SAVEU2';
cus_file = subscr_path'\SU2CUS.CMD';
call filefind cus_file;
esym'CALL' cus_file rdir;

librarian = value('LIBRARIAN',,env);
subscriber = value('WKSNAME',,env);
logfile = subscr_path'\'subscriber'.EVT';
transport = value('TRANSPORT',,env);
trsp_exe = subscr_path'\'transport'.EXE';
call filefind trsp_exe;

call msgout 1506, info, log, time(), date();               /* Log start time                      */
parse source . . p_file;                                   /* Get the name of this program        */
parse value(stream(p_file,'C',qdt)) with p_date p_time;    /* Get date and time of this program   */
parse value(stream(p_file,'C',qsz)) with p_size;           /* Get file size of this program       */
call msgout 1507, info, logonly, p_date, p_time, p_size;   /* Program status                      */

call semopen 'SU2BDSK';                                    /* Check that it isn't already running */

workq =  rxqueue('CREATE');                                /* Create a new queue                  */
rc = rxqueue('SET',workq);                                 /* Set to use it                       */
esym||'VER | RXQUEUE' workq;                               /* Write OS/2 version to queue         */
do queued();                                               /* Process all queued lines            */
   parse upper pull . . . . . os_verrel;                   /* Parse values from queued line       */
end;
rc = rxqueue('DELETE',workq);                              /* Throw away the queue                */

parse value os_verrel with major_ver '.' minor_ver
if minor_ver = '10'  then
   bdver = '1';                                            /* We need the 2.1 version             */
else if minor_ver = '11' then
   bdver = '2'                                             /* We need the 2.11 version            */
else if minor_ver = '0' | minor_ver = '00' then
   bdver = '0';                                            /* We need the 2.0 version             */
else
   call msgout 1516, fail, log, os_verrel;                 /* Msg- Invalid version                */

if transport = 'SU2TSN' then                               /* We need netbios version             */
   bdxport = 'N';
else if transport = 'SU2TSS' then                          /* We need IPX/SPX version             */
   bdxport = 'I';
else
   call msgout 1516, fail, log, transport;

workq =  rxqueue('CREATE');                                /* Create a new queue                  */
rc = rxqueue('SET',workq);                                 /* Set to use it                       */
say 'Getting files from Librarian' librarian;
call go_trsp 'GETFILE SU2UTIL.EXE FROM' librarian '/VIEW PROCS';
esym'SU2UTIL BOOTDRIVE | RXQUEUE' workq;
do queued();
   pull bootdrive;
end;
rc = rxqueue('DELETE',workq);                              /* Throw away the queue                */

if major_ver = '2' then
  bdfile = 'SU2BD2';                                         /* Default build diskette file         */
else if major_ver = '3' then
  bdfile = 'SU2BD3';
else
  call msgout 1516, fail, log, os_verrel;

if major_ver <> '3' then
do
   do while lines(bootdrive'\CONFIG.SYS')                     /* Parse the config.sys                */
      parse value linein(bootdrive'\CONFIG.SYS') with keyword '=' searchline
      if keyword = 'IFS' then
          do /* do */
          parse var searchline ifsdrive '\' searchline;       /* Get the IFS drive */
          parse var searchline ifspath '\' searchline;        /* Get the IFS path */
          if ifspath = 'IBM386FS' then                        /* We need the 386HPFS version */
             bdfile = 'SU2386'
          end /* do */
      if (keyword = 'device') | (keyword = 'DEVICE')then
          do /* do if */
          parse var searchline DEVdrive '\' searchline;       /* Get the DEV drive */
          parse var searchline searchline '.' extension;      /* get the  file extension */
          do while (length(searchline) > 0) & (extension = 'OS2')
             parse var searchline DEVpath '\' extension;      /* Get the DEV path */
             if (DEVpath = 'IBMTRDB') then                    /* We need the lan streamer version */
                bdxport = 'L';
          end /* do while */
          end /* do if */
   end; /* DO WHILE */
   rc = stream(bootdrive'\CONFIG.SYS','C','CLOSE');
end /* do */
bdsk_cmd = bdfile''bdver''bdxport'.CMD';                   /* Concatenate the complete file name  */
call msgout 1520, info, log, os_verrel;                    /* Msg- Building diskettes for 2.x sys */
call msgout 1521, info, log, bdsk_cmd, librarian;          /* Msg- Getting file from libr         */
call go_trsp 'GETFILE' bdsk_cmd 'FROM' librarian '/VIEW PROCS';
if stream(subscr_path'\'bdsk_cmd,'C','QUERY EXIST') = '' then
   do
      msgno = minmsg + 4;
      say 'The file 'subscr_path'\'bdsk_cmd' does not exist at the Librarian.'
      say 'SaveUtility/2 may need Corrective Service for newer versions of OS/2.'
      call msgout msgno, fail, log, bdsk_cmd;
   end /* do */
esym'CALL' bdsk_cmd;                                       /* Execute the build diskette program  */
esym'ERASE' bdsk_cmd rdir;
if bdfile = 'SU2386' then
   do /* do */
      bdfile = 'SU2BD2';
      bdsk_cmd = bdfile''bdver''bdxport'.CMD';             /* Concatenate the complete file name  */
      call msgout 1520, info, log, os_verrel;              /* Msg- Building diskettes for 2.x sys */
      call msgout 1521, info, log, bdsk_cmd, librarian;    /* Msg- Getting file from libr         */
      call go_trsp 'GETFILE' bdsk_cmd 'FROM' librarian '/VIEW PROCS';
      if stream(subscr_path'\'bdsk_cmd,'C','QUERY EXIST') = '' then
         do
            msgno = minmsg + 4;
            say 'The file 'subscr_path'\'bdsk_cmd' does not exist at the Librarian.'
            say 'SaveUtility/2 may need Corrective Service for newer versions of OS/2.'
            call msgout msgno, fail, log, bdsk_cmd;
         end /* do */
      esym'CALL' bdsk_cmd;                                 /* Execute the build diskette program  */
      esym'ERASE' bdsk_cmd rdir;
   end /* do */

call go_trsp 'GOODBYE' librarian;
call semclose;
exit 0;

/**************************************************************************************************/
/* Invoke transport and check the return code                                                     */
/**************************************************************************************************/
go_trsp:
parse arg trsp_cmd;

esym||trsp_exe trsp_cmd trp_v trp_p;                       /* Issue the transport command         */

select;                                                    /* Process return codes                */
   when rc = 0 then
      return 0;                                            /* Normal return code                  */
   when rc = 1 then
      return 1;                                            /* STOP was sent by shutdown           */
   when rc = 2 then
      return 2;                                            /* One or more minor errors occurred   */
   when rc = 3 then
      return 3;                                            /* RMTSIZE limit was reached           */
   when rc = 4 then
      return 4;                                            /* Single file exceeded RMTSIZE        */
   when rc = 6 then
      call msgout 1517, fail, log, librarian;              /* Msg- Librarian is busy              */
   when rc = 7 then
      call msgout 1518, fail, log, librarian;              /* Msg- Librarian not started          */
   otherwise
      call msgout 1519, fail, log, rc;                     /* Msg- Fatal error in transport       */
end;

return 0;                                                  /* Should never be reached             */


/**************************************************************************************************/
/* Local initialization                                                                           */
/**************************************************************************************************/
localinit:

call msginit 15;                                           /* Build boot diskettes                */

trp_v = '/V1';
trp_p = '/POLL 20 /POLLDUR 10';

return 0;

/**************************************************************************************************/
/* Local termination                                                                              */
/**************************************************************************************************/
localterm:

return 0;

/*EUC Do not delete, modify or move this line under any circumstances                             */
/* */
init:
'@VER | RXQUEUE'; do queued(); parse pull . . . . . os2_ver '.' os2_rel remain; end;
if os2_ver >= '2' then
do;
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
call SysLoadFuncs;
end;
cur_dir = directory();
parse source . . thisprog;
src_path = substr(thisprog,1,lastpos('\',thisprog)-1)
prog_name = substr(thisprog,lastpos('\',thisprog)+1);
parse var prog_name prog_name '.' .;
env = 'OS2ENVIRONMENT'; qex = 'QUERY EXISTS'; qdt = 'QUERY DATETIME'; qsz = 'QUERY SIZE';
debug = 0; verbose = 0; esym = '@'; rdir = '1>nul 2>nul';
info = 0; warn = 1; error = 2; fail = 3; action = 4; banner = 5; line = 6; prompt = 7;
nolog = 0; log = 1; logonly = 2;
resetcolors  = '[0m';  bold         = '[1m';  blink        = '[5m';  reversevideo = '[7m';
black        = '[30m'; red          = '[31m'; green        = '[32m'; yellow       = '[33m';
blue         = '[34m'; magenta      = '[35m'; cyan         = '[36m'; white        = '[37m';
on_black     = '[40m'; on_red       = '[41m'; on_green     = '[42m'; on_yellow    = '[43m';
on_blue      = '[44m'; on_magenta   = '[45m'; on_cyan      = '[46m'; on_white     = '[47m';
curup        = '[1A';  curdn        = '[1B';  clearscreen  = '[2J';  clearline    = '[K';
ms_col.0 = '';           mh_beg.0 = bold;         mh_end.0 = resetcolors;
ms_col.1 = bold||yellow; mh_beg.1 = bold||yellow; mh_end.1 = resetcolors||bold||yellow;
ms_col.2 = bold||red;    mh_beg.2 = bold||red;    mh_end.2 = resetcolors||bold||red;
ms_col.3 = bold||red;    mh_beg.3 = bold||red;    mh_end.3 = resetcolors||bold||red;
ms_col.4 = bold||green;  mh_beg.4 = bold||green;  mh_end.4 = resetcolors||bold||green;
ms_col.5 = bold||green;  mh_beg.5 = bold||green;  mh_end.5 = resetcolors||bold||green;
ms_col.6 = '';           mh_beg.6 = bold;         mh_end.6 = resetcolors;
ms_col.7 = bold||green;  mh_beg.7 = bold||green;  mh_end.7 = resetcolors||bold||green;
msg. = 'System error, invalid message.';
call localinit;
return 0;
msginit:
parse arg msgndx, msgfile, msgcount;
if msgfile = '' then
msgfile = src_path'\'prog_name'.MSG';
if stream(msgfile, 'C', qex) = '' then
do;
say bold||red'Unable to find message file' msgfile'.  SaveUtility/2 cannot continue.'resetcolors;
call beep 100, 1000;
exit 999;
end;
minmsg = msgndx * 100;
if msgcount = '' then
msgcount = 99;
maxmsg = minmsg + msgcount;
call stream msgfile, 'C', 'OPEN READ';
do while lines(msgfile);
parse value(linein(msgfile)) with msgid msg_text;
select;
when msgid <= 99 then
msg.msgid = msg_text;
when msgid >= minmsg & msgid <= maxmsg then
msg.msgid = msg_text;
when msgid > maxmsg then
leave;
otherwise
nop;
end;
end;
call stream msgfile, 'C', 'CLOSE';
return 0;
cleanup:
fail = 1;
quitnow:
call localterm;
if fail = 1 then
do;
call beep 100, 1000;
call msgout minmsg+8, error, log;
end;
else
do;
call beep 440, 200;
call msgout minmsg+11, warn, log;
end;
call msgout minmsg+9, error, log;
call semclose;
call stream logfile, 'C', 'CLOSE';
new_dir = directory(cur_dir);
if os2_ver >= 2 then
do xit_i = 1 to 8400;
if chars() then
leave;
call SysSleep 10;
end;
else
esym'PAUSE' rdir;
exit 8;
filefind:
parse arg reqd_file, ff_msg;
if ff_msg = '' then
ff_msg = minmsg + 4;
if stream(reqd_file, 'C', qex) = '' then
call msgout ff_msg, fail, log, reqd_file;
return 0;
semopen:
parse upper arg semname;
sem_file = subscr_path'\'semname'.LOK';
ret_val = stream(sem_file, 'C', 'OPEN WRITE');
if ret_val \= 'READY:' then
call msgout minmsg+13, fail, log;
return 0;
semclose:
call stream sem_file, 'C', 'CLOSE';
esym'ERASE' sem_file rdir;
return 0;
msgout:
parse arg msgid, mssta, mslog, msp1, msp2, msp3, msp4;
if msgid = '' then msgid = 0;
if mssta = '' then mssta = fail;
if msp1 = '' then msp1 = '{NOT SET}';
if msp2 = '' then msp2 = '{NOT SET}';
if msp3 = '' then msp3 = '{NOT SET}';
if msp4 = '' then msp4 = '{NOT SET}';
msd1 = msp1; msd2 = msp2; msd3 = msp3; msd4 = msp4; msgdsp = msg.msgid; msglog = msg.msgid;
msglog = repstr(msglog, '%1', msp1);
msglog = repstr(msglog, '%2', msp2);
msglog = repstr(msglog, '%3', msp3);
msglog = repstr(msglog, '%4', msp4);
if mslog = log | mslog = logonly then
do;
call lineout logfile, date('S') time() left(prog_name,8) right(msgid,4,'0') msglog;
call stream logfile, 'C', 'CLOSE';
end;
if mslog = logonly then
return 0;
msgdsp = repstr(msgdsp, '%1', msd1);
msgdsp = repstr(msgdsp, '%2', msd2);
msgdsp = repstr(msgdsp, '%3', msd3);
msgdsp = repstr(msgdsp, '%4', msd4);
if mssta = line then
do;
msgdsp = repstr(msgdsp, '{', bold);
msgdsp = repstr(msgdsp, '}', resetcolors);
say msgdsp;
return 0;
end;
if mssta = banner then
do;
say resetcolors||clearscreen||bold||cyan||on_blue|| clearline;
say center(msgdsp,80)||curup;
say clearline||resetcolors;
say '';
return 0;
end;
if mssta = prompt then
do;
say '';
say bold||green||right(msgid,4,'0') msgdsp||resetcolors;
return 0;
end;
linemax = 75;
msstm. = '';
dm_i = 0;
do forever;
dm_i = dm_i + 1;
dm_len = length(msgdsp);
if dm_len < linemax then
do;
msstm.dm_i = msgdsp;
leave;
end;
dm_j = lastpos(' ',substr(msgdsp,1,linemax));
msstm.dm_i = substr(msgdsp,1,dm_j-1);
msgdsp = substr(msgdsp,dm_j+1);
end;
msstm.0 = dm_i;
do dm_i = 1 to msstm.0;
msstm.dm_i = repstr(msstm.dm_i, '{', mh_beg.mssta);
msstm.dm_i = repstr(msstm.dm_i, '}', mh_end.mssta);
end;
do dm_i = 1 to msstm.0;
if dm_i = 1 then
msstm.dm_i = ms_col.mssta||right(msgid,4,'0') msstm.dm_i;
if dm_i = msstm.0 then
msstm.dm_i = msstm.dm_i||resetcolors;
if dm_i = 1 then
say msstm.dm_i;
else
say '     'msstm.dm_i;
end;
if mssta = fail then
call cleanup;
return 0;
repstr:
parse arg rs_src, rs_str, rs_rep;
rs_len = length(rs_str);
do forever;
rs_pos = pos(rs_str,rs_src);
if rs_pos = 0 then
return rs_src;
rs_src = insert(rs_rep,delstr(rs_src,rs_pos,rs_len),rs_pos-1);
end;
return 0;
help:
hlpfile = src_path'\SU2HLP.HLP';
if stream(hlpfile, 'C', qex) = '' then
do;
say bold||red'Unable to find help file' hlpfile'.  SaveUtility/2 cannot continue.'resetcolors;
call beep 100, 1000;
exit 999;
end;
say clearscreen||curup;
call stream hlpfile, 'C', 'OPEN READ';
do while lines(hlpfile);
parse value(linein(hlpfile)) with msgid hlp_text;
select;
when msgid = msgndx then
do;
hlp_text = repstr(hlp_text, '{', bold);
hlp_text = repstr(hlp_text, '}', resetcolors);
say hlp_text;
end;
when msgid > msgndx then
leave;
otherwise
nop;
end;
end;
call stream hlpfile, 'C', 'CLOSE';
exit 8;
parmq:
arg q_parm;
parm_pos = pos(q_parm,cmdline);
if parm_pos > 0 then
do;
parmlen = length(q_parm);
cmdline = delstr(cmdline,parm_pos,parmlen);
return 1;
end;
return 0;
logo:
say white||on_blue||clearscreen;
say ' ';
say center('              ',79);
say center('          ',79);
say center('                      ',79);
say center('                 ',79);
say center('                 ',79);
say center('                      ',79);
say center('          ',79);
say center('              ',79);
say ' ';
say center(' ' || left('',50,'')      || '',79);
say center(' ' || left(' ',50)          || '',79);
say center(' ' || center(msg.99,50)     || '',79);
say center(' ' || center(msg.msgndx,50) || '',79);
say center(' ' || left(' ',50)          || '',79);
say center(' ' || left('',50,'')      || '',79);
say ' ';
say center('(c) Copyright IBM Corporation 1993.  All Rights Reserved.',79);
say center('U.S. Government Users Restricted Rights',79);
say center('Use, duplication or disclosure restricted',79);
say center('by GSA ADP Schedule Contract with IBM Corp.',79);
wait = time('R');
do forever;
parse value(time('E')) with secs '.' hund;
if secs+0 > 3 then
leave;
end;
say resetcolors||clearscreen;
return 0;
debset: debug = 1; say '[0;68;"trace off";13p'; say '[0;67;"''cls''";13p';
vbset: verbose = 1; esym = ''; rdir = '';
return 0;
