/**************************************************************************************************/
/* IBM Save Utility/2                                                                             */
/**************************************************************************************************/
/* SU2BD21I.CMD                                                                                   */
/* OS/2 2.1 with IPX/SPX Boot diskette builder                                                    */
/**************************************************************************************************/
/*                                                                                                */
/*  (c) Copyright IBM Corp. 1993  All rights reserved.                                            */
/*  U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted           */
/*  by GSA ADP Schedule Contract with IBM Corp.                                                   */
/*                                                                                                */
/**************************************************************************************************/

call init;
parse source . . pgmsourcepath;
SourcePath = left(PgmSourcePath,lastpos('\',PgmSourcePath))

su2_drive = value('SAVEU2',,'OS2ENVIRONMENT');

starting_location = directory(su2_drive'\SAVEU2');
if directory() <> su2_drive'\SAVEU2' then
   call error 1 0 xx                                      /* Ensure we are in the right place     */

if stream('SU2CUS.CMD','C','QUERY EXIST') <> 0 then
   esym'CALL SU2CUS.CMD'
else
   call error 11 0 xx

librarian = value('LIBRARIAN',,'OS2ENVIRONMENT');
transport = value('TRANSPORT',,'OS2ENVIRONMENT');

say bold||yellow                                           /* In case MKDIR returns error         */
esym'MKDIR WORK'
say '';
rc = directory(su2_drive'\SAVEU2\WORK') /*  Change to the Work subdirectory    */

call arrayloading;

say 'Getting files from Librarian' librarian;
'..\'transport 'GETFILE SU2UTIL.EXE FROM' librarian '/VIEW PROCS /POLL 10 /POLLDUR 120 /V1';
if rc <> 0 then
   call error 12 rc 'SU2UTIL.EXE'

'..\'transport 'GETFILE SETENV.EXE FROM' librarian '/VIEW PROCS /POLL 10 /POLLDUR 120 /V1';
if rc <> 0 then
   call error 12 rc 'SETENV.EXE'

/**************************************************************************************************/
/* Find the Boot Drive to find the LIBPATH to find the DLLs                                       */
/**************************************************************************************************/

esym'SU2UTIL BOOTDRIVE | RXQUEUE';
do queued();
   pull bootdrive;
end;

do while lines(bootdrive'\CONFIG.SYS') & keyword <> 'LIBPATH'
   parse value linein(bootdrive'\CONFIG.SYS') with keyword '=' dllpath
end;
rc = stream(bootdrive'\CONFIG.SYS','C','CLOSE')

if keyword <> 'LIBPATH' then
   call error 8 0 bootdrive'\CONFIG.SYS'

i=1;
do until dllpath = ''                 /*  load the dll path array           */
   parse var dllpath entry ';' dllpath
   dll.i = entry
   i = i+1;
end;
dll.0 = i-1;

workarea  = su2_drive'\SAVEU2\WORK\'

/**************************************************************************************************/
/* Build Diskette Zero                                                                            */
/**************************************************************************************************/

Call Heading
do forever;
   say bold||Green'Put a copy of the OS/2 WARP installation diskette into drive A and press Enter.';
   say '';
   say bold||yellow'WARNING:'
   say 'This Diskette will be modified and no longer usable for its original purpose.'resetcolors
   pull reply;

   if stream('A:\SYSINSTX.COM','C','QUERY EXIST') = '' then
      say bold||red'The diskette in drive A is not the correct diskette.'
   else
      leave;
end;

Call Heading
call SysCurState 'OFF';

say bold||cyan'Deleting files from Diskette #0'bold||white;
do i = 1 to del_d0.0
  say left(left('', i, ''), del_d0.0, '') curup;
  junktext = 'A:\'del_d0.i;
  if stream(junktext,'C','QUERY EXIST') = '' then
    say bold||red'Cannot locate the file 'del_d0.i' on the diskette.'
  else
     do
        esym'ERASE 'junktext rdir;
        if rc <> 0 then
           call error 13 rc del_d0.i
     end;
end;

say bold||cyan'Copying from the Running System to Diskette #0'bold||white;

esym'COPY ..\'transport'.EXE A:\' rdir;

do i = 1 to active_d0.0
  say left(left('', i, ''), active_d0.0, '') curup;
  sourcefile = Search_Path(active_d0.i);
  if sourcefile = '' then
     call error 3 0 active_d0.i
  else
     do
        esym'COPY' sourcefile 'A:\' rdir;
        if rc <> 0 then
           call error 4 rc active_d0.i
     end;
end;
say clearline||resetcolors;
call SysCurState 'ON';

/**************************************************************************************************/
/* Build diskette One                                                                             */
/**************************************************************************************************/

Call Heading
do forever;
   say bold||Green'Put a copy of OS/2 WARP diskette #1 into drive A and press Enter.';
   say '';
   say bold||yellow'WARNING:'
   say 'This Diskette will be modified and no longer usable for its original purpose.'resetcolors
   pull reply;

   if stream('A:\CMD.EXE','C','QUERY EXIST') = '' then
      say bold||red'The diskette in drive A is not the correct diskette.'
   else
      leave;
end;

call SysCurState 'OFF';
Call Heading
say bold||cyan'Copying from the OS2 installation Diskette #1 to' workarea||bold||white;

if stream('A:\BUNDLE','C','QUERY EXIST') \= '' then
   esym'ERASE A:\BUNDLE' rdir;

do i = 1 to disk_one.0
  say left(left('', i, ''), disk_one.0, '') curup;
  esym'COPY' 'A:\'disk_one.i workarea rdir;
  if rc <> 0 then
     call error 2 rc disk_one.i
end;
say clearline||resetcolors;

/**************************************************************************************************/
/* Erase the diskette                                                                             */
/**************************************************************************************************/

say bold||cyan'Preparing the diskette';
esym||sourcepath'SU2DU ERASE A:' rdir;

say bold||cyan'Copying files from' workarea 'to Diskette #1'bold||white;
esym'COPY SETENV.EXE A:\' rdir;

do i = 1 to disk_one.0
   say left(left('', i, ''), disk_one.0, '') curup;
   esym'COPY' workarea||disk_one.i  'A:\' rdir;
   if rc <> 0 then
      call error 2 rc disk_one.i
end;
say clearline||resetcolors;

/**************************************************************************************************/
/* Move files to diskette                                                                         */
/**************************************************************************************************/

say bold||cyan'Copying selected files from the installed system to Diskette #1'bold||white;
do i = 1 to active_d1.0
   say left(left('', i, ''), active_d1.0, '') curup;
   sourcefile = Search_Path(active_d1.i);
   if sourcefile = '' then
      call error 3 0 active_d1.i
   else
      do
        esym'COPY' sourcefile 'A:\' rdir;
        if rc <> 0 then
           call error 4 rc active_d1.i
      end;
end;
say clearline||resetcolors;
/**************************************************************************************************/
/* Build the CONFIG.SYS file on Diskette One                                                      */
/**************************************************************************************************/

say bold||cyan'Building CONFIG.SYS on diskette #1'
do i = 1 to config_sys.0
   rc = lineout('A:\CONFIG.SYS', config_sys.i)
   if rc <> 0 then
      call error 5 rc 'A:\CONFIG.SYS'
end;
rc = stream('A:\CONFIG.SYS','C','CLOSE')

/**************************************************************************************************/
/* Build the STARTUP.CMD file on Diskette One                                                     */
/**************************************************************************************************/

say bold||cyan'Building STARTUP.CMD on diskette #1'
do i = 1 to startup_cmd.0
   rc = lineout('A:\STARTUP.CMD', startup_cmd.i)
   if rc <> 0 then
      call error 5 rc 'A:\STARTUP.CMD'
end;
rc = stream('A:\STARTUP.CMD','C','CLOSE')

/**************************************************************************************************/
/* Build the SU2GO.CMD file on diskette One                                                       */
/**************************************************************************************************/

say bold||cyan'Building SU2GO.CMD on diskette #1'
do i = 1 to su2go_cmd.0
   rc = lineout('A:\SU2GO.CMD', su2go_cmd.i)
   if rc <> 0 then
      call error 5 rc 'A:\SU2GO.CMD'
end;
rc = stream('A:\SU2GO.CMD','C','CLOSE')

/**************************************************************************************************/
/* Clean up and exit                                                                              */
/**************************************************************************************************/

call SysCurState 'ON';
rc = directory(su2_drive'\SAVEU2')
esym||sourcePath'SU2DU ERASE' su2_drive'\SAVEU2\WORK' rdir;
esym'RMDIR' su2_drive'\SAVEU2\WORK' rdir;
rc = directory(starting_location);

exit 0;

/**************************************************************************************************/
/* Search the PATH or LIBPATH for a filespec and return the full path                             */
/**************************************************************************************************/
Search_Path: Procedure  Expose dll.
arg filespec

parse var filespec name '.' Ext
if Ext = 'DLL' then
   do i = 1 to dll.0
      if filespec = 'NETAPI.DLL' then               /* check for netware api dynamic link library */
         do
           remaining_path = value('PATH',,'OS2ENVIRONMENT')
           work = 1
           do until work = ""                       /* look for netware directory in path variable */
              parse var remaining_path work ';' remaining_path;
              parse var work workdrv ':' remain_work;
              if remain_work = '\NETWARE' then
                  return work'\'filespec;
           end;
         end /* do */
      else
         if (stream(dll.i'\'filespec,c,'QUERY EXISTS')) <> '' then
            return dll.i'\'filespec;
   end;
else
   do
      remaining_path = value('PATH',,'OS2ENVIRONMENT')
      work = 1
      do until work = ""
         parse var remaining_path work ';' remaining_path
         copy_path = work;
         parse value copy_path with os2_drive '\' path
         if path = 'OS2' then
            do
               copy_path = os2_drive'\OS2\BOOT'
               if (stream(copy_path'\'filespec,c,'QUERY EXISTS')) <> '' then
                  return copy_path'\'filespec;
            end /* do */
         if (stream(work'\'filespec,c,'QUERY EXISTS'))   <> '' then
            return work'\'filespec;
      end;

      remaining_path = value('DPATH',,'OS2ENVIRONMENT')
      work = 1
      do until work = ""
         parse var remaining_path work ';' remaining_path
         if (stream(work'\'filespec,c,'QUERY EXISTS'))   <> '' then
            return work'\'filespec;
      end;
   end;

return '';

/**************************************************************************************************/
/* Clear the screen and put up headings                                                           */
/**************************************************************************************************/
Heading:

say resetcolors||clearscreen||bold||cyan||on_blue||clearline;
say center('SaveUtility/2 OS/2 WARP Boot Diskette Builder',80) || curup;
say clearline||resetcolors;
say '';

return

/**************************************************************************************************/
/* Initialize                                                                                     */
/**************************************************************************************************/
init:

EscB = '1B'x||'['  ; CurSave   =EscB||'s'  ; CurRest     =EscB||'u'
black  =EscB||'30m'; on_black  =EscB||'40m'; resetcolors =EscB||'0m'; tab8  ='09'x
red    =EscB||'31m'; on_red    =EscB||'41m'; bold        =EscB||'1m'; curup =EscB||'1A';
green  =EscB||'32m'; on_green  =EscB||'42m'; underscore  =EscB||'4m'; curdn =EscB||'1B';
yellow =EscB||'33m'; on_yellow =EscB||'43m'; blink       =EscB||'5m'; curfwd=EscB||'1C';
blue   =EscB||'34m'; on_blue   =EscB||'44m'; reversevideo=EscB||'7m'; curbwd=EscB||'1D';
magenta=EscB||'35m'; on_magenta=EscB||'45m'; invisible   =EscB||'8m'; curpos=EscB||'24;80H';
cyan   =EscB||'36m'; on_cyan   =EscB||'46m'; clearscreen =EscB||'2J'; co80  =EscB||'=3h';
white  =EscB||'37m'; on_white  =EscB||'47m'; clearline   =EscB||'K';  co40  =EscB||'=1h';
esym   = '@'; rdir = '1>NUL 2>NUL';

call Heading

say 'This function builds a pair of diskettes which can be used to perform';
say 'a full system restore of an OS/2 WARP system using SaveUtility/2.'
say '';
say 'You must supply copies of the OS/2 WARP Installation diskette and Diskette #1.';
say 'You will be prompted when to insert these diskettes, which will then be';
say 'modified for use with the SaveUtility/2 full system restore.'

return 0;

/*COPYALL*/
arrayloading:

call loadarray disk_one  /* Required List of files we need from OS/2 disk #1 to SU/2 disk 1 */
/* ANSICALL.DLL */
/* BKSCALLS.DLL */
/* BMSCALLS.DLL */
/* BVHINIT.DLL  */
/* BVSCALLS.DLL */
/* CLOCK01.SYS  */
/* CLOCK02.SYS  */
/* CMD.EXE      */
/* COUNTRY.SYS  */
/* DISK.NUM     */
/* DOSCALL1.DLL */
/* DOS.SYS      */
/* HARDERR.EXE  */
/* HPFS.IFS     */
/* IBM1FLPY.ADD */
/* IBM1S506.ADD */
/* IBM2ADSK.ADD */
/* IBM2FLPY.ADD */
/* IBM2SCSI.ADD */
/* IBMINT13.I13 */
/* KBDCALLS.DLL */
/* KEYBOARD.DCP */
/* MOUCALLS.DLL */
/* MSG.DLL      */
/* NAMPIPES.DLL */
/* NLS.DLL      */
/* NPXEMLTR.DLL */
/* OS2CHAR.DLL  */
/* OS2DASD.DMD  */
/* PRINT01.SYS  */
/* QUECALLS.DLL */
/* SCREEN01.SYS */
/* SCREEN02.SYS */
/* SESMGR.DLL   */
/* SIPANEL1.DLL */
/* SYSLEVEL.OS2 */
/* VIOCALLS.DLL */
/* VTBL850.DCP  */
/* IBMKBD.SYS   */
/* KBDBASE.SYS  */
/* RESOURCE.SYS */
/* XDFLOPPY.FLT */
/* END-OF-LIST     */

Call loadarray active_d0       /*  things we need from the running system for disk #0 */
/* FORMAT.COM   */
/* UHPFS.DLL    */
/* END-OF-LIST  */

say 'Loading IPX/SPX configuration.'curup;

Call loadarray del_d0         /* things to delete from diskette 0 */
/* bundle       */
/* readme.cid   */
/* readme.ins   */
/* tedit.exe    */
/* tedit.hlp    */
/* END-OF-LIST  */

Call loadarray active_d1    /* things we need from the running system for disk #1 */
/* LSL.SYS */
/* OSO001.MSG   */
/* DDAEMON.EXE */
/* TOKEN.SYS */
/* ROUTE.SYS */
/* IPX.SYS */
/* SPX.SYS */
/* SPDAEMON.EXE */
/* NWCALLS.DLL */
/* SPXCALLS.DLL */
/* IPXCALLS.DLL */
/* NWCONFIG.DLL */
/* NWREQOS2.MSG */
/* NETAPI.DLL */
/* VDISK.SYS */
/* END-OF-LIST */

Call loadarray config_sys
/* BUFFERS=32 */
/* IOPL=YES */
/* MEMMAN=NOSWAP */
/* PROTSHELL=A:\CMD.EXE /K A:\STARTUP.CMD */
/* PROTECTONLY=YES */
/* LIBPATH=.;A:\;C:\;D:\;E:\;F:\;G:\;H:\;I:\;J:\;K:\;L:\;M:\;N:\;O:\;P:\;Q:\;R:\;S:\;T:\;U:\;V:\;W:\;X:\;Y:\;Z:\; */
/* SET PATH=A:\;\; */
/* SET DPATH=A:\;\; */
/* IFS=HPFS.IFS /C:64 /AUTOCHECK:C */
/* PAUSEONERROR=NO */
/* CODEPAGE=850 */
/* DEVINFO=KBD,US,KEYBOARD.DCP */
/* DEVINFO=SCR,EGA,VTBL850.DCP */
/* SET KEYS=ON */
/* basedev=print01.sys  */
/* basedev=ibmkbd.sys   */
/* basedev=ibm1flpy.add */
/* basedev=ibm1s506.add */
/* basedev=ibm2flpy.add */
/* basedev=ibm2adsk.add */
/* basedev=ibm2scsi.add */
/* basedev=ibmint13.i13 */
/* basedev=os2dasd.dmd  */
/* basedev=xdfloppy.flt */
/* DEVICE=A:\VDISK.SYS 640,256,32 */
/* SET NWLANGUAGE=ENGLISH */
/* DEVICE=A:\LSL.SYS */
/* RUN=A:\DDAEMON.EXE */
/* DEVICE=A:\TOKEN.SYS */
/* DEVICE=A:\IPX.SYS */
/* DEVICE=A:\SPX.SYS */
/* RUN=A:\SPDAEMON.EXE */
/* SET TRANSPORT= */
/* SET LIBRARIAN= */
/* SET SU2_DROPACLS=1 */
/* END-OF-LIST */

do i = 1 to config_sys.0;                                  /* Insert transport & librarian names  */
   if config_sys.i = 'SET TRANSPORT=' then
         config_sys.i = 'SET TRANSPORT='transport;
   if config_sys.i = 'SET LIBRARIAN=' then
         config_sys.i = 'SET LIBRARIAN='librarian;
end;

Call loadarray startup_cmd
/* @IF %ECHO%. == . SET ECHO=OFF */
/* @ECHO %ECHO% */
/* Rem */
/* Rem STARTUP.CMD for SaveUtility/2 OS/2 2.1 System Restore */
/* Rem */
/* */
/* cls */
/* ECHO [1m[36m[44m[K                 SaveUtility/2 OS/2 WARP System Restore[0m */
/* ECHO. */
/* @ECHO [33m Locating VDISK */
/* for %%D in (C: D: E: F: G: H: I: J: K: L: M: N: O: P: Q: R: S: T: U: V: W: X: Y: Z:) DO VOL %%D 1>nul 2>NUL && set VD=%%D */
/* ECHO  [33m VDISK in use is [1m%VD%[0m */
/* */
/* Set RTN=P1& SET FILE=CMD.EXE& GOTO COPYIT */
/* :P1 */
/* Set COMSPEC=%VD%\CMD.EXE */
/* */
/* Set RTN=P2& SET FILE=SU2GO.CMD& GOTO COPYIT */
/* :P2 */
/* Set RTN=P3& SET FILE=OSO001.MSG& GOTO COPYIT */
/* :P3 */
/* Set RTN=P4& SET FILE=SETENV.EXE& GOTO COPYIT */
/* :P4 */
/* if exist A:\NWCALLS.DLL set RTN=P5& SET FILE=NWCALLS.DLL& GOTO COPYIT */
/* :P5 */
/* IF EXIST A:\SPXCALLS.DLL SET RTN=P6& SET FILE=SPXCALLS.DLL& GOTO COPYIT */
/* :P6 */
/* IF EXIST A:\NETAPI.DLL SET RTN=P7& SET FILE=NETAPI.DLL& GOTO COPYIT */
/* :P7 */
/* IF EXIST A:\IPXCALLS.DLL SET RTN=P8& SET FILE=IPXCALLS.DLL& GOTO COPYIT */
/* :P8 */
/* IF EXIST A:\NLS.DLL SET RTN=P9& SET FILE=NLS.DLL& GOTO COPYIT */
/* :P9 */
/* */
/* GOTO EXIT */
/* */
/* :Copyit */
/* ECHO [0m[36m Copying [1m %FILE%[0m[36m to %VD%[0m */
/* Copy A:\%FILE% %VD%\ */
/* if ERRORLEVEL 1 GOTO ERR01 */
/* IF NOT EXIST %VD%\%FILE% GOTO ERR01 */
/* GOTO %RTN% */
/* */
/* :ERR01 */
/* ECHO [1m[31mError RA01  Failed to copy %FILE% to %VD%, cause unknown. */
/* GOTO EGRESS */
/* */
/* :EXIT */
/* %VD% */
/* SU2GO.CMD */
/* */
/* :EGRESS */
/* END-OF-LIST */

Call loadarray su2go_cmd
/* @IF %ECHO%. == . SET ECHO=OFF */
/* @ECHO %ECHO% */
/* */
/* IF %1. == RCMD. GOTO COMMAND */
/* IF %1. == RESTART. GOTO Restart */
/* IF %1. == restart. GOTO Restart */
/* IF %1. == Restart. GOTO Restart */
/* */
/* :RETRY */
/* ECHO [33m[1m Reinsert diskette #0[32m */
/* PAUSE && ECHO [0m */
/* IF EXIST A:\%TRANSPORT%.EXE GOTO SECOND */
/* */
/* ECHO [1m[31m The diskette you inserted is not correct[0m */
/* GOTO RETRY */
/* :SECOND */
/* */
/* ECHO [1A[K[1A[K[1A[K */
/* IF NOT %WKSNAME%. == . GOTO GOTNAME */
/* ECHO [1m[32mType the Subscriber name of this workstation and press Enter.[0m */
/* SETENV.EXE %VD%\REPLY.CMD WKSNAME Edit0 */
/* CALL %VD%\REPLY.CMD */
/* :GOTNAME */
/* */
/* Set PATH=%VD%;%PATH% */
/* Set DPATH=%VD%;%DPATH% */
/* ECHO [36mGetting selected files from Librarian %LIBRARIAN% */
/* %TRANSPORT% GETFILE FDISK.COM FROM %LIBRARIAN% /VIEW OS2 /ALIAS %VD%\FDISK.COM /V1 /pd 120 */
/* IF NOT EXIST %VD%\FDISK.COM SET FILE=FDISK.COM& GOTO ERR04 */
/* */
/* :RESTART */
/* */
/* CLS */
/* ECHO [1m[36m[44m[K                 SaveUtility/2 OS/2 2.1 System Restore[0m */
/* ECHO. */
/* ECHO. */
/* ECHO Restore process options are as follows: */
/* ECHO. */
/* ECHO    [1m1.[0m  Partition the fixed disk                        (FDISK command) */
/* ECHO    [1m2.[0m  Format a logical drive                          (FORMAT command) */
/* ECHO    [1m3.[0m  Make a logical drive bootable                   (SYSINSTX command) */
/* ECHO    [1m4.[0m  Receive files from SaveUtility/2 */
/* ECHO    [1m5.[0m  Request a SaveUtility/2 full system restore, */
/* ECHO        then Receive files from SaveUtility/2 */
/* ECHO. */
/* ECHO    [1m9.[0m  Exit to command prompt */
/* ECHO. */
/* ECHO [1m[32mType one of the above options and press Enter.[0m */
/* :AskAgain */
/* IF NOT EXIST %VD%\SETENV.EXE SET FILE=SETENV.EXE& GOTO ERR04 */
/* SETENV.EXE %VD%\Reply.cmd option Edit0 */
/* call %VD%\Reply.cmd */
/* */
/* if %OPTION%. == 1. GOTO FDISK */
/* if %OPTION%. == 2. GOTO Format */
/* if %OPTION%. == 3. GOTO MAKBOOT */
/* if %OPTION%. == 4. GOTO Receive */
/* if %OPTION%. == 5. GOTO FSRReq */
/* if %OPTION%. == 9. GOTO Quit */
/* */
/* ECHO [1m[31mYou selected an invalid option ([33m%OPTION%[31m).[0m */
/* GOTO AskAgain */
/* */
/* :FDISK */
/* FDISK */
/* ECHO If changes to the hard drives have been made, a reboot is required at */
/* ECHO this time. otherwise press Enter to return. */
/* @pause */
/* GOTO Restart */
/* */
/* :Quit */
/* ECHO To resume, type SU2GO RESTART and press Enter. */
/* GOTO EGRESS */
/* */
/* :Format */
/* CLS */
/* ECHO [1m[36m[44m[K                 SaveUtility/2 OS/2 2.1 System Restore[0m */
/* ECHO. */
/* ECHO [1m[32mType the drive letter and press Enter.[0m */
/* SETENV.EXE %VD%\Reply.cmd Drive Edit0 */
/* CALL %VD%\REPLY.CMD */
/* ECHO [1m[32mSpecify the format, FAT or HPFS and press Enter.[0m */
/* SETENV.EXE %VD%\REPLY.CMD FILETYPE EDIT0 */
/* CALL %VD%\REPLY.CMD */
/* VOL %Drive%: */
/* ECHO Formatting drive %Drive%: with a file system of %FileType% */
/* ECHO ON */
/* FORMAT %Drive%: /FS:%FileType% */
/* @PAUSE */
/* @ECHO %ECHO% */
/* GOTO Restart */
/* */
/* :MAKBOOT */
/* ECHO [1m[32mType the drive letter and press Enter.[0m */
/* SETENV.EXE %VD%\Reply.cmd Drive Edit0 */
/* CALL %VD%\REPLY.CMD */
/* SYSINSTX %Drive%: */
/* IF ERRORLEVEL 1 GOTO ERR02 */
/* GOTO Restart */
/* */
/* :FSRREQ */
/* CLS */
/* ECHO [1m[36m[44m[K                 SaveUtility/2 OS/2 2.1 System Restore[0m */
/* ECHO. */
/* ECHO [36mSending a request for a Full System Restore to Librarian %LIBRARIAN%[0m */
/* %TRANSPORT% SENDCMD ""SU2SREST.CMD %WKSNAME%"" TO %LIBRARIAN% /VIEW SYSREST /V1 /pd 120 */
/* :RECEIVE */
/* ECHO. */
/* ECHO [36mThis workstation will be identified as [1m%WKSNAME% */
/* ECHO. */
/* ECHO The Restorer will send your files in due course.... */
/* C: */ 
/* CHDIR \ */ 
/* %TRANSPORT% RECEIVE CURRENTDIR /CONT /RECOVER /V1 */
/* IF ERRORLEVEL 2 GOTO ERR06 */
/* %VD% */
/* IF NOT EXIST C:\GETMODE.CMD GOTO ERR06 */
/* CALL C:\GETMODE.CMD */
/* ERASE C:\GETMODE.CMD */
/* SET SU2_POLLDUR=360 */
/* SET SU2_POLL=20 */
/* SET SU2_SD=1 */
/* SET SU2_RECOVER=1 */
/* SET SU2_VIEW=UNRESTRICTED */
/* FOR %%F IN (C:\TOBEREST.*) DO %TRANSPORT% GETLIST %%F FROM %FROMREST% %GETMODE% /V1 /PD 480 */
/* IF ERRORLEVEL 1 GOTO ERR08 */
/* FOR %%F IN (C:\TOBEREST.*) DO ERASE %%F */
/* %TRANSPORT% GETFILE %WKSNAME%.OS2 FROM %LIBRARIAN% /VIEW PROFILES /ALIAS %VD%\FSRCUS.CMD /V1 /pd 120 */
/* IF NOT EXIST %VD%FSRCUS.CMD GOTO ERR05 */
/* IF EXIST %VD%FSRCUS.CMD CALL %VD%FSRCUS.CMD */
/* IF NOT EXIST %SUBDRV%\SAVEU2\SU2CRITF.PRO GOTO ERR07 */
/* IF EXIST %SUBDRV%\SAVEU2\SU2CRITF.PRO COPY %SUBDRV%\SAVEU2\SU2CRITF.PRO %SUBDRV%\SAVEU2\SU2CRITF.RST */
/* %SUBDRV%\SAVEU2\SU2CRITF.EXE RESTORE %SUBDRV%\SAVEU2 */
/* if %OPTION%. == 4. GOTO RESTART */
/* ECHO [0m[1m[36m[44m[K */
/* ECHO [K                          OS/2 2.1 System Restore Completed */
/* ECHO [K */
/* ECHO [0m */
/* ECHO [0m[33mRemove the diskette from drive A: and press Ctrl-Alt-Del.[0m */
/* GOTO EGRESS */
/* :COPYIT */
/* ECHO [0m[36m Copying [1m %FILE%[0m[36m to %VD%[0m */
/* Copy A:\%FILE% %VD%\ */
/* if ERRORLEVEL 1 GOTO ERR04 */
/* IF NOT EXIST %VD%\%FILE% GOTO ERR04 */
/* GOTO %RTN% */
/* :HEADING */
/* CLS */
/* ECHO [1m[36m[44m[K                 SaveUtility/2 OS/2 2.1 System Restore[0m */
/* GOTO %RTN% */
/* :ERR02 */
/* ECHO [1m[31mError RA02  SYSINSTX failed with a non-zero return code. */
/* ECHO [1B  The hard disk may need re-formatting. */
/* GOTO EGRESS */
/* :ERR04 */
/* ECHO [1m[31mError RA04  Failed to copy %FILE% to %VD%, cause unknown. */
/* GOTO EGRESS */
/* :ERR05 */
/* ECHO [1m[31mError RA05  Failed to find %VD%FSRCUS.CMD. */
/* GOTO EGRESS */
/* :ERR06 */
/* ECHO [1m[31mError RA06  Failure during LAN Transport Setup. */
/* GOTO EGRESS */
/* :ERR07 */
/* ECHO [1m[31mError RA07  Failed to find %SUBDRV%\SAVEU2\SU2CRITF.PRO. */
/* GOTO EGRESS */
/* :ERR08 */
/* ECHO [1m[31mError RA08  Failed to get list from %LIBRARIAN% */
/* GOTO EGRESS */
/* :COMMAND */
/* @ECHO ON */
/* if %2. == FDISKQ. GOTO FDiskQ */
/* %2 %3 %4 %5 %6 %7 %8 %9 */
/* GOTO EGRESS */
/* */
/* :FDiskQ */
/* FDISK /QUERY */
/* */
/* :EGRESS */
/* %TRANSPORT% GOODBYE %LIBRARIAN% /V0 */
/* END-OF-LIST */

return

/**************************************************************************************************/
/* Load an array from the appropriate comments in this source code                                */
/**************************************************************************************************/
loadarray:
arg ArrayName

say cyan'Resolving' ArrayName 'information.'||curup;
i = 1
GoodData = ''                                              /* ensure no carry-over from last list */

do while GoodData <> 'END-OF-LIST';
   parse value sourceline(sigl + i ) with '/*' GoodData '*/'
   GoodData = strip(GoodData);
   expression = Arrayname'.'i' = "'GoodData'"'
   interpret expression
   i = i + 1;
end;
i = i-2;
expression = Arrayname'.0 = 'i
interpret expression
say clearline||curup

return 0;

/**************************************************************************************************/
/* Handle Errors                                                                                  */
/**************************************************************************************************/
error:
arg err rc dater pause                                    /*  ie  call error 3 rc hello           */

say '';
say bold||red||'Error'||err;
select
   when err =  1 then say 'Unable to Locate the \SAVEU2 subdirectory'
   when err =  2 then say 'Copy failed for 'yellow||dater||red||' with a rc of 'yellow||rc||red'.'
   when err =  3 then say 'Unable to locate required file 'yellow||dater||red||'.'
   when err =  4 then say 'Copy failed for 'yellow||dater||red||', return code was' yellow||rc||red'.'
   when err =  5 then say 'Write failed for 'yellow||dater||red||', return code was' yellow||rc||red'.'
   when err =  6 then say 'Building the diskette in drive A: failed.'
   when err =  7 then say 'Invocation of 'yellow||dater||red||' failed with rc of 'yellow||rc||red'.'
   when err =  8 then say 'The LIBPATH statment could not be found in 'yellow||dater||red||'.'
   when err =  9 then say 'Unable to copy 'yellow||dater||red||' to the A: drive.'
   when err = 10 then say 'The \IBMCOM subdirectory could not be found.'
   when err = 11 then say 'Unable to locate SU2CUS.CMD in the \SAVEU2 subdirectory.'
   when err = 12 then say 'Failure during transport with a rc of 'yellow||rc||red', active file is 'yellow||dater||red||'.'
   when err = 13 then say 'Unable to delete 'yellow||dater||red||' from diskette.  File maybe be Read Only.'
   otherwise say 'Error code '||yellow||err||red||'is undefined.'
end;

say resetcolors||bold||green;
esym'PAUSE';
say resetcolors;

exit 8;
