#define  INCL_WIN
#define  INCL_GPI
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include "fontlist.h"

#define MAXLEN      32

// external functions

// Internal function prototypes

MRESULT EXPENTRY MyWindowProc ( HWND hwnd, ULONG msg
                                , MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY ConfigDialogProc ( HWND hwndDlg, ULONG msg
                                  , MPARAM mp1, MPARAM mp2 );
void main( void );

// global variables

    HWND    hwndFrame;                      // Frame window handle
    USHORT  usItalic = -1;
    USHORT  usUnderscore = -1;
    USHORT  usBold = -1;
    USHORT  usStrikeout = -1;
    USHORT  usOutline = -1;

void main(  )
{
    HAB  hab;                           // Anchor block handle
    HMQ  hmq;                           // Message queue handle
    ULONG flCreate;                     // Window creation control flags
    ULONG  ulResult;                       // result of WinDlgBox

    hab = WinInitialize( (USHORT) NULL );
    hmq = WinCreateMsgQueue( hab, 0 );

    WinRegisterClass( hab, "Fontlist", (PFNWP)MyWindowProc, 0L, 0 );

    flCreate = FCF_SYSMENU | FCF_SIZEBORDER | FCF_TITLEBAR |
               FCF_MENU | FCF_MINMAX | FCF_SHELLPOSITION | FCF_TASKLIST;


                    ulResult = WinDlgBox (
                                  HWND_DESKTOP      // parent
                                , hwndFrame         // owner
                                , (PFNWP)ConfigDialogProc  // dialog proc
                                , (HMODULE) NULL    // resource in EXE
                                , FONTLIST          // dialog ID #
                                , (PVOID) NULL);    // create parms

    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );
}
//************************************************************
MRESULT EXPENTRY MyWindowProc( HWND hwnd, ULONG msg
                               , MPARAM mp1, MPARAM mp2 )
{
    HPS     hps;                            // Presentation space handle
    POINTL  pt;                             // for painting...
    static   CHAR  szListItem[MAXLEN];      // List input string

    switch( msg )
    {
        case WM_CLOSE:
            WinPostMsg( hwnd, WM_QUIT, 0L, 0L );
            return ( (MRESULT) NULL );
        case WM_PAINT:
            hps = WinBeginPaint ( hwnd , NULLHANDLE , NULL);
            GpiErase ( hps );
            pt.x = 10;
            pt.y = 10;
            GpiCharStringAt ( hps, &pt, (LONG) strlen(szListItem)
                              , szListItem );
            WinEndPaint ( hps );
            return ( (MRESULT) NULL );
        default:
            return ( WinDefWindowProc( hwnd, msg, mp1, mp2 ) );
    }
    return FALSE;
}
//************************************************************
MRESULT EXPENTRY ConfigDialogProc ( HWND hwndDlg, ULONG msg
                                    , MPARAM mp1, MPARAM mp2 )
{
    static  HWND    hwndList;       // List control window handle
    static  PSZ     pszHost;        // current host string
    CHAR    *pszTemp;               // temporary string pointer
    CHAR    *cNullChar;
    static char TempStr[45];
    ULONG   ulSelect;               // selected item index
    ULONG   ulCount;
    USHORT  usAttr;
    USHORT  i, j;                     // temporary loop counter
    FILE    *fontfile;
    FILE    *attrfile;
    static CHAR aszFontList[1400][45];

    switch ( msg )
    {
         case WM_INITDLG:


            fontfile = fopen( "fontlist", "r" );
            fgets( aszFontList[0], 45, fontfile );
            cNullChar = strrchr( aszFontList[0], '\n' );
            *cNullChar = '\0';
            j=1;
            while( !feof( fontfile ) )
            {
               fgets( aszFontList[j], 45, fontfile );
               if( !feof( fontfile ) ) {
                   cNullChar = strrchr( aszFontList[j], '\n' );
                   *cNullChar = '\0';
                  }
               j += 1;
            }
            fclose( fontfile );

          // retrieve a pointer to the current host string
            pszHost = PVOIDFROMMP ( mp2 );

          // retrieve the window handle of the list box
            hwndList = WinWindowFromID ( hwndDlg , FONTLISTBOX );

          // add all of the strings to the list box
            for ( pszTemp = aszFontList[0], i=1; i<j; i++ )
            {
                WinSendMsg ( hwndList, LM_INSERTITEM
                             , MPFROMSHORT ( LIT_END )
                             , MPFROMP ( pszTemp ) );
                pszTemp = aszFontList[i];
            }
            WinInvalidateRect(hwndFrame, NULL, FALSE );
            return ( (MRESULT) FALSE );


        case WM_CONTROL:

            if( SHORT2FROMMP( mp1 ) == BN_CLICKED )
            {
               switch( SHORT1FROMMP( mp1 ) )
               {
                  case FONTLISTITALIC:
                       usItalic *= -1;
                       break;
                  case FONTLISTUNDERSCORE:
                       usUnderscore *= -1;
                       break;
                  case FONTLISTBOLD:
                       usBold *= -1;
                       break;
                  case FONTLISTSTRIKEOUT:
                       usStrikeout *= -1;
                       break;
                    case FONTLISTOUTLINE:
                       usOutline *= -1;
                       break;
               }
            }
            return( (MRESULT) NULL );


        case WM_COMMAND:
            switch (SHORT1FROMMP(mp1))
            {
                case FONTLISTOK:
                   usAttr = 0;


                   if( usItalic == 1 ) usAttr |= FATTR_SEL_ITALIC;
                   if( usUnderscore == 1 ) usAttr |= FATTR_SEL_UNDERSCORE;
                   if( usBold == 1 ) usAttr |= FATTR_SEL_BOLD;
                   if( usStrikeout == 1 ) usAttr |= FATTR_SEL_STRIKEOUT;
                   if( usOutline == 1 ) usAttr |= FATTR_SEL_OUTLINE;

                   attrfile = fopen( "oneattr", "w" );
                   fprintf( attrfile, "%d\n", usAttr );
                   fclose( attrfile );
                   fontfile = fopen( "fontlist", "w" );


                   /* If NONE Selected ... force first entry */
                if (ulSelect == LIT_NONE)
                   {
                      fprintf( fontfile, "0\n");
                      i++;
                   }
                else
                {
                  do
                  {


                   ulSelect = (ULONG)WinSendMsg( hwndList,
                                          LM_QUERYSELECTION,
                                          MPFROMSHORT( LIT_FIRST ),
                                          NULL );

                           WinSendMsg( hwndList,
                                       LM_QUERYITEMTEXT,
                                       MPFROM2SHORT( ulSelect, 45 ),
                                       MPFROMP( TempStr ) );
                                                        //was TempStr
                           fprintf( fontfile, "%d\n", ulSelect );

                           WinSendMsg( hwndList, LM_SELECTITEM,
                                       MPFROMSHORT( ulSelect ),
                                       NULL );

                           ulSelect =  (ULONG)WinSendMsg( hwndList,
                                                   LM_QUERYSELECTION,
                                                   NULL, NULL );
                           i++;
                   }while( ulSelect != LIT_NONE );
                  }

                   fclose( fontfile );
                   WinDismissDlg( hwndDlg, FONTLISTOK);
                   return( (MRESULT) 0L );


            case FONTLISTSYSTEM:
                 ulCount = (ULONG) WinSendMsg( hwndList, LM_QUERYITEMCOUNT,
                                                NULL, NULL );

                 for( i=0; i < ulCount; i++ )
                    {
                       WinSendMsg( hwndList,
                                   LM_QUERYITEMTEXT,
                                   MPFROM2SHORT( i, 45 ),
                                   MPFROMP( TempStr ) );


                          if( TempStr[1] == 's' )
                          WinSendMsg( hwndList, LM_SELECTITEM,
                                      MPFROMSHORT( i ),
                                      MPFROMSHORT( TRUE ));
                          else
                          WinSendMsg( hwndList, LM_SELECTITEM,
                                      MPFROMSHORT( i ),
                                      MPFROMSHORT( FALSE ));

                    }

                 return( (MRESULT) NULL );




            case FONTLISTDEVICE:
                 ulCount = (ULONG) WinSendMsg( hwndList, LM_QUERYITEMCOUNT,
                                                NULL, NULL );

                 for( i=0; i < ulCount; i++ )
                    {

                       WinSendMsg( hwndList,
                                   LM_QUERYITEMTEXT,
                                   MPFROM2SHORT( i, 45 ),
                                   MPFROMP( TempStr ) );


                          if( TempStr[1] == 'd' )
                          WinSendMsg( hwndList, LM_SELECTITEM,
                                      MPFROMSHORT( i ),
                                      MPFROMSHORT( TRUE ));
                          else
                          WinSendMsg( hwndList, LM_SELECTITEM,
                                      MPFROMSHORT( i ),
                                      MPFROMSHORT( FALSE ));

                    }

                 return( (MRESULT) NULL );

            case FONTLISTALL:
                 ulCount = (ULONG) WinSendMsg( hwndList, LM_QUERYITEMCOUNT,
                                                NULL, NULL );

                 for( i=0; i < ulCount; i++ )
                    WinSendMsg( hwndList, LM_SELECTITEM,
                                MPFROMSHORT( i ),
                                MPFROMSHORT( TRUE ));

                 return( (MRESULT) NULL );


            case FONTLISTNONE:
                 ulCount = (ULONG) WinSendMsg( hwndList, LM_QUERYITEMCOUNT,
                                                NULL, NULL );

                 for( i=0; i < ulCount; i++ )
                    WinSendMsg( hwndList, LM_SELECTITEM,
                                MPFROMSHORT( i ),
                                MPFROMSHORT( FALSE ));

                 return( (MRESULT) NULL );

                case DID_CANCEL:
                  // return DID_CANCEL to indicate no change
                    WinDismissDlg ( hwndDlg, DID_CANCEL );
                    return ( (MRESULT) NULL );


            }
        default:
            return ( WinDefDlgProc( hwndDlg, msg, mp1, mp2 ) );
    }
}
