/**************************************************************************
 *
 * SOURCE FILE NAME = PTTPRINT.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 *   Purpose: Send output to printer and display.
 *
 *
 *
 *
 * FUNCTIONS  : startPrintThread
 *              PrintThread
 *              DoUnits
 *
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 ****************************************************************************/

#include "PTT.h"
#include "PTTprint.h"
#include <process.h>


/***************************************************************************
 *
 * FUNCTION NAME =   startPrintThread
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Startup the print thread.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = Thread Id
 *
 * RETURN-ERROR  = -1
 *
 ****************************************************************************/

TID startPrintThread()
{
  TID tid;                             /* thread id                         */


  /*
  ** start the thread running
  */

  tid = _beginthread(PrintThread,
                     NULL,
                     STACKSIZE,
                     NULL);



  return  tid;
}                                      /* end startPrintThread              */

/***************************************************************************
 *
 * FUNCTION NAME =   PrintThread
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  All printing is done from this thread.  The
 *             thread opens the presentation space for either
 *             the display or printer and calls the current
 *             test case with the newly created HPS.
 *
 *   Function Calls:  pCurrentTestCase
 *                    DoUnits
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID _Optlink PrintThread(PVOID Dummy)
{


    SHORT SelectedIndex = LIT_FIRST,NextSelectedIndex = 0;
    HWND ListhWnd;
    static PENTRYPOINT pSelectedEntry,pTempTestCase;
    QMSG MsgQPrintThread;
    DEVOPENSTRUC dop;
    PDRIVDATA driv;           /* pointer to job properties buffer */
    LONG drivbuflen;          /* length of job properties buffer */
    HAB hab;                  /* anchor block handle for DevPostDeviceModes */
    ULONG devrc;              /* return code from DevPostDeviceModes */
    HDC hdcPrinter;
    HPS hpsPrinter;
    HPS hpsScreen;
    SIZEL sizl;
    RECTL rClient;            /* Handle to rectangle formed by client area  */
    ERRORID errorid;
    PVOID junk = (PVOID)Dummy;

    sizl.cx = 0L;
    sizl.cy = 0L;



    if ((hABPrintThread = WinInitialize((USHORT)NULL)) == (HAB)NULL)
    {
      WinPostMsg(hWndClient,
                 WM_TEST_LOG,
                 MPFROM2SHORT(L_HDR,
                              0),
                 MPFROMLONG("PTTPRINT: Error from WinInitialize\n"));

    /*
    ** terminate ptt
    */

      WinPostMsg(hWndClient,
                 WM_CLOSE,
                 0L,
                 0L);

    /*
    ** _endthread
    */

      DosExit(EXIT_THREAD,
              (ULONG)MB_ERROR);
    }

    if ((hMQPrintThread = WinCreateMsgQueue(hABPrintThread,
                                            MESSAGE_QUEUE_SIZE)) == NULLHANDLE)
    {
      WinPostMsg(hWndClient,
                 WM_TEST_LOG,
                 MPFROM2SHORT(L_HDR,
                              0),
                 MPFROMLONG("PTTPRINT: Error from WinCreateMsgQueue\n"));

    /*
    ** terminate ptt
    */

      WinPostMsg(hWndClient,
                 WM_CLOSE,
                 0L,
                 0L);

    /*
    ** _endthread
    */

      DosExit(EXIT_THREAD,
              (ULONG)MB_ERROR);
    }
    DosSetPrty(PRTYS_THREAD,
               PRTYC_NOCHANGE,
               -1,
               (USHORT)NULL);

  /*
  ** initialize the print thread HAB pointer within the shared segment
  */

    *phabPrintThread = hABPrintThread;

    while (TRUE)
    {
      WinGetMsg(hABPrintThread,
                &MsgQPrintThread,
                NULLHANDLE,
                0,
                0);

      switch (MsgQPrintThread.msg)
      {
        case  WM_START_MULTIPLE :
          ListhWnd = WinWindowFromID(hwndTestCasesDlg,
                                     DLG_TESTSLB);

        /*
        ** Initialize search variables.
        */

          SelectedIndex = LIT_FIRST;
          NextSelectedIndex = 0;

          while (NextSelectedIndex != LIT_NONE)
          {
            NextSelectedIndex = SHORT1FROMMR(WinSendMsg(ListhWnd,
                                                        LM_QUERYSELECTION,
                                                        MPFROMSHORT
                                                           (SelectedIndex),
                                                        MPFROMP(NULL)));

            if (NextSelectedIndex != LIT_NONE)
            {
              pTempTestCase = (PENTRYPOINT)WinSendMsg(ListhWnd,
                                                      LM_QUERYITEMHANDLE,
                                                      MPFROMSHORT
                                                         (NextSelectedIndex),
                                                      NULL);
              WinPostQueueMsg(hMQPrintThread,
                              SHORT1FROMMP(MsgQPrintThread.mp1),
                              MPFROMP(pTempTestCase),
                              NULL);
            }
            SelectedIndex = NextSelectedIndex;
          }
          WinPostQueueMsg(hMQPrintThread,
                          WM_ENABLE_DISABLE_MENUES,
                          MPFROMSHORT(TRUE),
                          NULL);
          break;
        case  WM_ENABLE_DISABLE_MENUES :
          WinSetWindowText(hWndFrame,
                           "Printer Test Tool: MULTIPLE TESTS SELECTED");
          (VOID)EnableOrDisableMenues(SHORT1FROMMP(MsgQPrintThread.mp1));
          break;
        case  WM_TEST_PRINT :
          pSelectedTestCase = pSelectedEntry = (PENTRYPOINT)PVOIDFROMMP
             (MsgQPrintThread.mp1);

          if (pSelectedEntry == (PENTRYPOINT)NULL)
          {
            PostErrorMessage(hWndClient,
                             IDS_ERR_ENTRYPOINT);
            break;
          }

          if (bRunMultipleTests == TRUE)
            strcpy(szStatusLine,
                   "Printer Test Tool: MULTIPLE TESTS SELECTED");

          else
            sprintf(szStatusLine,
                    "Printer Test Tool:  %s",
                    pSelectedEntry->szTestName);

         /*
         ** Calling the test case with TRUE makes it send
         ** initialization messages to PTT such as
         **    WM_TEST_DOES_DEVCALLS
         **    WM_PTHREAD_DOES_DEVCALLS
         */

          (pSelectedEntry->TestAddress)(hpsPrinter,
                                        hWndClient,
                                        TRUE);

          if (usPTTOperatingMode != PTT_SCRIPT)
            (VOID)EnableOrDisableMenues(MIA_DISABLED);

         /*
         ** set current display mode var
         */

          usPTTOutputMode = PTT_PRINTER;

          if (!bTestDoesDevCalls)
          {

            if (lCurrentDCType == OD_QUEUED)
              dop.pszLogAddress = apCurrent[QUEUE];

            else
              dop.pszLogAddress = apCurrent[PORT];
            dop.pszDriverName = apCurrent[DEVICEDRIVER];

            if (strlen(apCurrent[DEVICE]) == 0)
              dop.pdriv = NULL;

            else
            {

              /* check size of buffer required for job properties */

              drivbuflen = DevPostDeviceModes ( hab,
                                                NULL,
                                                apCurrent[DEVICEDRIVER],
                                                apCurrent[DEVICE],
                                                apCurrent[PRINTERNAME],
                                                DPDM_QUERYJOBPROP );
              if (drivbuflen <= 0)
                return;                /* return error to caller */

              /* allocate memory for job properties */

              if (DosAllocMem((PPVOID)&driv,drivbuflen,fALLOC))
                return              ;  /* return error to caller */
              driv->cb = sizeof(DRIVDATA);
              driv->lVersion = 0;
              strcpy (driv->szDeviceName,apCurrent[DEVICE]);
              devrc = DevPostDeviceModes ( hab,
                                           driv,
                                           apCurrent[DEVICEDRIVER],
                                           apCurrent[DEVICE],
                                           apCurrent[PRINTERNAME],
                                           DPDM_QUERYJOBPROP );
              dop.pdriv = driv;
            }                          /* endif */
            dop.pszDataType = szCurrentDataType;
            dop.pszComment = "PTT";
            dop.pszQueueProcName = apCurrent[QPROCESSOR];
            dop.pszQueueProcParams = NULL;
            dop.pszSpoolerParams = NULL;
            dop.pszNetworkParams = NULL;

            if (!(hdcPrinter = DevOpenDC(hABPrintThread,
                                         lCurrentDCType,
                                         "*",
                                         9L,
                                         (PDEVOPENDATA)&dop,
                                         NULLHANDLE)))
            {
              errorid = WinGetLastError(hABPrintThread);
              WinPostMsg(hWndClient,
                         WM_TEST_LOG,
                         MPFROM2SHORT(L_HDR,
                                      0),
                         MPFROMLONG("PTTPRINT: Error from DevOpenDC\n"));

             /*
             ** terminate ptt
             */

              WinPostMsg(hWndClient,
                         WM_CLOSE,
                         0L,
                         0L);

             /*
             ** _endthread
             */

              DosExit(EXIT_THREAD,
                      (ULONG)MB_ERROR);
            }

           /*
           ** Get information about the device context and call DoUnits
           ** to enter that data into the shared data segment.  That data
           ** can then be used by the test cases.
           */

            if (!DevQueryCaps(hdcPrinter,
                              0L,
                              40L,
                              alDeviceCaps))
            {
              errorid = WinGetLastError(hABPrintThread);
              WinPostMsg(hWndClient,
                         WM_TEST_LOG,
                         MPFROM2SHORT(L_HDR,
                                      0),
                         MPFROMLONG("PTTPRINT: Error from DevQueryCaps\n"));

             /*
             ** terminate ptt
             */

              WinPostMsg(hWndClient,
                         WM_CLOSE,
                         0L,
                         0L);

             /*
             ** _endthread
             */

              DosExit(EXIT_THREAD,
                      (ULONG)MB_ERROR);
            }
            DoUnits();

            if (DEVESC_ERROR == DevEscape(hdcPrinter,
                                          DEVESC_STARTDOC,
                                          (LONG)(strlen(pSelectedEntry->szTestName)),
                                          pSelectedEntry->szTestName,
                                          NULL,
                                          NULL))
            {
              errorid = WinGetLastError(hABPrintThread);
              WinPostMsg(hWndClient,
                         WM_TEST_LOG,
                         MPFROM2SHORT(L_HDR,
                                      0),
                         MPFROMLONG("PTTPRINT: Error from DevEscape\n"));

             /*
             ** terminate ptt
             */

              WinPostMsg(hWndClient,
                         WM_CLOSE,
                         0L,
                         0L);

             /*
             ** _endthread
             */

              DosExit(EXIT_THREAD,
                      (ULONG)MB_ERROR);
            }
            hpsPrinter = GpiCreatePS(hABPrintThread,
                                     hdcPrinter,
                                     &sizl,
                                     ulCurrentPSType|ulCurrentPSUnits|
                                        GPIA_ASSOC);

            if (hpsPrinter == GPI_ERROR)
            {
              WinPostMsg(hWndClient,
                         WM_TEST_LOG,
                         MPFROM2SHORT(L_HDR,
                                      0),
                         MPFROMLONG("PTTPRINT: Error from GpiCreatePS\n"));

             /*
             ** terminate ptt
             */

              WinPostMsg(hWndClient,
                         WM_CLOSE,
                         0L,
                         0L);

             /*
             ** _endthread
             */

              DosExit(EXIT_THREAD,
                      (ULONG)MB_ERROR);
            }
          }                            /* End if !bTestDoesDevCalls         */

         /*
         ** Call the currently selected test case
         */

          WinSetWindowText(hWndFrame,
                           "***** T E S T   R U N N I N G *****");
          (pSelectedEntry->TestAddress)(hpsPrinter,
                                        hWndClient,
                                        FALSE);
          WinSetWindowText(hWndFrame,
                           szStatusLine);

          if (!bTestDoesDevCalls)
          {

            if (!DevEscape(hdcPrinter,
                           DEVESC_ENDDOC,
                           0L,
                           NULL,
                           NULL,
                           NULL))
            {
              WinPostMsg(hWndClient,
                         WM_TEST_LOG,
                         MPFROM2SHORT(L_HDR,
                                      0),
                         MPFROMLONG("PTTPRINT: Error from DevEscape\n"));

             /*
             ** terminate ptt
             */

              WinPostMsg(hWndClient,
                         WM_CLOSE,
                         0L,
                         0L);

             /*
             ** _endthread
             */

              DosExit(EXIT_THREAD,
                      (ULONG)MB_ERROR);
            }

           /*
           ** Destroy the presentation space and device context.
           */

            if (ulCurrentPSType == GPIT_NORMAL)
              GpiAssociate(hpsPrinter,
                           NULLHANDLE);
            GpiDestroyPS(hpsPrinter);
            DevCloseDC(hdcPrinter);
          }

          if (usPTTOperatingMode != PTT_SCRIPT && bRunMultipleTests == FALSE)

           /*
           ** enable TestCases menu
           */

            (VOID)EnableOrDisableMenues(TRUE);

           DosPostEventSem(ulPTTRamSem);


          break;

        case  WM_TEST_DISPLAY :
          pSelectedTestCase = pSelectedEntry = (PENTRYPOINT)PVOIDFROMMP
             (MsgQPrintThread.mp1);

          if (pSelectedEntry == (PENTRYPOINT)NULL)
          {
            PostErrorMessage(hWndClient,
                             IDS_ERR_ENTRYPOINT);
            return ;
          }

           /*
           ** Calling the test case with TRUE makes it send
           ** initialization messages to PTT such as
           **    WM_TEST_DOES_DEVCALLS
           **    WM_PTHREAD_DOES_DEVCALLS
           */

          (pSelectedEntry->TestAddress)(hpsScreen,
                                        hWndClient,
                                        TRUE);

          if (bRunMultipleTests == TRUE)
            strcpy(szStatusLine,
                   "Printer Test Tool: MULTIPLE TESTS SELECTED");

          else
            sprintf(szStatusLine,
                    "Printer Test Tool:  %s",
                    pSelectedEntry->szTestName);

          if (usPTTOperatingMode != PTT_SCRIPT)
            (VOID)EnableOrDisableMenues(MIA_DISABLED);

           /*
           ** set current display mode var
           */

          usPTTOutputMode = PTT_SCREEN;

           /*
           ** Get information about the device context and call DoUnits
           ** to enter that data into the shared data segment.  That data
           ** can then be used by the test cases.
           */

          DevQueryCaps(hDC,
                       0L,
                       40L,
                       alDeviceCaps);
          DoUnits();
           /*
           ** Create a PS that is associated with the window's device
           ** context.  The device context was defined in the main program
           ** before entering the PM message processing loop.
           */

          hpsScreen = GpiCreatePS(hABPrintThread,
                                  hDC,
                                  &sizl,
                                  ulCurrentPSUnits|ulCurrentPSType|GPIA_ASSOC)
             ;

           /*
           ** Determine the size of the client area
           */

          WinQueryWindowRect(hWndClient,
                             &rClient);

           /*
           ** Fill the background with the default background color
           */

          WinFillRect(hpsScreen,
                      &rClient,
                      CLR_BACKGROUND);

           /*
           ** Call the currently selected test case
           */

          WinSetWindowText(hWndFrame,
                           "***** T E S T   R U N N I N G *****");
          (pSelectedEntry->TestAddress)(hpsScreen,
                                        hWndClient,
                                        FALSE);
          WinSetWindowText(hWndFrame,
                           szStatusLine);

           /*
           ** Tell PM that window has been updated.
           */

          WinQueryUpdateRect(hWndClient,
                             &rClient);
          WinValidateRect(hWndClient,
                          &rClient,
                          TRUE);

           /*
           **  The next statment is deleted because it is invalid to
           **  De-Associate a Micro Presenatation space.
           **
           ** GpiAssociate (hpsScreen, NULL);
           */

          if (ulCurrentPSType == GPIT_NORMAL)
            GpiAssociate(hpsScreen,
                         NULLHANDLE);
          GpiDestroyPS(hpsScreen);

          if (usPTTOperatingMode != PTT_SCRIPT && bRunMultipleTests == FALSE)
            (VOID)EnableOrDisableMenues(TRUE);

           DosPostEventSem(ulPTTRamSem);


          break;                       /* End of WM_TEST_DISPLAY           */
        case  WM_CANCEL_PRINT_THREAD :
          DosSleep(5000L);

           /*
           ** _endthread
           */

          DosExit(EXIT_PROCESS,
                  0);
          break;
      }                                /* endswitch                         */
    }                                  /* endwhile (TRUE)                   */
  }                                    /* end PrintThread                   */

/***************************************************************************
 *
 * FUNCTION NAME =   DoUnits
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  This function sets the variables pDimensionX
 *             and pDimensionY variables.
 *
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

  VOID DoUnits()
  {
#define  INCH2CM       (double)(0.39370000);
    double MMPerScrnX;
    double CMPerScrnX;
    double INPerScrnX;
    double MMPerScrnY;
    double CMPerScrnY;
    double INPerScrnY;
    double XWidth,YHeight,XRes,YRes;

    /*
    ** Divide by 1000 to get mms. from meters
    */

    XWidth = (double)alDeviceCaps[CAPS_WIDTH];
    XRes = (double)alDeviceCaps[CAPS_HORIZONTAL_RESOLUTION];
    XRes /= 1000.00000000;
    MMPerScrnX = XWidth/XRes;
    CMPerScrnX = MMPerScrnX/(double)10.00000000;
    INPerScrnX = CMPerScrnX *INCH2CM;
    YHeight = (double)alDeviceCaps[CAPS_HEIGHT];
    YRes = (double)alDeviceCaps[CAPS_VERTICAL_RESOLUTION];
    YRes /= 1000.00000000;
    MMPerScrnY = YHeight/YRes;
    CMPerScrnY = MMPerScrnY/(double)10.00000000;
    INPerScrnY = CMPerScrnY *INCH2CM;

    switch ((int)ulCurrentPSUnits)
    {
      case  PU_ARBITRARY :
      case  PU_PELS :
        *pDimensionX = (LONG)XWidth;
        *pDimensionY = (LONG)YHeight;
        break;
      case  PU_LOMETRIC :
        {
          double PelsPerCMX = (double)100.00000000;
          double PelsPerCMY = (double)100.00000000;

          *pDimensionX = (LONG)((PelsPerCMX *CMPerScrnX)+(double)0.50000000);
          *pDimensionY = (LONG)((PelsPerCMY *CMPerScrnY)+(double)0.50000000);
        }
        break;
      case  PU_LOENGLISH :
        {
          double PelsPerINX = 100.00000000;
          double PelsPerINY = 100.00000000;

          *pDimensionX = (LONG)((PelsPerINX *INPerScrnX)+0.50000000);
          *pDimensionY = (LONG)((PelsPerINY *INPerScrnY)+0.50000000);
        }
        break;
      case  PU_HIMETRIC :
        {
          double PelsPerCMY = 1000.00000000;
          double PelsPerCMX = 1000.00000000;

          *pDimensionY = (LONG)((PelsPerCMY *CMPerScrnY)+.50000000);
          *pDimensionX = (LONG)((PelsPerCMX *CMPerScrnX)+.50000000);
        }
        break;
      case  PU_HIENGLISH :
        {
          double PelsPerINX = 1000.00000000;
          double PelsPerINY = 1000.00000000;

          *pDimensionX = (LONG)((PelsPerINX *INPerScrnX)+0.50000000);
          *pDimensionY = (LONG)((PelsPerINY *INPerScrnY)+0.50000000);
        }
        break;
      case  PU_TWIPS :
        {
          double PelsPerINX = 1440.00000000;
          double PelsPerINY = 1440.00000000;

          *pDimensionX = (LONG)((PelsPerINX *INPerScrnX)+0.50000000);
          *pDimensionY = (LONG)((PelsPerINY *INPerScrnY)+0.50000000);
        }
        break;
      default  :
        DosExit(EXIT_PROCESS,
                0);
        break;
    }                                  /* end switch                       */
  }                                    /* end DoUnits                      */

/***************************************************************************
 *
 * FUNCTION NAME =   EnableOrDisableMenues
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = USHORT  SelectionState
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

  VOID EnableOrDisableMenues(USHORT SelectionState)
  {
    HWND hwndAppMenu;
    HWND hwndOptionsMenu;
    MENUITEM mi;

   /*
   ** get window handle of application menu
   */

    hwndAppMenu = WinWindowFromID(hWndFrame,
                                  FID_MENU);

   /*
   ** get window handle of options menu
   */

    WinSendMsg(hwndAppMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(IDM_OPTIONS,
                            FALSE),
               MPFROMP(&mi));
    hwndOptionsMenu = mi.hwndSubMenu;

   /*
   ** disable TestCases menu
   */

    WinSendMsg(hwndAppMenu,
               MM_SETITEMATTR,
               MPFROM2SHORT(IDM_TESTCASES,
                            TRUE),
               MPFROM2SHORT(MIA_DISABLED,
                            SelectionState));

   /*
   ** disable Actions menu
   */

    WinSendMsg(hwndAppMenu,
               MM_SETITEMATTR,
               MPFROM2SHORT(IDM_ACTIONS,
                            TRUE),
               MPFROM2SHORT(MIA_DISABLED,
                            SelectionState));

   /*
   ** disable Change Log Level option
   */

    WinSendMsg(hwndOptionsMenu,
               MM_SETITEMATTR,
               MPFROM2SHORT(IDM_OPTIONS_LOGLEVEL,
                            TRUE),
               MPFROM2SHORT(MIA_DISABLED,
                            SelectionState));

   /*
   ** disable Configuration option
   */

    WinSendMsg(hwndOptionsMenu,
               MM_SETITEMATTR,
               MPFROM2SHORT(IDM_OPTIONS_CONFIGURATION,
                            TRUE),
               MPFROM2SHORT(MIA_DISABLED,
                            SelectionState));
    return ;
  }

