/**************************************************************************
 *
 * SOURCE FILE NAME = PTTINIT.H
 *
 * DESCRIPTIVE NAME = This header file contains all the constants, variables,
 *                    function prototypes for use by the PTTINIT.c module.
 *
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

/*
** Constant definitions used in InitTestCases function
*/

#define  NORMAL_FILES  0               /* used in DosFindFirst/Next         */
#define  FILE_ATTRIBUTE NORMAL_FILES   /* "                                 */
#define  SEARCH_PATTERN "*.DLL"        /* " changed for Power Pc            */
#define  RESERVED      0L              /* "                                 */
/*#define  INIT_PROC_NAME "INITTEST"*/ /* used in DosGetProcAddr            */
#define  INIT_PROC_NAME "InitTest"     /* changed for Power Pc              */
#define  ERROR         0               /* error return code                 */
#define  BACKSLASH     '\\'
#define  ERROR_TITLE   "Error Loading File"
#define  MEMORY_ALLOC_SIZE 65536L

/*
** External function prototypes
*/

extern TID startPrintThread(VOID);

extern TID startScriptThread(VOID);
extern MRESULT EXPENTRY CmdLineDlgProc(HWND,USHORT,MPARAM,MPARAM);

/*
** External vars
*/

extern HAB hABPrintThread;
extern TID ScriptThreadID;       /* Thread ID for background script thread */
extern TID PrintThreadID;        /* Thread ID for background print thread  */
extern CHAR szAppName[20];       /* class name of application (PTT)        */
extern CHAR *pass_fail;          /* test log pass/fail variable            */

/*
** Local function prototypes
*/

BOOL PTT_Init(INT argc,CHAR **argv);
BOOL get_parms(INT argc,CHAR **argv);
VOID ParseFileSpec(PCHAR pszFileSpec,PCHAR szSearchPattern);
CHAR *GetNextFileSpec(INT argc,CHAR *argv[]);
BOOL LoadAndInitializeTestCase(HWND hWnd,PCHAR szSearchPattern);
VOID PostErrorMessage(HWND hWnd,USHORT MessageID);
INT InitPrinters(VOID);
INT _Optlink qsort_compare(const void *s1,const void *s2);
VOID ptt_WriteHeader(VOID);
VOID ptt_RecordLogLevel(VOID);
