/**************************************************************************
 *
 * SOURCE FILE NAME = PTTINIT.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 *   Purpose: Initialize global variables; initialize printer information
 *            by extracting information from os2ini file; load testcase
 *            DLLs and initialize testcase data structures.
 *
 *
 * FUNCTIONS  : PTT_Init
 *              get_parms
 *              CmdLineDlgProc
 *              InitPrinters
 *              InitTestCases
 *              qsort_compare
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *   08/02/95  @V1.0RME01         Moved DosCreateEventSem to PTT.c and
 *                                moved print thread start up to after
 *                                InitPrinters call
 ****************************************************************************/

#define  INCL_DOSMODULEMGR
#define  INCL_DOSERRORS
#define  INCL_DOSFILEMGR
#include "PTT.h"
#include "PTTlog.h"
#include "PTTinit.h"
#include <ctype.h>


/*
**This array will hold all the handles to the open DLL files.
*/

static HMODULE ahModules[MAXDLLS];
static USHORT NumberOfLoadedDlls = 0;



/***************************************************************************
 *
 * FUNCTION NAME =   PTT_Init
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Get information on defined printers, load test
 *             cases and initialize variables.
 *
 *   Function Calls: get_parms
 *                   get_cmd_arg
 *                   CmdLineDlgProc
 *                   startPrintThread
 *                   startMultiThread
 *                   InitPrinters
 *                   InitTestCases
 *
 *   New    : hHeap parameter is no logner needed.
 *
 * INPUT = argc
 *         argv
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = FALSE
 *
 ****************************************************************************/

BOOL PTT_Init(INT argc,CHAR **argv)
{

  /*
  ** Initialize the global variables that are used throughout PTT.
  */

   /*
   ** The following 5 vars need to be initialized before the command line
   ** parameters are checked.
   */

  bSearch_Pattern = FALSE;      /* set initial state of DLL search pattern  */
  bPTTDoesLog = TRUE;               /* set initial state of logging method  */
  strcpy(szLogFileName,
         "PTT_LOG");                   /* set initial log file name         */
  pttloglevel = L_HDR;                 /* set initial logging level         */
  usPTTOperatingMode = PTT_INTERACTIVE; /* set initial operating mode       */
  bDisplayLogWindow = FALSE;           /* set initial state of log window   */
  bRunMultipleTests = FALSE;     /* set initial state of # of tests chosen  */
  szCurrentDataType = "PM_Q_STD";
  lCurrentDCType = OD_QUEUED;
  ulCurrentPSType = GPIT_MICRO;
  ulCurrentPSUnits = PU_PELS;


  /*
  ** Parse the command line argments for PTT
  */

  if (!get_parms(argc,
                 argv))
  {
    return (FALSE);
  }

   /*
   ** if user has chosen not to use PTT's logging method
   **   then parse the command line for Testlog arguments
   */

#if      TESTLOG

  if (!bPTTDoesLog)
  {
    get_cmd_arg((SHORT)argc,
                argv);

     /*
     ** setup initial state of pass_fail var for testlog
     */

    pass_fail = "FAIL";
  }
#endif

  /*
  ** Open the log file and write the log file header. *
  */

  if (bPTTDoesLog)
  {
    PTT_OPENLOG(szLogFileName);        /* open log for PTTLog              */
  }

#if      TESTLOG

  else
  {
    OPENLOG("PTT_LOG");                /* open log for Testlog             */
  }
#endif

  if (bPTTDoesLog)
  {
     /*
     ** Print out the header to the log file
     */

    (VOID)ptt_WriteHeader();
    (VOID)ptt_RecordLogLevel();
  }

#if      TESTLOG

  else
  {
     /*
     ** Print out the header to the log file--testlog
     */

    DosGetDateTime(&DateTime);  /* get the date and time to enter into log */
    CWRITELOG(L_HDR,
              0,
              (l_log,
               "Start of PTT run.\n"));
    CWRITELOG(L_HDR,
              0,
              (l_log,
               "%02d/%02d/%02d  %02d:%02d\n",
               DateTime.month,
               DateTime.day,
               DateTime.year,
               DateTime.hours,
               DateTime.minutes));
    CWRITELOG(L_HDR,
              0,
              (l_log,
               "=== START ===\n"));
  }
#endif

  /*
  ** Startup all required background threads.
  */

  /*
  ** This call searches the os2ini file to find the printers that are
  ** defined and initializes all related variables.
  */

  if (InitPrinters() == ERROR)
  {
    PostErrorMessage(hWndClient,
                     IDS_ERR_READINI);
  }

   /*
   ** startup the thread that sends output to the display and printer
   */

  if ((PrintThreadID = startPrintThread()) == -1)
  {
    return (ERROR);
  }

  /*
  ** Obtain a handle to the window's device context.  It will be used
  ** whenever the user wants to see the printer output in the window.
  ** See WM_PAINT processing.
  */

  hDC = WinOpenWindowDC(hWndClient);

   /*
   ** PTT initialization was successful
   */

  return (TRUE);
}                                      /* end PTT_Init                     */

/***************************************************************************
 *
 * FUNCTION NAME =   get_parms
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Get the command line arguments
 *
 *
 *   Function Calls: NONE
 *
 *
 *   New    : hHeap parameter is no logner needed.
 *
 * INPUT = argc
 *         argv
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = FALSE
 *
 ****************************************************************************/

BOOL get_parms(INT argc,CHAR *argv[])
{
  int i;
  unsigned action = 0;

    /* If you encounter an invalid parameter, then ignore it instead
    ** of aborting the program .
    ** Done By : M.M.ABUZANT
    */

    /*
    ** parse the command line arguments
    */

  for (i = 1; i < argc; i++)
  {

    switch (*(argv[i]))
    {
      case '-' :

        switch (*(argv[i]+1))
        {
          case 'f' :                   /* get filename to use for logging  */
          case 'F' :
            strcpy(szLogFileName,
                   argv[i]+2);
            break;

#if      TESTLOG
          case 'g' :                   /* use testlog to do the logging    */
          case 'G' :
            bPTTDoesLog = FALSE;
            break;
#endif
          case 'l' :                   /* get logging level to use         */
          case 'L' :

            if (isdigit((INT)*(argv[i]+2)))
            {
              pttloglevel = (INT)atoi(argv[i]+2);
            }

            else
            {
              WinMessageBox(HWND_DESKTOP,
                            hWndClient,
                            "Invalid logging level specified!",
                            NULL,
                            (USHORT)NULL,
                            MB_OK|MB_MOVEABLE|MB_CUAWARNING);
              return (FALSE);
            }
            break;
          case 's' :                   /* used only by testlog            */
          case 'S' :
            break;
          case 'x' :                   /* used only by testlog            */
          case 'X' :
            break;
          case '?' :
            WinDlgBox(HWND_DESKTOP,
                      hWndClient,
                      (PFNWP)CmdLineDlgProc,
                      (HMODULE)NULL,
                      IDLG_CMDLINE,
                      NULL);
            return (FALSE);
            break;
          default  :
            break;
        }
        break;
      case '#' :

        switch (*(argv[i]+1))
        {
          case 'b' :                   /* used only by testlog            */
          case 'B' :
            break;
          case 'i' :                   /* used only by testlog            */
          case 'I' :
            break;
          case 's' :                   /* used only by testlog            */
          case 'S' :
            break;
          case 't' :                   /* used only by testlog            */
          case 'T' :
            break;
          default  :
            break;
        }
        break;
      default  :
        break;
    }                                  /* end switch                       */
  }                                    /* end for                          */
  return (TRUE);
}                                      /* end get_parms                    */

/***************************************************************************
 *
 * FUNCTION NAME =   InitPrinters
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Find the printers that are defined in the system
 *             and setup PTT's variables accordingly.
 *
 *   Function Calls: qsort_compare
 *
 *   New      : hHeap now is a static local variable.
 *            help in implementing the re-read os2.ini
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

INT InitPrinters(VOID)
{

  static PVOID pvHeap = NULL;
  PVOID pvAllocMemory;

  ULONG ulSize,ulSizeToAlloc;
  PVOID  psIniNames;
  CHAR *pszName;
  CHAR achPrintData[256];
  CHAR *pchBeginString,*pchEndString;
  SHORT i;

  /*
  ** This creates a heap (also destroys the cmd line args) that
  ** is used throught the initialization module to allocate memory.
  **
  ** Note The Base Heap will be in another segment so i can use the
  ** command line arguments.(MABUZANT)
  */

   /*
   ** Make sure the you free segment from previous calls. Also
   ** Destroy the heap.
   */


  if (pvHeap != NULL)
  {
    DosFreeMem(pvHeap);
    pvHeap = NULL;
  }

   if (DosAllocMem(&pvHeap,
                  MEMORY_ALLOC_SIZE,
                  PAG_READ|PAG_WRITE|PAG_COMMIT) || DosSubSetMem(pvHeap,
                                                              DOSSUB_INIT,
                                                             MEMORY_ALLOC_SIZE
                                                                 ))


  {
    PostErrorMessage(hWndClient,
                     IDS_ERR_MEMORY);

    return (FALSE);
  }

  /*
  ** Using the PrfQueryProfileSize, determine the size of the largest
  ** string to be returned from PrfQueryProfileString and WinAllocMem
  ** a data structure of that size to hold the string for conversion
  ** to our internal data structures in the next section.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_PRINTER",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  ulSizeToAlloc = ulSize;
  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_QUEUE",
                      (PSZ)NULL,
                      (PULONG)&ulSize);

  if (ulSize > ulSizeToAlloc)
    ulSizeToAlloc = ulSize;
  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_PORT",
                      (PSZ)NULL,
                      (PULONG)&ulSize);

  if (ulSize > ulSizeToAlloc)
    ulSizeToAlloc = ulSize;
  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_DD",
                      (PSZ)NULL,
                      (PULONG)&ulSize);

  if (ulSize > ulSizeToAlloc)
    ulSizeToAlloc = ulSize;
  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_QP",
                      (PSZ)NULL,
                      (PULONG)&ulSize);

  if (ulSize > ulSizeToAlloc)
    ulSizeToAlloc = ulSize;

  DosSubAllocMem(pvHeap,
              &pvAllocMemory,
              ulSizeToAlloc);

  if (!pvAllocMemory)
    return (ERROR);
  psIniNames = (CHAR *)pvAllocMemory;


  /*
  ** For each defined printer, there is an associated string defined in
  ** the OS2INI file.  This string is in the form, "port name;device driver
  ** name;queue name".  We will put this information out of the OS2INI
  ** file and store in our global data structures.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_PRINTER",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  PrfQueryProfileString(HINI_SYSTEM,
                        (PSZ)"PM_SPOOLER_PRINTER",
                        (PSZ)NULL,
                        (PSZ)"",
                        psIniNames,
                        ulSize);

  for (NPrinters = 0,
       pszName = psIniNames; *pszName; NPrinters++)
  {
    PrfQueryProfileString(HINI_SYSTEM,
                          (PSZ)"PM_SPOOLER_PRINTER",
                          (PSZ)pszName,
                          (PSZ)"",
                          (PSZ)achPrintData,
                          (LONG)sizeof(achPrintData));

    DosSubAllocMem(pvHeap,
               &pvAllocMemory,
                sizeof(PMDEFPRINTER));

    if (!pvAllocMemory)
      return (ERROR);
    apPrinters[NPrinters] = (PMDEFPRINTER *)pvAllocMemory;

      /*
      ** Copy the name of the printer as defined in Print Manager into
      ** the printer structure.
      */

    strcpy(apPrinters[NPrinters]->aszPrinterName,
           pszName);

      /*
      ** Define pchBeginString as pointer to the beginning of the
      ** port name and pchEndString to its end.  Change the ";" that
      ** separates each item with a "\0" and copy the port name to
      ** apPrinters.  Do the same thing for the device driver name and
      ** queue name.
      */

    pchBeginString = achPrintData;

    if ((pchEndString = strchr(achPrintData,
                               ';')) == NULL)
      return (ERROR);
    *pchEndString = '\0';
    strcpy(apPrinters[NPrinters]->aszPortName,
           pchBeginString);
    pchBeginString = ++pchEndString;

    if ((pchEndString = strchr(pchBeginString,
                               ';')) == NULL)
      return (ERROR);
    *pchEndString = '\0';
    strcpy(apPrinters[NPrinters]->aszDDName,
           pchBeginString);
    pchBeginString = ++pchEndString;

    if ((pchEndString = strchr(pchBeginString,
                               ';')) == NULL)
      return (ERROR);
    *pchEndString = '\0';
    strcpy(apPrinters[NPrinters]->aszQueueName,
           pchBeginString);

      /*
      ** For device drivers that have support for more than one printer,
      ** the device driver name consist of the main name followed by
      ** a ".", followed by the name of the specific printer.  Parse
      ** the device driver name string into two separate strings and
      ** store them.
      */

    if ((pchBeginString = strchr(apPrinters[NPrinters]->aszDDName,
                                 '.')) == NULL)
      strcpy(apPrinters[NPrinters]->aszDeviceName,
             "");

    else
    {
      *pchBeginString = '\0';
      strcpy(apPrinters[NPrinters]->aszDeviceName,
             ++pchBeginString);
    }
    pszName += strlen(pszName)+1;
  }

  /*
  ** Load the queue names from the INI files, and place them one by one
  ** in the apQueueNames data structure.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_QUEUE",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  PrfQueryProfileString(HINI_SYSTEM,
                        (PSZ)"PM_SPOOLER_QUEUE",
                        (PSZ)NULL,
                        (PSZ)"",
                        psIniNames,
                        ulSize);

  for (NQueues = 0,
       pszName = psIniNames; *pszName; NQueues++)
  {

    DosSubAllocMem(pvHeap,
                &pvAllocMemory,
                strlen(pszName)+1);

    if (!pvAllocMemory)
      return (ERROR);
    apQueueNames[NQueues] = (CHAR *)pvAllocMemory;
    strcpy(apQueueNames[NQueues],
           pszName);
    pszName += strlen(pszName)+1;
  }

  /*
  ** Load the port names from the INI files and place them one by one
  ** in the apPortNames data structure.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_PORT",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  PrfQueryProfileString(HINI_SYSTEM,
                        (PSZ)"PM_SPOOLER_PORT",
                        (PSZ)NULL,
                        (PSZ)"",
                        psIniNames,
                        ulSize);

  for (NPorts = 0,
       pszName = psIniNames; *pszName; NPorts++)
  {

    DosSubAllocMem(pvHeap,
                &pvAllocMemory,
                strlen(pszName)+1);

    if (!pvAllocMemory)
      return (ERROR);
    apPortNames[NPorts] = (CHAR *)pvAllocMemory;
    strcpy(apPortNames[NPorts],
           pszName);
    pszName += strlen(pszName)+1;
  }

  /*
  ** Load the device driver names from the INI files and place them one
  ** by one into the apDDNames data structure.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_DD",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  PrfQueryProfileString(HINI_SYSTEM,
                        (PSZ)"PM_SPOOLER_DD",
                        (PSZ)NULL,
                        (PSZ)"",
                        psIniNames,
                        ulSize);

  for (NDevices = 0,
       pszName = psIniNames; *pszName; NDevices++)
  {

    DosSubAllocMem(pvHeap,
                &pvAllocMemory,
                strlen(pszName)+1);

    if (!pvAllocMemory)
      return (ERROR);
    apDDNames[NDevices] = (CHAR *)pvAllocMemory;

    strcpy(apDDNames[NDevices],
           pszName);
    pszName += strlen(pszName)+1;
  }

  /*
  ** Because there can be so many device drivers, we will sort them so
  ** that they show up sorted in the list boxes.
  */

  qsort((void *)apDDNames,
        NDevices,
        sizeof(PCHAR),
        qsort_compare);

  /*
  ** For device drivers that have support for more than one printer,
  ** the device driver name consist of the main name followed by
  ** a ".", followed by the name of the specific printer.  Parse
  ** the device driver name string into two separate strings and
  ** store them.
  */

  for (i = 0; i < NDevices; i++)
  {

    if ((pchBeginString = strchr(apDDNames[i],
                                 '.')) == NULL)
    {

      DosSubAllocMem(pvHeap,
                  &pvAllocMemory,
                  (ULONG)1);

      if (!pvAllocMemory)
        return (ERROR);
      apDeviceNames[i] = (CHAR *)pvAllocMemory;

      strcpy(apDeviceNames[i],
             "");
    }

    else
    {
      *pchBeginString = '\0';

      DosSubAllocMem(pvHeap,
                  &pvAllocMemory,
                  strlen(++pchBeginString)+1);

      if (!pvAllocMemory)
        return (ERROR);
      apDeviceNames[i] = (CHAR *)pvAllocMemory;

      strcpy(apDeviceNames[i],
             pchBeginString);
    }
  }

  /*
  ** Load the queue processor names from the INI files and place them
  ** one by one in the apPortNames data structure.
  */

  PrfQueryProfileSize(HINI_SYSTEM,
                      (PSZ)"PM_SPOOLER_QP",
                      (PSZ)NULL,
                      (PULONG)&ulSize);
  PrfQueryProfileString(HINI_SYSTEM,
                        (PSZ)"PM_SPOOLER_QP",
                        (PSZ)NULL,
                        (PSZ)"",
                        psIniNames,
                        ulSize);

  for (NQProcessors = 0,
       pszName = psIniNames; *pszName; NQProcessors++)
  {

    DosSubAllocMem(pvHeap,
                &pvAllocMemory,
                strlen(pszName)+1);

    if (!pvAllocMemory)
      return (ERROR);
    apQProcNames[NQProcessors] = (CHAR *)pvAllocMemory;

    strcpy(apQProcNames[NQProcessors],
           pszName);
    pszName += strlen(pszName)+1;
  }

  /*
  ** Set up the defaults.
  */

  apCurrent[PRINTERNAME] = apPrinters[0]->aszPrinterName;
  apCurrent[QUEUE] = apPrinters[0]->aszQueueName;
  apCurrent[PORT] = apPrinters[0]->aszPortName;
  apCurrent[DEVICEDRIVER] = apPrinters[0]->aszDDName;
  apCurrent[DEVICE] = apPrinters[0]->aszDeviceName;
  apCurrent[QPROCESSOR] = apQProcNames[0];

   /*
   ** release the memory that was taken from the heap
   */


 // Change made to conform to 32 bit
  DosSubFreeMem(pvHeap,
             (PVOID)psIniNames,
             ulSizeToAlloc);


  DosSubUnsetMem(pvHeap);

   /*
   ** printer initialization completed successfully
   */

  return (TRUE);
}                                      /* end InitPrinters                */

/***************************************************************************
 *
 * FUNCTION NAME =   qsort_compare
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Compare two printer driver names
 *             and setup PTT's variables accordingly.
 *
 *   Function Calls: qsort_compare
 *
 *   New      : hHeap now is a static local variable.
 *            help in implementing the re-read os2.ini
 *
 * INPUT = const void *s1
 *         const void *s2
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

INT _Optlink qsort_compare(const void *s1,const void *s2)
{
  return (strcmp((char *)s1,
                 (char *)s2));
}


/***************************************************************************
 *
 * FUNCTION NAME =   InitTestCases
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose: This function searches for test case DLL's, and
 *            adds each test to the printer component test tool
 *            menu.  Procedure addresses and test case names
 *            are resolved via a standard initialization
 *            routine within each DLL--'InitTest'--which fills
 *            a data structure with the names and addresses of
 *            test cases, as well as the number of test cases
 *            within a DLL.
 *
 *   Function Calls: *proc_init_addr
 *
 * INPUT = HWND   hWnd
 *         INT    argc
 *         CHAR **argv
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

INT InitTestCases(HWND hWnd,INT argc,CHAR **argv)
{
  PCHAR pszFileSpec;
  SHORT GroupCount;
  HDIR DirHandle;                      /* used in DosFindFirst/Next         */
  FILEFINDBUF3  ResultBuf;               /* DOS file find struct              */

  ULONG SearchCount;                   /* DOS file find params              */
  static CHAR szSearchPattern[_MAX_PATH]; /* contains the DLL search pattern*/

  /*
  ** Initialize ahModules array to NULL
  */

  memset((VOID *)ahModules,
         0x00,
         sizeof(ahModules));

  /*
  ** Allocate a shared data segement to provide information needed by
  ** the test cases in the DLL files.
  */

  if (DosAllocMem(&selTestSeg,
              100*sizeof(LONG),
              PAG_READ | PAG_WRITE | PAG_COMMIT))
      PostErrorMessage(hWndClient,IDS_ERR_MEMORY);



  if (!selTestSeg)
  {
    PostErrorMessage(hWndClient,
                     IDS_ERR_MEMORY);
    return (ERROR);
  }

   /*
   ** initialize the pointers into the share data segment
   */

  pDimensionX = (LONG *)selTestSeg;
  pDimensionY = (LONG *)selTestSeg+sizeof(LONG);
  pBasX = (LONG *)selTestSeg+(2*sizeof(LONG));
  pBasY = (LONG *)selTestSeg+(3*sizeof(LONG));
  phabPrintThread = (PHAB)selTestSeg+(4*sizeof(LONG));
  alDeviceCaps = (LONG *)selTestSeg+(5*sizeof(LONG));

  pSelectedTestCase = (PENTRYPOINT)NULL;

 /*
 ** Search for all printer test cases stored in the current subdirectory.
 ** Test cases come in DLLs.  These special DLLs contain an entry point
 ** called INITTEST that when called returns a data structure with the
 ** names and addresses of all the test cases in that DLL.
 */

  /*
  ** Find the first DLL in the subdirectory.
  */

  while (pszFileSpec = GetNextFileSpec(argc,
                                       argv))
  {
    (VOID)ParseFileSpec(pszFileSpec,
                        szSearchPattern);

    DirHandle = 0x0001;
    SearchCount = 0x0001;



      // 32 bit DosFindFirst function
      if(DosFindFirst(szSearchPattern,
                     (PHDIR)&DirHandle,
                     FILE_DIRECTORY,
                     &ResultBuf,
                     sizeof(ResultBuf),
                     &SearchCount,
                     FIL_STANDARD) == 0)

    {

  /*
  ** Enter a loop which calls the DLL entry point INITTEST of each DLL
  ** in the subdirectory and, based on the information returned in
  ** TESTINITINFO, creates the correct action bar menu submenu items
  ** and entries into internal data structures.
  */


      do
      {
        /*
        **Supply the full path name for DosLoadModule. This is helpfull
        ** when the file is located in a directory that is not included
        ** in the DPATH statment.
        */


        strcpy(strrchr(szSearchPattern,
                       BACKSLASH)+1,
               ResultBuf.achName);


         /*
         ** This message is an indication that we are still a live
         */

        WinSendMsg(hWndPromptDlg,
                   WM_PROMPT_MESSAGE,
                   MPFROMP(szSearchPattern),
                   NULL);

        /*
        ** We only load .DLL files .
        */




        if (strstr(strupr(ResultBuf.achName),
                   ".DLL")){


          (VOID)LoadAndInitializeTestCase(hWnd,
                                          szSearchPattern);
        }/*End IF*/

      }                                /* End while                        */

      //32 bit DosFindNext function
      while (DosFindNext(DirHandle,
                         (PVOID)&ResultBuf,
                         sizeof(ResultBuf),
                         &SearchCount) == 0);

    }                                  /* End if                           */
  }
  GroupCount = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hWnd,
                                                       DLG_GROUPLB),
                                       LM_QUERYITEMCOUNT,
                                       NULL,
                                       NULL));

  if (GroupCount <= (SHORT)NULL)
    PostErrorMessage(hWnd,
                     IDS_ERR_NO_DLLS);

  else
  {
    WinSendMsg(WinWindowFromID(hWnd,
                               DLG_GROUPLB),
               LM_SELECTITEM,
               MPFROMSHORT(0),
               MPFROMSHORT(TRUE));
    WinSendMsg(WinWindowFromID(hWnd,
                               DLG_TESTSLB),
               LM_SELECTITEM,
               MPFROMSHORT(0),
               MPFROMSHORT(TRUE));
    pSelectedTestCase = (PENTRYPOINT)WinSendMsg(WinWindowFromID(hWnd,
                                                                DLG_TESTSLB),
                                                LM_QUERYITEMHANDLE,
                                                MPFROMSHORT(0),
                                                NULL);
    WinSendMsg(hWndClient,
               WM_CHOOSE_TESTCASE,
               NULL,
               NULL);
  }

  /*DosFreeMem(selTestSeg);*/ /* Fixed bug in PTT */
  return (TRUE);
}

/***************************************************************************
 *
 * FUNCTION NAME =   GetNextFileSpec
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls: NONE
 *
 * INPUT = INT    argc
 *         CHAR **argv
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

CHAR *GetNextFileSpec(INT argc,CHAR *argv[])
{
  static FirstTimeThough = TRUE;   /* The first time we call this function. */
  static iIndex = 0;
  static PCHAR pszFileSpecFound = (PCHAR)NULL;


  for (iIndex++; iIndex < argc; iIndex++)

    if ((memicmp(argv[iIndex],
                 "-t",
                 2) == 0) || (argv[iIndex][0] != '-'))
      break;

  if (FirstTimeThough && (iIndex >= argc))
    pszFileSpecFound = (PCHAR)SEARCH_PATTERN;

  else

    if (iIndex < argc)

      pszFileSpecFound = memicmp(argv[iIndex],
                                 "-t",
                                 2)?argv[iIndex]:(argv[iIndex])+2;

    else
      pszFileSpecFound = (PCHAR)NULL;
  FirstTimeThough = FALSE;
  return  pszFileSpecFound;
}

/***************************************************************************
 *
 * FUNCTION NAME =   ParseFileSpec
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls: NONE
 *
 * INPUT = PCHAR pszFileSpec
 *         PCHAR szSearchPattern
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

VOID ParseFileSpec(PCHAR pszFileSpec,PCHAR szSearchPattern)
{
  ULONG ulDriveMap;
  PCHAR TempPtr = pszFileSpec,pSlash;
  CHAR szTempPath[_MAX_PATH];
  HDIR DirHandle;                      /* used in DosFindFirst/Next        */
  FILEFINDBUF3  ResultBuf;               /* DOS file find struct  32 bit   */


  ULONG SearchCount,DriveNum,DirLen = _MAX_PATH,ReturnCode;

  strupr(pszFileSpec);

  if (*(pszFileSpec+1) == ':')
  {
    strncpy(szSearchPattern,
            pszFileSpec,
            2);
    TempPtr += 2;
  }

  else
  {
     DosQueryCurrentDisk(&DriveNum,
                         &ulDriveMap);


    *szSearchPattern = (CHAR)(DriveNum+'@');
    *(szSearchPattern+1) = ':';
  }
  *(szSearchPattern+2) = (CHAR)NULL;

  if (*TempPtr == BACKSLASH)
    strcat(szSearchPattern,
           TempPtr);
  else
  {

    DosQueryCurrentDir(DriveNum,
                      szTempPath,
                      &DirLen);


    if (strlen(szTempPath))
      strcat(szSearchPattern,
             "\\");

     /* NEW 32 BIT  - path */
     strcat(szSearchPattern,szTempPath);


  }

   /*
   ** Check to see it they did not specify a file name
   */

  DirHandle = 0x0001;
  SearchCount = 0x0001;

  if (strpbrk(szSearchPattern,
              "*?") == (PCHAR)NULL)
  {
    // 32 bit DosFindFirst function
    ReturnCode = DosFindFirst(szSearchPattern,
                              (PHDIR)&DirHandle,
                              MUST_HAVE_DIRECTORY | FILE_NORMAL,
                              &ResultBuf,
                              sizeof(ResultBuf),
                              &SearchCount,
                              FIL_STANDARD);


    if ((ReturnCode == 0 && (ResultBuf.attrFile&FILE_DIRECTORY)) ||
       (ReturnCode == ERROR_NO_MORE_FILES))
      strcat(szSearchPattern,
             "\\*.DLL");
  }

  /*
  ** Get rid of '\\' slashes.
  */

  while (pSlash = strstr(szSearchPattern,
                         "\\\\"))
    memmove(pSlash,
            pSlash+1,
            strlen(pSlash));

  return ;

}

/***************************************************************************
 *
 * FUNCTION NAME =   LoadAndInitializeTestCase
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls: NONE
 *
 * INPUT = HWND  hWnd
 *         PCHAR szSearchPattern
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE
 *
 * RETURN-ERROR  = ERROR
 *
 ****************************************************************************/

BOOL LoadAndInitializeTestCase(HWND hWnd,PCHAR szSearchPattern)
{
  HWND hWndGroup;
  INT ReturnCode,i;
  CHAR szLoadError[_MAX_PATH+100];
  HMODULE hModule;
  PCHAR ErrorString = (PCHAR)NULL;


  ULONG RequiredSize;
  PVOID TestCase;

  PFN proc_init_addr;

                                          /* pointer to init function      */
  TESTINITINFO test_info;             /* contains init info from test case */
  PTEST_CASE_COMPONENT pTestCase;





  hWndGroup = WinWindowFromID(hWnd,
                              (ULONG)DLG_GROUPLB);


  if (ReturnCode = DosLoadModule(szLoadError,  /* Object name buffer        */
                                 sizeof(szLoadError), /* Length-object name */
                                 szSearchPattern,  /* Module name string    */
                                 &hModule))   /* Address of module handle   */
  {
    ErrorString = "Error Loading  ";
  }

  else
  {

    /*
    ** Get the address of the test case initialization procedure
    ** from the DLL.
    */

    if (DosQueryProcAddr(hModule,
                       0L,
                       INIT_PROC_NAME,
                       &proc_init_addr))
    {
        ErrorString = "Error getting initializing procedure address in   ";
      }

      else
      {

       /*
       ** call INITTEST routine to get testcase information
       */
        (*proc_init_addr)(selTestSeg,
                          (PTESTINITINFO)&test_info);

        RequiredSize = (ULONG)(test_info.ntests * ENTRY_POINT_SIZE) + TEST_CASE_SIZE;


        /* Changed 9/24/93 PP/BW */
        DosAllocMem((PPVOID)&pTestCase,
                    sizeof(TEST_CASE_COMPONENT),
                    PAG_READ|PAG_WRITE|PAG_COMMIT);


        if (!TestCase)
          ErrorString = "Error Allocating memory to store entry points for  ";
        else
        {


            pTestCase->ntests = test_info.ntests;

            strcpy(pTestCase->group_name,
                   test_info.group_name);
            ahModules[NumberOfLoadedDlls++] = hModule;
            strcpy(pTestCase->FullDllName,
                   szSearchPattern);

            DosAllocMem(&TestCase,
                        (ULONG)(sizeof(ENTRYPOINT) * pTestCase->ntests),
                        PAG_READ|PAG_WRITE|PAG_COMMIT);

           pTestCase->pEntryPoint = (PENTRYPOINT)TestCase;

           /*  Changed 09/24/93 PP/BW */
           for (i = 0; i < pTestCase->ntests; i++)
            {
              memset(pTestCase->pEntryPoint, 0, sizeof(ENTRYPOINT));
              strcpy(pTestCase->pEntryPoint->szTestName,
                     test_info.test_names[i]);
              pTestCase->pEntryPoint->TestAddress = test_info.test_addrs[i];


              if (i < pTestCase->ntests)
                pTestCase->pEntryPoint++;
            }

           pTestCase->pEntryPoint = (PENTRYPOINT)TestCase;

            i = SHORT1FROMMR(WinSendMsg(hWndGroup,
                                        LM_INSERTITEM,
                                        MPFROMSHORT(LIT_END),
                                        MPFROMP(pTestCase->group_name)));

            WinSendMsg(hWndGroup,
                       LM_SETITEMHANDLE,
                       MPFROMSHORT(i),
                       MPFROMP(pTestCase));
          }
        }
      }

      if (ErrorString == (PCHAR)NULL)
        return  TRUE;

      else
      {
        DosFreeModule(hModule);
        sprintf(szLoadError,
                "%s  %s\n\nDLL is ignored.",
                ErrorString,
                szSearchPattern);
        WinMessageBox(HWND_DESKTOP,
                      hWnd,
                      szLoadError,
                      "DLL Error Condition",
                      0,
                      MB_OK|MB_ERROR|MB_APPLMODAL|MB_MOVEABLE|MB_SYSTEMMODAL);
      }
      //Free Memory
      DosFreeMem(TestCase);
      DosFreeMem(pTestCase);
      return  FALSE;
    }


    VOID PostErrorMessage(HWND hWnd,
                          USHORT MessageID)
    {
      INT ActualMessageLength;
      static CHAR szMessageStorage[450];

      ActualMessageLength = WinLoadString(hAB,
                                          (HMODULE)NULL,
                                          MessageID,
                                          sizeof(szMessageStorage),
                                          szMessageStorage);

      if (!ActualMessageLength)
        strcpy(szMessageStorage,
               " An Error has occured.\n\n"
                  "Error Message Can't be retrieved\n");
      WinMessageBox(HWND_DESKTOP,
                    hWnd,
                    szMessageStorage,
                    "Error Condition",
                    0,
                    MB_OK|MB_ERROR|MB_APPLMODAL|MB_MOVEABLE|MB_SYSTEMMODAL);
      return ;
    }

    VOID APIENTRY CleanUpFunction(VOID)
    {
      USHORT usIndex = 0;

   /*
   ** logfile=(FILE *)NULL means the file been closed
   ** successfully.
   */

      if (bPTTDoesLog && (logfile != (HFILE)NULL))
      {

     /*
     ** Print out the trailer to the log file and close the log file
     ** -- for PTTLog this is done in PTT_CLOSELOG
     */

        PTT_CLOSELOG();
      }
       _fcloseall();                     /* Flush and Close all open Files   */

    /*
    ** Free memory occupied by All loaded DLL.
    */


      while (ahModules[usIndex] != (HMODULE)NULL)
        DosFreeModule(ahModules[usIndex++]);
   /*
   ** Close Event Semaphore
   */

      DosCloseEventSem(ulPTTRamSem);

   /*
   ** Tell OS/2 to execute next function on the list
   */

      DosExitList(EXLST_EXIT,
                  (PFNEXITLIST)CleanUpFunction);

    }

