/**************************************************************************
 *
 * SOURCE FILE NAME = PTTDLGS.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose: Contains all dialog procedures.
 *
 *
 *
 *
 * FUNCTIONS  : TestCasesDlgProc
 *              ConfigDlgProc
 *              LoggingDlgProc
 *              LogToDlgBox
 *              CmdLineDlgProc
 *              LogLevelDlgProc
 *              AboutDlgProc
 *
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *   08/02/95  @V1.0RME01         Moved call that loads the test case DLLs
 *                                and initialize apTestAddrs and apTestNames
 *                                and also chooses the default testcase to
 *                                PTT.c in main to WM_INITIALIZE_TESTCASES
 *                                in main message loop. Also ulPTTRamSem used
 *                                for the script thread.
 ****************************************************************************/

#include "PTT.h"
#include "PTTlog.h"
#include "PTTdlgs.h"
#include "ctype.h"

/***************************************************************************
 *
 * FUNCTION NAME =   TestCasesDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle TestCases menu option.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY TestCasesDlgProc(HWND hWndDlg,
                                  USHORT message,
                                  MPARAM mp1,
                                  MPARAM mp2)
{
  USHORT i;

  USHORT usSelect;
  SHORT INT NextSelectedIndex = 0,SelectedIndex = LIT_FIRST;
  static INT LastSelectedGroup = 0;
  static BOOL LastSelectedGroupAttr = FALSE;
  static SHORT DefaultFontHeight = 0x7fff;
  static HWND hwndGroupLB,hwndTestsLB,PatternhWnd; /* handles of listboxes */

  ULONG ulPostCnt;

//BSC  PSZ szPTTSem;

  switch (message)
  {
    case  WM_MEASUREITEM :

    /*
    ** Get the current font char height. This is needed since the
    ** group list box has the style LS_OWNERDRAW.
    */

      if (DefaultFontHeight = 0x7fff)
      {
        FONTMETRICS fm;
        HPS hps = WinGetPS(hWndDlg);

        GpiQueryFontMetrics(hps,
                            (LONG)sizeof fm,
                            &fm);
        DefaultFontHeight = (USHORT)((float)fm.lMaxBaselineExt *1.1);
        WinReleasePS(hps);
      }
      return  MRFROM2SHORT(DefaultFontHeight,
                           0);
//BSC      break;

    case  WM_DRAWITEM :
      {
        POWNERITEM pDrawItem = (POWNERITEM)mp2;

        LastSelectedGroup = pDrawItem->idItem;
        LastSelectedGroupAttr = (BOOL)pDrawItem->fsState;
      }
      return (MRESULT)FALSE;
//BSC      break;
    case  WM_INITDLG :

      /*
      ** get handles of the list boxes
      */
      hwndGroupLB = WinWindowFromID(hWndDlg,
                                    DLG_GROUPLB);
      hwndTestsLB = WinWindowFromID(hWndDlg,
                                    DLG_TESTSLB);
      PatternhWnd = WinWindowFromID(hWndDlg,
                                    DLG_CHOOSE_PATTERN);

       /*
       ** Set/clear semaphore to indicate we're to begin initializing testcases.
       ** -- this is needed for the script thread.
       */

      DosResetEventSem(ulPTTRamSem,
                       &ulPostCnt);

      bRunMultipleTests = FALSE;

       /*
       ** clear/post semaphore to indicate we're finished with initialiation
       ** -- this is needed for the script thread.
       */

      DosPostEventSem(ulPTTRamSem);

       /*
       ** Insert the predefined pattern into the list box and set
       ** the default value to "All".
       */

      for (i = 0; i < PATTERN_COUNT; )
        WinSendMsg(PatternhWnd,
                   LM_INSERTITEM,
                   MPFROMSHORT(LIT_END),
                   MPFROMP(*(apPatterns+i++)));
      WinSetWindowText(PatternhWnd,
                       *apPatterns);

      break;                           /* End of WM_INITDLG                */
    case  WM_DISABLE_DISPLAY_OPTION :
      {
        HWND hwndAppMenu = WinWindowFromID(hWndFrame,
                                           FID_MENU);

     /*
     ** Enable/Disable Actions menu
     */

        WinSendMsg(hwndAppMenu,
                   MM_SETITEMATTR,
                   MPFROM2SHORT(IDM_ACTIONS,
                                TRUE),
                   MPFROM2SHORT(MIA_DISABLED,
                                SHORT1FROMMP(mp2)));
      }
      break;
    case  WM_CONTROL :

      if (SHORT2FROMMP(mp1) == LN_SELECT && SHORT1FROMMP(mp1) == DLG_GROUPLB)
      {
        PTEST_CASE_COMPONENT pTestCase;
        PENTRYPOINT pEntryList;

        WinEnableWindowUpdate(hwndTestsLB,
                              FALSE);
        pTestCase = (PTEST_CASE_COMPONENT)WinSendMsg(hwndGroupLB,
                                                     LM_QUERYITEMHANDLE,
                                                     MPFROMSHORT
                                                        (LastSelectedGroup),
                                                     NULL);
        pEntryList = pTestCase->pEntryPoint;

        if (LastSelectedGroupAttr == TRUE)
        {




          /** Changed 09/24/93 **/
          for (i = 0; i < pTestCase->ntests;i++)
          {
            usSelect = SHORT1FROMMR(WinSendMsg(hwndTestsLB,
                                               LM_INSERTITEM,
                                               MPFROMSHORT(LIT_END),
                                               MPFROMP(pEntryList->szTestName)
                                               ));


            WinSendMsg(hwndTestsLB,
                       LM_SETITEMHANDLE,
                       MPFROMSHORT(usSelect),
                       MPFROMP(pEntryList) );

          if (i < pTestCase->ntests)
            pEntryList++;


          }
        }

        else
        {
          usSelect = SHORT1FROMMR(WinSendMsg(hwndTestsLB,
                                             LM_SEARCHSTRING,
                                             MPFROM2SHORT(LSS_CASESENSITIVE,
                                                          LIT_FIRST),
                                             MPFROMP((pEntryList->szTestName))
                                                ));


          for (i = 0; i < pTestCase->ntests; i++)
          {
            WinSendMsg(hwndTestsLB,
                       LM_DELETEITEM,
                       MPFROMSHORT(usSelect),
                       NULL);

          }
        }
        WinEnableWindowUpdate(hwndTestsLB,
                              TRUE);
      }
      break;                           /* End of WM_CONTROL                 */

    case  WM_COMMAND :

      switch (SHORT1FROMMP(mp1))
      {

        case  DLG_DELETE_MATCH :
          (VOID)PerformPatternMatching(FALSE);
          break;

        case  DLG_ADD_MATCH :
          (VOID)PerformPatternMatching(TRUE);
          break;

        case  DLG_TEST_SELECT :

           /*
           ** Check to see if more than one testcase is selected
           */

          i = 0;
          usSelect = LIT_NONE;

          while (NextSelectedIndex != LIT_NONE)
          {
            NextSelectedIndex = SHORT1FROMMR(WinSendMsg(hwndTestsLB,
                                                        LM_QUERYSELECTION,
                                                        MPFROMSHORT
                                                           (SelectedIndex),
                                                        MPFROMP(NULL)));

            if (NextSelectedIndex != LIT_NONE)
            {

              if (i == 0)
                usSelect = NextSelectedIndex;
              i++;
            }
            SelectedIndex = NextSelectedIndex;
          }                            /* End of while loop                */

           /*
           ** First check if any selection is made...
           */

          if (i == NULLHANDLE)
          {
            WinMessageBox(HWND_DESKTOP,
                          hWndDlg,
                          "   No test were selected!! \
                  Please highlight \
                      a testcase or \
                        click cancel.",
                          "PTT Testcase Selection",
                          (USHORT)NULL,
                          MB_OK|MB_MOVEABLE|MB_CUAWARNING);
            return (MRESULT)FALSE;
          }

          else

            if (i == 1)
            {
              pSelectedTestCase = (PENTRYPOINT)WinSendMsg(hwndTestsLB,
                                                          LM_QUERYITEMHANDLE,
                                                          MPFROMSHORT(usSelect),
                                                          0L);

              bRunMultipleTests = FALSE;
            }

            else
              bRunMultipleTests = TRUE;
          WinSendMsg(hwndTestCasesDlg,
                     WM_CLOSE,
                     NULL,
                     NULL);
          break;
        case  DLG_TEST_CANCEL :

                 /*
                 ** Ignore data values entered into the dialog controls
                 ** and dismiss the dialog window
                 */

          WinShowWindow(hwndTestCasesDlg,
                        FALSE);
          WinSendMsg(hwndTestCasesDlg,
                     WM_DISABLE_DISPLAY_OPTION,
                     NULL,
                     MPFROMSHORT(0));
          WinSendMsg(hWndClient,
                     WM_CHOOSE_TESTCASE,
                     NULL,
                     NULL);
          WinSetFocus(HWND_DESKTOP,
                      hWndClient);
          break;
      }
      break;                           /* End of WM_COMMAND               */
      case WM_CLOSE :
      WinPostMsg(hWndDlg,
                 WM_COMMAND,
                 MPFROMSHORT(DLG_TEST_CANCEL),
                 0L);

      break;                           /* End of WM_CLOSE                 */

    default  :
      return (WinDefDlgProc(hWndDlg,
                            message,
                            mp1,
                            mp2));
//BSC      break;
  }
  return  FALSE;
}                                      /* End of TestCasesDlgProc         */

/***************************************************************************
 *
 * FUNCTION NAME =   ConfigDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle Options-Configuration menu option.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY ConfigDlgProc(HWND   hWndDlg,
                               USHORT message,
                               MPARAM mp1,
                               MPARAM mp2)
{
  SHORT i;
  SHORT usSelect;
  HWND hwndButton;
  CHAR achInsert[500];
  CHAR achManySpaces[80];
  CHAR aszNone[5];
  static LONG lTempDCType;
  static ULONG ulTempPSType,ulTempPSUnits;
  static CHAR aszTempDataType[10];
  static HWND hwndList,hwndQPList;


  switch (message)
  {
    case  WM_INITDLG :
      hwndList = WinWindowFromID(hWndDlg,
                                 DLG_CFG1DEVLIST);
      hwndQPList = WinWindowFromID(hWndDlg,
                                   DLG_CFG1QPLIST);
      WinSendMsg(hWndDlg,
                 WM_SET_DEFAULTS,
                 NULL,
                 NULL);
      break;                           /* End of WM_INITDLG               */

    case  WM_FILL_DREVER_LISTBOX :

      WinEnableWindowUpdate(hwndList,
                            FALSE);

      /*
      ** Fill the list box with all printers defined in the Printer
      ** Names data structure.  They are entered into the list in
      ** the same order they appear in the array so when we
      ** query the list box, the list number alone identifies the
      ** user's choice.
      ** Delete old stuff first ,if any.
      */

      WinSendMsg(hwndList,
                 LM_DELETEALL,
                 NULL,
                 NULL);
      WinSendMsg(hwndQPList,
                 LM_DELETEALL,
                 NULL,
                 NULL);
      memset(achManySpaces,
             (INT)' ',
             sizeof(achManySpaces));
      memset(achInsert,
             (INT)' ',
             sizeof(achInsert));
      strcpy(aszNone,
             "NONE");

      for (i = 0; i < NPrinters; i++)
      {
        strcpy(achInsert,
               apPrinters[i]->aszQueueName);
        strncat(achInsert,
                achManySpaces,
                20-strlen(achInsert)+1);
        strcat(achInsert,
               apPrinters[i]->aszPrinterName);
        strncat(achInsert,
                achManySpaces,
                45-strlen(achInsert)+1);

        if (apPrinters[i]->aszPortName[0] == (CHAR)NULL)
        {
          strcat(achInsert,
                 aszNone);
        }

        else
        {
          strcat(achInsert,
                 apPrinters[i]->aszPortName);
        }
        strncat(achInsert,
                achManySpaces,
                70-strlen(achInsert)+1);
        strcat(achInsert,
               apPrinters[i]->aszDDName);

        if (strlen(apPrinters[i]->aszDeviceName) != 0)
        {
          strcat(achInsert,
                 ".");
          strcat(achInsert,
                 apPrinters[i]->aszDeviceName);
        }
        WinSendMsg(hwndList,
                   LM_INSERTITEM,
                   MPFROMSHORT(LIT_END),
                   MPFROMP(achInsert));

        /*
        ** Mark the current printer as selected in the list box only
        ** if there is a perfect match for all strings in apPrinter.
        */

        if (!strcmp(apPrinters[i]->aszQueueName,
                    apCurrent[QUEUE]) && !strcmp(apPrinters[i]->aszPortName,
                                                 apCurrent[PORT]) && !strcmp
                                                    (apPrinters[i]->aszDDName,
                                                     apCurrent[DEVICEDRIVER])
                                                     && !strcmp(apPrinters[i]
                                                     ->aszDeviceName,
                                                                apCurrent
                                                                [DEVICE]))
          WinSendMsg(hwndList,
                     LM_SELECTITEM,
                     MPFROMSHORT(i),
                     MPFROMSHORT(TRUE));
      }

      /*
      ** Fill the queue processor list box with all possible entries.
      ** Entries are made in the same order they are in the array so when
      ** we query the list box, the list number alone identifies the
      ** user's choice.
      */

      for (i = 0; i < NQProcessors; i++)
      {
        WinSendMsg(hwndQPList,
                   LM_INSERTITEM,
                   MPFROMSHORT(LIT_END),
                   MPFROMP(apQProcNames[i]));

        /*
        ** Mark the current queue processor as selected in the list box
        */

        if (!strcmp(apQProcNames[i],
                    apCurrent[QPROCESSOR]))
          WinSendMsg(hwndQPList,
                     LM_SELECTITEM,
                     MPFROMSHORT(i),
                     MPFROMSHORT(TRUE));
      }
      WinEnableWindowUpdate(hwndList,
                            TRUE);
      break;

    case  WM_SET_DEFAULTS :

      WinSendMsg(hWndDlg,
                 WM_FILL_DREVER_LISTBOX,
                 NULL,
                 NULL);

         /*
         ** From our global variable we know which is the currently selected
         ** device context type.  Use that value to determine the window
         ** handle its corresponding radio button and send it a message
         ** so it will be turned on.
         */

      switch ((int)lCurrentDCType)
      {
        case  OD_QUEUED :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODQUEUED);
          break;

        case  OD_DIRECT :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODDIRECT);
          break;

        case  OD_INFO :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODINFO);
          break;

        case  OD_METAFILE :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODMETAFILE);
          break;

        case  OD_METAFILE_NOQUERY :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODMETAFILENQ);
          break;

        case  OD_MEMORY :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ODMEMORY);
          break;

      }
      WinSendMsg(hwndButton,
                 BM_CLICK,
                 MPFROMSHORT(TRUE)     /* turn on default choice          */
                    ,
                 0L);                  /* button                          */

         /*
         ** From our global variables, we know what the currently selected
         ** data type is.  Use that value to determine the window handle
         ** of it corresponding radio button and send it a message to
         ** turn it on.
         */

      if (!strcmp(szCurrentDataType,
                  "PM_Q_RAW"))
      {
        hwndButton = WinWindowFromID(hWndDlg,
                                     DLG_CFG1PMQRAW);
      }

      else
      {
        hwndButton = WinWindowFromID(hWndDlg,
                                     DLG_CFG1PMQSTD);
      }
      WinSendMsg(hwndButton,
                 BM_CLICK,
                 MPFROMSHORT(TRUE)     /* turn on default choice           */
                    ,
                 0L);                  /* button                           */

         /*
         ** From our global variable we know which is the currently selected
         ** Presentation space type.  Use that value to determine the window
         ** handle its corresponding radio button and send it a message
         ** so it will be turned on.
         */

      switch ((int)ulCurrentPSType)
      {
        case  GPIT_MICRO :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1MICRO);
          break;
        case  GPIT_NORMAL :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1NORMAL);
          break;
      }
      WinSendMsg(hwndButton,
                 BM_CLICK,
                 MPFROMSHORT(TRUE)     /* turn on default choice           */
                    ,
                 0L);                  /* button                           */

         /*
         ** From our global variable we know which is the currently selected
         ** Presentation space units.  Use that value to determine the window
         ** handle its corresponding radio button and send it a message
         ** so it will be turned on.
         */

      switch ((int)ulCurrentPSUnits)
      {
        case  PU_ARBITRARY :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1ARBITRARY);
          break;

        case  PU_PELS :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1PELS);
          break;

        case  PU_LOMETRIC :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1LOMETRIC);
          break;

        case  PU_HIMETRIC :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1HIMETRIC);
          break;

        case  PU_LOENGLISH :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1LOENGLISH);
          break;

        case  PU_HIENGLISH :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1HIENGLISH);
          break;

        case  PU_TWIPS :

          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_CFG1TWIPS);
          break;
      }

      WinSendMsg(hwndButton,
                 BM_CLICK,
                 MPFROMSHORT(TRUE)     /* turn on default choice           */
                    ,
                 0L);                  /* button                           */
      break;                           /* End of WM_SET_DEFAULTS           */

    case  WM_CONTROL :

      if (SHORT2FROMMP(mp1) == BN_CLICKED)
      {
          /*
          ** track the currently selected button
          */

        switch (SHORT1FROMMP(mp1))
        {
                /*
                ** Check for device context type buttons
                */

          case  DLG_CFG1ODQUEUED :

            lTempDCType = OD_QUEUED;
            break;

          case  DLG_CFG1ODDIRECT :

            lTempDCType = OD_DIRECT;
            break;

          case  DLG_CFG1ODINFO :

            lTempDCType = OD_INFO;
            break;

          case  DLG_CFG1ODMETAFILE :

            lTempDCType = OD_METAFILE;
            break;

          case  DLG_CFG1ODMETAFILENQ :

            lTempDCType = OD_METAFILE_NOQUERY;
            break;

          case  DLG_CFG1ODMEMORY :

            lTempDCType = OD_MEMORY;
            break;

                /*
                ** Check for data type buttons
                */

          case  DLG_CFG1PMQRAW :

            strcpy(aszTempDataType,
                   "PM_Q_RAW");
            break;

          case  DLG_CFG1PMQSTD :

            strcpy(aszTempDataType,
                   "PM_Q_STD");
            break;

                /*
                ** Check for presentation type buttons
                */

          case  DLG_CFG1MICRO :

            ulTempPSType = GPIT_MICRO;
            break;

          case  DLG_CFG1NORMAL :

            ulTempPSType = GPIT_NORMAL;
            break;

                /*
                ** Check for presentation unit buttons
                */

          case  DLG_CFG1ARBITRARY :

            ulTempPSUnits = PU_ARBITRARY;
            break;

          case  DLG_CFG1PELS :
            ulTempPSUnits = PU_PELS;
            break;

          case  DLG_CFG1LOMETRIC :

            ulTempPSUnits = PU_LOMETRIC;
            break;

          case  DLG_CFG1HIMETRIC :

            ulTempPSUnits = PU_HIMETRIC;
            break;

          case  DLG_CFG1LOENGLISH :

            ulTempPSUnits = PU_LOENGLISH;
            break;

          case  DLG_CFG1HIENGLISH :

            ulTempPSUnits = PU_HIENGLISH;
            break;

          case  DLG_CFG1TWIPS :

            ulTempPSUnits = PU_TWIPS;
            break;

        }
      }

      switch (SHORT1FROMMP(mp1))
      {
        case  DLG_CFG1DEVLIST :        /* List box                       */
          {
          }
          break;
        case  DLG_CFG1QPLIST :         /* List box                       */
          {
          }
          break;
      }
      break;                           /* End of WM_CONTROL              */
    case  WM_COMMAND :

      switch (SHORT1FROMMP(mp1))
      {
        case  DLG_REFRESH :

          if (InitPrinters() == 0)
          {
               /*
               ** Stick ErroCode here
               */
          }

          WinPostMsg(hWndDlg,
                     WM_FILL_DREVER_LISTBOX,
                     NULL,
                     NULL);
          break;

        case  DID_OK :

             /*
             ** Find out which printer the user selected
             */

          usSelect = (SHORT)SHORT1FROMMR(WinSendMsg(hwndList,
                                                    LM_QUERYSELECTION,
                                                    NULL,
                                                    NULL));

          if (usSelect != LIT_NONE)
          {

           /*
           ** First check to see if all the current print dirver's
           ** components are valid.
           */

            PPMDEFPRINTER Queue = *(apPrinters+usSelect); /* Shorter name  */
            SHORT ErrorID = 0;


            if (strlen(Queue->aszQueueName) == (USHORT)NULL || strchr
               (Queue->aszQueueName,
                ',') != (PCHAR)NULL)
              ErrorID = IDS_ERR_NO_PRINTER_QUEUE;
              // No need to check for port
              else

                if (strlen(Queue->aszDDName) == (USHORT)NULL || strchr
                   (Queue->aszDDName,
                    ',') != (PCHAR)NULL || strlen(Queue->aszPrinterName) ==
                    (USHORT)NULL || strchr(Queue->aszPrinterName,
                                           ',') != (PCHAR)NULL || strchr
                                           (Queue->aszDeviceName,
                                            ',') != (PCHAR)NULL)

                  ErrorID = IDS_ERR_MULTIPLE_DEVICES;

            if (ErrorID)
            {
              PostErrorMessage(hWndDlg,
                               ErrorID);
              break;
            }
            WinSendMsg(hWndClient,
                       WM_CHOOSE_QUEUE,
                       MPFROMP(apPrinters[usSelect]->aszQueueName),
                       NULL);
            WinSendMsg(hWndClient,
                       WM_CHOOSE_PORT,
                       MPFROMP(apPrinters[usSelect]->aszPortName),
                       NULL);
            WinSendMsg(hWndClient,
                       WM_CHOOSE_DDRIVER,
                       MPFROMP(apPrinters[usSelect]->aszDDName),
                       MPFROMP(apPrinters[usSelect]->aszDeviceName));
            WinSendMsg(hWndClient,
                       WM_CHOOSE_PRINTERNAME,
                       MPFROMP(apPrinters[usSelect]->aszPrinterName),
                       NULL);
          }

             /*
             ** Find out which queue processor the user selected
             */

          usSelect = (SHORT)SHORT1FROMMR(WinSendMsg(hwndQPList,
                                                    LM_QUERYSELECTION,
                                                    NULL,
                                                    NULL));
          WinSendMsg(hWndClient,
                     WM_CHOOSE_QPROCESS,
                     MPFROMP(apQProcNames[usSelect]),
                     NULL);

             /*
             ** Send messages to client window to set new device context
             ** type and data type.
             */

          WinSendMsg(hWndClient,
                     WM_CHOOSE_DCTYPE,
                     MPFROMLONG(lTempDCType),
                     NULL);
          WinSendMsg(hWndClient,
                     WM_CHOOSE_DATATYPE,
                     MPFROMP(aszTempDataType),
                     NULL);
          WinSendMsg(hWndClient,
                     WM_CHOOSE_PSTYPE,
                     MPFROMLONG(ulTempPSType),
                     NULL);
          WinSendMsg(hWndClient,
                     WM_CHOOSE_PSUNITS,
                     MPFROMLONG(ulTempPSUnits),
                     NULL);
          WinInvalidateRect(hWndClient,
                            NULL,
                            FALSE);
          WinDismissDlg(hWndDlg,
                        TRUE);
          break;
        case  DID_CANCEL :

                 /*
                 ** Ignore data values entered into the dialog controls
                 ** and dismiss the dialog window
                 */

          WinDismissDlg(hWndDlg,
                        FALSE);
          break;
      }

      break;                           /* End of WM_COMMAND               */

    case  WM_CLOSE :
      WinPostMsg(hWndDlg,
                 WM_COMMAND,
                 MPFROMSHORT(DID_CANCEL),
                 0L);
      break;                           /* End of WM_CLOSE                 */

    default  :
      return (WinDefDlgProc(hWndDlg,
                            message,
                            mp1,
                            mp2));
//BSC      break;
  }
  return  FALSE;
}                                      /* End of ConfigDlgProc              */

/***************************************************************************
 *
 * FUNCTION NAME =   LoggingDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle Options-Log Window menu option.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY LoggingDlgProc(HWND   hwnd,
                                USHORT message,
                                MPARAM param1,
                                MPARAM param2)
{

  switch (message)
  {
    case  WM_INITDLG :

          /*
          ** Initialize the dialog box controls.
          */

      return (MRESULT)TRUE;
//BSC      break;

    case  WM_CLOSE :

      WinSendMsg(hWndClient,
                 WM_COMMAND,
                 MPFROMSHORT(IDM_OPTIONS_DISPLAYLOG),
                 NULL);
      break;

    case  WM_COMMAND :

          /*
          ** Button has been pressed by the user.
          */

      switch (SHORT1FROMMP(param1))
      {
        case  DID_CANCEL :
          WinPostMsg(hwnd,
                     WM_CLOSE,
                     NULL,
                     NULL);
          break;

        default  :

                /*
                ** Other WM_COMMAND messages - pass to DefDlgProc
                */

          return ((MRESULT)WinDefDlgProc(hwnd,
                                         message,
                                         param1,
                                         param2));
//BSC          break;
      }
      break;
    case  WM_CONTROL :

          /*
          ** Handle list box notification messages from dialog box
          */

      return ((MRESULT)WinDefDlgProc(hwnd,
                                     message,
                                     param1,
                                     param2));
//BSC      break;
    default  :

          /*
          ** Other messages - pass to DefDlgProc
          */

      return ((MRESULT)WinDefDlgProc(hwnd,
                                     message,
                                     param1,
                                     param2));
//BSC      break;
  }
  return (0);
}

/***************************************************************************
 *
 * FUNCTION NAME =   LogToDlgBox
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Write a string to the Log Window.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = PSZ  string
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID LogToDlgBox(PSZ string)
{
  USHORT nitems;
  CHAR szlogstring[200];
  CHAR *temp;
  HWND ListhWnd;

    /*
    ** Display message in logging listbox
    */

  ListhWnd = WinWindowFromID(hwndLogDlg,
                             DLG_LOGLISTBOX);

    /*
    ** copy logging string into local data
    */

  strcpy(szlogstring,
         string);

    /*
    ** remove new line char from string
    */

  temp = strstr(szlogstring,
                "\n");

  if (temp != NULL)
  {
    *temp = (CHAR)NULL;
  }
  WinSendMsg(ListhWnd,
             LM_INSERTITEM,
             MPFROMSHORT(LIT_END),
             MPFROMP(szlogstring));
  nitems = SHORT1FROMMR(WinSendMsg(ListhWnd,
                                   LM_QUERYITEMCOUNT,
                                   NULL,
                                   NULL));

  if (nitems > 100)
    WinSendMsg(ListhWnd,
               LM_SELECTITEM,
               NULL,
               NULL);
  WinSendMsg(ListhWnd,
             LM_SETTOPINDEX,
             MPFROMSHORT((((INT)nitems < 14)?0:(INT)nitems-12)),
             NULL);
  return ;
}                                      /* end LogToDlgBox                  */

/***************************************************************************
 *
 * FUNCTION NAME =   CmdLineDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Display valid command line options.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY CmdLineDlgProc(HWND   hWndDlg,
                                USHORT message,
                                MPARAM mp1,
                                MPARAM mp2)
{

  switch (message)
  {
    case  WM_COMMAND :

      switch (SHORT1FROMMP(mp1))
      {
        case  MBID_OK :
          WinDismissDlg(hWndDlg,
                        FALSE);
          break;
        default  :
          return (FALSE);
      }
    default  :
      return (WinDefDlgProc(hWndDlg,
                            message,
                            mp1,
                            mp2));
  }
  return (FALSE);
}                                      /* end CmdLineDlgProc               */

/***************************************************************************
 *
 * FUNCTION NAME =   AboutDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Display About Box.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY AboutDlgProc(HWND   hWndDlg,
                              USHORT message,
                              MPARAM mp1,
                              MPARAM mp2)
{

  switch (message)
  {
    case  WM_INITDLG :
      break;
    case  WM_COMMAND :

      switch (SHORT1FROMMP(mp1))
      {
        case  MBID_OK :
          WinDismissDlg(hWndDlg,
                        FALSE);
          break;
        default  :
          return (FALSE);
      }
    default  :
      return (WinDefDlgProc(hWndDlg,
                            message,
                            mp1,
                            mp2));
  }
  return (FALSE);
}                                      /* end AboutDlgProc                 */

/***************************************************************************
 *
 * FUNCTION NAME =   LogLevelDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle Options-ChangeLogLevel menu option.
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = HWND   hWndDlg
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY LogLevelDlgProc(HWND   hWndDlg,
                                 USHORT message,
                                 MPARAM mp1,
                                 MPARAM mp2)
{
  static SHORT temp;
  static HWND hwndButton;


  switch (message)
  {
    case  WM_INITDLG :

        /*
        ** Find the current log level and set the radio button.
        */

      switch (pttloglevel)
      {
        case  L_HDR :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_HDR);
          break;
        case  L_ABORT :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_ABORT);
          break;
        case  L_FAIL :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_FAIL);
          break;
        case  L_WARN :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_WARN);
          break;
        case  L_TRACE :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_TRACE);
          break;
        case  L_LOTRACE :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_LOTRACE);
          break;
        case  L_DEBUG :
          hwndButton = WinWindowFromID(hWndDlg,
                                       DLG_LOG_DEBUG);
          break;
      }

        /*
        ** turn on default choice
        */

      WinSendMsg(hwndButton,
                 BM_CLICK,
                 MPFROMSHORT(TRUE),
                 0L);
      break;                           /* End of WM_INITDLG               */
    case  WM_CONTROL :

      if (SHORT2FROMMP(mp1) == BN_CLICKED)
      {
           /*
           ** track the currently selected button
           */

        switch (SHORT1FROMMP(mp1))
        {
                /*
                ** Check for log level
                */

          case  DLG_LOG_HDR :
            temp = L_HDR;
            break;
          case  DLG_LOG_ABORT :
            temp = L_ABORT;
            break;
          case  DLG_LOG_FAIL :
            temp = L_FAIL;
            break;
          case  DLG_LOG_WARN :
            temp = L_WARN;
            break;
          case  DLG_LOG_TRACE :
            temp = L_TRACE;
            break;
          case  DLG_LOG_LOTRACE :
            temp = L_LOTRACE;
            break;
          case  DLG_LOG_DEBUG :
            temp = L_DEBUG;
            break;
        }
      }
      break;                           /* End of WM_CONTROL               */

    case  WM_COMMAND :

      switch (SHORT1FROMMP(mp1))
      {
        case  DID_OK :

               /*
               ** Send message to client window to set new logging level.
               */

          WinSendMsg(hWndClient,
                     WM_CHOOSE_LOGLEVEL,
                     MPFROMSHORT(temp),
                     NULL);
          WinInvalidateRect(hWndClient,
                            NULL,
                            FALSE);
          WinDismissDlg(hWndDlg,
                        TRUE);
          break;
        case  DID_CANCEL :

               /*
               ** Ignore data values entered into the dialog controls
               ** and dismiss the dialog window
               */

          WinDismissDlg(hWndDlg,
                        FALSE);
          break;
      }
      break;                           /* End of WM_COMMAND               */

    case  WM_CLOSE :
      WinPostMsg(hWndDlg,
                 WM_COMMAND,
                 MPFROMSHORT(DID_CANCEL),
                 0L);
      break;                           /* End of WM_CLOSE                 */

    default  :
      return (WinDefDlgProc(hWndDlg,
                            message,
                            mp1,
                            mp2));
//BSC      break;
  }

  if (message == WM_INITDLG)
  {

       /*
       ** turn on default choice
       */

    WinSendMsg(hwndButton,
               BM_CLICK,
               MPFROMSHORT(TRUE),
               0L);
  }
  return  FALSE;
}                                      /* end LogLevelDlgProc             */


/***************************************************************************
 *
 * FUNCTION NAME =   PerformPatternMatching
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:
 *
 *
 *   Function Calls:  NONE
 *
 *
 *
 * INPUT = USHORT SelectAction
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID PerformPatternMatching(USHORT SelectAction)
{
  PTEST_CASE_COMPONENT pTestCase;
  PENTRYPOINT pTestEntries;
  CHAR szTempPattern[10],*pTemp;
  HWND hWndTestList,hWndEntryList,hWndPattern;

  USHORT usSelect,usIndex;
  ULONG SelectedIndex = LIT_FIRST,NextSelectedIndex = 0L;

  hWndTestList = WinWindowFromID(hwndTestCasesDlg,
                                 DLG_GROUPLB);
  hWndEntryList = WinWindowFromID(hwndTestCasesDlg,
                                  DLG_TESTSLB);
  hWndPattern = WinWindowFromID(hwndTestCasesDlg,
                                DLG_CHOOSE_PATTERN);
  WinQueryWindowText(hWndPattern,
                     sizeof(szTempPattern),
                     szTempPattern);
  WinEnableWindowUpdate(hWndEntryList,
                        FALSE);


  while(NextSelectedIndex != LIT_NONE)
  {
    NextSelectedIndex =     (ULONG) (WinSendMsg(hWndTestList,
                                                LM_QUERYSELECTION,
                                                MPFROMLONG(SelectedIndex),
                                                MPFROMP(NULL)));


    if (NextSelectedIndex != LIT_NONE)
    {
      pTestCase = (PTEST_CASE_COMPONENT)WinSendMsg(hWndTestList,
                                                   LM_QUERYITEMHANDLE,
                                                   MPFROMLONG
                                                      (NextSelectedIndex),
                                                   NULL);
      pTestEntries = (PENTRYPOINT)pTestCase->pEntryPoint;
      usSelect = SHORT1FROMMR(WinSendMsg(hWndEntryList,
                                         LM_SEARCHSTRING,
                                         MPFROM2SHORT(LSS_CASESENSITIVE,
                                                      LIT_FIRST),
                                         MPFROMP((pTestEntries->szTestName))));

      for (usIndex = 0; usIndex < pTestCase->ntests; usIndex++,
           usSelect++)
      {

        if (stricmp(szTempPattern,
                    "ALL") == (SHORT)NULL)
          WinSendMsg(hWndEntryList,
                     LM_SELECTITEM,
                     MPFROMSHORT(usSelect),
                     MPFROMSHORT(SelectAction));

        else
        {
          pTemp = ((pTestEntries+usIndex)->szTestName)+strlen((pTestEntries+
             usIndex)->szTestName)-strlen(szTempPattern);

          if (isdigit((INT)*(pTemp+strlen(pTemp)-1)))
            pTemp--;

          if (strnicmp(pTemp,
                       szTempPattern,
                       strlen(szTempPattern)) == (SHORT)NULL)
            WinSendMsg(hWndEntryList,
                       LM_SELECTITEM,
                       MPFROMSHORT(usSelect),
                       MPFROMSHORT(SelectAction));

        }
      }
    }
  SelectedIndex = NextSelectedIndex;
 }
  WinEnableWindowUpdate(hWndEntryList,
                        TRUE);

  return ;
}


//**************************************************************************
//
//  FUNCTION: UserMessage()                         CHANGE VERSION: PTT 32.A
//   PURPOSE: Functions as a Macro to Simplify Error Message Display
//            throughout PTT.  Uses WinAlarm() to Audibly warn the User
//            of PTT Internal Problems.  UserMessage() can display three
//            types of messages; Error, Warning, or Question. Note that
//            the Return Value=WinMessageBox's Return Value.
//
//    CALLER:
//     CALLS: WinLoadMessage()
//            WinMessageBox()
//            WinAlarm()
//
//   RETURNS: Returns FALSE = -1 if Unable to Load Message
//            in Message Queue.
//
//**************************************************************************
ULONG APIENTRY UserMessage(HWND hWnd , ULONG MessageID, ULONG MessageType, PCHAR szMessage)
{
   CHAR  szMessageStorage[MAXNAMEL*5];
   CHAR  szTitleBarString[] = "PTT Problem Dialog              "; // Don't get rid of the spaces
   ULONG flEchoStyle        =  WA_ERROR;
   ULONG flDlgStyle         =  MB_OK | MB_APPLMODAL |
                               MB_MOVEABLE | MB_SYSTEMMODAL;

   if ((szMessage != (PCHAR)NULL) && (MessageID == (ULONG)NULLHANDLE))
                      strcpy(szMessageStorage, szMessage);

   if (MessageID != NULLHANDLE){ // If MessageID is not NULL, then
      if (!WinLoadMessage(hAB,   // Load the Message
                          (HMODULE)NULL,
                          MessageID,
                          sizeof(szMessageStorage),
                          (PSZ)szMessageStorage))
      { // Unable to Load the Message
         WinAlarm(HWND_DESKTOP, WA_ERROR);  // On Error, Sound Alarm and Return FALSE
         return(FALSE);
      } // END if
   } // END if

   if (MessageType == MB_WARNING){ // The Default Message Display is an ERROR Msg.
       strcpy (szTitleBarString, "PTT User Warning Dialog");
       flDlgStyle       = flDlgStyle | MB_ICONEXCLAMATION;
       flEchoStyle      = WA_NOTE;
   } else { // This Tests to see if the User wants a QUESTION Message
       if (MessageType == MB_ICONQUESTION) {
           strcpy(szTitleBarString, "Are You Sure???");
           flDlgStyle       = MessageType | MB_YESNO | MB_APPLMODAL |
                              MB_MOVEABLE | MB_SYSTEMMODAL;
           flEchoStyle      = WA_NOTE;
       } else
           flDlgStyle = flDlgStyle | MB_ERROR;
   } //END else

   // Sound the Alarm, Display the Message, and Return Result.
   WinAlarm(HWND_DESKTOP, flEchoStyle);
   return(WinMessageBox(HWND_DESKTOP,
                        hWnd,
                        szMessageStorage,
                        szTitleBarString,
                        0,
                        flDlgStyle));
} // END UserMessage()



