PROJ = ptt
CC = icc

#  /W3           - Warns of all non-ANSI usage
#  /G3           - Generate 80486 code
#  /DLINT_ARGS   - Check functional arguments against prototypes
#  /Sp           - Packs Structure
#  /Ti+          - Generates all debugger information
#  /Sm           - Allow all C Set/2 extensions including those for migration
#  /O+           - Optimize object code
#  /Gs+          - Stack checking
#  /Ge           - Build .EXE file
#  /Ss           - Allow for the // comments

CFLAGS  = /Ti+ /O- /Oi- /Os- /Oc- /W3 /G3 /DLINT_ARGS /Sp /Sm /Gm+ /Gd+ /Gs+ /Ss

#
#  The following is to use the new libraries for Visual Age C/C++
#
LLIBS    = CPPOM30.LIB + OS2386.LIB

LFLAGS   =  /DE /CODEVIEW /STACK:64000 /NOD /ALIGN:16 /PACKC /PACKD /M /BASE:0x10000 /PM:PM

ICLCPPOPTS=/GM+ /GD+ /DIC_TRACE_ALL /DIC_DEVELOP /B" /PM:PM"

EXECFLAGS= $(ICLCPPOPTS)
EXELFLAGS=/B" /PM:PM"

MAPFILE  = ptt.map
# LINKER   = link386
# old linker... the new linker is ilink
LINKER   = ilink
LRF      = echo > NUL
RC       = rc
DEF_FILE = PTT.DEF

OBJS  = PTT.obj      PTTCOMM.obj  \
        PTTDLGS.obj  PTTLOG.obj   \
        PTTINIT.obj  PTTPRINT.obj 
RESS  = PTT.res

compile = $(CC) /c $(CFLAGS)

all: $(PROJ).exe

.SUFFIXES:
.SUFFIXES: .sbr .obj .res .c .rc

PTT.obj : PTT.C PTT.h PTTmain.h PTTlog.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ ptt.c

PTTCOMM.obj : PTTCOMM.C PTT.h PTTcomm.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ pttcomm.c

PTTDLGS.obj : PTTDLGS.C PTT.h PTTlog.h PTTdlgs.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ pttdlgs.c

PTTLOG.obj : PTTLOG.C PTT.h PTTlog.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ pttlog.c

PTTINIT.obj : PTTINIT.C PTT.h PTTlog.h PTTinit.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ pttinit.c

PTTPRINT.obj : PTTPRINT.C PTT.h PTTprint.h pttdlg.h PTT_DLL.h
   $(compile) /Fo$@ pttprint.c


ptt.EXE: $(OBJS) ptt.RES
      $(LINKER) /nofree $(LFLAGS) \
          $(OBJS),ptt.exe,ptt.map,$(LLIBS),ptt.def
  $(RC) ptt.RES ptt.EXE

#    $(RC) $(RESS)

PTT.RES: PTT.RC ptt.DLG  
  $(RC) -r ptt.RC ptt.RES 
