/**************************************************************************
 *
 * SOURCE FILE NAME = PTT.H
 *
 * DESCRIPTIVE NAME =  This header file contains all the global constants,
 *                     variables, and typedefs.  It is included by all the
 *                     modules in PTT.
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * NOTES
 *
 * EXTERN should only be define as blank by PTT.c.  That makes all those
 * variables global variables in that module.  The rest of the modules
 * will have those variables defined as "extern" and, as a result, will
 * have access to them.
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *
 *
 ****************************************************************************/

#if      defined(EXTERN)

#else
  #define  EXTERN        extern
#endif
#define  INCL_PM
#define  INCL_DOSPROCESS
#define  INCL_DOSINFOSEG
#define  INCL_DOSFILEMGR
#define  INCL_DOSMEMMGR
#define  INCL_DOSDATETIME
#define  INCL_DOSMODULEMGR
#define  INCL_DOSSEMAPHORES
#define  NOLOG
#include <stdio.h>                  /* these are multithreaded c libraries  */
#include <stdlib.h>
#include <string.h>
#include <stddef.h>
#include <process.h>
#include <os2.h>

/*
** #include "test2.h"         ** testlog header file
*/

/*
** Constants
*/

/*
** These constants define the WM_COMMANDs that are sent to the main
** window when a user selects a pull down menu.
*/

#define  ID_PTT        1
#define  IDM_TESTCASES 1000
#define  IDM_ACTIONS   3000
#define  IDM_ACTIONS_DISPLAY 3050
#define  IDM_ACTIONS_PRINT 3051
#define  IDM_OPTIONS   4000
#define  IDM_OPTIONS_CONFIGURATION 4050
#define  IDM_OPTIONS_DISPLAYLOG 4051
#define  IDM_OPTIONS_LOGLEVEL 4052
#define  IDM_HELP      7000
#define  IDM_HELP_TEMP 7050
#define  IDM_HELP_ABOUT 7060
#define  IDM_EXIT      WM_CLOSE

/*
** Dialog box defines
*/

#include "pttdlg.h"
#define  IDS_ERR_WINDOW_CREATE 1
#define  IDS_ERR_WINDOW_POS 2
#define  IDS_ERR_READINI 3
#define  IDS_ERR_MEMORY 4
#define  IDS_ERR_OPENFILE 5
#define  IDS_ERR_NO_DLLS 6
#define  IDS_ERR_EXITLIST 7
#define  IDS_ERR_NO_PRINTER_PORT 8
#define  IDS_ERR_NO_PRINTER_QUEUE 9
#define  IDS_ERR_MULTIPLE_DEVICES 10
#define  IDS_ERR_ENTRYPOINT 11



/*
** User defined messages.
*/

/*
** These messages are for communication between different parts of the
** test processor and the client window.  Although I don't expect this
** test tool to ever get that big, don't use messages WM_USER + 200 or
** above.  These are used for communication between test cases and the
** main window of the test processor.
*/

#define  WM_CHOOSE_QUEUE WM_USER
#define  WM_CHOOSE_PORT WM_CHOOSE_QUEUE + 1
#define  WM_CHOOSE_DDRIVER WM_CHOOSE_PORT + 1
#define  WM_CHOOSE_QPROCESS WM_CHOOSE_DDRIVER + 1
#define  WM_CHOOSE_DCTYPE WM_CHOOSE_QPROCESS + 1
#define  WM_CHOOSE_DATATYPE WM_CHOOSE_DCTYPE + 1
#define  WM_CHOOSE_PSTYPE WM_CHOOSE_DATATYPE + 1
#define  WM_CHOOSE_PSUNITS WM_CHOOSE_PSTYPE + 1
#define  WM_CHOOSE_TESTCASE WM_CHOOSE_PSUNITS + 1
#define  WM_CHOOSE_PRINTERNAME WM_CHOOSE_TESTCASE + 1
#define  WM_CHOOSE_LOGLEVEL WM_CHOOSE_PRINTERNAME + 1
#define  WM_SET_DEFAULTS WM_CHOOSE_LOGLEVEL+1
#define  WM_INITIALIZE_TESTCASES WM_SET_DEFAULTS +1
#define  WM_DISABLE_DISPLAY_OPTION WM_INITIALIZE_TESTCASES+1
#define  WM_PROMPT_MESSAGE WM_DISABLE_DISPLAY_OPTION+1
#define  WM_FILL_DREVER_LISTBOX WM_PROMPT_MESSAGE+1
#define  WM_ENABLE_DISABLE_MENUES WM_PROMPT_MESSAGE+100

/*
** Include the common include file between PTT and the test cases.
** User defined messages for communication between test cases and PTT,
** as well as type and constant defines are found in "PTT_DLL.H".
*/

#include "PTT_DLL.h"

/*
** Messages for PrintThread.  These messages should only be used by the
** test processor client window for communicating with the print thread.
*/

#define  WM_TEST_PRINT WM_USER+1000
#define  WM_TEST_DISPLAY WM_TEST_PRINT + 1
#define  WM_CANCEL_PRINT_THREAD WM_TEST_DISPLAY + 1
#define  WM_START_MULTIPLE WM_CANCEL_PRINT_THREAD+1

/*
** Typedefs
*/

#define  NAMESIZE      50           /* Size of names pulled out of OS2.INI  */
typedef struct pm_def_printer_structure
{
  CHAR aszPrinterName[NAMESIZE]; /* Name that is defined in Print Manager   */
  CHAR aszQueueName[NAMESIZE];   /* Queue Name (ie, LPT1Q)                  */
  CHAR aszDDName[200];           /* Device Driver Name (ie, IBM4201)        */
  CHAR aszDeviceName[200];       /* Used if device driver support more      */
                                 /*than one device. (i.e., PLOTTER, PSCRIPT)*/
  CHAR aszPortName[NAMESIZE];    /* Port Name (ie, LPT1,LPT2,LPT3)          */
} PMDEFPRINTER,*PPMDEFPRINTER;

/*
** This structure keeps track of a group of testcases within a DLL.
*/

typedef struct _TESTCASEDLL
{
  USHORT ntests;                       // number of tests in a group
  PCHAR pszGroupName;                  // name of the group
  USHORT usIndex;                // index into the apTestNames/Addrs array
                                 //   where the tests for this group starts
} TESTCASEDLL,*PTESTCASEDLL;

/*
** Global function prototypes.
*/

/*
** this function is used to check and uncheck a menu item
*/

USHORT cwCheckPulldown(HWND,USHORT);
INT InitTestCases(HWND hWnd,INT argc,CHAR **argv);

/*
*  Global varible declarations or EXTERN statements depending on how
*  "EXTERN" is #defined.  In PTT.c, EXTERN is #defined as blank.  As a
*  result, all these variables are defined in PTT.c.  The rest of the
*  programs have EXTERN #defined as "EXTERN."  As a result, they have
*  access to the variables as global EXTERN variables.
*/

/*
** General global variables.
*/

EXTERN HAB hAB;                    /* Handle to the Anchor Block           */
EXTERN HMQ hMQ;                    /* Handle to the Message Queue          */
EXTERN HWND hWndFrame;             /* Handle to the Window Frame           */
EXTERN HWND hWndClient;            /* Handle to the Client Window          */
EXTERN HWND hwndLogDlg;            /* Handle to the Logging Dialog Window  */
EXTERN HWND hwndTestCasesDlg;      /* Handle to the TestCase Dialog Window */
EXTERN HDC hDC;                    /* Handle to the window Device Context  */
EXTERN HWND hWndPromptDlg;         /* Handle to the Prompt Dialog Window   */

EXTERN HEV hevPTTSem;
EXTERN ULONG ulPostCount;

/*
** apPrinterNames is an array of records containing printer information
** defined by the printer manager.
**
** apQueueNames, apPortNames, apQProcessors, apDDNames, and apDeviceNames
** are used when the user decides to configure the printer ports
** independently of the print managers configuration.  These variables
** will contain all the existing queues, port names, and device drivers
** defined in the OS2.INI file.
**
*/

#define  LISTSIZE      40              // Size of out list arrays
EXTERN SHORT NPrinters;
EXTERN PPMDEFPRINTER apPrinters[LISTSIZE];
EXTERN SHORT NQueues;
EXTERN PCHAR apQueueNames[LISTSIZE];
EXTERN SHORT NPorts;
EXTERN PCHAR apPortNames[LISTSIZE];
EXTERN SHORT NQProcessors;
EXTERN PCHAR apQProcNames[LISTSIZE];
EXTERN SHORT NDevices;
EXTERN PCHAR apDDNames[LISTSIZE];
EXTERN PCHAR apDeviceNames[LISTSIZE];  /* Used only for device drivers     */
                                       /* that support multiple devices    */
                                       /* (i.e., PLOTTER, PSCRIPT).        */
                                       /* For other DDs will be set to "". */

EXTERN USHORT NTests;                  /* number of test cases loaded      */
EXTERN USHORT NTestDLLs;               /* number of DLLs loaded            */

/*
** These variables define the current configuration chosen by the user.
** The next time the user issues a start print, the test case defined by
** pCurrentTestCase will be printed on the printer defined by apCurrent
** using the rest of the variables to define the type of printing.
*/

#define  QUEUE         0        /* Used to access apCurrent and other data  */
#define  PORT          1
#define  DEVICEDRIVER  2
#define  DEVICE        3
#define  QPROCESSOR    4
#define  PRINTERNAME   5
#define  CURRENTSIZE   6             /* CURRENTSIZE must stay one larger than
                                        the #define that preceeds it.       */

EXTERN PCHAR apCurrent[CURRENTSIZE]; /* Pointers to the currently
                                        selected queue, port, and device
                                        driver.                             */
EXTERN PENTRYPOINT pSelectedTestCase;
EXTERN LONG lCurrentDCType;            /* OD_QUEUED, OD_DIRECT, OD_INFO,
                                          OD_METAFILE, OD_METAFILE_NOQUERY,
                                          or OD_MEMORY                      */

EXTERN CHAR *szCurrentDataType;       /* PM_Q_RAW or PM_Q_STD               */
EXTERN ULONG ulCurrentPSType;         /* GPIT_MICRO, GPIT_NORMAL            */

EXTERN ULONG ulCurrentPSUnits;        /* PU_ARBITRARY,PU_PELS,PU_LOMETRIC,
                                         PU_HIMETRIC, PU_LOENGLISH,
                                         PU_HIENGLISH, PU_TWIPS             */

#define  TESTSIZE      2000           /* Total number of test cases allowed */
#define  MAXDLLS       100            /* Maximum number of DLLs allowed     */

/*
** Variables to control access to the test segment.  The segment is
** allocated in PTTInit and the following pointers are defined as offsets
** in that segment.  These are used to facilitate drawing in different
** presentation space units by test cases.  In addition, the HAB of the
** print thread has been added to the segment.
*/

EXTERN PVOID selTestSeg;

EXTERN LONG *pDimensionX,*pDimensionY,*pBasX,*pBasY,*alDeviceCaps;
EXTERN PHAB phabPrintThread;

/*
** Other variables.
*/

EXTERN ULONG ulPTTRamSem;            /* ram semaphore used in script mode  */

EXTERN BOOL bTestDoesDevCalls;       /* Determines whether PrintThread
                                        does all the DevOpen and DevEscape
                                        for the test case or not.          */

EXTERN BOOL bRunMultipleTests;       /* Did the user choose > 1 tests      */
EXTERN BOOL bDisplayLogWindow;       /* Does user want to see log on screen*/
EXTERN BOOL bSearch_Pattern;         /* Did user specify new dll pattern   */
EXTERN BOOL bPTTDoesLog;             /* Log via PTT or TESTLOG             */
EXTERN USHORT usPTTOperatingMode;    /* PTT running interactive or script  */
EXTERN USHORT usPTTOutputMode;       /* Test output to display or printer  */
EXTERN DATETIME DateTime;            /* Structure to hold date/time info.  */
EXTERN CHAR szStatusLine[100];       /* string contains current test name  */
EXTERN CHAR szDLLSearchPattern[100]; /* string contains new dll pattern    */
EXTERN CHAR szLogFileName[100];      /* string contains logging file name  */
EXTERN CHAR szScriptFileName[100];   /* string contains script file name   */

/*
** Function definintions.
*/

BOOL PTT_Init(INT argc,CHAR **argv);
INT InitPrinters(VOID);
VOID EnableOrDisableMenues(USHORT SelectionState);
VOID PostErrorMessage(HWND hWnd,USHORT MessageID);
VOID PerformPatternMatching(USHORT SelectAction);
MRESULT EXPENTRY PromptDlgProc(HWND,USHORT,MPARAM,MPARAM);
VOID PTT_CWRITELOG(int level, ULONG rc, CHAR *logentry);
