/**************************************************************************
 *
 * SOURCE FILE NAME = PTT.C
 *
 * DESCRIPTIVE NAME = Printer and Display Test Tool
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose: Startup PTT and handle messages for execution of PTT.  Also
 *          provide routines that are used by other modules.
 *
 *
 *
 * FUNCTIONS  : main
 *              PTTWndProc
 *              RegisterClass
 *              CreateWindow
 *              cwCheckPulldown
 *              SignatureProc
 *              PromptDlgProc
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 *
 *
 * EXTERNAL FUNCTIONS
 *
 * CHANGE ACTIVITY =
 *   DATE      FLAG        APAR   CHANGE DESCRIPTION
 *   --------  ----------  -----  --------------------------------------
 *   mm/dd/yy  @VR.MPPPXX  XXXXX  XXXXXXX
 *   08/02/95  @V1.0RME01         Changed sequence in initialization to avoid
 *                                timing errors
 ****************************************************************************/


#define  EXTERN
#include "PTT.h"
#include <stdlib.h>
#include "PTTmain.h"
#include "PTTlog.h"
#include "PTTprint.h"
/***************************************************************************
 *
 * FUNCTION NAME =   main(argc,argv)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Call initialization routines, create windows,
 *             and distribute messages to ptt's window proc.
 *
 *   Function Calls:  RegisterClass
 *                    CreateWindow
 *                    PTT_Init
 *
 *
 * INPUT = argc
 *         ergv
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = NONE
 *
 * RETURN-ERROR  = FALSE
 *
 ****************************************************************************/



  PID pid;                             /* Process identifier for adding
                                          name to switch list               */

static CHAR **PointerToArgv;
static INT OurArgc;
int x;
//ULONG xy, ny, number;
INT main(INT argc, CHAR **argv)
{


  TID tid;                             /* Thread identifier                 */

  QMSG qmsg;                           /* MSG structure to store your
                                          messages                          */
  ULONG ulPostCnt;                     /* RME01 added for semaphore use     */
  PointerToArgv = argv;
  OurArgc = argc;
// xy = 0;
// number = -9;
// for (ny = 1; ny <= number; ++ny )
//   {
//     xy = xy +1;
//   }
 /*
 ** The WinInitialize routine initializes the Presentation Manager
 ** facilities for use by this application and returns a handle to the
 ** anchor block assigned to the application by PM.
 */

  if ((hAB = WinInitialize((USHORT)NULL)) == (HAB)NULL)
    return (FALSE);

 /*
 ** The WinCreateMsgQueue call creates a message queue for this application.
 */

  if ((hMQ = WinCreateMsgQueue(hAB,
                               5000U)) == NULLHANDLE)
    return (FALSE);

 /*
 ** The following function registers the classes of all application windows.
 */

  if (!RegisterClass())
    return (FALSE);

 /*
 ** The CreateWindow function creates a frame window for this application's
 ** top window, and set the window's size and location as appropriate.
 */

  hWndFrame = CreateWindow((HWND)HWND_DESKTOP,
                           FCF_TITLEBAR|FCF_SYSMENU|FCF_ICON|FCF_ACCELTABLE|
                              FCF_MINBUTTON|FCF_MAXBUTTON|FCF_SIZEBORDER|
                              FCF_MENU|FCF_SHELLPOSITION,
                           szAppName,
                           "Printer Test Tool",
                           ID_PTT,
                           0,
                           0,
                           0,
                           0,
                           &hWndClient,
                           0L,
                           SWP_SHOW|SWP_MAXIMIZE);

  if (hWndFrame == NULLHANDLE)
    return (FALSE);

 /*
 ** The following in-line routine fills out the application's switch control
 ** structure with the appropriate information to add the application's name
 ** to the OS/2 Task Manager List, a list of the jobs currently running on
 ** the computer.
 */

  WinQueryWindowProcess(hWndFrame,
                        &pid,
                        &tid);
  pSwctl.hwnd = hWndFrame;             /* Frame window handle             */
  pSwctl.idProcess = pid;              /* Process identifier              */
  pSwctl.uchVisibility = SWL_VISIBLE;  /* visibility                      */
  pSwctl.fbJump = SWL_JUMPABLE;        /* Jump indicator                  */
  strcpy(pSwctl.szSwtitle,
         "Printer Test Tool");         /* Frame window title              */
  hSwitch = WinAddSwitchEntry(&pSwctl);

/*
** Install A function that will be called to close all open files
** and DLLs. This is done to make sure that the log files is kept
** intact.
*/


   if (DosExitList(EXLST_ADD,
                  (PFNEXITLIST)CleanUpFunction) != 0)
    PostErrorMessage(hWndClient,
                     IDS_ERR_EXITLIST);

//RME01 Old sequence initialized some dialog procs and other values in
//      WM_CREATE message handling. Since this message is sent and acted
//      on, prior to the return of WinCreateStdWindow(). some values were
//      unavailable at the time.
//
//      Sequence is now: run WinCreateStdWindow(), WM_CREATE message is
//      passed to default message handler. Then, create the ulPTTRamSem
//      event seamphore, and send a WM_INITIALIZE_TESTCASES message.
//      Non_default code formely in WM_CREATE handling is now all in
//      WM_INITIALIZE_TESTCASES.

//RME01 Moved this from PTT_Init(), so that routines in WM_CREATE and
//      WM_INITIALIZE_TESTCASES have a valid seamaphore to work with.
//
//      Create the semaphore
//

  DosCreateEventSem(NULL,         /* Unnamed         */
                    &ulPTTRamSem, /* Semaphore name  */
                    0,            /* Process private */
                    TRUE);        /* Initially set   */

//RME01 Moved this from TestCasesDlgProc() in dttdlgs.c.
//      Since TestCasesDlgProc() is now activated from

//      Set/clear semaphore to indicate we're to begin initializing

//DosResetEventSem(ulPTTRamSem,&ulPostCnt);

//      This call loads the test case DLLs and initializes apTestAddrs
//      and apTestNames and also chooses the default test case.

  WinSendMsg(hWndClient,
             WM_INITIALIZE_TESTCASES,
             MPFROMHWND(HWND_DESKTOP),
             NULL);
//bRunMultipleTests = FALSE;

//      clear/post semaphore to indicate we're finished with initialization

//DosPostEventSem(ulPTTRamSem);


 /*
 ** PTT_Init will initialize global variables; extract information from the
 ** OS2.INI file and store it in data structures for use later in printing;
 ** and load all test case DLLs and initialize the test case data structures.
 */

  if (PTT_Init(argc,
               argv))
  {                                    /* if initialization went ok        */

   /*
   ** The following is the message loop for the application.
   */

    while (WinGetMsg(hAB,
                     (PQMSG)&qmsg,
                     NULLHANDLE,
                     0,
                     0))
      WinDispatchMsg(hAB,
                     (PQMSG)&qmsg);

   /*
   ** Print the trailer information to the log file and close the log file
   */

    if (bPTTDoesLog)
    {

     /*
     ** Print out the trailer to the log file and close the log file
     ** -- for PTTLog this is done in PTT_CLOSELOG
     */

      PTT_CLOSELOG();
    }

#if      TESTLOG

    else
    {
     /*
     ** Print out the trailer to the log file--testlog
     */

      DosGetDateTime(&DateTime); /* get the date and time to enter into log */
      CWRITELOG(L_HDR,
                0,
                (l_log,
                 "=== END ===\n"));
      CWRITELOG(L_HDR,
                0,
                (l_log,
                 "%02d:%02d\n",
                 DateTime.hours,
                 DateTime.minutes));
      CWRITELOG(L_HDR,
                0,
                (l_log,
                 "End of PTT run.\n"));

     /*
     ** Close the log file
     */

      CLOSELOG(pass_fail,
               (l_log,
                "final logging message \n"));
    }
#endif
  }

 /*
 ** Perform clean up before exiting application.
 ** The following routine destroys the application's frame window (which
 ** also destroys its child windows), destroys its message queue, and
 ** disassociates the application from the Presentation Manager system.
 */


  CleanUpFunction();
  WinDestroyWindow(hwndLogDlg);
  WinDestroyWindow(hWndFrame);  /* Destroy the frame window                 */
  WinDestroyMsgQueue(hMQ);      /* Destroy this application's message clue  */
  WinTerminate(hAB);            /* Terminate this application's use of the  */
                                /* Presentation Manager resources           */
                                /* end of main                              */
}

/***************************************************************************
 *
 * FUNCTION NAME = PTTWndProc(hWnd, message, mp1, mp2)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Handle messages for the PTT window.
 *   Called by: main
 *
 *   Function Calls:  PTT_Command
 *                    pCurrentTestCase
 *                    SignatureProc
 *
 *
 * INPUT = HWND   hWnd
 *         USHORT message
 *         MPARAM mp1
 *         MPARAM mp2
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY PTTWndProc(HWND hWnd,
                            USHORT message,
                            MPARAM mp1,
                            MPARAM mp2)
{
  HPS hPS;                    /* Handle for the window presentation space  */
  RECTL rClient;              /* Handle to rectangle formed by client area */
  INT temp;                   /* Used to test logging level                */
  DEVOPENSTRUC *pdos;         /* Data structure for WM_GET_DEVOPENSTRUC    */
  PTESTENVINFO ptestenvinfo;  /* Data structure for WM_GET_ENV_INFO        */
  LONG *ptempDCType;          /* Temporary DCType for WM_GET_DEVOPENSTRUC  */
  FILE *j;

  switch (message)
  {
    case  WM_INITIALIZE_TESTCASES :

//RME01 Following 2 WinLoadDlg() calls moved from WM_CREATE handler.
//      WM_INITIALIZE_TESTCASES have a valid seamaphore to work with.

/* load the logging dialog box */

      hwndLogDlg = WinLoadDlg(HWND_DESKTOP,
                              HWND_OBJECT,
                              (PFNWP)LoggingDlgProc,
                              (HMODULE)NULL,
                              IDLG_LOGWINDOW,
                              NULL);
      hwndTestCasesDlg = WinLoadDlg(HWND_DESKTOP,
                                    HWND_OBJECT,
                                    (PFNWP)TestCasesDlgProc,
                                    (HMODULE)NULL,
                                    IDLG_TESTCASES,
                                    NULL);
                                    //MPFROMSHORT((USHORT)(temp)));
                                    //? MPFROMLONG(temp));
      hWndPromptDlg = WinLoadDlg(HWND_DESKTOP,
                                 HWND_OBJECT,
                                 (PFNWP)PromptDlgProc,
                                 (HMODULE)NULL,
                                 ID_MESSAGE,
                                 NULL);
      WinSetFocus(HWND_DESKTOP,
                  hWndPromptDlg);

//RME01 Changed HWNDFROMMP(mp1) to hwndTestCasesDlg which is returned
//      from TestCasesDlgProc call

      InitTestCases(hwndTestCasesDlg,
                    OurArgc,
                    PointerToArgv);
      WinDestroyWindow(hWndPromptDlg);
      break;                           /* End of WM_INITIALIZE_TESTCASES  */
    case  WM_COMMAND :

           /*
           ** The PM messages for action bar and pulldown menu items are
           ** processed in this routine.
           */

      PTT_Command(hWnd,
                  message,
                  mp1,
                  mp2);
      break;                           /* End of WM_COMMAND                */
    case  WM_PAINT :                   /* code for the window's client area */
      hPS = WinBeginPaint(hWnd,
                          NULLHANDLE,
                          NULL);

           /*
           ** Determine the size of the client area
           */

      WinQueryWindowRect(hWnd,
                         &rClient);

           /*
           ** Fill the background with the default background color
           */

      WinFillRect(hPS,
                  &rClient,
                  CLR_BACKGROUND);

           /*
           ** Tell PM that window has been updated.
           */

      WinQueryUpdateRect(hWnd,
                         &rClient);
      WinValidateRect(hWnd,
                      &rClient,
                      TRUE);

      WinEndPaint (hPS);
      break;                           /* End of WM_PAINT                  */
   case WM_CLOSE :                   /* close the window                 */


     if(usPTTOperatingMode == PTT_INTERACTIVE){
      if (MBID_YES != WinMessageBox(HWND_DESKTOP,
                                    hWnd,
                                    "Are you sure you want to quit?",
                                    "Exiting Printer Test Tool",
                                    (USHORT)NULL,
                                    MB_YESNO|MB_MOVEABLE|MB_ICONQUESTION))
        break;
     }



      WinSetWindowText(hWndFrame, "PTT32 is Closing down...");


        WinPostQueueMsg(hMQPrintThread,
                        WM_CANCEL_PRINT_THREAD,
                        NULL,
                        NULL);
        /*
        ** terminate PTT
        */

        WinPostMsg(hWnd,
                   WM_QUIT,
                   0L,
                   0L);


      /*
      ** Always make sure that the disabled menues are enabled .
      */

      (VOID)EnableOrDisableMenues(FALSE);

      break;                          /* End of WM_CLOSE                  */

      /*
      ** The WM_CHOOSE_xxx messages are used by routines to configure the
      ** test case.  With it PTT can be configured for all its functions.
      ** Specific test cases should only use these messages to communicate
      ** with this window.
      */

    case  WM_CHOOSE_QUEUE :            /* choose a new queue to print to   */

      apCurrent[QUEUE] = PVOIDFROMMP(mp1);
      break;

    case  WM_CHOOSE_PORT :             /* choose a new port to print to    */

      apCurrent[PORT] = PVOIDFROMMP(mp1);
      break;

    case  WM_CHOOSE_DDRIVER :    /* choose a new device driver to print to */

      apCurrent[DEVICEDRIVER] = PVOIDFROMMP(mp1);
      apCurrent[DEVICE] = PVOIDFROMMP(mp2);
      break;

    case  WM_CHOOSE_PRINTERNAME :      /* choose a new printer by name     */

      apCurrent[PRINTERNAME] = PVOIDFROMMP(mp1);
      break;

    case  WM_CHOOSE_QPROCESS : /* choose a new queue processor to print to */

      apCurrent[QPROCESSOR] = PVOIDFROMMP(mp1);
      break;

    case  WM_CHOOSE_DCTYPE : /* contains OD_DIRECT, OD_QUEUED, OD_INFO ... */

      lCurrentDCType = LONGFROMMP(mp1);
      break;

    case  WM_CHOOSE_DATATYPE :         /* contains PM_Q_RAW or PM_Q_STD    */

      strcpy(szCurrentDataType,
             PVOIDFROMMP(mp1));
      break;

    case  WM_CHOOSE_PSTYPE :         /* contains GPIT_MICRO or GPIT_NORMAL */

      ulCurrentPSType = LONGFROMMP(mp1);
      break;

    case  WM_CHOOSE_PSUNITS :       /* contains PU_ARBITRARY, PU_PELS, ... */

      ulCurrentPSUnits = LONGFROMMP(mp1);
      break;

    case  WM_CHOOSE_LOGLEVEL :         /* choose a new logging level       */

      if (bPTTDoesLog)
      {
             /*
             ** PTT log
             */

        pttloglevel = SHORT1FROMMP(mp1);
        ptt_RecordLogLevel();
      }

#if      TESTLOG

      else
      {
             /*
             ** TESTLOG
             ** l_level = SHORT1FROMMP(mp1);
             */

        LOGLEVEL(SHORT1FROMMP(mp1));
      }                                /* endif                             */
#endif
      break;

    case  WM_CHOOSE_TESTCASE :      /* Redefines the name of the currently
                                       selected test case.                  */

      j = fopen("title.txt","w");

      if (bRunMultipleTests == TRUE)
        strcpy(szStatusLine,
               "Printer Test Tool: MULTIPLE TESTS SELECTED");

      else{
        fprintf(j,"%p \n",pSelectedTestCase->szTestName);
         sprintf(szStatusLine,
                "Printer Test Tool:  %s",
                pSelectedTestCase->szTestName);   //paul
      }


      WinSetWindowText(hWndFrame,
                       szStatusLine);
      WinInvalidateRect(hWnd,
                        NULL,
                        FALSE);
      break;
    case  WM_TEST_DOES_DEVCALLS :  /* Test cases send this message when
                                      they are selected to tell PrintThread
                                      that they will do all DEV calls.      */

      bTestDoesDevCalls = TRUE;

       /*
       ** disable the "display to screen" option for this type of test
       */

      WinSendMsg(WinWindowFromID(hWndFrame,
                                 FID_MENU),
                 MM_SETITEMATTR,
                 MPFROM2SHORT(IDM_ACTIONS_DISPLAY,
                              TRUE),
                 MPFROM2SHORT(MIA_DISABLED,
                              MIA_DISABLED));
      break;
    case  WM_PTHREAD_DOES_DEVCALLS : /* Test cases send this message when
                                        they are selected to tell PrintThread
                                        that it won't do DEV calls.         */

      bTestDoesDevCalls = FALSE;

       /*
       ** enable the "display to screen" option for this type of test
       */

      WinSendMsg(WinWindowFromID(hWndFrame,
                                 FID_MENU),
                 MM_SETITEMATTR,
                 MPFROM2SHORT(IDM_ACTIONS_DISPLAY,
                              TRUE),
                 MPFROM2SHORT(MIA_DISABLED,
                              0));
      break;
    case  WM_TEST_SIGNATURE :

      /*
      ** Each individual test should send this message to print the name
      ** of the test on the output.  The test case should pass the HPS of
      ** the test and the location of where it would like to print the
      ** test based on the coordinates it is working in.  If the test
      ** case passes in the values of (0,0) for x and y, then a default
      ** value for x and y will be used.  The HPS should be in mp1, and
      ** the coordinates should be in mp2.
      */

      SignatureProc(message,
                    mp1,
                    mp2);
      break;
    case  WM_LOG_SIGNATURE :

      /*
      ** Each individual test should send this message to print the name
      ** of the test to the log file.  mp1 and mp2 are not used.
      */

      SignatureProc(message,
                    0,
                    0);
      break;
    case  WM_TEST_LOG :

      /*
      ** This message indicates that the test case wants to log a message
      ** to the log file.  The CWRITELOG command is executed on behalf
      ** of the test case with the parameters that are passed in.
      **    MP1 contains the log level and the return code.
      **    MP2 contains a pointer to the message to log.
      */

      if (bPTTDoesLog)
      {                                /* log via PTT                      */

        PTT_CWRITELOG(LONGFROMMP(mp1),
                      LONGFROMMP(mp2),
                      (PCHAR)LONGFROMMP(mp2));
      }

#if      TESTLOG

      else
      {                                /* log via Testlog                  */

        CWRITELOG(SHORT1FROMMP(mp1),
                  SHORT1FROMMP(mp2),
                  (l_log,
                   (PCHAR)LONGFROMMP(mp2)));
      }
#endif
           /*
           ** Log to the Log Window, but only if the log level is set
           ** at the correct level.
           */

      temp = LONGFROMMP(mp1);


      if (temp <= pttloglevel)
      {
        LogToDlgBox((PCHAR)LONGFROMMP(mp2));
      }
      break;
    case  WM_GET_DEVOPENSTRUC :  /* mp1 contains a pointer to a DEVOPENSTRUC.
                                    Enter the current information into it.
                                    mp2 contains a pointer to a long. The
                                    DCType is entered into it.              */

      pdos = (DEVOPENSTRUC *)PVOIDFROMMP(mp1);

      if (lCurrentDCType == OD_QUEUED)
      {
        pdos->pszLogAddress = apCurrent[QUEUE];
      }

      else
      {
        pdos->pszLogAddress = apCurrent[PORT];
      }
      pdos->pszDriverName = apCurrent[DEVICEDRIVER];

      if (!apCurrent[DEVICE] || strlen(apCurrent[DEVICE]) == 0)
      {
        pdos->pdriv = NULL;
      }

      else
      {
        pdos->pdriv->cb = sizeof(DRIVDATA);
        pdos->pdriv->lVersion = 0;
        strcpy(pdos->pdriv->szDeviceName,
               apCurrent[DEVICE]);
        pdos->pdriv->abGeneralData[0] = '\0';
      }
      pdos->pszDataType = szCurrentDataType;
      pdos->pszComment = "PTT";
      pdos->pszQueueProcName = apCurrent[QPROCESSOR];
      pdos->pszQueueProcParams = NULL;
      pdos->pszSpoolerParams = NULL;
      pdos->pszNetworkParams = NULL;
      ptempDCType = (LONG *)PVOIDFROMMP(mp2);
      *ptempDCType = lCurrentDCType;
      break;

    case  WM_GET_ENV_INFO : /* mp1 contains a pointer to a TESTENVINFO struc.
                               Enter the current information into it.       */

      ptestenvinfo = (PTESTENVINFO)PVOIDFROMMP(mp1);
      ptestenvinfo->usOperatingMode = usPTTOperatingMode;
      ptestenvinfo->usOutputMode = usPTTOutputMode;
      ptestenvinfo->ulPSType = ulCurrentPSType;
      break;

    default  :

           /*
           ** For any message for which you don't specifically provide a
           ** service routine, you should return the message to PM using
           ** the WinDefWindowProc function.
           */

      return (WinDefWindowProc(hWnd,
                               message,
                               mp1,
                               mp2));
      break;                           /* End of default                   */
  }                                    /* endswitch                        */
  return (0L);
}                                      /* End of PTTWndProc                */

/***************************************************************************
 *
 * FUNCTION NAME = RegisterClass(VOID)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Register class of main PTT window.
 *   Called by: main
 *
 *   Function Calls:  NONE
 *
 *
 * INPUT = NONE
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE if succesfull else FALSE
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

INT RegisterClass(VOID)
{
  INT rc;

  strcpy(szAppName,
         "PTT");
  rc = WinRegisterClass(hAB,               /* Anchor block handle           */
                        (PCH)szAppName,    /* Name of class being registered*/
                        (PFNWP)PTTWndProc, /* Window procedure for class    */
                        CS_SIZEREDRAW,
                        (USHORT)NULL);     /* Extra bytes to reserve        */

  if (rc == FALSE)
    return (FALSE);
  return (TRUE);
}                                          /* End of RegisterClass          */

/***************************************************************************
 *
 * FUNCTION NAME = CreateWindow()
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose:  Create main PTT window.
 *   Called by: main
 *
 *   Function Calls:  NONE
 *
 *
 * INPUT =  HWND hWndParent,           Handle to the parent of the window
 *                                     to be created
 *          ULONG ctldata,             Frame control flags for the window
 *          PCH appname,               Class name of the window
 *          PCH title,                 Title of the window
 *          USHORT ResID,              Resource id value
 *          INT x,                     Initial horizontal and vertical
 *                                     location of origin
 *          INT y,INT cx,              Initial width and height of
 *                                     the window
 *          INT cy,PHWND hWndClient,   Handle to the client area of
 *                                     the window
 *          ULONG lfStyle,             Frame window style
 *          USHORT uSizeStyle)         User defined size and location flags
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = Handle to window frame
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

HWND CreateWindow(HWND   hWndParent,
                  ULONG  ctldata,
                  PCH    appname,
                  PCH    title,
                  USHORT ResID,
                  INT    x,
                  INT    y,
                  INT    cx,
                  INT    cy,
                  PHWND  hWndClient,
                  ULONG  lfStyle,
                  USHORT uSizeStyle)
{
  INT rc;                        /* accepts return codes from function calls*/
  HWND hWndFrame;                /* local handle to created window frame    */
  USHORT SizeStyle;              /* local window positioning options        */

   /*
   ** Create the frame window
   */

  hWndFrame = WinCreateStdWindow(hWndParent,    /* parent of window        */
                                 lfStyle,       /* frame window style      */
                                 &ctldata,      /* frame flags             */
                                 appname,       /* class name              */
                                 title,         /* window title            */
                                 0L,            /* client window style     */
                                 (HMODULE)NULL, /* module for resources    */
                                 ResID,         /* resource id             */
                                 (HWND FAR *)hWndClient); /* client handle */

   /*
   ** if hWndFrame is NULL, an error occured when opening the window, notify
   ** the user and exit this function
   */

  if (hWndFrame == NULLHANDLE)
  {
    PostErrorMessage(HWND_DESKTOP,
                     IDS_ERR_WINDOW_CREATE);
    return ((HWND)NULL);
  }
   /*
   ** set up size options
   */

  SizeStyle = (USHORT)(SWP_ACTIVATE|SWP_ZORDER|uSizeStyle);

   /*
   ** if the either the intial x or y position of the window is non-zero,
   **    set the window to its new position
   */

  if ((x > 0) || (y > 0))
    SizeStyle |= SWP_MOVE;

   /*
   ** if either the width or the height are non-zero, then the size of the
   **     created window will be changed, set SizeStyle accordingly
   */

  if ((cx > 0) || (cy > 0))
    SizeStyle |= SWP_SIZE;

   /*
   ** set the size and position of the window and activate it
   */

  rc = WinSetWindowPos(hWndFrame,
                       HWND_TOP,
                       x,
                       y,
                       cx,
                       cy,
                       SizeStyle);

   /*
   ** if rc is not set to TRUE then WinSetWindowPos failed, notify the user
   ** and exit this function
   */

  if (!rc)
  {
    PostErrorMessage(*hWndClient,
                     IDS_ERR_WINDOW_POS);
    return ((HWND)NULL);
  }

   /*
   ** return the handle to the frame window
   */

  return (hWndFrame);
}                                      /* End of CreateWindow              */

/***************************************************************************
 *
 * FUNCTION NAME = cwCheckPulldown(HWND hwnd, USHORT item)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose: determines whether a menu item is checked or
 *            unchecked; if unchecked the item is checked and
 *            vice-versa.
 *
 *   Called by: main
 *
 *   Function Calls:  NONE
 *
 *
 * INPUT =   HWND   hWnd
 *           USHORT item
 *
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = TRUE if menu item is now checked, else FALSE.
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

USHORT cwCheckPulldown(HWND   hWnd,
                       USHORT item)
{
  MENUITEM Menu;             /* structure to store attributes of menu item  */

   /*
   ** query the system for the attributes of this particular menu item
   */

  WinSendMsg(WinWindowFromID(hWnd,
                             FID_MENU),
             MM_QUERYITEM,
             MPFROM2SHORT(item,
                          TRUE),
             MPFROMP((PMENUITEM)&Menu));

   /*
   ** if this menu item's MIA_CHECKED bit is on, uncheck the menu item,
   **    else, check the menu item
   */

  Menu.afAttribute = ~Menu.afAttribute;
  WinSendMsg(WinWindowFromID(hWnd,
                             FID_MENU),
             MM_SETITEMATTR,
             MPFROM2SHORT(item,
                          TRUE),
             MPFROM2SHORT(MIA_CHECKED,
                          Menu.afAttribute));
  return ((USHORT)(Menu.afAttribute&MIA_CHECKED));

}                                      /* End of cwCheckPulldown function  */

/***************************************************************************
 *
 * FUNCTION NAME = SignatureProc(USHORT msg, MPARAM mp1,mp2)
 *
 *
 * DESCRIPTION   =
 *
 *   Purpose: outputs the test signature to either the output
 *            device or the logfile and logwindow.  The msg
 *            parm determines where to send the output.  The
 *            mp1 and mp2 parms contain the HPS and cooridnates,
 *            respectively.  The mp2 parm is not used for
 *            output to the logfile/logwindow.
 *
 *   Called by: main
 *
 *   Function Calls:  LogToDlgBox
 *
 *
 * INPUT =  USHORT msg
 *          MPARAM mp1
 *          MPARAM mp2
 *
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = VOID
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

VOID SignatureProc(USHORT msg,
                   MPARAM mp1,
                   MPARAM mp2)
{
#define  RESOLUTION(Value) (.0254*(Value)+.50)
  HDC hDC;
  double xPixels;
  double yPixels;
  HPS hpsSignature;
  LONG hori_pels_per_m;
  LONG vert_pels_per_m;

  /*
  ** find the current DC Type and assign the equivalent string value
  */

  switch ((INT)lCurrentDCType)
  {
    case  OD_QUEUED :
      strcpy(szDCType,
             "OD_QUEUED");
      break;
    case  OD_DIRECT :
      strcpy(szDCType,
             "OD_DIRECT");
      break;
    case  OD_INFO :
      strcpy(szDCType,
             "OD_INFO");
      break;
    case  OD_METAFILE :
      strcpy(szDCType,
             "OD_METAFILE");
      break;
    case  OD_METAFILE_NOQUERY :
      strcpy(szDCType,
             "OD_METAFILE_NOQUERY");
      break;
    case  OD_MEMORY :
      strcpy(szDCType,
             "OD_MEMORY");
      break;
  }                                    /* endswitch                         */

  /*
  ** find the current PS Type and assign the equivalent string value
  */

  switch ((INT)ulCurrentPSType)
  {
    case  GPIT_MICRO :
      strcpy(szPSType,
             "GPIT_MICRO");
      break;
    case  GPIT_NORMAL :
      strcpy(szPSType,
             "GPIT_NORMAL");
      break;
  }                                    /* endswitch                         */

  /*
  ** find the current PS Units and assign the equivalent string value
  */

  switch ((INT)ulCurrentPSUnits)
  {
    case  PU_ARBITRARY :
      strcpy(szPSUnits,
             "PU_ARBITRARY");
      break;
    case  PU_PELS :
      strcpy(szPSUnits,
             "PU_PELS");
      break;
    case  PU_LOMETRIC :
      strcpy(szPSUnits,
             "PU_LOMETRIC");
      break;
    case  PU_HIMETRIC :
      strcpy(szPSUnits,
             "PU_HIMETRIC");
      break;
    case  PU_LOENGLISH :
      strcpy(szPSUnits,
             "PU_LOENGLISH");
      break;
    case  PU_HIENGLISH :
      strcpy(szPSUnits,
             "PU_HIENGLISH");
      break;
    case  PU_TWIPS :
      strcpy(szPSUnits,
             "PU_TWIPS");
      break;
  }                                    /* endswitch                         */

  DosGetDateTime(&DateTime);    /* get the date and time to enter into log  */

  /*
  ** print the signature information to a formatted string
  */

  sprintf(szSignature1,
          "# %s, %s, %s, %s, %s.\n",
          pSelectedTestCase->szTestName,
          szDCType,
          szCurrentDataType,
          szPSType,
          szPSUnits);

  /*
  ** print the signature information to a formatted string
  */

  sprintf(szSignature2,
          "# %s, %s, %s, %s, %s,""%02d/%02d/%2d.%02d:%02d:%02d\n",
          apCurrent[PRINTERNAME],
          apCurrent[DEVICEDRIVER],
          apCurrent[DEVICE],
          apCurrent[PORT],
          apCurrent[QUEUE],
          DateTime.month,
          DateTime.day,
          DateTime.year%100,
          DateTime.hours,
          DateTime.minutes,
          DateTime.seconds);

  /*
  ** output the signature
  ** print to output device
  */

  if (msg == WM_TEST_SIGNATURE)
  {
    hpsSignature = (HPS)LONGFROMMP(mp1); /* get the hps of the output device*/

    hDC = GpiQueryDevice(hpsSignature);
    DevQueryCaps(hDC,
                 CAPS_HORIZONTAL_RESOLUTION,
                 1L,
                 &hori_pels_per_m);
    DevQueryCaps(hDC,
                 CAPS_VERTICAL_RESOLUTION,
                 1L,
                 &vert_pels_per_m);

    /*
    ** Calculate the pixels per inch in X-direction
    */

    xPixels = (double)RESOLUTION(hori_pels_per_m);

    /*
    ** Calculate the pixels per inch in Y-direction
    */

    yPixels = (double)RESOLUTION(vert_pels_per_m);

    /*
    ** print the signature information to a formatted string
    */

    sprintf(szSignature1,
            "# %s, %s, %s, %s, %s, %03d*%03d .\n",
            pSelectedTestCase->szTestName,
            szDCType,
            szCurrentDataType,
            szPSType,
            szPSUnits,
            (SHORT)xPixels,
            (SHORT)yPixels);

    /*
    ** calculate the font metrics needed for output to the device
    */

    GpiQueryFontMetrics(hpsSignature,
                        (LONG)sizeof(fm),
                        &fm);
    xChar = (SHORT)fm.lAveCharWidth;
    yChar = (SHORT)fm.lMaxBaselineExt;

    /*
    ** if user specified (0,0) for the coordinates, then
    **   output the signature at the default location
    */

    if ((SHORT1FROMMP(mp2) == 0) && (SHORT2FROMMP(mp2) == 0))
    {
      ptlName.x = DEFAULT_SIGNATURE_LOCATION_X;
      ptlName.y = DEFAULT_SIGNATURE_LOCATION_Y;
    }

    /*
    ** else output the signature at the location specified by the user
    */

    else
    {
      ptlName.x = SHORT1FROMMP(mp2);
      ptlName.y = SHORT2FROMMP(mp2);
    }
    GpiCharStringAt(hpsSignature,
                    &ptlName,
                    (LONG)strlen(szSignature1)-1,
                    szSignature1);
    ptlName.y -= yChar;                /* position to next line           */

    GpiCharStringAt(hpsSignature,
                    &ptlName,
                    (LONG)strlen(szSignature2)-1,
                    szSignature2);
  }

  /*
  ** print to log file and log window
  */

  else
  {                                    /* WM_LOG_SIGNATURE                 */

    DosGetDateTime(&DateTime);  /* get the date and time to enter into log */

    if (bPTTDoesLog)
    {
      /*
      ** if PTT is doing the logging...
      */

      sprintf(szLogEntry,
              "# Date: %02d/%02d/%04d. Time:  %02d:%02d:%02d.%02d.\n",
              DateTime.month,
              DateTime.day,
              DateTime.year,
              DateTime.hours,
              DateTime.minutes,
              DateTime.seconds,
              DateTime.hundredths);
      PTT_CWRITELOG(L_FAIL,
                    0,
                    szLogEntry);
      PTT_CWRITELOG(L_FAIL,
                    0,
                    szSignature1);
      PTT_CWRITELOG(L_FAIL,
                    0,
                    szSignature2);
    }

#if      TESTLOG

    else
    {
      /*
      ** else Testlog is doing the logging
      */

      CWRITELOG(L_HDR,
                0,
                (l_log,
                 "# %02d/%02d/%02d  %02d:%02d\n",
                 DateTime.month,
                 DateTime.day,
                 DateTime.year,
                 DateTime.hours,
                 DateTime.minutes));
      CWRITELOG(L_HDR,
                0,
                (l_log,
                 szSignature1));
      CWRITELOG(L_HDR,
                0,
                (l_log,
                 szSignature2));
    }
#endif

    /*
    ** if the current loglevel > L_FAIL,
    ** then output the signature to the Log Window
    */

    if (L_FAIL <= pttloglevel)
    {
      LogToDlgBox(szSignature1);
      LogToDlgBox(szSignature2);
    }
  }
}                                      /* end SignatureProc              */

/***************************************************************************
 *
 * FUNCTION NAME = PromptDlgProc
 *
 *
 * DESCRIPTION   =
 *
 *
 *   Function Calls:
 *
 *
 * INPUT =  HWND   hWnd
 *          USHORT message
 *          MPARAM mp1
 *          MPARAM mp2
 *
 *
 * OUTPUT = NONE
 *
 *
 * RETURN-NORMAL = MRESULT
 *
 * RETURN-ERROR  = NONE
 *
 ****************************************************************************/

MRESULT EXPENTRY PromptDlgProc(HWND   hWnd,
                               USHORT message,
                               MPARAM mp1,
                               MPARAM mp2)
{

  switch (message)
  {
    case  WM_PROMPT_MESSAGE :
      WinSetDlgItemText(hWnd,
                        ID_MESSAGE_TEXT,
                        mp1);
      break;
    default  :
      return (WinDefDlgProc(hWnd,
                            message,
                            mp1,
                            mp2));
  }
  return (FALSE);
}                                      /* PromptDlgProc                   */


void PTT_CWRITELOG(int level, ULONG rc, CHAR *logentry)
{
  if((INT)level <= pttloglevel)
    DosWrite(logfile,(PVOID) logentry, strlen(logentry),&rc);

}
