#ifndef GPIVIEW_H
#define GPIVIEW_H

/****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module name:  GPIVIEW
 *
 * Purpose:  Include file for GPIVIEW DLL.
 *
 * Revision Log: 10/24/90, PDVT, Donna Williams
 *                     - initial creation
 *               12/04/90, PDVT, Hal Bray
 *                     -  implementation of testcase design
 *
 * SRS References: Section 5.5
 *
 * Contents: This file contains the following definitions:
 *           - function prototypes
 *           - defines specific to GPIVIEW
 *
 * Limitations:    NONE
 *
 *\\end
****************************************************************************/

/* Declare all GPIVIEW test functions */
VOID  APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo);
VOID  APIENTRY GpiSetDefViewingLimitsPre(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetGraphicsFieldPre(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetViewingLimitsPre(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiViewApp(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetDefViewingLimitsExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetDefViewingLimitsExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetViewingLimitsExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetViewingLimitsExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID  APIENTRY GpiSetPageViewportExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID           fill_page(HPS hPS, LONG pattern);

#define NTESTS      9          // Number of test entry points

#define SEGMENT_ID1 (999L)              // Segment ID number used in GpiSetDefViewingLimitsExh2
#define SEGMENT_ID2 (SEGMENT_ID1 - 1)   // Segment ID number used in GpiSetViewingLimitsExh1

#endif

