/***************************************************************************
 *\\ddd
 * Subtask Name:  PDVT
 *
 * Module name:   gpistd.c
 *
 * Purpose:       This module is called by the PTT to test GPI Standard
 *                Precision.
 *
 * Revision Log:  10/29/90, PDVT, Kim Cairns
 *                - Original module template
 *                12/04/90, PDVT, Kim Cairns
 *                - code completion
 *                01/03/91, PDVT, Kim Cairns
 *                - minor changes to standardize code
 *
 * SRS References:  Section 5.1
 *
 * Contents:
 *               InitTest()
 *               gpi_std_pre1()   - creates a 1/2"x1/2" grid
 *               gpi_std_pre2()   - creates a 1"x1" grid
 *               gpi_std_pre3()   - creates a 2"x2" grid
 *
 * Design Overview:
 *   This testcase consists of the drawing of a set of grids, using GPI
 *   functions, and measuring their accuracy in printed form.  This is
 *   a visual test, therefore the amount of logging done is minimal.
 *
 * Limitations:
 *   The GPI APIs used to draw the grids are not tested for functionality
 *   and exhaustive return codes in this testcase.  They are covered in
 *   the GPILINE testcase.
 *
 *\\end
 ***************************************************************************/

#define INCL_WIN      /* win function definitions */
#define INCL_GPI      /* all gpi specific definitions */

#include <string.h>
#include <os2.h>
#include <stdio.h>
#include "PTTDLLDF.h" // test case defines
#include "gpistd.h"   // gpi standard grid dll header file
#include "gpi_grid.h" // gpi standard grid functions header file
#include "std_util.h"  // standard write and log functions header file

 /***************************************************************************
 *\\ddd
 * Routine name: InitTest()
 *
 * Purpose:  Initialize function name and address array for ptt.
 *
 * System Requirements:  None
 *
 * Revision Log:  10/29/90, PDVT, Kim Cairns
 *                - initial function template
 *                12/03/90, PDVT, Kim Cairns
 *                - added group_name
 *
 * Inputs:
 *             sel            - pass thru parameter for other function call
 *             pInitInfo      - pointer to info array
 *
 * Outputs:
 *             pInitInfo      - updated with all entry points names and addresses
 *
 * Subroutines Required:
 *             InitTestSegVars()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *   for all test functions in this test case {
 *       pInitInfo->function name = function name[i]
 *       pInitInfo->function address = function address[i]
 *   }
 *   call init set function
 *\\end
 ***************************************************************************/
VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo)
  {

    /**** Initialize total number of tests in test case ****/
    pInitInfo->ntests = NTESTS;

    /**** Load test names and entry point addresses ****/
    strcpy(pInitInfo->group_name,"GPI Standard");
    strcpy(pInitInfo->test_names[0],"GpiStandardPre1");
    pInitInfo->test_addrs[0]=gpi_std_pre1;
    strcpy(pInitInfo->test_names[1],"GpiStandardPre2");
    pInitInfo->test_addrs[1]=gpi_std_pre2;
    strcpy(pInitInfo->test_names[2],"GpiStandardPre3");
    pInitInfo->test_addrs[2]=gpi_std_pre3;

    InitTestSegVars(sel);
  }

 /***************************************************************************
 *\\ddd
 * Routine name:  gpi_std_pre1()
 *
 * Purpose:  This is an entry point for the PTT that causes the first of three
 *           GPI Standard precision tests to be run.
 *
 * System Requirements:  Section 5.1.2
 *
 * Revision Log:  10/29/90, PDVT, Kim Cairns
 *                - initial function template
 *
 * Inputs:
 *             hPS            - presentation space handle
 *             hWndClient     - client window handle
 *             SelectionCall  - selection indicator
 *
 * Outputs:
 *             None
 *
 * Subroutines Required:
 *             gpi_grid()     - standard grid function using GPIs
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  for each type of presentation units (changed manually through Config1):
 *    draw grid with 1/2" x 1/2" squares
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY gpi_std_pre1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
        TEST_SIGNATURE(0,0);
        LOG_SIGNATURE;
        CWRITELOG(L_LOTRACE, 0, "+ee+ GpiStandardPre1 - Entry.\n");

        // This sets the squares of the grid to 1/2" x 1/2"
        gpi_grid (hPS, (LONG)HALFINCH);

        MapAndWriteString(hPS, delta_x+100, delta_y+100,
           "This grid's squares are 1/2x1/2 inch.");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiStandardPre1 - Exit.\n");
       }
}
 /***************************************************************************
 *\\ddd
 * Routine name:  gpi_std_pre2()
 *
 * Purpose:  This is an entry point for the PTT that causes the second of three
 *           GPI Standard precision tests to be run.
 *
 * System Requirements:  Section 5.1.2
 *
 * Revision Log:  10/29/90, PDVT, Kim Cairns
 *                - initial function template
 *
 * Inputs:
 *             hPS            - presentation space handle
 *             hWndClient     - client window handle
 *             SelectionCall  - selection indicator
 *
 * Outputs:
 *             None
 *
 * Subroutines Required:
 *             gpi_grid()     - standard grid function using GPIs
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  for each type of presentation units (changed manually through Config1):
 *    draw grid with 1" x 1" squares
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY gpi_std_pre2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
        TEST_SIGNATURE(0,0);
        LOG_SIGNATURE;
        CWRITELOG(L_LOTRACE, 0, "+ee+ GpiStandardPre2 - Entry.\n");

        // This sets the squares of the grid to 1" x 1"
        gpi_grid (hPS, (LONG)INCH);

        MapAndWriteString(hPS, delta_x+100, delta_y+100,
           "This grid's squares are 1x1 inch.");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiStandardPre2 - Exit.\n");
  }
}
 /***************************************************************************
 *\\ddd
 * Routine name:  gpi_std_pre3()
 *
 * Purpose:  This is an entry point for the PTT that causes the third of three
 *           GPI Standard precision tests to be run.
 *
 * System Requirements:  Section 5.1.2
 *
 * Revision Log:  10/29/90, PDVT, Kim Cairns
 *                - initial function template
 *
 * Inputs:
 *             hPS            - presentation space handle
 *             hWndClient     - client window handle
 *             SelectionCall  - selection indicator
 *
 * Outputs:
 *             None
 *
 * Subroutines Required:
 *             gpi_grid()     - standard grid function using GPIs
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *  for each type of presentation units (changed manually through Config1):
 *    draw grid with 2" x 2" squares
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY gpi_std_pre3(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
        TEST_SIGNATURE(0,0);
        LOG_SIGNATURE;
        CWRITELOG(L_LOTRACE, 0, "+ee+ GpiStandardPre3 - Entry.\n");

        // This sets the squares of the grid to 2" x 2"
        gpi_grid (hPS, (LONG)TWOINCH);

        MapAndWriteString(hPS, delta_x+100, delta_y+100,
           "This grid's squares are 2x2 inches.");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiStandardPre3 - Exit.\n");
  }
}

