/************************************************************************/
/* GPISHADE.C                                              */
/*                                                                      */
/* Purpose: Provide an example of how to write a PTT test case and how  */
/*          to use the functions that are available to the test case    */
/*          programmer.                                                 */
/*                                                                      */
/* Functions in Program:  InitTest                                      */
/*                        GpiShade1 (tests Pel spacing and shading      */
/*                        GpiShade2 (Vertical box overlapping in Overpaint mode */
/*                        GpiShade3 (Tests circle shading in Fill and outline mode */
/*                        GpiShade4 (Tests FM_OR shading against color table)*/
/*                        GpiShade5 (Same as 4 but with different colors) */
/*
/************************************************************************/
#define INCL_WIN
#define INCL_GPI
#include <string.h>
#include <stdlib.h>
char *color;
long color1,color2;
#include <stdio.h>
#include <os2.h>
#include "PTTDLLDF.h"   // test case defines
#include "std_util.h"
// local function prototypes
VOID APIENTRY GpiShade1 (HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY GpiShade2 (HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY GpiShade3 (HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY GpiShade4 (HPS hPS,HWND hWndClient,BOOL SelectionCall);
VOID APIENTRY GpiShade5(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade6(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade7(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade8(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade9(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade10(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade11(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade12(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade13(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiShade14(HPS hPS, HWND hWndClient, BOOL SelectionCall);
void boxes(HPS hPS, long lengthx, long lengthy, long initx, long inity, long color1, long color2);


CHAR *whatis(long digit);
#define FXTOLONG 65536

// 6 tests are contained in gpishade.dll
#define NTESTS  14

PCHAR pGroupName = "GpiShade";    // group name of the tests
PCHAR pTestName1 = "GpiShadePelSpace";    // test name
PCHAR pTestName2 = "GpiShadeOverlapBox";    //     "
PCHAR pTestName3 = "GpiShadeOverlapCircle1";    //     "
PCHAR pTestName4 = "GpiShadeORing-1";    //     "
PCHAR pTestName5 = "GpiShadeORing-2";    //     "
PCHAR pTestName6 = "GpiShadeORing-3";
PCHAR pTestName7 = "GpiShadeORing-4";
PCHAR pTestName8 = "GpiShadeBlue";
PCHAR pTestName9 = "GpiShadeGreen";
PCHAR pTestName10 = "GpiShadeRed";
PCHAR pTestName11 = "GpiShadeGray";
PCHAR pTestName12 = "GpiShadeAll";
PCHAR pTestName13 = "GpiShadeOverlapCircle2";
PCHAR pTestName14 = "GpiShadeOverlapBox2";
TESTENVINFO testenvinfo;


/**************************************************************
*  Function Name: InitTest(USHORT sel,PTESTINITINFO pInitInfo)*
*                                                            *
*  Purpose:  Establish a link with PTT and initialize pointers*
*            into the shared segment (shared with PTT).       *
*                                                             *
*  Function Calls: InitTestSegVars                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo){

    pInitInfo->ntests = NTESTS;
    strcpy(pInitInfo->group_name,pGroupName);
    strcpy(pInitInfo->test_names[0],pTestName1);
    pInitInfo->test_addrs[0]=GpiShade1;
    strcpy(pInitInfo->test_names[1],pTestName2);
    pInitInfo->test_addrs[1]=GpiShade2;
    strcpy(pInitInfo->test_names[2],pTestName3);
    pInitInfo->test_addrs[2]=GpiShade3;
    strcpy(pInitInfo->test_names[3],pTestName4);
    pInitInfo->test_addrs[3]=GpiShade4;
    strcpy(pInitInfo->test_names[4],pTestName5);
    pInitInfo->test_addrs[4]=GpiShade5;
    strcpy(pInitInfo->test_names[5],pTestName6);
    pInitInfo->test_addrs[5]=GpiShade6;
    strcpy(pInitInfo->test_names[6],pTestName7);
    pInitInfo->test_addrs[6]=GpiShade7;
    strcpy(pInitInfo->test_names[7],pTestName8);
    pInitInfo->test_addrs[7]=GpiShade8;
    strcpy(pInitInfo->test_names[8],pTestName9);
    pInitInfo->test_addrs[8]=GpiShade9;
    strcpy(pInitInfo->test_names[9],pTestName10);
    pInitInfo->test_addrs[9]=GpiShade10;
    strcpy(pInitInfo->test_names[10],pTestName11);
    pInitInfo->test_addrs[10]=GpiShade11;
    strcpy(pInitInfo->test_names[11],pTestName12);
    pInitInfo->test_addrs[11]=GpiShade12;
    strcpy(pInitInfo->test_names[12],pTestName13);
    pInitInfo->test_addrs[12]=GpiShade13;
    strcpy(pInitInfo->test_names[13],pTestName14);
    pInitInfo->test_addrs[13]=GpiShade14;
    InitTestSegVars(sel);
}  // end InitTest


/*  GpiShade1 tests the shading and spacing of a series of rectangles   */
/*  spaced one Pel unit apart. This test should be run in Pel Mode only */
/*  Returns: void                                                       */
/*  By: Paul M. Ramey                                                  */

VOID APIENTRY GpiShade1 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
LONG     it = 1;
LONG     no,wide;
LONG     initx,inity,lengthx,lengthy,tempx,tempy;
LONG    lcolor = 0L;
FIXED   fxmultiplier = FXTOLONG;
FIXED   fxStartAngle = 0;
FIXED   fxSweepAngle = FXTOLONG * 24;
CHAR    *str2;
static  POINTL       apt;
int countr,bap;
CHAR let1[100], let2[100];

  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");

  //  Set current pointer position
         no = 2;

         str2 = "Run in Pel mode only. Spacing should increase in successive Pel units." ;
         wide = (long) strlen(str2);   //length of string for GpiCharString
         apt.x = 30;       //set position of character string
         apt.y = 100;

         GpiMove(hPS,&apt);
         GpiCharString( hPS, wide, str2);
         initx = 60;   //initial points...first set of coordinates
         inity = 315;
         tempx = 10;  //initial point...second set of coordinates
         tempy = 125;
         lengthx = initx - tempx;
         lengthy = inity - tempy;
         //Now set up a loop to draw the boxes. The horizontal spacing
         //between each box will increase by one pel unit per box.

         for (no = 2;no<12;no++ ) {
         it++;

   //The following series of statements allow the color name of each
   //rectangle to be displayed to the screen vertically
         countr = strlen(whatis(it));
         bap = 0;

         sprintf(let1,"%s", whatis(it));

         let1[countr] = '\0';
         countr--;
         //Display the color name character by character
         while ((countr > 0 ) || (countr == 0)){

         sprintf(let2,"%c",let1[countr]);



          apt.x = tempx + 10;
          apt.y = inity + 10 + bap ;

              GpiMove(hPS,&apt);
              GpiSetColor(hPS, CLR_BLACK);
              GpiCharString(hPS,(long) strlen(let2), let2);
              countr--;
          bap=bap+14;
         }




         apt.x = initx;

                      //specify coordinate
         apt.y = inity;



         GpiMove( hPS, &apt );

         apt.x = tempx;
         apt.y = tempy;
          apt.y = tempy;


         lengthx = initx - apt.x;        //obtain horizontal and vertical box length
         lengthy = inity - apt.y;

         //The color used for this box shading will be the color corresponding


         //to the value of the variable it (it<15).

         GpiSetColor( hPS, it );
         GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L );

         apt.x = tempx;
         apt.y = inity + 200;

         GpiMove(hPS,&apt);
              apt.x = initx+no+lengthx;      //set position of following box (no = increase of Pel position)
         apt.y = inity;
         initx = apt.x;
         inity = apt.y;
         GpiMove( hPS, &apt);
          apt.x = ((tempx + lengthx)) + no;
         apt.y = tempy;
         tempx = apt.x;
         tempy = apt.y;





         inity = inity;
       }
}  // end else


} // end GpiShade1


/**************************************************************
*  Function Name:   GpiShade2(HPS, HWND, BOOL SelectionCall)  *
*                                                             *
*  Purpose:  Tests the shading of a graphic that features     *
*            overlapping boxes                                *
*                                                             *
*      By: Paul M. Ramey                                      *
*                                                             *
*  Returns VOID                                               *
**************************************************************/
VOID APIENTRY GpiShade2 (HPS hPS,HWND hWndClient,BOOL SelectionCall){





   INT     p;
   LONG    i;
   LONG    lcolor = 0L;
   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");



   p = 1000;

//Begin by drawing box that will underly pattern that will be drawn.
//Check screen and printout to see if this figure appears.

     apt.x = 925;
     apt.y = 375;
     MapPt(apt);
     GpiMove( hPS, &apt);
//Setup another loop that will generate the stacked boxes.

  for (i=1L;i<9L ;i++ ) {
     apt.x = 100;
     apt.y = (p - 100);
     MapPt(apt);




     GpiSetColor( hPS, i);


     GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
     apt.x = 10;
     apt.y = (p-100);
     MapPt(apt);
     GpiMove(hPS, &apt);
     GpiCharString(hPS, (long)strlen(whatis(i)), whatis(i));
     apt.x = 925;
     apt.y = 75;
     MapPt(apt);
     GpiMove(hPS, &apt);
     p = p - 100;
  } /* endfor */









}
}




/* Function: GpiShade3(HPS,HWND,BOOL Selection Call) */
/*           Tests the shading of overlapped circles.*/
/*           Returns: VOID                           */
/*    By Paul M. Ramey                               */



VOID APIENTRY GpiShade3 (HPS hPS,HWND hWndClient,BOOL SelectionCall){




   POINTL delta_ptl;
   ARCPARAMS arcparam1;


   INT     p,tempo,junk,n;
   LONG    i,g;
   LONG    lcolor = 0L;
   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");








   n = 400;
   g = 3 * 65536;        //set up multiplier
   p = 100;

//Set up arc parameters....

      set_delta(hPS);

      delta_ptl.x = delta_x/8;
      delta_ptl.y = delta_y/8;
      arcparam1.lR = 0L;
      arcparam1.lQ = 4*delta_ptl.y;
      arcparam1.lP = 4*delta_ptl.x;
      arcparam1.lS = 0L;
      MapArc(arcparam1);
      GpiSetArcParams(hPS,&arcparam1);



//Set up loop to draw filled and shaded circles.
      n = 400;

    junk = 1;
    for (i=1L;i<10L ;i++ ) {
     tempo = p+100;
     if(i==7){
        i++;
     }



     apt.x = ((p+180))*8;   //adjustment of x value for each time through loop
     apt.y = 925*5;
     MapPt(apt);
     GpiMove(hPS,&apt);


        GpiSetColor( hPS,i );
        GpiFullArc( hPS,DRO_OUTLINEFILL,g);
        junk = 0;
        p = tempo;

 } /* endfor */


 }
 }

/* Function: GpiShade4 tests FM_OR mode graphics by drawing rectangles         */
/* of different colors on the screen and then drawing the OR-ed result         */
/* using GpiSetMix. This value is compared with the color value that is        */
/* obtained by numerically oring the long value of the two colors and checking */
/* the value of this color in the color table                                  */

VOID APIENTRY GpiShade4 (HPS hPS,HWND hWndClient,BOOL
SelectionCall){
   long p;
   char str[100], str2[100];
   long color1 = CLR_BLUE;
   long color2;
      long initx,inity,whoa1,whoa2;
      long lengthx, lengthy;

      long tempx,tempy;
    LONG    lcolor = 0L;

   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");




      initx = 150;              //first x coordinate
      color1 = CLR_BLUE;        //initialize first two colors


      color2 = CLR_RED;

        inity = 850;        // first y coordinate
       p = 0L;              //initialize loop counter
       whoa1 = initx;
       whoa2 = inity;
   while (p<8){


   lengthx = 50;                //set length of rectangle on screen
   lengthy = lengthx;

      apt.x = initx;           //set  x value
      apt.y = inity;           //set  y value
      MapPt(apt);              //map the point and move there
      GpiMove(hPS,&apt);
      apt.x = initx - lengthx;
      apt.y = inity - lengthy;
       MapPt(apt);

      //set color and mix of first rectangle, then draw this rectangle

      GpiSetColor( hPS, color1);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

      //set the position of the first user message

      apt.x = initx-lengthx;
      apt.y = inity + 10;
      tempx = initx+lengthx+10+100;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS, &apt);
      sprintf(str, "%s (%ld) OR ",whatis(color1),color1);

      GpiSetColor(hPS, CLR_BLACK);




      GpiCharString(hPS, (long)strlen(str),str);

//position second rectangle
      apt.x = tempx + lengthx + 20;
      apt.y = inity;
      tempx = apt.x;
      tempy = apt.y;

      MapPt(apt);



      GpiMove(hPS, &apt);

 //draw box of second color

      apt.x = tempx  - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color2);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

   //set position of next user message

      apt.x = tempx - lengthx;

      apt.y = inity + 10;
      tempx = tempx+225;
      tempy = inity;
      MapPt(apt);



      GpiMove(hPS,&apt);


      sprintf(str2,"%s = (%ld) ",whatis(color2),color2  );
      GpiSetColor(hPS, CLR_BLACK);

      GpiCharString(hPS, (long) strlen(str2), str2);

//set coordinates of last rectangle (which features two previous colors OR-ed
//together)......

      apt.x = tempx;
      apt.y = inity;
      tempx = apt.x;
      tempy = apt.y;
      MapPt(apt);
      GpiMove(hPS, &apt);



      apt.x = tempx - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color1);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

      GpiSetMix( hPS, FM_OR);
      GpiSetColor(hPS, color2);

       GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
      ++p;                          //increment loop counter
      color1 = color1 + 2;         //increment values in color table
      color2 = color1 + 1;
      inity= inity - 100;
 }
}
}
/* This is GpiShade5. This test is practically the same as GpiShade4 with the
   exception that the colors are different. Also the color values are decremented
   instead of incremented.                                           */


VOID APIENTRY GpiShade5(HPS hPS,HWND hWndClient,BOOL SelectionCall){
   long p;
   char str[100], str2[100];
   long color1 = CLR_BLUE;
   long color2;
      long initx,inity,whoa1,whoa2;
      long lengthx, lengthy;

      long tempx,tempy;
    LONG    lcolor = 0L;

   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");
      initx = 150;
      color1 = CLR_PALEGRAY;
      color2 = CLR_BROWN;

        inity = 850;
       p = 15L;             //initialize loop counter to "top"
       whoa1 = initx;
       whoa2 = inity;
   while (p>8){


   lengthx = 50;          //set length of box
   lengthy = lengthx;

      apt.x = initx;
      apt.y = inity;
      MapPt(apt);
      GpiMove(hPS,&apt);

//Repeat procedure used in GpiShade4

      apt.x = initx - lengthx;
      apt.y = inity - lengthy;
       MapPt(apt);

      GpiSetColor( hPS, color1);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

      apt.x = initx-lengthx;
      apt.y = inity + 10;
      tempx = initx + lengthx + 10 +100;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS, &apt);
      sprintf(str, "%s (%ld) OR ",whatis(color1),color1);
      GpiSetColor(hPS,CLR_BLACK);
      GpiCharString(hPS, (long)strlen(str),str);
      apt.x = tempx + lengthx;
      apt.y = inity;
      tempx = apt.x;
      tempy = apt.y;
      MapPt(apt);
      GpiMove(hPS, &apt);
      apt.x = tempx  - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color2);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
      apt.x = tempx-lengthx;
      apt.y = inity + 10;
      tempx = tempx+ 225;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS,&apt);


      sprintf(str2,"%s (%ld) = ",whatis(color2),color2  );
      GpiSetColor(hPS, CLR_BLACK);

      GpiCharString(hPS, (long) strlen(str2), str2);
       apt.x = tempx-lengthx;
      apt.y = inity+10;
      tempx = tempx;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS, &apt);
      GpiSetColor(hPS, (color1|color2));

    //Draw OR-ed color box
      apt.x = tempx;
      apt.y = inity;
      MapPt(apt);
      GpiMove(hPS,&apt);
      apt.x = tempx - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color1);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
      GpiSetMix( hPS, FM_OR);
      GpiSetColor(hPS, color2);

       GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

//Decrement loop counter and change color of boxes

      --p;
      color1 = color1 - 2;
      color2 = color1 - 1;
      inity= inity - 100;
 }
}

}

/* Function:   GpiShade6(HPS, HWND,Bool SelectionCall); */

/* This test performs further testing of the FM_OR mix modes */
/* using rectangles                                          */






VOID APIENTRY GpiShade6 (HPS hPS,HWND hWndClient,BOOL
SelectionCall){
   long p;
   char str[100], str2[100];
   long color1 = CLR_PINK;
   long color2;
      long initx,inity,whoa1,whoa2;
      long lengthx, lengthy;

      long tempx,tempy;
    LONG    lcolor = 0L;

   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");




      initx = 150;              //first x coordinate
      color1 = CLR_BLUE;        //initialize first two colors


      color2 = CLR_PALEGRAY;

        inity = 850;        // first y coordinate
       p = 0L;              //initialize loop counter
       whoa1 = initx;
       whoa2 = inity;
   while (p<8){


   lengthx = 50;                //set length of rectangle on screen
   lengthy = lengthx;

      apt.x = initx;           //set  x value
      apt.y = inity;           //set  y value
      MapPt(apt);              //map the point and move there
      GpiMove(hPS,&apt);
      apt.x = initx - lengthx;
      apt.y = inity - lengthy;
       MapPt(apt);

      //set color and mix of first rectangle, then draw this rectangle

      GpiSetColor( hPS, color1);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

      //set the position of the first user message

      apt.x = initx-lengthx;
      apt.y = inity + 10;
      tempx = initx + lengthx + 10+100;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS, &apt);
      sprintf(str, "%s (%ld) OR",whatis(color1),color1);
      GpiSetColor(hPS,CLR_BLACK);
      GpiCharString(hPS, (long)strlen(str),str);

//position second rectangle
      apt.x = tempx + lengthx;
      apt.y = inity;
      tempx = apt.x;
      tempy = apt.y;

      MapPt(apt);

      GpiMove(hPS, &apt);

 //draw box of second color

      apt.x = tempx  - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color2);
      GpiSetMix(hPS, FM_OVERPAINT);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

   //set position of next user message

      apt.x = tempx -lengthx;
      apt.y = inity + 10;
      tempx = tempx + 225;
      tempy = inity;
      MapPt(apt);
      GpiMove(hPS,&apt);

      sprintf(str2,"%s (%ld) = ",whatis(color2),color2  );
      GpiSetColor(hPS, (CLR_BLACK));

      GpiCharString(hPS, (long) strlen(str2), str2);


//set coordinates of last rectangle (which features two previous colors OR-ed
//together)......

      apt.x = tempx;
      apt.y = inity;
      tempx = apt.x;
      tempy = apt.y;
      MapPt(apt);
      GpiMove(hPS, &apt);



      apt.x = tempx - lengthx;
      apt.y = inity - lengthy;
      MapPt(apt);
      GpiSetColor(hPS, color1);
      GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
      GpiSetMix( hPS, FM_OR);
      GpiSetColor(hPS, color2);
       GpiBox(hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

      ++p;                          //increment loop counter
      color1 = color1 + 1;         //increment values in color table
      color2 = color2-1;
      inity= inity - 100;
 }
}
}

/* GpiShade7 draws two figures upon the screen, a circle and a rectangle. The circle is shaded
     the color specified by the variable color1, and the rectangle is the "or-ed" result of color1 and
     the color specified by the variable color2.   */


VOID APIENTRY GpiShade7 (HPS hPS,HWND hWndClient,BOOL SelectionCall){

   POINTL delta_ptl;
   ARCPARAMS arcparam1;
   CHAR str[100];
   LONG    numb;
   LONG     po;
   LONG    lcolor = 0L;
    INT     p,tempo,junk,n;
   LONG    g;
    FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;
   color1 = CLR_BLUE;
   color2 = CLR_RED;

     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");

   //Set up arc parameters

   n = 400;
   g = 4 * 65536;
   p = 100;
      set_delta(hPS);

      delta_ptl.x = delta_x/8;
      delta_ptl.y = delta_y/8;
      arcparam1.lR = 0L;
      arcparam1.lQ = 4*delta_ptl.y;
      arcparam1.lP = 4*delta_ptl.x;
      arcparam1.lS =  0L;
      MapArc(arcparam1);
      GpiSetArcParams(hPS,&arcparam1);
   apt.x = 100*5;
   apt.y = 200*6;
   MapPt(apt);
   GpiMove(hPS,&apt);

   sprintf(str,"Color Table ORING. Circle = %s ,Invisible Rectangle = %s",whatis(color1),whatis(color2));
    numb = (long) strlen(str);
   GpiCharString(hPS,numb,str);
    junk = 1;

     //specify location of arc to be drawn, move there, and then draw the circle

     tempo = p+100;
     apt.x = ((p+400))*8;
     apt.y = 925*5;
     MapPt(apt);
     GpiMove(hPS,&apt);
     GpiSetColor( hPS, color1 );
        GpiFullArc( hPS,DRO_OUTLINEFILL,g);
     p = tempo;

     po = 1000;
   apt.x = 3000;
   apt.y = 5000;
   MapPt(apt);
   GpiMove( hPS, &apt);
     apt.x = 7000;
     apt.y = 9000;
     MapPt(apt);
     GpiSetMix(hPS, FM_OVERPAINT);
     GpiSetColor ( hPS,color2);
     GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
     GpiSetMix( hPS, FM_OR);
      GpiSetColor ( hPS, color1);
  GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);
     p = p-100;

}
}
/* This is the function whatis(name). When passed a long integer value, this */
/* function employs a switch statement to obtain the name of the corresponding */
/* color in the color table. (Returns a pointer to a character string) */


CHAR *whatis(long name){

switch((int) name){
case CLR_BLACK:
   color = "Black";
   break;
case CLR_WHITE:
   color = "White";

   break;
  case CLR_BLUE:
   color = "Blue";
   break;
case CLR_RED:
   color = "Red";
   break;
 case CLR_PINK:
   color = "Pink";
   break;
case CLR_GREEN:
   color = "Green";
   break;
case CLR_CYAN:
   color = "Cyan";
   break;
case CLR_YELLOW:
   color = "Yellow";
   break;
case CLR_NEUTRAL:
   color = "Neutral";
   break;
case CLR_DARKGRAY:
   color = "Darkgray";
   break;
case CLR_DARKBLUE:
   color = "Darkblue";
   break;
case CLR_DARKRED:
   color = "Darkred";
   break;
case CLR_DARKPINK:
   color = "Darkpink";
   break;
case CLR_DARKGREEN:
   color = "Darkgreen";
   break;
case CLR_DARKCYAN:
   color = "Darkcyan";
   break;
case CLR_BROWN:
   color = "Brown";
   break;
case 15:
   color = "Palegray";
   break;
default:
   color = "UNKNOWN";
 }
 return(color);







  }
/**************************************************************
*  Function Name: GpiShade8(Hps, HWND, BOOL SelectionCall)    *
*                 //BLUE                                      *
*                                                             *
*  Returns:  VOID                                             *
*                                                             *
*
**************************************************************/
VOID APIENTRY GpiShade8 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
static  POINTL       aptbl, aptblMapped;
static  POINTL       apttr, apttrMapped;
static  POINTL       apt;
LONG    ColorTable[255];
LONG    count;
LONG    RGBNumber = 1L;


  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");

    apt.x = 0;
    apt.y = 700;
    MapPt( apt );
    GpiCharStringAt( hPS, &apt, 61L, "All shades of Blue - RGB values from 0x00000001 to 0x000000FF" );

    aptbl.x = 0;
    aptbl.y = 100;
    apttr.x = 3;
    apttr.y = 120;

    GpiCreateLogColorTable( hPS, LCOL_RESET, LCOLF_RGB,
                            0L, 256L, ColorTable );

    for (count=0; count<=254; count+=1 ) {

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );

         GpiSetColor( hPS, RGBNumber );
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 3;
         apttr.x += 3;
         apttr.y += 2;

         RGBNumber += 1;

    } /* endfor */


}  // end else


} // end GpiShade8



/**************************************************************
*  Function Name: GpiShade9(Hps, HWND, BOOL SelectionCall)    *
*                                                             *
*  Purpose:  Draws rectangular boxes spaced apart by succesive*
*            Pel Units.                                       *
*                                                             *
*                                                             *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID APIENTRY GpiShade9 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
static  POINTL       aptbl, aptblMapped;
static  POINTL       apttr, apttrMapped;
static  POINTL       apt;
LONG    ColorTable[255];
LONG    count;
LONG    RGBNumber = 256L;


  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");


    apt.x = 0;
    apt.y = 700;
    MapPt( apt );
    GpiCharStringAt( hPS, &apt, 62L, "All shades of Green - RGB values from 0x00000100 to 0x0000FF00" );

    aptbl.x = 0;
    aptbl.y = 100;
    apttr.x = 3;
    apttr.y = 120;


    GpiCreateLogColorTable( hPS, LCOL_RESET, LCOLF_RGB,
                            0L, 256L, ColorTable );




    for (count=0; count<=254; count+=1 ) {

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );




         GpiSetColor( hPS, RGBNumber );
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 3;
         apttr.x += 3;
         apttr.y += 2;

         RGBNumber += 256;

    } /* endfor */


}  // end else


} // end GpiShade9



/**************************************************************
*  Function Name: GpiShade10(Hps, HWND, BOOL SelectionCall)    *
*                                                             *
*  Purpose:  Draws rectangular boxes spaced apart by succesive*
*            Pel Units.                                       *
*                                                             *
*                                                             *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID APIENTRY GpiShade10 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
static  POINTL       aptbl, aptblMapped;
static  POINTL       apttr, apttrMapped;
static  POINTL       apt;
LONG    ColorTable[255];
LONG    count;
LONG    RGBNumber = 65536L;


  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");


    apt.x = 0;
    apt.y = 700;
    MapPt( apt );
    GpiCharStringAt( hPS, &apt, 60L, "All shades of Red - RGB values from 0x00010000 to 0x00FF0000" );

    aptbl.x = 0;
    aptbl.y = 100;
    apttr.x = 3;
    apttr.y = 120;


    GpiCreateLogColorTable( hPS, LCOL_RESET, LCOLF_RGB,
                            0L, 256L, ColorTable );




    for (count=0; count<=254; count+=1 ) {

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );




         GpiSetColor( hPS, RGBNumber );
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 3;
         apttr.x += 3;
         apttr.y += 2;

         RGBNumber += 65536;

    } /* endfor */


}  // end else


} // end GpiShade10



/**************************************************************
*  Function Name: GpiShade11(Hps, HWND, BOOL SelectionCall)    *
*                                                             *
*  Purpose:  Draws rectangular boxes spaced apart by succesive*
*            Pel Units.                                       *
*                                                             *
*                                                             *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID APIENTRY GpiShade11 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
static  POINTL       aptbl, aptblMapped;
static  POINTL       apttr, apttrMapped;
static  POINTL       apt;
LONG    ColorTable[255];
LONG    count;
LONG    RGBNumber = 0L;


  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");


    apt.x = 0;
    apt.y = 700;
    MapPt( apt );
    GpiCharStringAt( hPS, &apt, 61L, "All shades of Gray - RGB values from 0x00000000 to 0xFFFFFFFF" );

    aptbl.x = 0;
    aptbl.y = 100;
    apttr.x = 3;
    apttr.y = 120;


    GpiCreateLogColorTable( hPS, LCOL_RESET, LCOLF_RGB,
                            0L, 256L, ColorTable );




    for (count=0; count<=254; count+=1 ) {

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );




         GpiSetColor( hPS, RGBNumber );
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 3;
         apttr.x += 3;
         apttr.y += 2;

         RGBNumber += 65536 + 256 + 1;

    } /* endfor */


}  // end else


} // end GpiShade11



/**************************************************************
*  Function Name: GpiShade12(Hps, HWND, BOOL SelectionCall)    *
*                                                             *
*  Purpose:  Draws rectangular boxes spaced apart by succesive*
*            Pel Units.                                       *
*                                                             *
*                                                             *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID APIENTRY GpiShade12 (HPS hPS,HWND hWndClient,BOOL SelectionCall){
static  POINTL       aptbl, aptblMapped;
static  POINTL       apttr, apttrMapped;
static  POINTL       apt;
LONG    ColorTable[255];
LONG    count;
LONG    RGBNumber = 0L;


  if (SelectionCall){
    // tell PTT to do the dev calls
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 1000;
    *pBasisY = 1000;

  }
  else{
    // check the operating environment
    WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

    TEST_SIGNATURE(0,0); // display signature to output device
    LOG_SIGNATURE;       // write signature to log file
    CWRITELOG(L_TRACE,0,"starting sample test one\n");


    apt.x = 0;
    apt.y = 700;
    MapPt( apt );
    GpiCharStringAt( hPS, &apt, 20L, "Many shades of Color" );

    aptbl.x = 0;
    aptbl.y = 100;
    apttr.x = 1;
    apttr.y = 120;


    GpiCreateLogColorTable( hPS, LCOL_RESET, LCOLF_RGB,
                            0L, 256, ColorTable );



    for (count=0L; count<=253L; count+=1L ) {

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );

         if( GpiSetColor( hPS, RGBNumber ) == FALSE )
         CWRITELOG(L_TRACE, 0, "GpiSetColor                   - Failed\n");

         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 1;
         apttr.x += 1;
         apttr.y += 1;

         RGBNumber += 256L;

         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );

         if( GpiSetColor( hPS, (LONG) RGBNumber ) == FALSE )
         CWRITELOG(L_TRACE, 0, "GpiSetColor                   - Failed\n");
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 1;
         apttr.x += 1;
         apttr.y += 1;


         RGBNumber += 65536L;


         aptblMapped.x = aptbl.x;
         aptblMapped.y = aptbl.y;
         apttrMapped.x = apttr.x;
         apttrMapped.y = apttr.y;

         MapPt( aptblMapped );
         MapPt( apttrMapped );

         if( GpiSetColor( hPS, (LONG) RGBNumber ) == FALSE )
         CWRITELOG(L_TRACE, 0, "GpiSetColor                   - Failed\n");
         GpiMove( hPS, &aptblMapped );
         GpiBox( hPS, DRO_FILL, &apttrMapped, 0L, 0L );

         aptbl.x += 1;
         apttr.x += 1;
         apttr.y += 1;

         RGBNumber += 1;

    } /* endfor */


}  // end else


} // end GpiShade12


VOID APIENTRY GpiShade13 (HPS hPS,HWND hWndClient,BOOL SelectionCall){




   POINTL delta_ptl;
   ARCPARAMS arcparam1;

   INT     p,tempo,junk,n;
   LONG    i,g,d,scraig,unk;
   LONG    lcolor = 0L;
   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;

   static  POINTL       apt;


     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");






   unk = 0;
   d = 7;
   n = 400;
   g =  d * 65536;        //set up multiplier
   p = 100;

//Set up arc parameters....

      set_delta(hPS);

      delta_ptl.x = delta_x/8;
      delta_ptl.y = delta_y/8;
     arcparam1.lR = 0L;
      arcparam1.lQ = 4*delta_ptl.y;
      arcparam1.lP = 4*delta_ptl.x;
      arcparam1.lS = 0L;
      MapArc(arcparam1);
      GpiSetArcParams(hPS,&arcparam1);



//Set up loop to draw filled and shaded circles.
      n = 400;
    scraig = 0;
    junk = 1;


    for (i=1L;i<7L ;i++ ) {
     tempo = p+100;

        d = d-1;

     if(d>0){

        g = (d) * 65536;



     apt.x = 580*8;   //adjustment of x value for each time through loop
     apt.y = 1005*5;
     MapPt(apt);
     GpiMove(hPS,&apt);


              if( GpiSetColor( hPS, i ) == FALSE )
              CWRITELOG(L_TRACE, 0, "GpiSetColor                   - Failed\n");


          GpiFullArc( hPS,DRO_OUTLINEFILL,g);
          unk = unk - 100;
     }
        junk = 0;
        p = tempo;

 } /* endfor */



 }

 }
  VOID APIENTRY GpiShade14 (HPS hPS,HWND hWndClient,BOOL SelectionCall){

   INT     p;
   LONG    i;
   LONG    lcolor = 0L;
   FIXED   fxmultiplier = FXTOLONG;
   FIXED   fxStartAngle = 0;
   FIXED   fxSweepAngle = FXTOLONG * 24;
   CHAR str[100],str2[100];
   static  POINTL       apt;

   p = 1000;
     if (SelectionCall){
       // tell PTT to do the dev calls
       WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 1000;
       *pBasisY = 1000;

     }
     else{
       // check the operating environment
       WinSendMsg (hWndClient, WM_GET_ENV_INFO, MPFROMP(&testenvinfo), NULL);

       TEST_SIGNATURE(0,0); // display signature to output device
       LOG_SIGNATURE;       // write signature to log file
       CWRITELOG(L_TRACE,0,"starting sample test one\n");






  for (i=9L;i<14L;i++ ) {
     apt.x = (100 * (i-8));
     apt.y = (p - 100);
     MapPt(apt);



     if(i != 9L){

      if(i==CLR_DARKCYAN){ i = CLR_BLACK; }
     GpiSetColor( hPS, i);


     GpiBox( hPS, DRO_OUTLINEFILL, &apt, 0L, 0L);

     apt.x = 10;
     apt.y = (p-100);
     MapPt(apt);
     GpiMove(hPS, &apt);
     sprintf (str, "Clr %s:", whatis(i), p);
     GpiCharString(hPS, (long)strlen(str), str);
     if (i==CLR_BLACK) {
      sprintf(str2, " (smallest box) ", str2);
      apt.x = 10;
      apt.y = (p-200);
      MapPt(apt);
      GpiMove(hPS,&apt);

      GpiCharString(hPS, (long)strlen(str2), str2);

     } /* endif */
     }
     apt.x = 900 - (100*(i-8));


     apt.y = (75 + (100*(i-8)));
     MapPt(apt);
     GpiMove(hPS, &apt);


     if(i == CLR_BLACK){ i = CLR_DARKCYAN; }



    p = p - 100;
  } /* endfor */


}
}
