#define INCL_DOSPROCESS
#define INCL_DEV      // include all DEV definitions
#define INCL_WIN      // include Win definitions
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gre error definitions
#include <string.h>
#include <stdlib.h>
#include <os2.h>
#include <stdio.h>
#include <limits.h>
#include "PTTDLLDF.h"  // test case defines.
#include "common1.h"
#include "common2.h"
#include "gpiseg.h"   // Test Definition File.

/****************************************************************************
 *\\ddd
 * Subtask Name: GREATT
 *
 * Module name: SEGEXH.C
 *
 * Purpose: This module is called by PTT via the GPISEG dynamic link
 *          library.  It contains the exhaustive entrypoints for the test
 *          case.
 *
 * Revision Log:  9/3/91 - GREATT, Initial Creation, Darin C. Hafer
 *
 * SAD References:
 *
 * SRS References:
 *
 * Contents:  GpiOpenSegmentExh()
 *            GpiDeleteSegmentExh()
 *            GpiDeleteSegmentsExh()
 *            GpiDrawChainExh1()
 *            GpiDrawChainExh2()
 *            GpiDrawAndRemoveDynamicsExh()
 *            GpiDrawFromExh1()
 *            GpiDrawFromExh2()
 *            GpiDrawSegmentExh()
 *            GpiEraseExh()
 *            GpiResetAndQryBoundaryDataExh()
 *            GpiSetAndQryInitSegmentAttrsExh()
 *            GpiSetAndQrySegmentAttrsExh()
 *            GpiQuerySegmentNamesExh()
 *            GpiSetAndQrySegmentPriorityExh()
 *            GpiSetAndQryStopDrawExh()
 *
 * Limitations:
 *
 *\\end
****************************************************************************/

/****************************************************************************
 *\\ddd
 * Routine Name: GpiOpenSegmentExh()
 *
 * Purpose:  This entrypoint will exhaustively test the GpiOpenSegment
 *           function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/3/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 *
 * Subroutines Required:
 *     RandPels()
 *     SetInitialSegmentAttrs()
 *     MapAndWriteString()
 *
 * Limitations:
 *  1) This does not at all test all the possible
 *     environment settings in which GpiOpenSegment is used
 *     as this would be virtually impossible and would take
 *     hours to run.  It does test opening segments in the
 *     three different drawing modes.
 *
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Reinitialize the random number generator.
 *   Allocate space to store segment identifiers.
 *   for (DrawMode=DM_DRAW; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
 *      Initialize descriptive text and color.
 *      GpiSetDrawingMode(hPS, DrawMode);
 *      Call SetInitialSegmentAttrs() to set up Segment attributes.
 *      Call RandPels() to draw 16381 random pels within a box.
 *      log error if more than 16378 segments are retained.
 *      if (DrawMode != DM_DRAW) {
 *         if (DrawMode == DM_DRAWANDRETAIN)
 *            Set color to the background.
 *         Draw the chain of pels.
 *      }
 *      Delete the segments.
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiOpenSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiOpenSegmentExh";
 SEGMENTATTRS SegAttributes[3] = { ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                                   ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                                   ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE
                                 };
 PVOID  Buffer = NULL;
 RECTL  rclPel;
 LONG   yCoord=600L, DrawMode, Return, Finish ,rc;
 CHAR   szBuffer[100];
 CHAR   szPast1[100];
 CHAR   szPast2[100];
   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      srand(1);

      DosAllocMem(&Buffer,65536L,
                     PAG_READ | PAG_WRITE | PAG_COMMIT);

      rclPel.xLeft = 100L;
      rclPel.xRight= 350L;

      for (DrawMode=DM_DRAW; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
           switch ((INT) DrawMode) {
              case DM_DRAW:
                 strcpy(szAddMessage, "DM_DRAW");
                 strcpy(szBuffer, "Segments are being drawn");
                 strcpy(szPast1, "Segments were drawn");
                 break;

              case DM_RETAIN:
                 strcpy(szAddMessage, "DM_RETAIN");
                 strcpy(szBuffer, "Segments are being retained in memory - Will take some time...");
                 strcpy(szPast1, "Segments were retained in memory");
                 break;

              case DM_DRAWANDRETAIN:
                 strcpy(szAddMessage, "DM_DRAWANDRETAIN");
                 strcpy(szBuffer, "Segments are being drawn, and retained in memory - Will take SEVERAL minutes...");
                 strcpy(szPast1, "Segments were drawn, and retained in memory");
                 break;
              default:
                 strcpy(szAddMessage, "Unknown Draw Mode");
                 break;
           }

           /* I am writing this out before the mode is actually set   */
           /* because MapAndWriteString MUST !!! be used in Draw mode.*/
           GpiSetColor(hPS, CLR_BLACK);
           sprintf(achLogLine, "Drawing Mode is %s, Creating randomly placed segments...", szAddMessage);
           sprintf(szPast2, "Drawing Mode was %s, Created randomly placed segments...", szAddMessage);
           strcpy(szAddMessage, achLogLine);
           MapAndWriteString(50L, yCoord, achLogLine);
           GpiSetColor(hPS, CLR_BLUE);
           MapAndWriteString(100L, yCoord-25L, szBuffer);
           GpiSetColor(hPS, CLR_BLACK);


           if (!GpiSetDrawingMode(hPS, DrawMode)) {
              ErrorCount++;
              ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
           }

           Return = GpiQueryDrawingMode(hPS);

         SUBENTER(Segment Identifier Range, NULL);
           Finish = (Return == DM_DRAW ? 327L : MAX_SEG);
           SetInitialSegmentAttrs(hPS, &SegAttributes[Return-1]);
           rclPel.yBottom = yCoord-120L;
           rclPel.yTop    = yCoord-35L;
           if (Return==DM_DRAW) {
              if (!RandPels(hPS, hWndClient, Finish, &rclPel, 0x02))
                 ERRSTATUS(TRUE, "RandPels()", EntryName);
           } else {
              if (rc = !RandPels(hPS, hWndClient, Finish, &rclPel, 0x00))
                 ERRSTATUS(TRUE, "RandPels()", EntryName);
           }
           Return = GpiQuerySegmentNames(hPS, FIRST_SEG, MAX_SEG,
                                         MAX_SEG, Buffer);
           if (Return == GPI_ALTERROR) {
              ErrorCount++;
              sprintf(achLogLine, "%ld existing retained segments"
                                 "  exceeded the documented limit of 16381", Return);
              LOGINFO(L_HDR, "@", achLogLine);
           }

           if (DrawMode != DM_DRAW) {
              if (!GpiResetPS(hPS, GRES_ATTRS)) {
                 ErrorCount++;
                 ERRSTATUS(TRUE, "GpiResetPS()", NULL);
              }

              if (DrawMode == DM_DRAWANDRETAIN)
                 GpiSetColor(hPS, CLR_BACKGROUND);

              if (!GpiDrawChain(hPS)) {
                 ErrorCount++;
                 ERRSTATUS(TRUE, "GpiDrawChain()",EntryName);
              }

              if (DrawMode == DM_DRAWANDRETAIN) {
                 GpiSetColor(hPS, CLR_BLACK);
                 strcpy(achLogLine, "No pels/pixels should show.");
                 MapAndWriteString(525L, yCoord-95L, achLogLine);
              }
           }
           GpiSetColor(hPS, CLR_BACKGROUND);
           MapAndWriteString(50L, yCoord, szAddMessage);
           MapAndWriteString(100L, yCoord-25L, szBuffer);
           GpiSetColor(hPS, CLR_BLACK);
           MapAndWriteString(50L, yCoord, szPast2);
           GpiSetColor(hPS, CLR_BLUE);
           MapAndWriteString(100L, yCoord-25L, szPast1);

           yCoord -= 135L;

           if (DrawMode != DM_DRAW) {
              sprintf(achLogLine, "%ld Total segments retained, now deleting them", Return);
              MapAndWriteString(100L, yCoord, achLogLine);
           } else {
              sprintf(achLogLine, "%ld Total segments retained", Return);
              MapAndWriteString(100L, yCoord, achLogLine);
           }
           if (!GpiDeleteSegments(hPS, FIRST_SEG, MAX_SEG)) {
              ErrorCount++;
              ERRSTATUS(TRUE, "GpiDeleteSegments()",EntryName);
           }
           strcpy(achLogLine, " - DONE !");
           MapAndWriteString(650L, yCoord, achLogLine);
           yCoord -= 40L;
         SUBEXIT();
      } /* For DrawMode Loop */

      DosFreeMem(Buffer);
      EXIT_MAIN(EntryName);
   }
  return;
}

 /****************************************************************************
 *\\ddd
 * Routine Name: GpiDeleteSegmentExh
 *
 * Purpose:  This entrypoint will exhaustively test the GpiDeleteSegment
 *           function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/5/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 *
 * Subroutines Required:
 *     DeleteSegment()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DeleteSegment() with the SINGLE flag.  This flags the use of the
 *     GpiDeleteSegment() function.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDeleteSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDeleteSegmentExh";


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }

      ENTER_MAIN(EntryName);
      DeleteSegment(hPS, hWndClient, SINGLE);
      EXIT_MAIN(EntryName);
   }
   return;
}

 /****************************************************************************
 *\\ddd
 * Routine Name: GpiDeleteSegmentsExh
 *
 * Purpose:  This entrypoint will exhaustively test the GpiDeleteSegments
 *           function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/5/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 *
 * Subroutines Required:
 *     DeleteSegment()
 *     SetInitialSegmentAttrs()
 *     OpenAndClose()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Set the drawing Mode to RETAIN.
 *   Set the segment attributes.
 *   Call OpenAndClose() to open a segment, draw something and close it.
 *   Call GpiDeleteSegments() with the first param greater than the last.
 *   Call DeleteSegment() with the RANGE flag.  This flags the use of the
 *     GpiDeleteSegments() function call.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDeleteSegmentsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDeleteSegmentsExh";
 POINTL ptlPoint={50, 200};


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }

      ENTER_MAIN(EntryName);

      SETENTER(" ", "TEST 0 - Create a Segment");
        GpiSetDrawingMode(hPS, DM_RETAIN);
        SetInitialSegmentAttrs(hPS, &SegAttrs[0]);
        sprintf(achLogLine, "Segment %ld in TEST 0", Seg5);
        if (!OpenAndClose(hPS, TRUE, Seg1, achLogLine, &ptlPoint))
           ERRSTATUS(TRUE, "OpenAndClose()", EntryName);
      SETEXIT();

      SUBENTER(First is greater than last, NULL);
        if (!GpiDeleteSegments(hPS, Seg5, Seg1)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "Deleting Segment %ld", ltoa(Seg1, achLogLine, 10));
        }
        /* This tests the validity of deleting */
        /* a segment. If PMERR_SEG_NOT_FOUND is*/
        /* returned, then the delete worked.   */
        if (!GpiDrawSegment(hPS, Seg5)) {
           error=WinGetLastError(hPS);
           if (ERRORIDERROR(error) != PMERR_SEG_NOT_FOUND) {
              ErrorCount++;
           }
        }
      SUBEXIT();
      DeleteSegment(hPS, hWndClient, RANGE);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawChainExh1
 *
 * Purpose:  This entrypoint will exhaustively test the GpiDrawChain
 *           function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/10/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 *
 * Subroutines Required:
 *     DrawFromOrChain1()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DrawFromOrChain1() with the CHAIN flag.  This flags the use of the
 *     GpiDrawChain() function call.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawChainExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawChainExh1";

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }

      ENTER_MAIN(EntryName);
      DrawFromOrChain1(hPS, hWndClient, CHAIN);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawChainExh2
 *
 * Purpose: This entrypoint will exhaustively test the GpiDrawChain
 *          function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/10/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     DrawFromOrChain2()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DrawFromOrChain2() with the CHAIN flag.  This flags the use of the
 *     GpiDrawChain() function call.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawChainExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawChainExh2";

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      DrawFromOrChain2(hPS, hWndClient, CHAIN);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawAndRemoveDynamicsExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiDrawDynamics and
 *          GpiRemoveDynamics function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/17/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     CreateSegmentChain()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Make a copy of the global "SegAttrs" structure so I can change the values
 *     accordingly.
 *   Set up segments 1 and 3 to be dynamic.
 *   Call CreateSegmentChain() to create four segments in RETAIN mode.
 *   Draw the non-dynamic segments.
 *   Draw the dynamic segments.
 *   if the device is the display, NumberOfTimes=3.
 *   for (Move=1; Move<=NumberOfTimes; Move++) {
 *      Remove the dynamic segments.
 *      Set the segment transform to move the chain over 2 inches.
 *      Redraw the dynamic segments.
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawAndRemoveDynamicsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawAndRemoveDynamicsExh";
 MATRIXLF MatStruct;
 LONG     Move, NumberOfTimes=1L;
 SEGMENTATTRS TempAttrs[8];

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }

      ENTER_MAIN(EntryName);

      SETENTER(" ", "Create segment chain");
         memcpy((PVOID)TempAttrs, (PVOID)SegAttrs, sizeof(SegAttrs));
         TempAttrs[0].Dynamic = ATTR_ON;
         TempAttrs[0].FastChain=ATTR_OFF;
         TempAttrs[2].Dynamic = ATTR_ON;

         CreateSegmentChain(hPS, hWndClient, TempAttrs, Seg1, Seg4, TYPE_RETAIN);

         if (!GpiResetPS(hPS, GRES_ATTRS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiResetPS()", NULL);
         }
         if (!GpiDrawChain(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDrawChain()", NULL);
         }
         if (!GpiResetPS(hPS, GRES_ATTRS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiResetPS()", NULL);
         }
         if (!GpiDrawDynamics(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDrawDynamics() - 1", NULL);
         }
         if (DeviceIsDisplay())
            NumberOfTimes = 3;
      SETEXIT();

      SUBENTER(Draw and Remove Dynamics, NULL);
         for (Move=1; Move<=NumberOfTimes; Move++) {
            if (!GpiRemoveDynamics(hPS, Seg1, Seg4)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiRemoveDynamics()", NULL);
            }

            MatStruct.fxM11 = MAKEFIXED(1, 0);
            MatStruct.fxM12 = MAKEFIXED(0, 0);
            MatStruct.lM13  = 0L;
            MatStruct.fxM21 = MAKEFIXED(0, 0);
            MatStruct.fxM22 = MAKEFIXED(1, 0);
            MatStruct.lM23  = 0L;
            MatStruct.lM31  = MapX(200L*Move);
            MatStruct.lM32  = 0L;
            MatStruct.lM33  = 1L;

            if (!GpiSetSegmentTransformMatrix(hPS, Seg1, 9L, &MatStruct,TRANSFORM_REPLACE)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiSetSegmentTransformMatrix()", NULL);
            }
            if (!GpiResetPS(hPS, GRES_ATTRS)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiResetPS()", NULL);
            }
            if (!GpiDrawDynamics(hPS)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiDrawDynamics() - 2", NULL);
            }
         }
      SUBEXIT();
      WriteText(Seg1, Seg4);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawFromExh1
 *
 * Purpose: This entrypoint will exhaustively test the GpiDrawFrom
 *          function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/10/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     DrawFromOrChain1()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DrawFromOrChain1() with the FROM flag.  This flags the use of the
 *     GpiDrawFrom() function call.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawFromExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawFromExh1";

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      DrawFromOrChain1(hPS, hWndClient, FROM);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawFromExh2
 *
 * Purpose: This entrypoint will exhaustively test the GpiDrawFrom
 *          function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/10/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     DrawFromOrChain2()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DrawFromOrChain2() with the FROM flag.  This flags the use of the
 *     GpiDrawFrom() function call.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawFromExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawFromExh2";

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      DrawFromOrChain2(hPS, hWndClient, FROM);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiDrawSegmentExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiDrawSegment
 *          function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/20/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     DrawSegment()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call DrawSegment().
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiDrawSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiDrawSegmentExh";


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      DrawSegment(hPS, hWndClient);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
   return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiEraseExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiErase function
 *           call with all four type of clipping.
 *
 * System Requirements:
 *
 * Revision Log: 9/25/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     Scribble()
 *     SetInitialSegmentAttrs()
 *
 * Limitations:
 *     This entrypoint does not produce printer output that matches the
 *     display.  GpiErase only erases the ouput display.  According to
 *     Appendix D of the 1.3 upgrade of the Programming Reference, GpiErase
 *     should not be used when creating metafiles.
 *     You will notice that the scribble in the clip region either does not
 *     appear or causes a mess when printed PM_Q_STD and OD_QUEUED.  This is
 *     because GpiSetClipRegion will not work when creating SAA-conforming
 *     metafiles and the GpiSetPageViewport call is ignored.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   if (OD_QUEUED and PM_Q_STD) abortentry;
 *   Reinitialize the random number generator.
 *   Allocate memory to hold an array of pointl structures for the
 *     Scribble function.
 *   Set drawing mode to DM_RETAIN.
 *   Set initial segment attributes to the default.
 *   Open the clip path segment.
 *   Set arc parameters.
 *   Begin path.
 *   Draw arc.
 *   End path.
 *   Set clip path.
 *   Call the Scribble subroutine to draw in the clip path.
 *   Close the clip path segment.
 *   Draw the clip path segment.
 *   Call GpiErase to clear the output display of the Device Context.
 *
 *   Set drawing mode to DM_RETAIN.
 *   Set initial segment attributes to the default.
 *   Open the viewing limits segment.
 *   Set the viewing limits.
 *   Call the Scribble subroutine to draw in the viewing limits.
 *   Close the viewing limits segment.
 *   Set the Model Transform.
 *   Draw the viewing limits segment.
 *   Call GpiErase to clear the output display of the Device Context.
 *
 *   Set drawing mode to DM_RETAIN.
 *   Set initial segment attributes to the default.
 *   Open the graphics field segment.
 *   Set the graphics field.
 *   Call the Scribble subroutine to draw in the graphics field.
 *   Close the graphics field segment.
 *   Set the Default View Matrix.
 *   Draw the graphics field segment.
 *   Call GpiErase to clear the output display of the Device Context.
 *
 *   Set drawing mode to DM_RETAIN.
 *   Set initial segment attributes to the default.
 *   Open the clip region segment.
 *   Create a region.
 *   Set the clip region.
 *   Call the Scribble subroutine to draw in the clip region.
 *   Close the clip region segment.
 *   Set the Page Viewport.
 *   Draw the clip region segment.
 *   Call GpiErase to clear the output display of the Device Context.
 *
 *   Free allocated memory.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiEraseExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiEraseExh";
 POINTL       ptl;
 POINTL      *Top;
 INT          size=2;
 ARCPARAMS    arc_parameters;
 MATRIXLF     Matrix;
 RECTL        rect;
 HRGN         hrgn1;
 PVOID       LineSelector = NULL;
 LONG lDCType;
 DEVOPENSTRUC   dop;
 DRIVDATA driv;


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {

      dop.pdriv = &driv;
      WinSendMsg(hWndClient,WM_GET_DEVOPENSTRUC,MPFROMP(&dop), MPFROMP(&lDCType));

      if (DeviceIsPrinter() && lDCType==OD_QUEUED && strcmp("PM_Q_STD", dop.pszDataType)==0) {
         ABORTENTRY(EntryName, "OD_QUEUED & PM_Q_STD Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      else {
         if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
            ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
            DeletePrinterOutput(EntryName);
            return;
         }
      }

      ENTER_MAIN(EntryName);

      SETENTER(" ", "Set Clip Path");
        srand(1);

        DosAllocMem((PVOID)&Top,65536L,
                        PAG_READ | PAG_WRITE | PAG_COMMIT);

        if (!GpiSetDrawingMode(hPS, DM_RETAIN)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
        }
        SetInitialSegmentAttrs(hPS, &SegAttrs[0]);
        if (!GpiOpenSegment(hPS, CLIP_PATH)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
        }
        arc_parameters.lR = MapX(0L);
        arc_parameters.lQ = MapY(delta_y/2);
        arc_parameters.lP = MapX(delta_x/2);
        arc_parameters.lS = MapY(0L);
        if (!GpiSetArcParams(hPS, &arc_parameters)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetArcParams()", EntryName);
        }
        ptl.x =  MapX(2 * delta_x);
        ptl.y =  MapY(2 * delta_y);
        if (!GpiBeginPath(hPS, 1L)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiBeginPath()", EntryName);
        }
        GpiMove(hPS, &ptl);
        GpiFullArc(hPS, DRO_OUTLINE, MAKEFIXED(size, 0));
        if (!GpiEndPath(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiEndPath()", EntryName);
        }
        if (!GpiSetClipPath(hPS, 1L, SCP_ALTERNATE | SCP_AND)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetClipPath()", EntryName);
        }
        if (!Scribble(hPS, hWndClient, Top))
           ERRSTATUS(TRUE, "Scribble()", EntryName);
        if (!GpiCloseSegment(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
        }
        if (!GpiDrawSegment(hPS, CLIP_PATH)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiDrawSegment()", EntryName);
        }
      SETEXIT();

      SUBENTER(Call GpiErase, NULL);
        if (!GpiErase(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiErase()", EntryName);
        }
      SUBEXIT();

        /*----------------------------------------------------------*/

      SETENTER(" ", "Set Viewing Limits");
        if (!GpiSetDrawingMode(hPS, DM_RETAIN)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
        }
        SetInitialSegmentAttrs(hPS, &SegAttrs[0]);
        if (!GpiOpenSegment(hPS, VIEW_LIMIT)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
        }
        rect.xLeft   = MapX(4 * delta_x);
        rect.yBottom = MapY(delta_y);
        rect.xRight  = MapX(5 * delta_x);
        rect.yTop    = MapY(3 * delta_y);
        if (!GpiSetViewingLimits(hPS, &rect)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetViewingLimits()", EntryName);
        }
        if (!Scribble(hPS, hWndClient, Top))
           ERRSTATUS(TRUE, "Scribble()", EntryName);
        if (!GpiCloseSegment(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
        }
        if (!GpiSetModelTransformMatrix( hPS, 0L, &Matrix, TRANSFORM_ADD )) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetModelTransformMatrix()", EntryName);
        }
        if (!GpiDrawSegment(hPS, VIEW_LIMIT)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiDrawSegment()", EntryName);
        }
      SETEXIT();

      SUBENTER(Call GpiErase, NULL);
        if (!GpiErase(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiErase()", EntryName);
        }
      SUBEXIT();

        /*----------------------------------------------------------*/

      SETENTER(" ", "Set Graphics Field");
        if (!GpiSetDrawingMode(hPS, DM_RETAIN)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
        }
        SetInitialSegmentAttrs(hPS, &SegAttrs[0]);
        if (!GpiOpenSegment(hPS, GRAPHICS_FIELD)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
        }
        rect.xLeft   = MapX(6 * delta_x);
        rect.yBottom = MapY(delta_y);
        rect.xRight  = MapX(7 * delta_x);
        rect.yTop    = MapY(3 * delta_y);
        if (!GpiSetGraphicsField(hPS, &rect)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetGraphicsField()", EntryName);
        }
        if (!Scribble(hPS, hWndClient, Top))
           ERRSTATUS(TRUE, "Scribble()", EntryName);
        if (!GpiCloseSegment(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
        }
        if (!GpiSetDefaultViewMatrix( hPS, 0L, &Matrix, TRANSFORM_ADD )) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetDefaultViewMatrix()", EntryName);
        }
        if (!GpiDrawSegment(hPS, GRAPHICS_FIELD)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiDrawSegment()", EntryName);
        }
      SETEXIT();

      SUBENTER(Call GpiErase, NULL);
        if (!GpiErase(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiErase()", EntryName);
        }
      SUBEXIT();

        /*----------------------------------------------------------*/

      SETENTER(" ", "Set Clip Region");
        if (!GpiSetDrawingMode(hPS, DM_RETAIN)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
        }
        SetInitialSegmentAttrs(hPS, &SegAttrs[0]);
        if (!GpiOpenSegment(hPS, CLIP_REGION)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
        }
        rect.xLeft   = MapX(150);
        rect.yBottom = MapY(5 * delta_y);
        rect.xRight  = MapX(7 * delta_x);
        rect.yTop    = MapY(6 * delta_y);
        if ((hrgn1=GpiCreateRegion(hPS,1L,&rect)) == RGN_ERROR) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiCreateRegion()", EntryName);
        }
        GpiSetClipRegion(hPS,hrgn1,NULL);
        if (!Scribble(hPS, hWndClient, Top))
           ERRSTATUS(TRUE, "Scribble()", EntryName);
        if (!GpiCloseSegment(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
        }

        if (GpiSetPageViewport(hPS, &rect) == FALSE) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiSetPageViewport()", EntryName);
        }
        if (!GpiDrawSegment(hPS, CLIP_REGION)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiDrawSegment()", EntryName);
        }
      SETEXIT();

      SUBENTER(Call GpiErase, NULL);
        if (!GpiErase(hPS)) {
           ErrorCount++;
           ERRSTATUS(TRUE, "GpiErase()", EntryName);
        }
      SUBEXIT();

      DosFreeMem((PVOID)Top);
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiResetAndQryBoundaryDataExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiResetBoundaryData
 *          and GpiQueryBoundaryData function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/25/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     CreateSegmentChain()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Get the line spacing.
 *   for (Mode=TYPE_DRAW; Mode<=TYPE_RETAIN; Mode<<=1) {
 *      for (SegID=i; SegID<=i+3; SegID++) {
 *         Turn Boundary determination ON.
 *         Create segment SegID.
 *         if (Mode & TYPE_RETAIN) {
 *            Draw the segment.
 *            Turn Boundary Determination OFF.
 *         } else {
 *            Turn Boundary Determination OFF.
 *         }
 *         Query the Boundary Data.
 *         if ((Mode & TYPE_DRAW) && (SegID<3)) {
 *            Reset the Boundary Data.
 *         }
 *         Convert the coordinates back to WORLD
 *         Draw a box with the Boundary Data.
 *      }
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiResetAndQryBoundaryDataExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiResetAndQryBoundaryDataExh";
 RECTL        rclBoundary;
 POINTL       ptlPoint;
 LONG         i=Seg1, SegID;
 BYTE         Mode;

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);

      strcpy(achLogLine, "The coordinates represent the lower left corner"
                         " and the upper right");
      MapAndWriteString(25L, (pg_size_y*delta_y)-63, achLogLine);
      strcpy(achLogLine, "corner of the boxes that border around the"
                         " 'plus' signs.");
      MapAndWriteString(25L, ((pg_size_y-1L)*delta_y)-20, achLogLine);

      SUBENTER(Query and/or Reset Boundary Data, NULL);
         for (Mode=TYPE_DRAW; Mode<=TYPE_RETAIN; Mode<<=1) {
            for (SegID=i; SegID<=i+3; SegID++) {
               if (!GpiSetDrawControl(hPS, DCTL_BOUNDARY, DCTL_ON)) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiSetDrawControl()", EntryName);
               }
               CreateSegmentChain(hPS, hWndClient, SegAttrs, SegID, SegID, (BYTE)Mode);
               if (Mode & TYPE_RETAIN) {
                  if (!GpiResetPS(hPS, GRES_ATTRS)) {
                     ErrorCount++;
                     ERRSTATUS(TRUE, "GpiResetPS()", NULL);
                  }
                  if (!GpiDrawFrom(hPS, SegID, SegID)) {
                     ErrorCount++;
                     ERRSTATUS(TRUE, "GpiDrawFrom()", EntryName);
                  }
                  if (!GpiSetDrawControl(hPS, DCTL_BOUNDARY, DCTL_OFF)) {
                     ErrorCount++;
                     ERRSTATUS(TRUE, "GpiSetDrawControl()", EntryName);
                  }
                  WriteSegmentText(SegID, SegID);
               }
               if (Mode & TYPE_DRAW) {
                  WriteSegmentText(SegID, SegID);
                  if (!GpiSetDrawControl(hPS, DCTL_BOUNDARY, DCTL_OFF)) {
                     ErrorCount++;
                     ERRSTATUS(TRUE, "GpiSetDrawControl()", EntryName);
                  }
               }
               if (!GpiQueryBoundaryData(hPS, &rclBoundary)) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiQueryBoundaryData()", EntryName);
               }
               if ((Mode & TYPE_DRAW) && (SegID<3)) {
                 if (!GpiResetBoundaryData(hPS)) {
                    ErrorCount++;
                    ERRSTATUS(TRUE, "GpiResetBoundaryData()", EntryName);
                 }
               }
               if (!GpiConvert(hPS, CVTC_MODEL, CVTC_WORLD, 2L, (PPOINTL)&rclBoundary)) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiConvert()", EntryName);
               }
               ptlPoint.x = rclBoundary.xRight + 10L;
               ptlPoint.y = rclBoundary.yTop - (2*syPosition);
               GpiMove(hPS, &ptlPoint);
               sprintf(achLogLine, "(%ld, %ld)", rclBoundary.xLeft,
                                                 rclBoundary.yBottom);
               GpiCharStringAt(hPS, &ptlPoint, strlen(achLogLine), achLogLine);
               ptlPoint.y -= syPosition;
               sprintf(achLogLine, "(%ld, %ld)", rclBoundary.xRight,
                                                 rclBoundary.yTop);
               GpiCharStringAt(hPS, &ptlPoint, strlen(achLogLine), achLogLine);

               ptlPoint.x = rclBoundary.xLeft;
               ptlPoint.y = rclBoundary.yBottom;
               GpiMove(hPS, &ptlPoint);
               ptlPoint.x = rclBoundary.xRight;
               ptlPoint.y = rclBoundary.yTop;
               if (GpiBox(hPS, DRO_OUTLINE, &ptlPoint, 0L, 0L) == GPI_ERROR) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiBox()", EntryName);
               }
            } /* for (SegID  */
            i=Seg5;
         } /* for (Mode= */
      SUBEXIT();
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryInitSegmentAttrsExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiSetInitialSegmentAttrs
 *          and GpiQueryInitialSegmentAttrs function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/26/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     SetAndQueryLoop()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call SetAndQueryLoop() subroutine with a FALSE.  This flags the use of
 *     the GpiSetInitialSegmentAttrs and GpiQueryInitialSegmentAttrs function
 *     calls.
 *   Call DeletePrinterOutput() subroutine.
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQryInitSegmentAttrsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiSetAndQryInitSegmentAttrsExh";


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      SUBENTER(Call SetAndQueryLoop, NULL);
         SetAndQueryLoop(hPS, hWndClient, FALSE);
      SUBEXIT();
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQrySegmentAttrsExh
 *
 * Purpose: This entrypoint will exhaustively test the GpiSetSegmentAttrs
 *          and GpiQuerySegmentAttrs function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/26/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     SetAndQueryLoop()
 *     DeletePrinterOutput()
 *     CreateSegmentChain()
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   for (DrawMode=DM_RETAIN; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
 *      Set the drawing mode.
 *      Open segment Seg1.
 *      Call SetAndQueryLoop() subroutine with TRUE.  This flags the use of
 *        the GpiSetSegmentAttrs and GpiQuerySegmentAttrs function calls.
 *      Close segment Seg1.
 *      Call SetAndQueryLoop() subroutine with TRUE.  This flags the use of
 *        the GpiSetSegmentAttrs and GpiQuerySegmentAttrs function calls.
 *      Delete segment Seg1.
 *   }
 *   Call CreateSegmentChain() with segments 3-6 being unchained.
 *   Draw the chain.
 *   for (SegID=3L; SegID<=6L; SegID++) {
 *      Make segment SegID chained.
 *      Draw the chain.
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQrySegmentAttrsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiSetAndQrySegmentAttrsExh";
 LONG   SegID, DrawMode;
 SEGMENTATTRS TempAttrs[8];


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);

      for (DrawMode=DM_RETAIN; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
         SETENTER(" ", "Open a Segment");
            if (!GpiSetDrawingMode(hPS, DrawMode)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
            }
            if (!GpiOpenSegment(hPS, Seg1)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
            }
         SETEXIT();
         SUBENTER(Set and Query Attributes, NULL);
            SetAndQueryLoop(hPS, hWndClient, TRUE);
         SUBEXIT();
         if (!GpiCloseSegment(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
         }
         SUBENTER(Call SetAndQueryLoop, NULL);
            SetAndQueryLoop(hPS, hWndClient, TRUE);
         SUBEXIT();
         if (!GpiDeleteSegment(hPS, Seg1)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDeleteSegment()", EntryName);
         }
      }
      SETENTER(" ", "Create chain");
         memcpy((PVOID)TempAttrs, (PVOID)SegAttrs, sizeof(SegAttrs));
         for (SegID=3L; SegID<=6L; SegID++) {
             TempAttrs[SegID-1L].Chained = ATTR_OFF;
         }
         CreateSegmentChain(hPS, hWndClient, TempAttrs, Seg1, Seg8, TYPE_RETAIN);

         if (!GpiDrawChain(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDrawChain()", EntryName);
         }
      SETEXIT();
      SUBENTER(Set and Query, NULL);
         for (SegID=3L; SegID<=6L; SegID++) {
            if (!GpiSetSegmentAttrs(hPS, SegID, ATTR_CHAINED, ATTR_ON)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "Set Chain", NULL);
            }
            if (GpiQuerySegmentAttrs(hPS, SegID, ATTR_CHAINED) != ATTR_ON) {
               ErrorCount++;
               ERRSTATUS(TRUE, "Query Chain", NULL);
            }
            if (!GpiDrawChain(hPS)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiDrawChain()", EntryName);
            }
         }
      SUBEXIT();
      WriteText(Seg1, Seg8);
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name:  GpiQuerySegmentNamesExh
 *
 * Purpose:  This entrypoint will exhaustively test the GpiQuerySegmentNames
 *           function call.
 *
 * System Requirements:
 *
 * Revision Log: 9/30/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   for (DrawMode=DM_RETAIN; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
 *      Set the drawing mode.
 *      Open and Close segment FIRST_SEG.
 *      Open and Close segment LONG_MAX.
 *      for (SegID=1; SegID<=10; SegID++) {
 *         Open and Close a segment from 1 to LONG_MAX-1.
 *      }
 *      Query names from 1 to LONG_MAX.
 *      Query names from LONG_MAX to LONG_MAX.
 *      Query names from LONG_MAX to 1.
 *      Delete segments.
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQuerySegmentNamesExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiQuerySegmentNamesExh";
 LONG *Buffer, DrawMode, Return;
 register INT SegID;


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);
      //32 bit
      if(DosAllocMem((PVOID)&Buffer, 0xFFFF,
                     PAG_READ | PAG_WRITE | PAG_COMMIT) == NO_ERROR){
          CLEANUP("DosAllocMem", EntryName);
          return;
      }
      for (DrawMode=DM_RETAIN; DrawMode<=DM_DRAWANDRETAIN; DrawMode++) {
         SETENTER(" ", "Open and Close Segments");
            if (!GpiSetDrawingMode(hPS, DrawMode)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiSetDrawingMode()", EntryName);
            } else {
               sprintf(achLogLine, "%s", DrawMode==DM_RETAIN?"DM_RETAIN":"DM_DRAWANDRETAIN");
               LOGINFO(L_TRACE, "*", achLogLine);
            }
            if (!GpiOpenSegment(hPS, FIRST_SEG)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
            }
            if (!GpiCloseSegment(hPS)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
            }
            if (!GpiOpenSegment(hPS, LONG_MAX)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
            }
            if (!GpiCloseSegment(hPS)) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
            }
            for (SegID=1; SegID<=10; SegID++) {
               if (!GpiOpenSegment(hPS, randL(1L, LONG_MAX-1L))) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiOpenSegment()", EntryName);
               }
               if (!GpiCloseSegment(hPS)) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiCloseSegment()", EntryName);
               }
            }
         SETEXIT();
         SUBENTER(Query the names, NULL);
            Return = GpiQuerySegmentNames(hPS, FIRST_SEG, LONG_MAX,
                                          MAX_SEG, (PLONG)Buffer);
            if (Return == GPI_ALTERROR) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiQuerySegmentNames()", EntryName);
            } else {
               sprintf(achLogLine, "First Query: %ld,  Expected: 12", Return);
               LOGINFO(L_TRACE, "*", achLogLine);
            }
            Return = GpiQuerySegmentNames(hPS, LONG_MAX, LONG_MAX,
                                          MAX_SEG, (PLONG)Buffer);
            if (Return == GPI_ALTERROR) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiQuerySegmentNames()", EntryName);
            } else {
               sprintf(achLogLine, "Second Query: %ld,  Expected: 1", Return);
               LOGINFO(L_TRACE, "*", achLogLine);
            }
            Return = GpiQuerySegmentNames(hPS, LONG_MAX, FIRST_SEG,
                                          MAX_SEG, (PLONG)Buffer);
            if (Return == GPI_ALTERROR) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiQuerySegmentNames()", EntryName);
            } else {
               sprintf(achLogLine, "Third Query: %ld,  Expected: 1", Return);
               LOGINFO(L_TRACE, "*", achLogLine);
            }
         SUBEXIT();
         if (!GpiDeleteSegments(hPS, FIRST_SEG, LONG_MAX)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDeleteSegments()", EntryName);
         }
      } /* for (DrawMode= */
      DosFreeMem((PVOID)Buffer);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQrySegmentPriorityExh
 *
 * Purpose: This entrypoint wil exhaustively test the GpiSetSegmentPriority
 *          and GpiQuerySegmentPriority function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/30/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     CreateSegmentChain()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *     The display output will not be very effective.  Look at the log file
 *     to verify success.  After changing priorities, the order of the 8
 *     segments should be (from lowest to highest priority) 7,2,1,3,6,5,8,4.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call CreateSegmentChain for 8 segments, Seg4 and Seg7 are unchained.
 *   Draw the chain. Segments 1,2,3,5,6,and 8 will be drawn.
 *   Set Seg4 to the end of the chain.
 *   Set Seg7 to the beginning of the chain.
 *   Set Seg2 to be before Seg1.
 *   Set Seg5 to be after Seg6.
 *   Draw the chain.
 *   for (SegID=Seg1; SegID<=Seg8; SegID++) {
 *      Query the lower and the higher priority segment of SegID.
 *   }
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQrySegmentPriorityExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiSetAndQrySegmentPriorityExh";
 SEGMENTATTRS TempAttrs[8];
 LONG   ReturnLow, ReturnHi, SegID;


   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);

      SETENTER(" ", "Create the segments");
         memcpy((PVOID)TempAttrs, (PVOID)SegAttrs, sizeof(SegAttrs));
         TempAttrs[3].Chained = ATTR_OFF;
         TempAttrs[6].Chained = ATTR_OFF;
         CreateSegmentChain(hPS, hWndClient, TempAttrs, Seg1, Seg8, TYPE_RETAIN);
         if (!GpiResetPS(hPS, GRES_ATTRS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiResetPS()", NULL);
         }
         if (!GpiDrawChain(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDrawChain()", NULL);
         }
      SETEXIT();
      SUBENTER(Set and Query the priorities, NULL);
         if (!GpiSetSegmentPriority(hPS, Seg4, 0L, LOWER_PRI)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetSegmentPriority() - 1", NULL);
         }
         if (!GpiSetSegmentPriority(hPS, Seg7, 0L, HIGHER_PRI)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetSegmentPriority() - 2", NULL);
         }
         if (!GpiSetSegmentPriority(hPS, Seg2, Seg1, LOWER_PRI)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetSegmentPriority() - 3", NULL);
         }
         if (!GpiSetSegmentPriority(hPS, Seg5, Seg6, HIGHER_PRI)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetSegmentPriority() - 4", NULL);
         }
         if (!GpiResetPS(hPS, GRES_ATTRS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiResetPS()", NULL);
         }
         if (!GpiDrawChain(hPS)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiDrawChain()", NULL);
         }
         strcpy(achLogLine, "LOW   SegID     HI");
         LOGINFO(L_HDR, "*", achLogLine);

         for (SegID=Seg1; SegID<=Seg8; SegID++) {
            if ((ReturnLow = GpiQuerySegmentPriority(hPS, SegID, LOWER_PRI)) == GPI_ALTERROR) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiQuerySegmentPriority() - LOW", NULL);
            }
            if ((ReturnHi  = GpiQuerySegmentPriority(hPS, SegID, HIGHER_PRI)) == GPI_ALTERROR) {
               ErrorCount++;
               ERRSTATUS(TRUE, "GpiQuerySegmentPriority() - HIGH", NULL);
            }
            sprintf(achLogLine, "%5ld  <  %5ld  <  %5ld", ReturnLow, SegID, ReturnHi);
            LOGINFO(L_HDR, "*", achLogLine);
         }
      SUBEXIT();
      WriteText(Seg1, Seg8);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
  return;
}

/****************************************************************************
 *\\ddd
 * Routine Name: GpiSetAndQryStopDrawExh
 *
 * Purpose: This entry point will exhaustively test the GpiSetStopDraw and
 *          GpiQueryStopDraw function calls.
 *
 * System Requirements:
 *
 * Revision Log: 9/26/91 - Initial Creation, Darin C. Hafer
 *
 *
 * Inputs:
 *     hPS           - Handle to the Presentation Space.
 *     hWndClient    - Handle to the Client Window.
 *     SelectionCall - Boolean from PTT.
 *
 * Outputs:
 *
 * Subroutines Required:
 *     CreateThread()
 *     DeletePrinterOutput()
 *
 * Limitations:
 *     DosSleep is used to synchronize the use of the PS, not semaphores.
 *     If I stop the execution of the asynchronous thread with a semaphore,
 *     that seems to defeat the purpose of a stop draw.  DosSleep causes
 *     the PMERR_PS_BUSY not to occur from within the main thread.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 * {
 *   Check PS_TYPE for proper settings.
 *   Call CreateThread() to initial the thread.
 *   for (StopAndQuery=1; StopAndQuery<=3; StopAndQuery++) {
 *      Sleep for 3 seconds to allow drawing to be done.
 *      Set the Stop Draw condition to ON.
 *      Query the Stop Draw condition.
 *      Turn on/off dynamic attribute of segments 1-4.
 *      Set the Stop Draw condition to OFF.
 *      Query the Stop Draw condition.
 *   }
 *   DeletePrinterOutput().
 * }
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetAndQryStopDrawExh(HPS hPS, HWND hWndClient, BOOL SelectionCall)
{
 static CHAR *EntryName = "GpiSetAndQryStopDrawExh";
 USHORT Counter;
 LONG   Offset=0L, StopAndQuery, ErrNum, Return;
 LONG   OnOrOff[12] = { ATTR_OFF, ATTR_ON, ATTR_OFF, ATTR_ON,
                        ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_OFF,
                        ATTR_OFF, ATTR_ON, ATTR_OFF, ATTR_ON
                      };

   if (SelectionCall) {
      WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
   }
   else {
      if ((GpiQueryPS(hPS, &sizePS) & PS_TYPE) != GPIT_NORMAL) {
         ABORTENTRY(EntryName, "GPIT_MICRO Restriction");
         DeletePrinterOutput(EntryName);
         return;
      }
      ENTER_MAIN(EntryName);

      hAB = WinQueryAnchorBlock(hWndClient);

      IsRunning=FALSE;

      DosPostEventSem(ulSem);

      SUBENTER(SET STOP DRAW, NULL);
      for (StopAndQuery=1; StopAndQuery<=3; StopAndQuery++) {
         /* Draw for about 3 seconds */
         DosSleep(3000);

         if (!GpiSetStopDraw(hPS, SDW_ON)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetStopDraw() - ON", EntryName);
         }
         for (Counter=1; Counter<=5; Counter++) {
            Return = GpiQueryStopDraw(hPS);
            if (Return == SDW_ERROR) {
               ErrNum = WinGetLastError(hAB);
               if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiQueryStopDraw() - ON", EntryName);
               }
               DosSleep(100);
            }
            else if (Return != SDW_ON) {
                    ErrorCount++;
                    ERRSTATUS(TRUE, "GpiQueryStopDraw() - ON", EntryName);
            }
            else break;
         } /* for (Counter= */

         for (Counter=1; Counter<=5; Counter++) {
            GpiSetSegmentAttrs(hPS, Seg1, ATTR_DYNAMIC, OnOrOff[Offset++]);
            ErrNum = WinGetLastError(hAB);
            if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY)
               break;
            DosSleep(100);
         }
         for (Counter=1; Counter<=5; Counter++) {
            GpiSetSegmentAttrs(hPS, Seg2, ATTR_DYNAMIC, OnOrOff[Offset++]);
            ErrNum = WinGetLastError(hAB);
            if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY)
               break;
            DosSleep(100);
         }
         for (Counter=1; Counter<=5; Counter++) {
            GpiSetSegmentAttrs(hPS, Seg3, ATTR_DYNAMIC, OnOrOff[Offset++]);
            ErrNum = WinGetLastError(hAB);
            if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY)
               break;
            DosSleep(100);
         }
         for (Counter=1; Counter<=5; Counter++) {
            GpiSetSegmentAttrs(hPS, Seg4, ATTR_DYNAMIC, OnOrOff[Offset++]);
            ErrNum = WinGetLastError(hAB);
            if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY)
               break;
            DosSleep(100);
         }

         if (!GpiSetStopDraw(hPS, SDW_OFF)) {
            ErrorCount++;
            ERRSTATUS(TRUE, "GpiSetStopDraw() - OFF", EntryName);
         }
         for (Counter=1; Counter<=5; Counter++) {
            Return = GpiQueryStopDraw(hPS);
            if (Return == SDW_ERROR) {
               ErrNum = WinGetLastError(hAB);
               if (ERRORIDERROR(ErrNum) != PMERR_PS_BUSY) {
                  ErrorCount++;
                  ERRSTATUS(TRUE, "GpiQueryStopDraw() - OFF", EntryName);
               }
               DosSleep(100);
            }
            else if (Return != SDW_OFF) {
                    ErrorCount++;
                    ERRSTATUS(TRUE, "GpiQueryStopDraw() - OFF", EntryName);
            }
            else break;
         }
      } /* for (StopAndQuery= */
      SUBEXIT();
      while(IsRunning)
        DosSleep(500);
      WriteText(Seg1, Seg4);
      DeletePrinterOutput(EntryName);
      EXIT_MAIN(EntryName);
   }
  return;
}
