/************************************************************************/
/* Module name: PTTDLLVR.C                                              */
/*                                                                      */
/* Purpose: Provide variables, procedures and macros that are used by   */
/*          test case DLLs.                                             */
/*                                                                      */
/* Functions:  InitTestSegVars                                          */
/*             VerifyReturnedErrorCode                                  */
/*             ReportSetupError                                         */
/*             MakePSBusy                                               */
/*             FreePS                                                   */
/*             BusyThread                                               */
/*             BusyErrorExit                                            */
/*                                                                      */
/*  RCB: 10/21/91 ADDED ErrorMessage() and modified VerifyReturned-     */
/*                ErrorCode() and VerifyReturnCode to utilize the new   */
/*                function.                                             */
/*  $X1 McCowan 3/6/92  change busy thread to utilize polyline          */
/*                      it takes longer than a bitblt and you can       */
/*                      see that the PS is in use.                      */
/*  $X2 McCowan 3/6/92  check for valid pointer from wingeterrorinfo    */
/*                      before referencing it.  When there is a PM      */
/*                      bug that does not properly record the error     */
/*                      information it caused this TC to trap instead   */
/*                      of reporting the failure.                       */
/*                                                                      */
/************************************************************************/
#define INCL_GPI
#define INCL_DEV
#define INCL_DOS
#define INCL_ERRORS
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "pttdlldf.h"
#include "errors.h"

#define ARRAYLEN(ArrayName)  (sizeof(ArrayName)/sizeof(ArrayName[0]))

// These variables are used by the MAP macros to resolve Presentation Space
// unit locations.  The pDimX and pDimY variables are set by DoUnit
// everytime a presentation space is created.  alDevCaps contains the
// data structure returned by a DevQueryCaps call.

LONG *pDimX, *pDimY, *pBasisX, *pBasisY, *alDevCaps;


// This var points to the HAB of the print thread.  This is needed to
// retrieve error information (ie, WinGetLastError).

PHAB phabPThread;

CHAR *ErrorMessage(USHORT);

/************************************************************************
 ************************************************************************
 ************************************************************************
 * Every test case must call this procedure from InitTest to make pDimX,
 * pDimY, and alDevCaps variables in the segments pointed to my sel.
 ************************************************************************
 ************************************************************************
 ************************************************************************/

/**************************************************************
*  Function Name: InitTestSegVars(USHORT selSeg)              *
*                                                             *
*  Purpose:  Every test case must call this function from     *
*            InitTest to make pDimX, pDimY, and alDevCaps     *
*            variables point into the shared segment.         *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID InitTestSegVars (PVOID selSeg) {

   pDimX       = (LONG *) selSeg;
   pDimY       = (LONG *) selSeg + (sizeof (LONG));
   pBasisX     = (LONG *) selSeg + (2 * sizeof (LONG));
   pBasisY     = (LONG *) selSeg + (3 * sizeof (LONG));
   phabPThread = (PHAB)   selSeg + (4 * sizeof (LONG));
   alDevCaps   = (LONG *) selSeg + (5 * sizeof (LONG));
}  // end InitTestSegVars


#define MANYSPACES \
"                                                                                "
/**************************************************************
*  Function Name: VerifyReturnedErrorCode(...)                *
*                                                             *
*  Purpose:  This function is called to verify that the       *
*            proper error code is returned for a given error  *
*            condition.  This function verifies that the      *
*            error id and severity match those expected by    *
*            the test case.                                   *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
SHORT VerifyReturnedErrorCode(HWND hWndClient, LONG ReturnCode,
                              CHAR *szTestName, USHORT usExpSev,
                              USHORT usExpErrorid, PSZ szFileName,
                              USHORT usLineNo) {
  PERRINFO perrorinfo;
  ERRORID ActErrorid;
  CHAR achLogLine[100];
  BOOL bSuccess;
  USHORT usActErrId;
  CHAR ErrorString[100];

  bSuccess = TRUE;

  if ( ReturnCode <= 0L){   // This means the API call failed

    perrorinfo = WinGetErrorInfo( *phabPThread );
    if (perrorinfo)                                            //@X1A
       ActErrorid = perrorinfo->idError;
    else                                                       //@X1A
       {
       CWRITELOG(L_FAIL, 0, "WinGetErrorInfo returned NULL");  //@X1A
       ActErrorid = 0;                                         //@X1A
       }


//  *****************************************************************
//                                                        5/24/91
//  Note from TSS...Upon deciding that severity check was not
//  of crucial importance, and being that the current drivers only
//  support two severity levels, it was decided that severity
//  checking be commented out for the time being.
//  *****************************************************************
//
    // Test the actual error code returned and its severity.
//
//    if ( (ERRORIDERROR(ActErrorid) != usExpErrorid)||
//                             (ERRORIDSEV(ActErrorid)!=usExpSev)) {
//
//
//
      // see note above
      usActErrId = ERRORIDERROR(ActErrorid);
      if  (usActErrId != usExpErrorid) {
      // see note above



      // ???? Right here make call to PTT to have it log the configuration

      LOG_SIGNATURE;

      // Log a message stating that the expected and actual return codes don't
      // match.




// *******************************************************************
//                                                       5/24/91
// Note from TSS...Since severity was commented out above, their is no
//                 point in printing it out to the log.  See above for
//                 more comments on why severity was commented out
// *******************************************************************
//
//
//      sprintf(achLogLine,
//        "*MISMATCH - Expected %02x %04x, actual value %02x %04x.\n",
//        usExpSev,usExpErrorid,ERRORIDSEV(ActErrorid),ERRORIDERROR(ActErrorid));
//

      //see above note
      strcpy(ErrorString, ErrorMessage(usExpErrorid));
      sprintf(achLogLine,
        "*MISMATCH - Expected %04x: %s;\n",
          usExpErrorid,ErrorString);
      //see above note

      CWRITELOG(L_FAIL, 0, achLogLine);

      strcpy(ErrorString, ErrorMessage(usActErrId));
      sprintf(achLogLine, "            Actual value %04x: %s.\n", usActErrId, ErrorString);
      CWRITELOG(L_FAIL, 0, achLogLine);

// RCB 10/21/91  THE FOLLOWING CODE WAS REMOVED BECAUSE IT ONLY PRINTED
//     GARBAGE MOST OF THE TIME, AND ADDS NO BENEFIT TO LOG MESSAGE
      // Log the additional message located in the message field of the
      // ERRINFO structure.

//      pb = MAKEP ( SELECTOROF(perrorinfo), perrorinfo->offaoffszMsg );
//      npb = (NPBYTE) *pb;
//      pb = MAKEP (SELECTOROF(perrorinfo), npb );
//      if ( strchr (pb, '\n') == NULL)
//        strcat (pb, "\n");                // Make sure the string ends in EOL


//      strcpy (achLogLine, "*ERRORINFO message is - ");
//      strcat (achLogLine, pb );
//      CWRITELOG(L_FAIL, 0, achLogLine);


      // Tell the location in the file of the error.

      sprintf(achLogLine,"*LOCATION - %s, line %d.\n", szFileName, usLineNo);
      CWRITELOG(L_FAIL, 0, achLogLine);

      bSuccess = FALSE;
    } // end if

    if (perrorinfo)                                    //@X1A
       WinFreeErrorInfo(perrorinfo);
  } // end if
  else{

    // If we are here it means we were expecting an error, but the call worked
    // and reported no error.

    LOG_SIGNATURE;

    // Log a message stating that the expected and actual return codes don't
    // match.



// *******************************************************************
//                                                       5/24/91
// Note from TSS...Since severity was commented out above, their is no
//                 point in printing it out to the log.  See above for
//                 more comments on why severity was commented out
// *******************************************************************
//


    strcpy(ErrorString, ErrorMessage(usExpErrorid));
    sprintf(achLogLine,
      "*MISMATCH - Expected %04x: %s;\n",
        usExpErrorid,ErrorString);
    CWRITELOG(L_FAIL, 0, achLogLine);

    sprintf(achLogLine, "             worked properly instead.\n");
    CWRITELOG(L_FAIL, 0, achLogLine);


    // Tell the location in the file of the error.

    sprintf(achLogLine,"*LOCATION - %s, line %d.\n", szFileName, usLineNo);
    CWRITELOG(L_FAIL, 0, achLogLine);

    bSuccess = FALSE;
  } // end else

  // Print a line stating the item being tested and whether it passed or failed.

  strcpy (achLogLine,"@");
  strcat (achLogLine, szTestName);
  strncat (achLogLine, MANYSPACES, 53-strlen(szTestName));

  if (bSuccess)
    strcat (achLogLine,"-    PASS.\n");
  else
    strcat (achLogLine,"-    FAIL.\n");
  CWRITELOG(L_TRACE, 0, achLogLine);

  return( (bSuccess ? 0 : 1) );

}  // end VerifyReturnedErrorCode

/**************************************************************
*  Function Name: VerifyReturnCode(...)                       *
*                                                             *
*  Purpose:  This function is called to verify that the       *
*            proper error code is returned for a given error  *
*            condition.  This function verifies that the      *
*            error id and severity match those expected by    *
*            the test case.                                   *
*                                                             *
*  NOTE:  This function is virtually a copy of the above fun- *
*  tion VerifyReturnedErrorCode(), with the exception that    *
*  this function is modified to consider a return code an     *
*  error code only if rc < 0 (and not rc <= 0 as in the above *
*  function).  This is necessary to test those API calls that *
*  can return a 0 as a valid code (and not an error), e.g.,   *
*  GpiQueryPel().                                             *
*  For more information, see the DEBUGGING NOTE found in      *
*  GpiBtMpr.c under the entrypoint GpiQueryPelRc.             *
*                                                             *
*  Called by: CheckRc1()                                      *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
SHORT VerifyReturnCode(HWND hWndClient, LONG ReturnCode,
                              CHAR *szTestName, USHORT usExpSev,
                              USHORT usExpErrorid, PSZ szFileName,
                              USHORT usLineNo) {
  PERRINFO perrorinfo;
  ERRORID ActErrorid;
  CHAR achLogLine[100];
  BOOL bSuccess;
  USHORT junk = usExpSev;
  USHORT usActErrId;
  CHAR ErrorString[100];

  bSuccess = TRUE;

  if ( ReturnCode < 0L){   // This means the API call failed

    perrorinfo = WinGetErrorInfo( *phabPThread );
    if (perrorinfo)                                          //@X1A
       ActErrorid = perrorinfo->idError;
    else                                                     //@X1A
       {                                                     //@X1A
       CWRITELOG(L_FAIL, 0, "WinGetErrorInfo returned NULL");//@X1A
       ActErrorid = 0;                                       //@X1A
       }                                                     //@X1A

//  *****************************************************************
//                                                        5/24/91
//  Note from TSS...Upon deciding that severity check was not
//  of crucial importance, and being that the current drivers only
//  support two severity levels, it was decided that severity
//  checking be commented out for the time being.
//  *****************************************************************
//
    // Test the actual error code returned and its severity.
//
//    if ( (ERRORIDERROR(ActErrorid) != usExpErrorid)||
//                             (ERRORIDSEV(ActErrorid)!=usExpSev)) {
//
//
//
      // see note above
      usActErrId = ERRORIDERROR(ActErrorid);
      if  (usActErrId != usExpErrorid) {
      // see note above



      // ???? Right here make call to PTT to have it log the configuration

      LOG_SIGNATURE;

      // Log a message stating that the expected and actual return codes don't
      // match.




// *******************************************************************
//                                                       5/24/91
// Note from TSS...Since severity was commented out above, their is no
//                 point in printing it out to the log.  See above for
//                 more comments on why severity was commented out
// *******************************************************************
//
//
//      sprintf(achLogLine,
//        "*MISMATCH - Expected %02x %04x, actual value %02x %04x.\n",
//        usExpSev,usExpErrorid,ERRORIDSEV(ActErrorid),ERRORIDERROR(ActErrorid));
//

      //see above note
      strcpy(ErrorString, ErrorMessage(usExpErrorid));
      sprintf(achLogLine,
        "*MISMATCH - Expected %04x: %s;\n",
          usExpErrorid,ErrorString);
      //see above note

      CWRITELOG(L_FAIL, 0, achLogLine);

      strcpy(ErrorString, ErrorMessage(usActErrId));
      sprintf(achLogLine, "            Actual value %04x: %s.\n", usActErrId, ErrorString);
      CWRITELOG(L_FAIL, 0, achLogLine);


// RCB 10/21/91  THE FOLLOWING CODE WAS REMOVED BECAUSE IT ONLY PRINTED
//     GARBAGE MOST OF THE TIME, AND ADDS NO BENEFIT TO LOG MESSAGE
      // Log the additional message located in the message field of the
      // ERRINFO structure.

//      pb = MAKEP ( SELECTOROF(perrorinfo), perrorinfo->offaoffszMsg );
//      npb = (NPBYTE) *pb;
//      pb = MAKEP (SELECTOROF(perrorinfo), npb );
//      if ( strchr (pb, '\n') == NULL)
//        strcat (pb, "\n");                // Make sure the string ends in EOL


//      strcpy (achLogLine, "*ERRORINFO message is - ");
//      strcat (achLogLine, pb );
//      CWRITELOG(L_FAIL, 0, achLogLine);


      // Tell the location in the file of the error.

      sprintf(achLogLine,"*LOCATION - %s, line %d.\n", szFileName, usLineNo);
      CWRITELOG(L_FAIL, 0, achLogLine);

      bSuccess = FALSE;
    } // end if

    if (perrorinfo)                                      //@X1A
       WinFreeErrorInfo(perrorinfo);
  } // end if
  else{

    // If we are here it means we were expecting an error, but the call worked
    // and reported no error.

    LOG_SIGNATURE;

    // Log a message stating that the expected and actual return codes don't
    // match.



// *******************************************************************
//                                                       5/24/91
// Note from TSS...Since severity was commented out above, their is no
//                 point in printing it out to the log.  See above for
//                 more comments on why severity was commented out
// *******************************************************************
//


    strcpy(ErrorString, ErrorMessage(usExpErrorid));
    sprintf(achLogLine,
      "*MISMATCH - Expected %04x: %s;\n",
        usExpErrorid,ErrorString);
    CWRITELOG(L_FAIL, 0, achLogLine);

    sprintf(achLogLine, "             worked properly instead.\n");
    CWRITELOG(L_FAIL, 0, achLogLine);


    // Tell the location in the file of the error.

    sprintf(achLogLine,"*LOCATION - %s, line %d.\n", szFileName, usLineNo);
    CWRITELOG(L_FAIL, 0, achLogLine);

    bSuccess = FALSE;
  } // end else

  // Print a line stating the item being tested and whether it passed or failed.

  strcpy (achLogLine,"@");
  strcat (achLogLine, szTestName);
  strncat (achLogLine, MANYSPACES, 53-strlen(szTestName));

  if (bSuccess)
    strcat (achLogLine,"-    PASS.\n");
  else
    strcat (achLogLine,"-    FAIL.\n");
  CWRITELOG(L_TRACE, 0, achLogLine);

  return( (SHORT) (bSuccess ? 0 : 1) );

}  // end VerifyReturnCode


/**************************************************************
*  Function Name: ReportSetupError(...)                       *
*                                                             *
*  Purpose:  This function is used to return imexpected       *
*            API errors.  It assumes that an error has        *
*            occurred so it does a WinGetErrorInfo to         *
*            get the specifics about the error and            *
*            prints it out.                                   *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID ReportSetupError (HWND hWndClient, CHAR *pCallName,
                       PSZ szFileName, USHORT usLineNo) {
  PERRINFO perrorinfo;
  CHAR achLogLine[100];
  USHORT usActErrId;
  CHAR ErrorString[100];

  LOG_SIGNATURE;

  perrorinfo = WinGetErrorInfo( *phabPThread );
  if (perrorinfo)                                          //@X1A
     usActErrId = ERRORIDERROR(perrorinfo->idError);
  else                                                     //@X1A
     usActErrId = 0;                                       //@X1A

  sprintf (achLogLine,
    //TSS...took out "a non test"
    "*Failure on API %s with error id = %04x.\n", pCallName, usActErrId);
  CWRITELOG (L_FAIL,0, achLogLine);

//  RCB  ADDED 10/23/91
  strcpy(ErrorString, ErrorMessage(usActErrId));
  sprintf(achLogLine, "            Actual value %04x: %s.\n", usActErrId, ErrorString);
  CWRITELOG(L_FAIL, 0, achLogLine);

// RCB 10/23/91 REMOVED THE FOLLOWING, AS IT OUTPUTS ONLY GARBAGE
  // Log the additional message located in the message field of the
  // ERRINFO structure.

//  pb = MAKEP ( SELECTOROF(perrorinfo), perrorinfo->offaoffszMsg );
//  npb = (NPBYTE) *pb;
//  pb = MAKEP (SELECTOROF(perrorinfo), npb );
//  if ( strchr (pb, '\n') == NULL)
//    strcat (pb, "\n");                // Make sure the string ends in EOL

//  strcpy (achLogLine, "*ERRORINFO message is - ");
//  strcat (achLogLine, pb );
//  CWRITELOG(L_FAIL, 0, achLogLine);


  // Tell the location in the file of the error.

  sprintf(achLogLine,"*LOCATION - File %s, line %d.\n", szFileName, usLineNo);
  CWRITELOG(L_FAIL, 0, achLogLine);
} // end ReportSetupError




/************************************************************************
 ************************************************************************
 ************************************************************************
 * These routines can be used by test cases that verify return codes to
 * create PMERR_PM_BUSY situation.  To create a PM_PS_BUSY situation, call
 * MakePSBusy immediately followed by the API to be tested.  After calling
 * the API, call FreePS to return the PS to normal.
 ************************************************************************
 ************************************************************************
 ************************************************************************/


// Define variables to create the PMERR_HPS_BUSY condition.

#define STACKSIZE   4096

CHAR    FAR *TStack;
ULONG   BusyVal = 0L;          /* BusyThread semaphore value       */
HSEM    BusySem = (HSEM)&BusyVal;    /* BusyThread sem address  BSC      */
ULONG   BusyCnt;
TID     ThreadID;
CHAR    BusyThreadErrorMsg[25];


// Function prototype to create busy condition

VOID    BusyThread(HPS hPS);
VOID    BusyErrorExit (CHAR *message);


/**************************************************************
*  Function Name: MakePSBusy(HWND hWndClient, HPS hPS)        *
*                                                             *
*  Purpose:  This function is used to create a PM_PS_BUSY     *
*            condition.                                       *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  TRUE if all goes well, and FALSE for failures.   *
**************************************************************/
BOOL MakePSBusy(HWND hWndClient, HPS hPS){

  HPS     junk=hPS;

  // Preset the error message to "".

  strcpy (BusyThreadErrorMsg, "");


  // Set the semaphore to wait on.

  if (!BusyVal && DosCreateEventSem(NULL, &BusyVal, 0, TRUE) != NO_ERROR) {
    REPORTSETUPERROR("DosCreateEventSem");
    return(FALSE);
  }

  if (DosResetEventSem(BusyVal, &BusyCnt) != NO_ERROR){
    REPORTSETUPERROR("DosResetEventSem");
    return(FALSE);
  }

  if (DosCreateThread ((PTID)&ThreadID, (PFNTHREAD) BusyThread, 0L, 0L,
                      (ULONG)STACKSIZE)) {
    REPORTSETUPERROR("DosCreateThread");
    return(FALSE);
  }

  // Wait until the BusyThread is just about to start its long PS hogging
  // instruction before letting this thread continue.

  if (DosWaitEventSem(BusyVal, SEM_INDEFINITE_WAIT) != NO_ERROR){
    REPORTSETUPERROR("DosSemWait");
    return(FALSE);
  }


  // In case this thread gets control after the BusyThread issues
  // the DosSemClear but before the PS hogging instruction, we'll
  // sleep for a second.

  if (DosSleep(500L) != NO_ERROR ){         //@X1C (CHANGED 1 SEC TO 1/2 SEC)
    REPORTSETUPERROR("DosSleep");
    return(FALSE);
  }

  return(TRUE);

} // end MakePSBusy



/**************************************************************
*  Function Name: FreePS(HWND hWndClient)                     *
*                                                             *
*  Purpose:  This function is used to reverse the PS_BUSY     *
*            condition.                                       *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  TRUE if all goes well, and FALSE for failures.   *
**************************************************************/
BOOL FreePS(HWND hWndClient){


  // Wait for the BusyThread to let us know it is complete.

  if (DosWaitEventSem(BusyVal, SEM_INDEFINITE_WAIT) != NO_ERROR){
    REPORTSETUPERROR("DosSemWait");
    return(FALSE);
  }

  // Clear the DosEnterCritSec()

  DosExitCritSec();

  // If BusyThreadErrorMsg == "" is means BusyThread executed with no
  // errors.  Otherwise it contains the name of the API that failed.

  if (!strcmp(BusyThreadErrorMsg, "")){
    return(TRUE);
  }
  else{
    REPORTSETUPERROR(BusyThreadErrorMsg);
    return(FALSE);
  }

} // end FreePS



/**************************************************************
*  Function Name: BusyThread(HPS hPS)                         *
*                                                             *
*  Purpose:  This thread is used to make the presentation     *
*            space busy.  When the test case issues the       *
*            MakePSBusy command followed by the API to be     *
*            tested, the API will compete with the thread     *
*            over the use of the presentation space.          *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID    BusyThread(HPS hPS){

  HDC         hDC;
  HAB         habBusy;
  HMQ         hmqBusy;

  static  POINTL  pPoints[8000];
  USHORT          i;

  for (i = 0; i < 8000; i++)
      {
      pPoints[i].x = i % 2L * 1000;
      pPoints[i].y = i / 90L * 5;
      }


  // Make sure the presentation space passed to us is valid
  // and associated with a device context.

  hDC = GpiQueryDevice(hPS);
  //if ( (hDC == HDC_ERROR) || (hDC == NULL) )
  if ( (hDC == HDC_ERROR) )
    BusyErrorExit("GpiQueryDevice (in BusyThread)" );


  // Create an anchor block and message queue for this thread.

  if ( (habBusy = WinInitialize((SHORT)NULL)) == NULLHANDLE)
    BusyErrorExit("WinInitialize (in BusyThread)" );

  // Create Message Queue ... but ignore any errors ...
  // any errors returned will indicate either Message Queue
  // already created or resource problem ... in either case
  // the next set of calls will capture the resource problem
  // while the already created error isn't a problem.
  hmqBusy = WinCreateMsgQueue(habBusy, 0);




  // This is the command that hogs the hPS long enough to force the
  // PMERR_HPS_BUSY condition to occur.

  if (GpiPolyLine(hPS, 8000L, pPoints) != GPI_OK)
      BusyErrorExit("GpiPolyLine (in BusyThread)");

  // Let's clean up.
  if (hmqBusy)
      WinDestroyMsgQueue(hmqBusy);
  WinTerminate(habBusy);
  DosEnterCritSec();
  DosExit(EXIT_THREAD, 0);

} // end BusyThread



/**************************************************************
*  Function Name: BusyErrorExit(CHAR *message)                *
*                                                             *
*  Purpose:  This is an error exit function fo the BusyThread.*
*            It copies the error message that is passed in    *
*            as a parameter into the BusyThreadErrorMsg.  It  *
*            clears the semaphore BusySem to allow MakePSBusy *
*            to complete, and exits the thread.               *
*                                                             *
*  Function Calls:                                            *
*                                                             *
*  Returns:  VOID                                             *
**************************************************************/
VOID BusyErrorExit (CHAR *message){

  strcpy (BusyThreadErrorMsg, message);

  DosPostEventSem(BusyVal);
  DosExit(0,0);
}  // end BusyErrorExit

/*************************************************************
*  Function Name: ErrorMessage(USHORT usErrorId)             *
*                                                            *
*  Purpose: Returns in a string the name of the error        *
*           identified via usErrorId.                        *
*                                                            *
*  Called by: VerifyReturnedErrorCode(),                     *
*             VerifyReturnCode()                             *
*                                                            *
*  Created 10/21/91 by Rickey C. Brown                       *
*************************************************************/

CHAR  *ErrorMessage(USHORT usErrorId)
{
   USHORT index, current_error;
   CHAR   message[100];

   index = 0;
   current_error = errorcodes[index].ErrorId;
   while ((current_error != usErrorId) && (index < NUMERRORS))
      current_error = errorcodes[++index].ErrorId;

   if (index == NUMERRORS)
      sprintf(message, "THE ERROR CODE %hu IS UNKNOWN", usErrorId);
   else
     strcpy(message, errorcodes[index].ErrorName);

   return(message);
}

