#ifndef GPISEG_H
#define GPISEG_H



#define STACKSIZE  16000
#define FIRST_SEG   1L
#define MAX_SEG    16380

#define LAMPSHADE   10L
#define LAMPBASE    20L
#define TABLE       30L

#define CLIP_PATH      40L
#define VIEW_LIMIT     50L
#define GRAPHICS_FIELD 60L
#define CLIP_REGION    70L

#define TOTALSEGS   8L

#define CHAIN  0x01
#define FROM   0x02
#define DRAW   0x04
#define SINGLE 0x08
#define RANGE  0x10

/***************************************************************************
 *\\ddd
 * Subtask Name: Graphics Engine Tests
 *
 * Module name: gpiseg
 *
 * Purpose: gpiseg.dll include file
 *
 *  $header$
 *
 * Revision Log:
 *
 *
 * Contents:  This file contains the following definitions:
 *
 *              - function prototypes
 *              - number of tests
 *              - name of tests
 *              - global color structure
 *
 * Limitations:
 *  None
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
        declare all dll functions
***************************************************************************/
VOID APIENTRY InitTest(PVOID Selector, PTESTINITINFO init_info_p);
VOID APIENTRY GpiOpenSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDeleteSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDeleteSegmentsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawChainExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawChainExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawAndRemoveDynamicsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawFromExh1(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawFromExh2(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiDrawSegmentExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiEraseExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiResetAndQryBoundaryDataExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiSetAndQryInitSegmentAttrsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiSetAndQrySegmentAttrsExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiQuerySegmentNamesExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiSetAndQrySegmentPriorityExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);
VOID APIENTRY GpiSetAndQryStopDrawExh(HPS hPS, HWND hWndClient, BOOL SelectionCall);


int CreateRoom(HPS, HWND);
BOOL RandPels(HPS, HWND, LONG, RECTL *, BYTE);
BOOL OpenAndClose(HPS, BOOL, LONG, CHAR *, PPOINTL);
SHORT GetLineSpacing(HPS, HWND);
VOID DeleteSegment(HPS, HWND, BYTE);
VOID DrawFromOrChain1(HPS, HWND, BYTE);
VOID DrawFromOrChain2(HPS, HWND, BYTE);
VOID DrawSegment(HPS, HWND);
VOID LogEnvironment(HPS, HWND, LONG);
BOOL Scribble(HPS, HWND, PPOINTL);
VOID SetAndQueryLoop(HPS, HWND, BOOL);
BOOL CreateThread(HPS, HWND);
VOID NewThread(HPS, HWND);
VOID ResetAndOpen(HPS, HWND, LONG);
void Write_Text(HPS, HWND, LONG, LONG);

#define WriteSegmentText(lrange, urange)                                   \
        (void) Write_Text(hPS, hWndClient, lrange, urange)

extern POINTL aptDefine[MAXSEGMENTS][MAXPOINTS];

#ifdef MAIN_PROGRAM


ULONG ulSem = 0L;
HSEM  hSem = (HSEM)&ulSem;
//16 SEL   selStack;
PBYTE  Stack;
TID    tidAsync;                      /* Asynchronous thread's ID     */
ULONG  threadFlags = 0L;
HAB    habAsync;                      /* Asynchronous thread's anchor */
BOOL   IsRunning=FALSE;

LONG     ErrorCount=0L;      // Error counter.
CHAR     szAddMessage[200];  // Buffer used for printing log messages
CHAR     achLogLine[200];    // Buffer used for printing log messages
HDC      hDC;
HAB      hAB;
SIZEL    sizePS;
CHAR   * TestCaseName= "GpiSegmentTests";

SEGMENTATTRS SegAttrs[TOTALSEGS] = {  ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_OFF, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                             ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_OFF, ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE,
                            };
/***************************************************************************
        The stubbing out of unfinished entry points is illustrated
        here.  Those function tokens commented out will be ommitted
        from the entry point list of the test selection dialog.  All
        entry points not completely finished and thouroughly tested
        should be stubbed out before submitting pre-releases of the
        testcase to the customer.
***************************************************************************/

NAMES_AND_ADDRESSES EntryPointList[]=
    {
      TOKENIZEFUNCTIONNAME(GpiOpenSegmentExh),
      TOKENIZEFUNCTIONNAME(GpiDeleteSegmentExh),
      TOKENIZEFUNCTIONNAME(GpiDeleteSegmentsExh),
      TOKENIZEFUNCTIONNAME(GpiDrawChainExh1),
      TOKENIZEFUNCTIONNAME(GpiDrawChainExh2),
      TOKENIZEFUNCTIONNAME(GpiDrawAndRemoveDynamicsExh),
      TOKENIZEFUNCTIONNAME(GpiDrawFromExh1),
      TOKENIZEFUNCTIONNAME(GpiDrawFromExh2),
      TOKENIZEFUNCTIONNAME(GpiDrawSegmentExh),
      TOKENIZEFUNCTIONNAME(GpiEraseExh),
      TOKENIZEFUNCTIONNAME(GpiResetAndQryBoundaryDataExh),
      TOKENIZEFUNCTIONNAME(GpiSetAndQryInitSegmentAttrsExh),
      TOKENIZEFUNCTIONNAME(GpiSetAndQrySegmentAttrsExh),
      TOKENIZEFUNCTIONNAME(GpiQuerySegmentNamesExh),
      TOKENIZEFUNCTIONNAME(GpiSetAndQrySegmentPriorityExh),
      TOKENIZEFUNCTIONNAME(GpiSetAndQryStopDrawExh),
    };

#else

extern ULONG ulSem;
extern HSEM  hSem;
extern SEL   selStack;
extern TID   tidAsync;             // Asynchronous thread's ID
extern HAB   habAsync;             // Asynchronous thread's anchor
extern BOOL  IsRunning;

extern LONG       ErrorCount;      // Error counter.
extern CHAR       szAddMessage[];  // Buffer used for printing log messages
extern CHAR       achLogLine[];    // Buffer used for printing log messages
extern HDC        hDC;
extern HAB        hAB;
extern SIZEL      sizePS;
extern SEGMENTATTRS SegAttrs[TOTALSEGS];

#endif
#endif
