#define INCL_DEV      // include all DEV definitions
#define INCL_WIN
#define INCL_GPI      // include all Gpi definitions
#define INCL_ERRORS   // include all Gpi error definitions

#include <os2.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "PTTDLLDF.h"               // test case defines
#include "common1.h"
#include "common2.h"

POINTL aptDefine[MAXSEGMENTS][MAXPOINTS];

/*****************************************************************************
 *\ddd
 * Routine Name: CreateSegmentChain()
 *
 * Purpose: This will create a chain of segments with the
 *          attributes from SegmentAttrs array.
 *
 *
 *
 * System Requirements:
 *              NONE
 *
 *
 * Revision Log: 09/19/91 ,PTT, Ken McFadden
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    SegmentAttrs   // segment attributes
 *    lrange         // lower segment number to start at
 *    urange         // upper segment number to end at
 *    mode           // contains flags to allow different types
 *                      of outputs to the display.
 *
 * Outputs:
 *              int  // error level
 *
 * Subroutines Required:
 *              SetSegmentAttrs
 *              SetInitialSegmentAttrs
 *
 * Limitations:
 *              Must not exceed 8 segments.
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\\algorithm
 * {
 *      get anchor block;
 *      set delta;
 *      if GRID bit on then
 *              if GRID_FULL on then
 *                   draw one inch grid;
 *              else
 *                   draw one half inch grid;
 *      if urange - lrange + 1 is greater then MAXSEGMENTS then
 *              log error "invalid input range";
 *              return WARNING_L1;
 *      switch on MODE_TYPE
 *              case TYPE_DRAW:
 *                   set drawing mode to DM_DRAW;
 *              case TYPE_RETAIN:
 *                   set drawing mode to DM_RETAIN:
 *              case TYPE_DRAWRETAIN:
 *                   set drawing mode to DM_DRAWANDRETAIN;
 *              default:
 *                   set drawing mode to DM_DRAW;
 *
 *      loop from lrange to urange do;
 *              increment Count;
 *              Temp = the offset into adCurPosP with the current loop iteration;
 *              if device is a printer then
 *                   set up will be to use a one inch figure;
 *              else
 *                   set up will be to use a one half inch figure;
 *              set attribute mode;
 *              set initial segment attributes;
 *              open segment;
 *              set tag;
 *              set color;
 *              set pattern;
 *              if not NOPLUS then
 *                   plot points into aptDefine for a plus figure;
 *              draw figure;
 *              close segment;
 * }
 *\\end
 *****************************************************************************/
INT CreateSegmentChain(HPS hPS, HWND hWndClient, PSEGMENTATTRS SegmentAttrs,
                       LONG lrange, LONG urange, BYTE mode)
{
HAB           hAB;
LONG          Temp=0L, lval, GmodeX, GmodeY;
USHORT        Count=0;
double        *padPoint;
PSEGMENTATTRS SAttrs;
BYTE          tempMode;
SEGMENTATTRS  initAttrs = { ATTR_ON, ATTR_ON, ATTR_ON, ATTR_OFF,
                               ATTR_ON, ATTR_ON, ATTR_ON, AM_NOPRESERVE};

static double adCurPosP[]={0.5,  1.0,
                           2.5,  3.0,
                           0.5,  5.0,
                           2.5,  7.0,
                           4.5,  1.0,
                           6.5,  3.0,
                           4.5,  5.0,
                           6.5,  7.0
                          };

static double adCurPosC[]={1.25,  1.0,
                           2.25,  2.0,
                           1.25,  3.0,
                           2.25,  4.0,
                           5.25,  1.0,
                           6.25,  2.0,
                           5.25,  3.0,
                           6.25,  4.0
                          };

   hAB = WinQueryAnchorBlock(hWndClient);
   set_delta(hPS);
   if (mode & GRID)
     {
        if (mode & GRID_FULL)
           gpi_grid(hPS, ONE_INCH);
        else
           gpi_grid(hPS, HALF_INCH);
     }

      /* Check if the range is valid, if not, return. */
   if ((urange - lrange + 1) > MAXSEGMENTS)
     {
        LOGINFO(1, "@", "The input range for CreatSegmentChain is invalid.");
        return WARNING_L1;
     }

   tempMode = mode & (BYTE) MODE_TYPE;

   switch (tempMode)
          {
             case TYPE_DRAW:    GpiSetDrawingMode(hPS, DM_DRAW);
                                break;
             case TYPE_RETAIN:  GpiSetDrawingMode(hPS, DM_RETAIN);
                                break;
             case TYPE_DRAWRETAIN: GpiSetDrawingMode(hPS, DM_DRAWANDRETAIN);
                                break;
             default:           GpiSetDrawingMode(hPS, DM_DRAW);
          }

   error = 0;
   for (lval = lrange; lval <= urange; lval++)
     {
        Count++;
        Temp = lval * 2 - 1;

        if (DeviceIsPrinter())
        {
          padPoint = &adCurPosP[Temp-1];
          GmodeX = MapX((LONG) ((double) delta_x));
          GmodeY = MapY((LONG) ((double) delta_y));
        }
        else
        {
          padPoint = &adCurPosC[Temp-1];
          GmodeX = MapX((LONG) ((double) delta_x/2));
          GmodeY = MapY((LONG) ((double) delta_y/2));
        }
        SAttrs = &SegmentAttrs[Count-1];
        GpiSetAttrMode(hPS, SAttrs->AttrMode);
        SetInitialSegmentAttrs(hPS, SAttrs);

        if (!GpiOpenSegment(hPS, lval))
           return WARNING_L5;

             if (!GpiSetTag(hPS, lval))
             error | TAGERROR;

          if (Count == CLR_BACKGROUND)
            {
               if (!GpiSetColor(hPS, 12L))
                  error | COLORERROR;
            }
          else
            {
               if (!GpiSetColor(hPS, Count))
                  error | COLORERROR;
            }

        GpiSetPattern(hPS, PATSYM_HALFTONE);

        if (!GpiBeginArea(hPS, BA_ALTERNATE|BA_BOUNDARY))
           error | AREAERROR;

        if (!(mode & NOPLUS))
          {
             aptDefine[Count - 1][11].x = MapX((LONG) (((double) delta_x) * *(padPoint++)));
             aptDefine[Count - 1][11].y = MapY((LONG) (((double) delta_y) * *(padPoint)));
             aptDefine[Count - 1][0].x = aptDefine[Count - 1][11].x + GmodeX;
             aptDefine[Count - 1][0].y = aptDefine[Count - 1][11].y;
             aptDefine[Count - 1][1].x = aptDefine[Count - 1][0].x;
             aptDefine[Count - 1][1].y = aptDefine[Count - 1][0].y + GmodeY/2;
             aptDefine[Count - 1][2].x = aptDefine[Count - 1][1].x + GmodeX/2;
             aptDefine[Count - 1][2].y = aptDefine[Count - 1][1].y;
             aptDefine[Count - 1][3].x = aptDefine[Count - 1][2].x;
             aptDefine[Count - 1][3].y = aptDefine[Count - 1][2].y + GmodeY;
             aptDefine[Count - 1][4].x = aptDefine[Count - 1][3].x - GmodeX/2;
             aptDefine[Count - 1][4].y = aptDefine[Count - 1][3].y;
             aptDefine[Count - 1][5].x = aptDefine[Count - 1][4].x;
             aptDefine[Count - 1][5].y = aptDefine[Count - 1][4].y + GmodeY/2;
             aptDefine[Count - 1][6].x = aptDefine[Count - 1][5].x - GmodeX;
             aptDefine[Count - 1][6].y = aptDefine[Count - 1][5].y;
             aptDefine[Count - 1][7].x = aptDefine[Count - 1][6].x;
             aptDefine[Count - 1][7].y = aptDefine[Count - 1][6].y - GmodeY/2;
             aptDefine[Count - 1][8].x = aptDefine[Count - 1][7].x - GmodeX/2;
             aptDefine[Count - 1][8].y = aptDefine[Count - 1][7].y;
             aptDefine[Count - 1][9].x = aptDefine[Count - 1][8].x;
             aptDefine[Count - 1][9].y = aptDefine[Count - 1][8].y - GmodeY;
             aptDefine[Count - 1][10].x =aptDefine[Count - 1][9].x + GmodeX/2;
             aptDefine[Count - 1][10].y =aptDefine[Count - 1][9].y;
          }

        GpiMove(hPS, &aptDefine[Count - 1][11]);
        GpiPolyLine(hPS, 11L, &aptDefine[Count - 1][0]);
        GpiEndArea(hPS);

        if (!GpiCloseSegment(hPS))
           return WARNING_L5;

     }
   return 0;
}

/*****************************************************************************
 *\ddd
 * Routine Name: SetSegmentAttrs()
 *
 * Purpose: This will set the segment attributes.
 *
 *
 *
 * System Requirements:
 *              NONE
 *
 *
 * Revision Log: 09/19/91 ,PTT, Ken McFadden
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    SegmentAttrs   // segment attributes
 *    idSeg          // segment number
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              NONE
 *
 * Limitations:
 *              NONE
 *
 *\\end
 *****************************************************************************/
void SetSegmentAttrs(HPS hPS, PSEGMENTATTRS SegmentAttr, LONG idSeg)
{
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_CHAINED, SegmentAttr->Chained);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_DETECTABLE, SegmentAttr->Detectable);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_DYNAMIC, SegmentAttr->Dynamic);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_FASTCHAIN, SegmentAttr->FastChain);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_PROP_DETECTABLE, SegmentAttr->Prop_Detectable);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_PROP_VISIBLE, SegmentAttr->Prop_Visible);
   GpiSetSegmentAttrs(hPS, idSeg, ATTR_VISIBLE, SegmentAttr->Visible);
}

/*****************************************************************************
 *\ddd
 * Routine Name: SetInitialSegmentAttrs()
 *
 * Purpose: This will set the initial segment attributes.
 *
 *
 *
 * System Requirements:
 *              NONE
 *
 *
 * Revision Log: 09/19/91 ,PTT, Ken McFadden
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    SegmentAttrs   // segment attributes
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              NONE
 *
 * Limitations:
 *              NONE
 *
 *\\end
 *****************************************************************************/
void SetInitialSegmentAttrs(HPS hPS, PSEGMENTATTRS SegmentAttr)
{
   GpiSetInitialSegmentAttrs(hPS, ATTR_CHAINED, SegmentAttr->Chained);
   GpiSetInitialSegmentAttrs(hPS, ATTR_DETECTABLE, SegmentAttr->Detectable);
   GpiSetInitialSegmentAttrs(hPS, ATTR_DYNAMIC, SegmentAttr->Dynamic);
   GpiSetInitialSegmentAttrs(hPS, ATTR_FASTCHAIN, SegmentAttr->FastChain);
   GpiSetInitialSegmentAttrs(hPS, ATTR_PROP_DETECTABLE, SegmentAttr->Prop_Detectable);
   GpiSetInitialSegmentAttrs(hPS, ATTR_PROP_VISIBLE, SegmentAttr->Prop_Visible);
   GpiSetInitialSegmentAttrs(hPS, ATTR_VISIBLE, SegmentAttr->Visible);
}

/*****************************************************************************
 *\ddd
 * Routine Name: W_Text()
 *
 * Purpose: This will write the segment names over the figure.
 *
 *
 *
 * System Requirements:
 *              NONE
 *
 *
 * Revision Log: 09/19/91 ,PTT, Ken McFadden
 *
 *
 * Inputs:
 *    hPS            // presentation space
 *    hWndClient     // client window
 *    lrange         // lower segment number to start at
 *    urange         // upper segment number to end at
 *
 * Outputs:
 *              NONE
 *
 * Subroutines Required:
 *              WorldWriteString
 *
 * Limitations:
 *              NONE
 *
 *\\end
 *****************************************************************************/
void W_Text(HPS hPS, HWND hWndClient, LONG lrange, LONG urange)
{
LONG          lval;
USHORT        Count=0;
CHAR          szBuffer[32];
POINTL        ptText;
INT           printPos;

   if (DeviceIsPrinter())
      printPos = 6;
   else
      printPos = 8;
   for (lval = lrange; lval <= urange; lval++)
     {
        Count++;
        sprintf(szBuffer, "Segment %ld", lval);

        ptText.x = aptDefine[Count - 1][printPos].x;
        ptText.y = aptDefine[Count - 1][6].y + MapY(delta_y/20);

        GpiSetBackMix(hPS,BM_OVERPAINT);
        GpiSetColor(hPS, CLR_BLACK);
        WorldWriteString(ptText.x, ptText.y, &szBuffer[0]);
     }
}
