#define INCL_ERRORS
#define INCL_WIN
#define INCL_GPI
#define INCL_DEV
#define MAINSOURCEFILE              //This main source code.

#include <string.h>
#include <os2.h>
#include <stdio.h>
#include "pttdlldf.h"   /* test case defines */
#include "gpiregn.h"   /* gpi marker dll header file */
#include "std_util.h"

char error_message[80];

/*****************************************************************************
 *\\ddd
 * Subtask Name: PDVT
 *
 * Module Name: GPIREGN
 *
 * Purpose: This module is called by the PTT to test the Gpi Region API's.
 *
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *               - created initial module template
 *
 * SRS References: Section 5.8
 *
 * Contents:
 *            GpiRegionApp1()
 *            GpiCombineRegionExh()
 *            GpiCreateRegionExh()
 *            GpiEqualRegionExh()
 *            GpiOffsetRegionExh()
 *            GpiPtInRegionExh()
 *            GpiRectInRegionExh()
 *            GpiSetRegionExh()
 *            GpiQueryRegionBoxExh()
 *\\end
 *****************************************************************************/

/*****************************************************************************
 *\ddd
 * Routine Name: InitTest
 *
 * Purpose: Initialize function name and address array for PTT.
 *
 * Systems Requirements: None
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *               - initial function template
 *
 * Inputs:
 *   sel        // passed through to the InitTestSegVars function
 *   init_info_p    // name and address array used by PTT interface
 *
 * Outputs:
 *   init_info_p    // returned initialized with names and addresses
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 *****************************************************************************/
/*****************************************************************************
 *\\ algorithm
 * {
 *    for all test functions in this test case {
 *        init_info_p->function name = function name[i]
 *    init_info_p->function address = function address[i]
 *    }
 *    call init set function
 * }
 *\\end
 *****************************************************************************/

VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo)

{ // BEGIN--INIT TEST

    pInitInfo->ntests = NTESTS;  /* set number of entry points */

    strcpy(pInitInfo->group_name,"Gpi Region");
    strcpy(pInitInfo->test_names[0],"GpiRegionApp1");
    pInitInfo->test_addrs[0]=GpiRegionApp1;
    strcpy(pInitInfo->test_names[1], "GpiCombineRegionExh1");
    pInitInfo->test_addrs[1]=GpiCombineRegionExh1;
    strcpy(pInitInfo->test_names[2],"GpiCombineRegionExh2");
    pInitInfo->test_addrs[2]=GpiCombineRegionExh2;
    strcpy(pInitInfo->test_names[3],"GpiCreateRegionExh");
    pInitInfo->test_addrs[3]=GpiCreateRegionExh;
    strcpy(pInitInfo->test_names[4],"GpiEqualRegionExh");
    pInitInfo->test_addrs[4]=GpiEqualRegionExh;
    strcpy(pInitInfo->test_names[5],"GpiOffsetRegionExh");
    pInitInfo->test_addrs[5]=GpiOffsetRegionExh;
    strcpy(pInitInfo->test_names[6],"GpiPtInRegionExh");
    pInitInfo->test_addrs[6]=GpiPtInRegionExh;
    strcpy(pInitInfo->test_names[7],"GpiRectInRegionExh");
    pInitInfo->test_addrs[7]=GpiRectInRegionExh;
    strcpy(pInitInfo->test_names[8],"GpiSetRegionExh");
    pInitInfo->test_addrs[8]=GpiSetRegionExh;
    strcpy(pInitInfo->test_names[9],"GpiQueryRegionBoxExh");
    pInitInfo->test_addrs[9]=GpiQueryRegionBoxExh;

    InitTestSegVars(sel); /* this call used by the PTT interface */

} // END--INIT TEST

/***************************************************************************
 *\\ddd
 * Routine Name: GpiRegionApp1
 *
 * Purpose: This is an entry point for the PTT that causes the Gpi
 *           Region application test to be run.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *               - initial function template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

VOID APIENTRY GpiRegionApp1(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI REGION APPLICATION TEST */

  lErrorCount = 0L;

  if (SelectionCall)
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ gpiregionapp - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       RegionApp2(hPS, hWndClient);

       CWRITELOG(L_LOTRACE,0, "+ex+ gpiregionapp - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$gpiregionapp Test                                              -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$gpiregionapp Test                                              -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI REGION APPLICATION TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCombineRegionExh1
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiCombineRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *      OUTLINE 1ST REGION
 *      OUTLINE 2ND REGION
 *
 *      CREATE 1ST REGION OF ONE RECTANGLE
 *      CREATE 2ND REGION OF ONE RECTANGLE
 *
 *      SET PATTERN TO DIAG2.
 *      PAINT 1ST REGION
 *
 *      SET PATTERN TO HORIZ.
 *      PAINT 2ND REGION
 *
 *      CREATE 3RD REGION OF ONE RECTANGLE
 *
 *      COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
 *      THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
 *
 *      SET PATTERN TO PATTERN6
 *      PAINT 3RD REGION
 *
 *      DISPLAY REGION DISPLAY DOCUMENTATION
 *      DISPLAY REGION OPERATIONS DOCUMENTATION
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiCombineRegionExh1(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI COMBINE REGION EXHAUSTIVE1 */

#define NUM_OF_TESTS 5                 // NUMBER OF REGION TESTS

char report_error[80];                 // REPORTSETUPERROR MESSAGE
char write_log[80];                    // CWRITELOG MESSAGE
int i;                                 // REGION INDEX
LONG lCombine;                         // GPI RETURN VALUE
HRGN hrgn1;                            // REGION HANDLE 1
HRGN hrgn2;                            // REGION HANDLE 2
HRGN hrgn3;                            // REGION HANDLE 3
POINTL ppt;                            // POINT STRUCTURES
RECTL arectl1[5];                      // RECTANGLE OUTLINE FOR REGION1
RECTL arectl2[5];                      // RECTANGLE OUTLINE FOR REGION2
RECTL arectl3[5];                      // RECTANGLE OUTLINE FOR REGION3
static LONG  oper[] = { CRGN_AND,      // OPERATIONS ON REGIONS
                        CRGN_OR,
                        CRGN_COPY,
                        CRGN_XOR,
                        CRGN_DIFF};

   lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiCombineRegionExh1 - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

                                   // REGION 1
       arectl1[0].xLeft   = 625;   // REGION GROUP 1 AND
       arectl1[0].yBottom = 1250;
       arectl1[0].xRight  = 2500;
       arectl1[0].yTop    = 3125;

       arectl1[1].xLeft   = 1250;  // REGION GROUP 2 OR
       arectl1[1].yBottom = 6250;
       arectl1[1].xRight  = 3125;
       arectl1[1].yTop    = 8125;

       arectl1[2].xLeft   = 5625;  // REGION GROUP 3 COPY
       arectl1[2].yBottom = 5625;
       arectl1[2].xRight  = 7500;
       arectl1[2].yTop    = 7500;

       arectl1[3].xLeft   = 6250;  // REGION GROUP 4 XOR
       arectl1[3].yBottom = 1250;
       arectl1[3].xRight  = 7500;
       arectl1[3].yTop    = 3125;

       arectl1[4].xLeft   = 3750;  // REGION GROUP 5 DIFF
       arectl1[4].yBottom = 1025;
       arectl1[4].xRight  = 5000;
       arectl1[4].yTop    = 2225;

                                   // REGION 2
       arectl2[0].xLeft   = 1875;   // REGION GROUP 1 AND
       arectl2[0].yBottom = 2500;
       arectl2[0].xRight  = 3750;
       arectl2[0].yTop    = 5000;

       arectl2[1].xLeft   = 2500;  // REGION GROUP 2 OR
       arectl2[1].yBottom = 6875;
       arectl2[1].xRight  = 5000;
       arectl2[1].yTop    = 9375;

       arectl2[2].xLeft   = 6250;  // REGION GROUP 3 COPY
       arectl2[2].yBottom = 6250;
       arectl2[2].xRight  = 8125;
       arectl2[2].yTop    = 9375;

       arectl2[3].xLeft   = 6875;  // REGION GROUP 4 XOR
       arectl2[3].yBottom =  625;
       arectl2[3].xRight  = 9375;
       arectl2[3].yTop    = 5000;

       arectl2[4].xLeft   = 4375;  // REGION GROUP 5 DIFF
       arectl2[4].yBottom = 1600;
       arectl2[4].xRight  = 5625;
       arectl2[4].yTop    = 4100;

                                   // REGION 3
       arectl3[0].xLeft   = 0;   // REGION GROUP 1 AND
       arectl3[0].yBottom = 0;
       arectl3[0].xRight  = 0;
       arectl3[0].yTop    = 0;

       arectl3[1].xLeft   = 0;  // REGION GROUP 2 OR
       arectl3[1].yBottom = 0;
       arectl3[1].xRight  = 0;
       arectl3[1].yTop    = 0;

       arectl3[2].xLeft   = 0;  // REGION GROUP 3 COPY
       arectl3[2].yBottom = 0;
       arectl3[2].xRight  = 0;
       arectl3[2].yTop    = 0;

       arectl3[3].xLeft   = 0;  // REGION GROUP 4 XOR
       arectl3[3].yBottom = 0;
       arectl3[3].xRight  = 0;
       arectl3[3].yTop    = 0;

       arectl3[4].xLeft   = 0;  // REGION GROUP 5 DIFF
       arectl3[4].yBottom = 0;
       arectl3[4].xRight  = 0;
       arectl3[4].yTop    = 0;

       for ( i = 0; i < NUM_OF_TESTS; i++ )    // DISPLAY ALL REGIONS
         { /* BEGIN FOR--I */

           memset(write_log, '\0', 80);
           sprintf(write_log,
                   "+ie+ GpiCombineRegionExh1: %ld - Entry.\n", oper[i]);
           CWRITELOG(L_LOTRACE, 0, write_log);

           ppt.x = arectl1[i].xLeft;
           ppt.y = arectl1[i].yBottom;         // OUTLINE RECTANGLE 1
           MapPt(ppt);                         // ONE CORNER
           GpiMove(hPS, &ppt);
           ppt.x = arectl1[i].xRight;
           ppt.y = arectl1[i].yTop;
           MapPt(ppt);                         // OTHER CORNER
           GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

           ppt.x = arectl2[i].xLeft;
           ppt.y = arectl2[i].yBottom;         // OUTLINE RECTANGLE 2
           MapPt(ppt);                         // ONE CORNER
           GpiMove(hPS, &ppt);
           ppt.x = arectl2[i].xRight;
           ppt.y = arectl2[i].yTop;
           MapPt(ppt);                         // OTHER CORNER
           GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

         // *********
           MapRect(arectl1[i]);                      // MAP RECT. TO COOR. SP.
           hrgn1 = GpiCreateRegion( hPS,             // CREATE 1ST REGION
                                     1L,             // OF ONE RECTANGLE USING
                                     &arectl1[i]);   // COORDINATES FROM HERE

           MapRect(arectl2[i]);                      // MAP RECT. TO COOR. SP.
           hrgn2 = GpiCreateRegion( hPS,             // CREATE 2ND REGION
                                     1L,             // OF ONE RECTANGLE USING
                                     &arectl2[i]);   // COORDINATES FROM HERE
       // *********
           GpiSetPattern(hPS, PATSYM_DIAG2);         // SET PATTERN TO DIAG2.
           GpiPaintRegion(hPS, hrgn1);               // PAINT 1ST REGION

           GpiSetPattern(hPS, PATSYM_HORIZ);         // SET PATTERN TO HORIZ.
           GpiPaintRegion(hPS, hrgn2);               // PAINT 2ND REGION

       // *********
           MapRect(arectl3[i]);                      // MAP RECT. TO COOR. SP.
           hrgn3 = GpiCreateRegion( hPS,             // CREATE 3RD REGION
                                     1L,             // OF ONE RECTANGLE USING
                                     &arectl3[i]);   // COORDINATES FROM HERE

           // COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
           // THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
           lCombine = GpiCombineRegion(hPS, hrgn3, hrgn1, hrgn2, oper[i]);

           if ( lCombine == RGN_ERROR ) // CHECK IF ERROR OCCURRED
             { /* BEGIN IF--LCOMBINE */
               lErrorCount++;
               memset(report_error, '\0', 80);
               sprintf(report_error,"GpiCombineRegionExh1 Test: %ld",oper[i]);
               BADERROR("GpiCombineRegion", TRUE, "GpiCombineRegionExh1");
               return;
             } /* END IF--LCOMBINE */
           else
             { /* BEGIN ELSE--LCOMBINE */
               GpiSetPattern(hPS, PATSYM_DENSE6);        // SET PATTERN TO 6
               GpiPaintRegion(hPS, hrgn3);               // PAINT 3RD REGION
             } /* END ELSE--LCOMBINE */

           GpiDestroyRegion(hPS, hrgn1);           // DESTROY REGION HANDLES
           GpiDestroyRegion(hPS, hrgn2);
           GpiDestroyRegion(hPS, hrgn3);

           memset(write_log, '\0', 80);
           sprintf(write_log,
                   "+ix+ GpiCombineRegionExh1: %ld - Exit.\n", oper[i]);
           CWRITELOG(L_LOTRACE, 0, write_log);

       } /* END FOR--I */

       // REGION DISPLAY DOCUMENTATION
       MapAndWriteString(hPS, 250L, 5900L,"REG1: DIAG2");
       MapAndWriteString(hPS, 250L, 5600L,"REG2: HORIZ");
       MapAndWriteString(hPS, 250L, 5300L,"REG COMBO: CHECKRD");

       //REGION OPERATIONS DOCUMENTATION
       MapAndWriteString(hPS, 250L, 3500L,"AND COMBO");
       MapAndWriteString(hPS, 250L, 8250L,"OR COMBO");
       MapAndWriteString(hPS, 8200L, 8750L,"COPY COMBO");
       MapAndWriteString(hPS, 7000L, 5150L,"XOR COMBO");
       MapAndWriteString(hPS, 4375L, 4400L,"DIFF COMBO");

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiCombineRegionExh1 - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiCombineRegionExh1 Test                                      -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiCombineRegionExh1 Test                                      -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI COMBINE REGION EXHAUSTIVE1 */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCombineRegionExh2
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiCombineRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 * FOR EACH REGION SET a, b, c:
 *      CREATE 1ST REGION OF ONE RECTANGLE
 *      CREATE 2ND REGION OF ONE RECTANGLE
 *
 *      SET PATTERN TO DIAG2.
 *      PAINT 1ST REGION
 *
 *      SET PATTERN TO HORIZ.
 *      PAINT 2ND REGION
 *
 *      CREATE 3RD REGION OF ONE RECTANGLE
 *
 * FOR REGION SET a:
 *      COMBINE THE 1ST AND 2ND REGIONS BY THE AND OPERATION.
 *      THESE TWO REGIONS OVERLAP EACH OTHER.
 *      THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
 *      CHECK THAT THE RETURN VALUE FROM THE GPI IS RGN_RECT.
 *
 * FOR REGION SET b:
 *      COMBINE THE 1ST AND 2ND REGIONS BY THE AND OPERATION.
 *      THESE TWO REGIONS DO NOT OVERLAP EACH OTHER AT ALL.
 *      THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
 *      CHECK THAT THE RETURN VALUE FROM THE GPI IS RGN_NULL.
 *
 * FOR REGION SET c:
 *      COMBINE THE 1ST AND 2ND REGIONS BY THE OR OPERATION.
 *      THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
 *      CHECK THAT THE RETURN VALUE FROM THE GPI IS RGN_COMPLX.
 *
 * FOR EACH REGION SET a, b, c:
 *      SET PATTERN TO PATTERN8
 *      PAINT 3RD REGION
 *
 * DISPLAY REGION DISPLAY DOCUMENTATION
 * DISPLAY REGION OPERATIONS DOCUMENTATION
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiCombineRegionExh2(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI COMBINE REGION EXHAUSTIVE2 */

LONG lCombine;                             // GPI RETURN VALUE
HRGN hrgn1;                                // REGION HANDLE 1
HRGN hrgn2;                                // REGION HANDLE 2
HRGN hrgn3;                                // REGION HANDLE 3
RECTL arectl1[1];                          // REGION GROUP A RECT.1 RECT
RECTL arectl2[1];                          // REGION GROUP A RECT.2 RECT
RECTL arectl3[1];                          // REGION GROUP A RECT.3 RECT
RECTL brectl1[1];                          // REGION GROUP B RECT.1 NULL
RECTL brectl2[1];                          // REGION GROUP B RECT.2 NULL
RECTL brectl3[1];                          // REGION GROUP B RECT.3 NULL
RECTL crectl1[1];                          // REGION GROUP C RECT.1 COMPLEX
RECTL crectl2[1];                          // REGION GROUP C RECT.2 COMPLEX
RECTL crectl3[1];                          // REGION GROUP C RECT.3 COMPLEX

   lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiCombineRegionExh2 - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

                                       // RGN_RECT
       arectl1[0].xLeft   = 1000;      // RECTANGLE REGION 1A
       arectl1[0].yBottom = 1000;
       arectl1[0].xRight  = 3000;
       arectl1[0].yTop    = 3000;

       arectl2[0].xLeft   = 2000;      // RECTANGLE REGION 2A
       arectl2[0].yBottom = 2000;
       arectl2[0].xRight  = 5000;
       arectl2[0].yTop    = 5000;

       arectl3[0].xLeft   = 0;         // RECTANGLE REGION 3A
       arectl3[0].yBottom = 0;
       arectl3[0].xRight  = 0;
       arectl3[0].yTop    = 0;
                                       // RGN_NULL
       brectl1[0].xLeft   = 7700;      // RECTANGLE REGION 1B
       brectl1[0].yBottom = 1000;
       brectl1[0].xRight  = 9700;
       brectl1[0].yTop    = 3000;

       brectl2[0].xLeft   = 8500;      // RECTANGLE REGION 2B
       brectl2[0].yBottom = 3500;
       brectl2[0].xRight  = 9500;
       brectl2[0].yTop    = 4500;

       brectl3[0].xLeft   = 0;         // RECTANGLE REGION 3B
       brectl3[0].yBottom = 0;
       brectl3[0].xRight  = 0;
       brectl3[0].yTop    = 0;
                                       // RGN_COMPLEX
       crectl1[0].xLeft   = 3000;      // RECTANGLE REGION 1C
       crectl1[0].yBottom = 6500;
       crectl1[0].xRight  = 7000;
       crectl1[0].yTop    = 7500;

       crectl2[0].xLeft   = 4000;      // RECTANGLE REGION 2C
       crectl2[0].yBottom = 6000;
       crectl2[0].xRight  = 9000;
       crectl2[0].yTop    = 9000;

       crectl3[0].xLeft   = 0;         // RECTANGLE REGION 3C
       crectl3[0].yBottom = 0;
       crectl3[0].xRight  = 0;
       crectl3[0].yTop    = 0;

       CWRITELOG(L_LOTRACE,0, "+ie+ GpiCombineRegionExh2: RGN_RECT - Entry.\n");
   // ************ RGN_RECT
       MapRect(arectl1[0]);                    // MAP RECT. TO COOR. SP.
       hrgn1 = GpiCreateRegion( hPS,           // CREATE 1ST REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 arectl1);     // COORDINATES FROM HERE

       MapRect(arectl2[0]);                    // MAP RECT. TO COOR. SP.
       hrgn2 = GpiCreateRegion( hPS,           // CREATE 2ND REGION
                                1L,            // OF ONE RECTANGLE USING
                                arectl2);      // COORDINATES FROM HERE
       // *********
       GpiSetPattern(hPS, PATSYM_DIAG2);        // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn1);             // PAINT 1ST REGION

       GpiSetPattern(hPS, PATSYM_HORIZ);       // SET PATTERN TO HORIZ.
       GpiPaintRegion(hPS, hrgn2);             // PAINT 2ND REGION

       // *********
       MapRect(arectl3[0]);                    // MAP RECT. TO COOR. SP.
       hrgn3 = GpiCreateRegion( hPS,           // CREATE 3RD REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 arectl3);     // COORDINATES FROM HERE

       // COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
       // THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
       lCombine = GpiCombineRegion(hPS, hrgn3, hrgn1, hrgn2, CRGN_AND);

       if ( lCombine != RGN_RECT )   // COMBINED REGION SHOULD BE A RECTANGLE
           { /* BEGIN IF--LCOMBINE */
               lErrorCount++;                          // LOG ERROR
               BADERROR("GpiCombineRegion", TRUE, "GpiCombineRegionExh2");
               return;
           } /* END IF--LCOMBINE */
       else
           { /* BEGIN ELSE--LCOMBINE */
               GpiSetPattern(hPS, PATSYM_DENSE8);      // SET PATTERN TO 8
               GpiPaintRegion(hPS, hrgn3);             // PAINT 3RD REGION
               MapAndWriteString(hPS, 100L, 5250L,"Combined Region is Rectangle");
           } /* END ELSE--LCOMBINE */

       GpiDestroyRegion(hPS, hrgn1);           // DESTROY REGION HANDLES
       GpiDestroyRegion(hPS, hrgn2);
       GpiDestroyRegion(hPS, hrgn3);

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiCombineRegionExh2 - Exit.\n");

       CWRITELOG(L_LOTRACE,0, "+ie+ GpiCombineRegionExh2: RGN_NULL - Entry.\n");
   // ************ RGN_NULL
       MapRect(brectl1[0]);                    // MAP RECT. TO COOR. SP.
       hrgn1 = GpiCreateRegion( hPS,           // CREATE 1ST REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 brectl1);     // COORDINATES FROM HERE

       MapRect(brectl2[0]);                    // MAP RECT. TO COOR. SP.
       hrgn2 = GpiCreateRegion( hPS,           // CREATE 2ND REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 brectl2);     // COORDINATES FROM HERE
       // *********
       GpiSetPattern(hPS, PATSYM_DIAG2);        // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn1);             // PAINT 1ST REGION

       GpiSetPattern(hPS, PATSYM_HORIZ);       // SET PATTERN TO HORIZ.
       GpiPaintRegion(hPS, hrgn2);             // PAINT 2ND REGION

       // *********
       MapRect(brectl3[0]);                    // MAP RECT. TO COOR. SP.
       hrgn3 = GpiCreateRegion( hPS,           // CREATE 3RD REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 brectl3);     // COORDINATES FROM HERE

       // COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
       // THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
       lCombine = GpiCombineRegion(hPS, hrgn3, hrgn1, hrgn2, CRGN_AND);

       if ( lCombine != RGN_NULL )     // COMBINED REGION SHOULD BE NULL
           { /* BEGIN IF--LCOMBINE */
               lErrorCount++;                          // LOG ERROR
               BADERROR("GpiCombineRegion", TRUE, "GpiCombineRegionExh2");
               return;
           } /* END IF--LCOMBINE */
       else
           { /* BEGIN ELSE--LCOMBINE */
               GpiSetPattern(hPS, PATSYM_DENSE8);      // SET PATTERN TO 8
               GpiPaintRegion(hPS, hrgn3);             // PAINT 3RD REGION
               MapAndWriteString(hPS, 7000L, 4700L,"Combined Region is Null");
           } /* END ELSE--LCOMBINE */

       GpiDestroyRegion(hPS, hrgn1);           // DESTROY REGION HANDLES
       GpiDestroyRegion(hPS, hrgn2);
       GpiDestroyRegion(hPS, hrgn3);

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiCombineRegionExh2 - Exit.\n");

       CWRITELOG(L_LOTRACE,0, "+ie+ GpiCombineRegionExh2: RGN_COMPLEX - Entry.\n");
   // ************ RGN_COMPLEX
       MapRect(crectl1[0]);                    // MAP RECT. TO COOR. SP.
       hrgn1 = GpiCreateRegion( hPS,           // CREATE 1ST REGION
                                 2L,           // OF ONE RECTANGLE USING
                                 crectl1);     // COORDINATES FROM HERE

       MapRect(crectl2[0]);                    // MAP RECT. TO COOR. SP.
       hrgn2 = GpiCreateRegion( hPS,           // CREATE 2ND REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 crectl2);     // COORDINATES FROM HERE
       // *********
       GpiSetPattern(hPS, PATSYM_DIAG2);        // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn1);             // PAINT 1ST REGION

       GpiSetPattern(hPS, PATSYM_HORIZ);       // SET PATTERN TO HORIZ.
       GpiPaintRegion(hPS, hrgn2);             // PAINT 2ND REGION

       // *********
       MapRect(crectl3[0]);                    // MAP RECT. TO COOR. SP.
       hrgn3 = GpiCreateRegion( hPS,           // CREATE 3RD REGION
                                 1L,           // OF ONE RECTANGLE USING
                                 crectl3);     // COORDINATES FROM HERE

       // COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
       // THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
       lCombine = GpiCombineRegion(hPS, hrgn3, hrgn1, hrgn2, CRGN_OR);

       if ( lCombine != RGN_COMPLEX )  // COMBINED REGION SHOULD BE COMPLEX
           { /* BEGIN IF--LCOMBINE */
               lErrorCount++;                          // LOG ERROR
               BADERROR("GpiCombineRegion", TRUE, "GpiCombineRegionExh2");
               return;
           } /* END IF--LCOMBINE */
       else
           { /* BEGIN ELSE--LCOMBINE */
               GpiSetPattern(hPS, PATSYM_DENSE8);      // SET PATTERN TO 8
               GpiPaintRegion(hPS, hrgn3);             // PAINT 3RD REGION
               MapAndWriteString(hPS, 100L, 8000L,"Combined Region is Complex");
           } /* END ELSE--LCOMBINE */

       GpiDestroyRegion(hPS, hrgn1);           // DESTROY REGION HANDLES
       GpiDestroyRegion(hPS, hrgn2);
       GpiDestroyRegion(hPS, hrgn3);

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiCombineRegionExh2 - Exit.\n");

       // REGION DISPLAY DOCUMENTATION
       MapAndWriteString(hPS, 5300L, 4000L,"REG1: DIAG2");
       MapAndWriteString(hPS, 5300L, 3700L,"REG2: HORIZ");
       MapAndWriteString(hPS, 5300L, 3400L,"REG COMBO: DOTS");

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiCombineRegionExh2 - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiCombineRegionExh2 Test                                      -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiCombineRegionExh2 Test                                      -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI COMBINE REGION EXHAUSTIVE2 */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiCreateRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiCreateRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs:    NONE
 *
 * Subroutines Required:
 *     RegionCreateTest1(hPS,hWndClient)- CREATE REGION OF ONE RECTANGLE
 *     RegionCreateTest2(hPS,hWndClient)- CREATE REGION OF FOUR RECTANGLES
 *
 * Limitations:    NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CALL GPICREATEREGION FOR AN ONE RECTANGLE REGION.
 *     CALL GPICREATEREGION FOR A FOUR RECTANGLE REGION.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiCreateRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI CREATE REGION */

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0,
                   "+ee+ GpiCreateRegion Exhaustive Test - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       RegionCreateTest1(hPS,hWndClient);
       RegionCreateTest2(hPS,hWndClient);
       CWRITELOG(L_LOTRACE,0,
                   "+ex+ GpiCreateRegion Exhaustive Test - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiCreateRegion Exhaustive Test                                -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiCreateRegion Exhaustive Test                                -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI CREATE REGION */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiEqualRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiEqualRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CREATE TWO EQUAL REGIONS 1 AND 2.
 *     CALL GPIEQUAL REGION.
 *     CHECK THAT RETURN VALUE == EQRGN_EQUAL.
 *
 *     CREATE TWO DIFFERENT REGIONS 1 AND 2.
 *     CALL GPIEQUAL REGION.
 *     CHECK THAT RETURN VALUE == EQRGN_NOTEQUAL.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiEqualRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI EQUAL REGION EXHAUSTIVE */

LONG equality;         // GPIEQUALREGION RETURN VALUE
HRGN hrgn1;            // REGION HANDLE 1
HRGN hrgn2;            // REGION HANDLE 2
RECTL arectl1[3];      // EQUAL REGION 1 RECTANGLE COORDINATES
RECTL arectl2[3];      // EQUAL REGION 2 RECTANGLE COORDINATES
RECTL brectl1[2];      // NOT EQUAL REGION 1 RECTANGLE COORDINATES
RECTL brectl2[3];      // NOT EQUAL REGION 2 RECTANGLE COORDINATES

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiEqualRegion Exhaustive Test - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

                                           // EQUAL REGIONS
       arectl1[0].xLeft   = 1000;          // REGION 1
       arectl1[0].yBottom = 5000;
       arectl1[0].xRight  = 3000;
       arectl1[0].yTop    = 7000;
       arectl1[1].xLeft   = 1000;
       arectl1[1].yBottom = 2000;
       arectl1[1].xRight  = 2000;
       arectl1[1].yTop    = 4000;
       arectl1[2].xLeft   = 2000;
       arectl1[2].yBottom = 6000;
       arectl1[2].xRight  = 4000;
       arectl1[2].yTop    = 8000;

       arectl2[0].xLeft   = 1000;         // REGION 2
       arectl2[0].yBottom = 5000;
       arectl2[0].xRight  = 3000;
       arectl2[0].yTop    = 7000;
       arectl2[1].xLeft   = 1000;
       arectl2[1].yBottom = 2000;
       arectl2[1].xRight  = 2000;
       arectl2[1].yTop    = 4000;
       arectl2[2].xLeft   = 2000;
       arectl2[2].yBottom = 6000;
       arectl2[2].xRight  = 4000;
       arectl2[2].yTop    = 8000;

                                           // NOT EQUAL REGIONS
       brectl1[0].xLeft   = 5000;          // REGION 1
       brectl1[0].yBottom = 2000;
       brectl1[0].xRight  = 7000;
       brectl1[0].yTop    = 4000;
       brectl1[1].xLeft   = 6000;
       brectl1[1].yBottom = 1000;
       brectl1[1].xRight  = 8000;
       brectl1[1].yTop    = 3000;

       brectl2[0].xLeft   = 7000;         // REGION 2
       brectl2[0].yBottom = 7000;
       brectl2[0].xRight  = 9000;
       brectl2[0].yTop    = 9000;
       brectl2[1].xLeft   = 5000;
       brectl2[1].yBottom = 8000;
       brectl2[1].xRight  = 8000;
       brectl2[1].yTop    = 10000;
       brectl2[2].xLeft   = 8000;
       brectl2[2].yBottom = 6000;
       brectl2[2].xRight  = 10000;
       brectl2[2].yTop    = 8000;

       // ****REGIONS EQUAL
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiEqualRegion: EqualRects - Entry.\n");
       MapRect(arectl1[0]);                // MAP REGION COORD. TO COORD. SP.
       MapRect(arectl1[1]);
       MapRect(arectl1[2]);
       hrgn1 = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                                3L,       // OF THREE RECTANGLES USING
                               arectl1);  // COORDINATES FROM HERE

       MapRect(arectl2[0]);                // MAP REGION COORD. TO COORD. SP.
       MapRect(arectl2[1]);
       MapRect(arectl2[2]);
       hrgn2 = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                               3L,        // OF THREE RECTANGLES USING
                               arectl2);  // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_VERT);        // SET PATTERN TO VERT
       GpiPaintRegion(hPS, hrgn1);             // PAINT REGION

       GpiSetPattern(hPS, PATSYM_DIAG2);       // SET PATTERN TO DIAG2
       GpiPaintRegion(hPS, hrgn2);             // PAINT REGION
                                               // COMPARE REGIONS 1 AND 2
       equality = GpiEqualRegion(hPS, hrgn1, hrgn2);

       if ( equality != EQRGN_EQUAL )          // CHECK THAT RETURNED EQUAL
           { /* BEGIN IF--EQUALITY */
               lErrorCount++;
               BADERROR("GpiEqualRegion", TRUE, "GpiEqualRegionExh");
               return;
           } /* END IF--EQUALITY */
       else
           { /* BEGIN ELSE--COMPLX */        // DISPLAY TEXT
               MapAndWriteString(hPS, 2300L, 4000L,"Region 1: Vert");
               MapAndWriteString(hPS, 2300L, 3700L,"Region 2: Diag");
               MapAndWriteString(hPS, 2300L, 3400L,"Regions are Equal");
               MapAndWriteString(hPS, 2300L, 3100L,"Reg2 Painted Over Reg1");
           } /* END ELSE--COMPLX */

       GpiDestroyRegion(hPS, hrgn1);            // DESTROY REGION
       GpiDestroyRegion(hPS, hrgn2);            // DESTROY REGION

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiEqualRegion: EqualRects - Exit.\n");

       //****REGIONS NOT EQUAL
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiEqualRegion: NotEqualRects - Entry.\n");
       MapRect(brectl1[0]);               // MAP REGION COORD. TO COORD. SP.
       MapRect(brectl1[1]);
       hrgn1 = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                                2L,       // OF TWO RECTANGLES USING
                               brectl1);  // COORDINATES FROM HERE

       MapRect(brectl2[0]);               // MAP REGION COORD. TO COORD. SP.
       MapRect(brectl2[1]);
       MapRect(brectl2[2]);
       hrgn2 = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                               3L,        // OF THREE RECTANGLES USING
                               brectl2);  // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_DENSE8);      // SET PATTERN TO DENSE8
       GpiPaintRegion(hPS, hrgn1);             // PAINT REGION

       GpiSetPattern(hPS, PATSYM_HORIZ);       // SET PATTERN TO HORIZ.
       GpiPaintRegion(hPS, hrgn2);             // PAINT REGION
                                               // COMPARE REGIONS 1 AND 2
       equality = GpiEqualRegion(hPS, hrgn1, hrgn2);

       if ( equality != EQRGN_NOTEQUAL )   // CHECK THAT RETURNED NOTEQUAL
           { /* BEGIN IF--EQUALITY */
               lErrorCount++;
               BADERROR("GpiEqualRegion", TRUE, "GpiEqualRegionExh");
               return;
           } /* END IF--EQUALITY */
       else
           { /* BEGIN ELSE--COMPLX */      // DISPLAY TEXT
               MapAndWriteString(hPS, 5000L, 5900L,"Region 1: Horiz");
               MapAndWriteString(hPS, 5000L, 5600L,"Region 2: Dots");
               MapAndWriteString(hPS, 5000L, 5300L,"Regions are NotEqual");
           } /* END ELSE--COMPLX */

       GpiDestroyRegion(hPS, hrgn1);            // DESTROY REGION
       GpiDestroyRegion(hPS, hrgn2);            // DESTROY REGION

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiEqualRegion: NotEqualRects - Exit.\n");

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiEqualRegion Exhaustive Test - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiEqualRegion Exhaustive Test                                 -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiEqualRegion Exhaustive Test                                 -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI EQUAL REGION EXHAUSTIVE */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiOffsetRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiOffsetRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CREATE REGION OF ONE RECTANGLE.
 *     SET UP POINT STRUCTURE TO OFFSET REGION BY.
 *     CALL GPIOFFSET REGION.
 *     CHECK NO ERRORS OCCURRED AND PAINT NEW OFFSET REGION.
 *
 *     CREATE REGION OF TWO RECTANGLES.
 *     SET UP POINT STRUCTURE TO OFFSET REGION BY.
 *     CALL GPIOFFSET REGION.
 *     CHECK NO ERRORS OCCURRED AND PAINT NEW OFFSET REGION.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiOffsetRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI OFFSET REGION EXHAUSTIVE TEST */

POINTL ptl;            // POINT STRUCTURE
HRGN hrgn;             // REGION HANDLE
BOOL bOffset;          // GPIOFFSET REGION RETURN VALUE
RECTL arectl1[1];      // REGION RECTANGLE 1
RECTL arectl2[2];      // REGION RECTANGLE 2

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */

       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiOffsetRegion - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       arectl1[0].xLeft   = 1000;          // REGION 1 OF 1 RECTANGLE
       arectl1[0].yBottom = 1000;
       arectl1[0].xRight  = 3000;
       arectl1[0].yTop    = 4000;

       arectl2[0].xLeft   = 4000;         // REGION 2 OF TWO RECTANGLES
       arectl2[0].yBottom = 1000;
       arectl2[0].xRight  = 6000;
       arectl2[0].yTop    = 3000;
       arectl2[1].xLeft   = 5000;
       arectl2[1].yBottom = 2000;
       arectl2[1].xRight  = 8000;
       arectl2[1].yTop    = 5000;

       //******************1 RECT
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiOffsetRegion: 1 Rect - Entry.\n");

       MapRect(arectl1[0]);
       hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                               1L,        // OF ONE RECTANGLE USING
                               arectl1);  // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_DIAG2);        // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn);              // PAINT REGION

       MapAndWriteString(hPS, 1000L, 4200L,"Original Rect"); //DISPLAY TEXT

       ptl.x = 1000;                           // OFFSET REGION BY POINTS
       ptl.y = 4000;
       MapPt(ptl);
       bOffset = GpiOffsetRegion(hPS, hrgn, &ptl);

       if ( bOffset == FALSE )                 // CHECK IF OFFSET ERROR
           { /* BEGIN IF--BOFFSET */
               lErrorCount++;
               BADERROR("GpiOffsetRegion", TRUE, "GpiOffsetRegionExh");
               return;
           } /* END IF--BOFFSET */
       else
           { /* BEGIN ELSE--bOffset */
               GpiSetPattern(hPS, PATSYM_HORIZ);   // SET PATTERN TO HORIZ
               GpiPaintRegion(hPS, hrgn);          // PAINT REGION
               MapAndWriteString(hPS, 1000L, 8200L,"Offset Rect"); // DIS. TEXT
           } /* END ELSE--bOffset */

       GpiDestroyRegion(hPS, hrgn);                // DESTROY REGION

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiOffsetRegion: 1 Rects - Exit.\n");

       //******************2 RECTS
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiOffsetRegion: 2 Rects - Entry.\n");

       MapRect(arectl2[0]);              // MAP RECTANGLE COORD. TO COOR. SP.
       MapRect(arectl2[1]);
       hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                               2L,       // OF TWO RECTANGLES USING
                               arectl2); // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_DIAG2);       // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn);              // PAINT REGION

       MapAndWriteString(hPS, 3500L, 4200L,"Original");
       MapAndWriteString(hPS, 3500L, 3950L,"Rect");

       ptl.x = 1000;                           // OFFSET REGION BY POINTS
       ptl.y = 4500;
       MapPt(ptl);
       bOffset = GpiOffsetRegion(hPS, hrgn, &ptl);

       if ( bOffset == FALSE )                 // CHECK IF OFFSET ERROR
           { /* BEGIN IF--BOFFSET */
               lErrorCount++;
               BADERROR("GpiOffsetRegion", TRUE, "GpiOffsetRegionExh");
               return;
           } /* END IF--BOFFSET */
       else
           { /* BEGIN ELSE--bOffset */
               GpiSetPattern(hPS, PATSYM_HORIZ);   // SET PATTERN TO HORIZ
               GpiPaintRegion(hPS, hrgn);          // PAINT REGION
               MapAndWriteString(hPS, 4200L, 8200L,"Offset Rect"); // DIS. TEXT
           } /* END ELSE--bOffset */

       GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION HANDLE

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiOffsetRegion: 2 Rects - Exit.\n");

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiOffsetRegion - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiOffsetRegion Exhaustive Test                                -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiOffsetRegion Exhaustive Test                                -    PASS.\n");

   } /* END ELSE--SELECTION CALL */
}
/***************************************************************************
 *\\ddd
 * Routine Name: GpiPtInRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiPtInRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CREATE REGION OF THREE RECTANGLES.
 *
 *     CREATE POINT IN REGION.
 *     CALL GPIPTINREGION.
 *     CHECK THAT RETURN VALUE == PRGN_INSIDE
 *
 *     CREATE POINT OUTSIDE REGION.
 *     CALL GPIPTINREGION.
 *     CHECK THAT RETURN VALUE == PRGN_OUTSIDE
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiPtInRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI POINT IN REGION EXHAUSTIVE TEST */

POINTL ptl;            // POINT STRUCTURE
HRGN hrgn;             // REGION HANDLE
LONG lPtIn;            // GPIPTIN REGION RETURN VALUE
RECTL arectl[3];       // REGION COORDINATES

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */
       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiPtInRegion - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       arectl[0].xLeft   = 4000;               // SET UP REGION COORDINATES
       arectl[0].yBottom = 1000;
       arectl[0].xRight  = 6000;
       arectl[0].yTop    = 3000;
       arectl[1].xLeft   = 2000;
       arectl[1].yBottom = 7000;
       arectl[1].xRight  = 6000;
       arectl[1].yTop    = 8000;
       arectl[2].xLeft   = 5000;
       arectl[2].yBottom = 2000;
       arectl[2].xRight  = 8000;
       arectl[2].yTop    = 5000;

       //******************POINT IN REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiPtInRegion: Pt In Region - Entry.\n");

       MapRect(arectl[0]);                 // MAP REGION COORD. IN COORD. SP.
       MapRect(arectl[1]);
       MapRect(arectl[2]);
       hrgn = GpiCreateRegion( hPS,        // CREATE REGION IN PRESENTATION SPACE
                               3L,         // OF ONE RECTANGLE USING
                               arectl);    // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_DIAG2);   // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn);          // PAINT REGION

       ptl.x = 4250;                       // DRAW POINT
       ptl.y = 2500;
       MapPt(ptl);
       GpiCharStringAt(hPS,&ptl,2L,". ");
                                           // CHECK IF POINT IN REGION
       lPtIn = GpiPtInRegion(hPS, hrgn, &ptl);

       if ( lPtIn !=  PRGN_INSIDE )        // CHECK THAT RETURNED INSIDE
           { /* BEGIN IF--LPTIN */
               lErrorCount++;
               BADERROR("GpiPtInRegion", TRUE, "GpiPtInRegionExh");
               return;
           } /* END IF--LPTIN */
       else
           { /* BEGIN ELSE--lPtIn */            // DISPLAY TEXT
               MapAndWriteString(hPS, 2000L, 2500L,"Pt in Region");
           } /* END ELSE--lPtIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiPtInRegion: Pt In Region - Exit.\n");

       //******************POINT OUT OF REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiPtInRegion: Pt OutOf Region - Entry.\n");

       ptl.x = 4000;                           // DRAW POINT
       ptl.y = 8500;
       MapPt(ptl);
       GpiCharStringAt(hPS,&ptl,2L,". ");
                                               // CHECK IF POINT OUT OF REGION
       lPtIn = GpiPtInRegion(hPS, hrgn, &ptl);

       if ( lPtIn !=  PRGN_OUTSIDE )           // CHECK THAT RETURNED OUTSIDE
           { /* BEGIN IF--LPTIN */
               lErrorCount++;
               BADERROR("GpiPtInRegion", TRUE, "GpiPtInRegionExh");
               return;
           } /* END IF--LPTIN */
       else
           { /* BEGIN ELSE--lPtIn */           // DISPLAY TEXT
               MapAndWriteString(hPS, 2000L, 8500L,"Pt Out of Region");
           } /* END ELSE--lPtIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiPtInRegion: Pt Outof Region - Exit.\n");

       GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION HANDLE

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiPtInRegion - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiPtInRegion Exhaustive Test                                  -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiPtInRegion Exhaustive Test                                  -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI POINT IN REGION EXHAUSTIVE TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiRectInRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *      testing of GpiRectInRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CREATE REGION OF THREE RECTANGLES.
 *
 *     CREATE RECTANGLE IN REGION.
 *     CALL GPIRECTINREGION.
 *     CHECK THAT RETURN VALUE == RRGN_INSIDE
 *
 *     CREATE RECTANGLE OUTSIDE REGION.
 *     CALL GPIRECTINREGION.
 *     CHECK THAT RETURN VALUE == RRGN_OUTSIDE
 *
 *     CREATE RECTANGLE PARTIALLY IN REGION.
 *     CALL GPIRECTINREGION.
 *     CHECK THAT RETURN VALUE == RRGN_PARTIALLY
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiRectInRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI RECTANGLE IN REGION EXHAUSTIVE TEST */

LONG lRectIn;                  // GPIRECTIN REGION RETURN VALUE
POINTL ppt;                    // POINT STRUCTURES
HRGN hrgn;                     // REGION HANDLE
RECTL rectl[1];                // RECTANGLE COORDINATES
RECTL arectl[3];               // REGION COORDINATES

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */
       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiRectInRegion - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       arectl[0].xLeft   = 4000;       // SET UP REGION COORDINATES
       arectl[0].yBottom = 1000;
       arectl[0].xRight  = 6000;
       arectl[0].yTop    = 3000;
       arectl[1].xLeft   = 2000;
       arectl[1].yBottom = 7000;
       arectl[1].xRight  = 6000;
       arectl[1].yTop    = 8000;
       arectl[2].xLeft   = 5000;
       arectl[2].yBottom = 2000;
       arectl[2].xRight  = 8000;
       arectl[2].yTop    = 5000;

       MapRect(arectl[0]);             // MAP REGION COORDINATES TO COORD. SP.
       MapRect(arectl[1]);
       MapRect(arectl[2]);
       hrgn = GpiCreateRegion( hPS,    // CREATE REGION IN PRESENTATION SPACE
                               3L,         // OF THREE RECTANGLES USING
                               arectl);    // COORDINATES FROM HERE

       GpiSetPattern(hPS, PATSYM_DIAG2);   // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn);          // PAINT REGION

       //******************RECT IN REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiRectInRegion: Rect In Region - Entry.\n");

       rectl[0].xLeft = 5500;              // SET UP RECTANGLE COORDINATES
       rectl[0].yBottom = 2500;            // IN THE REGION
       rectl[0].xRight = 7000;
       rectl[0].yTop = 4000;

       ppt.x = rectl[0].xLeft;
       ppt.y = rectl[0].yBottom;           // OUTLINE RECTANGLE
       MapPt(ppt);                         // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl[0].xRight;
       ppt.y = rectl[0].yTop;
       MapPt(ppt);                         // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       MapRect(rectl[0]);                  // MAP RECT. COORD. TO COOR. SP.
       lRectIn = GpiRectInRegion(hPS, hrgn, rectl);  // IS RECT. IN REGION

       if ( lRectIn !=  RRGN_INSIDE )      // CHECK IF RECT. IN REGION
           { /* BEGIN IF--LRECTIN */
               lErrorCount++;
               BADERROR("GpiRectInRegion", TRUE, "GpiRectInRegionExh");
               return;
           } /* END IF--LRECTIN */
       else
           { /* BEGIN ELSE--lRectIn */     // DISPLAY TEXT
               MapAndWriteString(hPS, 8300L, 3300L,"Rect");
               MapAndWriteString(hPS, 8300L, 3000L,"in");
               MapAndWriteString(hPS, 8300L, 2700L,"Region");
           } /* END ELSE--lRectIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiRectInRegion: Rect In Region - Exit.\n");

       //******************RECT OUT OF REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiRectInRegion: Rect OutOf Region - Entry.\n");

       rectl[0].xLeft = 1000;          // SET UP RECTANGLE COORDINATES
       rectl[0].yBottom = 1000;        // OUT OF REGION
       rectl[0].xRight = 3000;
       rectl[0].yTop = 3000;

       ppt.x = rectl[0].xLeft;
       ppt.y = rectl[0].yBottom;       // OUTLINE RECTANGLE
       MapPt(ppt);                     // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl[0].xRight;
       ppt.y = rectl[0].yTop;
       MapPt(ppt);                     // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       MapRect(rectl[0]);              // MAP RECTANGLE COORD. TO COORD. SP.
       lRectIn = GpiRectInRegion(hPS, hrgn, rectl);  // IS RECT. OUT OF REGION

       if ( lRectIn !=  RRGN_OUTSIDE ) // CHECK IF RECT. OUT OF REGION
           { /* BEGIN IF--LRECTIN */
               lErrorCount++;
               BADERROR("GpiRectInRegion", TRUE, "GpiRectInRegionExh");
               return;
           } /* END IF--LRECTIN */
       else
           { /* BEGIN ELSE--lRectIn */     // DISPLAY TEXT
               MapAndWriteString(hPS, 1000L, 3300L,"Rect Out of Region");
           } /* END ELSE--lRectIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiPtInRegion: Rect Outof Region - Exit.\n");

       //******************POINT PARTIALLY IN REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiRectInRegion: Rect Partial Region - Entry.\n");

       rectl[0].xLeft = 2000;              // SET UP RECTANGLE COORDINATES
       rectl[0].yBottom = 6000;            // PARTIALLY IN THE REGION
       rectl[0].xRight = 5000;
       rectl[0].yTop = 7500;

       ppt.x = rectl[0].xLeft;
       ppt.y = rectl[0].yBottom;           // OUTLINE RECTANGLE
       MapPt(ppt);                         // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl[0].xRight;
       ppt.y = rectl[0].yTop;
       MapPt(ppt);                         // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       MapRect(rectl[0]);                  // MAP RECT. COORD. TO COORD. SP.
       lRectIn = GpiRectInRegion(hPS, hrgn, rectl); // IS RECT. PART.IN REGION

       if ( lRectIn !=  RRGN_PARTIAL )   // CHECK IF RECT. PARTIALLY IN REGION
           { /* BEGIN IF--LRECTIN */
               lErrorCount++;
               BADERROR("GpiRectInRegion", TRUE, "GpiRectInRegionExh");
               return;
           } /* END IF--LRECTIN */
       else
           { /* BEGIN ELSE--lRectIn */     // DISPLAY TEXT
               MapAndWriteString(hPS, 1000L, 5500L,"Rect Partial in Region");
           } /* END ELSE--lRectIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiPtInRegion: Rect Partial Region - Exit.\n");

       GpiDestroyRegion(hPS, hrgn);        // DESTROY REGION HANDLE

       CWRITELOG(L_LOTRACE,0, "+ex+ GpiRectInRegion - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiRectInRegion Exhaustive Test                                -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiRectInRegion Exhaustive Test                                -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI RECTANGLE IN REGION EXHAUSTIVE TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiSetRegionExh
 *
 * Purpose: This is an entry point for the PTT that causes the exhaustive
 *              testing of GpiSetRegion.
 *
 * Systems Requirements: Section 5.7.3
 *
 * Revision Log: 10/24/90, PDVT, Gisselle Labault
 *               - created initial template
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs:    NONE
 *
 * Subroutines Required:
 *      RegionSetTest1(hPS,hWndClient) - SET A REGION OF ONE RECTANGLE.
 *      RegionSetTest2(hPS,hWndClient) - SET A REGION OF FOUR RECTANGLES.
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     Call SetRegion Test 1 for one Rectangle
 *     Call SetRegion Test 2 for four Rectangles.
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiSetRegionExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI SET REGION EXHAUSTIVE TEST */

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */
       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0,
                   "+ee+ GpiSetRegion Exhaustive Test - Entry.\n");

       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       RegionSetTest1(hPS,hWndClient);     // Test one Rectangle
       RegionSetTest2(hPS,hWndClient);     // Test four Rectangles
       CWRITELOG(L_LOTRACE,0,
                   "+ex+ GpiSetRegion Exhaustive Test - Exit.\n");
       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"$ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiSetRegion Exhaustive Test                                   -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiSetRegion Exhaustive Test                                   -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI SET REGION EXHAUSTIVE TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: GpiQueryRegionBoxExh
 *
 * Purpose: This is an entry point for the PTT that causes exhaustive
 *              testing of GpiQueryRegionBox.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *               - initial function template
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs:    NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     Call QueryRegionBox test 1 for a Rectangle Region
 *     Call QueryRegionBox test 2 for a Null Region
 *     Call QueryRegionBox test 3 for a Complex Region
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY GpiQueryRegionBoxExh(HPS hPS,HWND hWndClient, BOOL SelectionCall)
{ /* BEGIN--GPI QUERY REGION BOX EXHAUSTIVE TEST */

  lErrorCount = 0L;

  if ( SelectionCall )
   { /* BEGIN IF--SELECTION CALL */

       WinSendMsg(hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
       *pBasisX = 10000;
       *pBasisY = 10000;

   } /* END IF--SELECTION CALL */
  else
   { /* BEGIN ELSE--SELECTION CALL */
       LOG_SIGNATURE;
       TEST_SIGNATURE(0,0);
       CWRITELOG(L_LOTRACE,0, "+ee+ GpiQueryRegionBox - Entry.\n");
       MapAndWriteString(hPS, 100L, 9000L,"RUNS ONLY IN PELS");

       RegionBoxTest1(hPS, hWndClient);
       RegionBoxTest2(hPS, hWndClient);
       RegionBoxTest3(hPS, hWndClient);
       CWRITELOG(L_LOTRACE,0, "+ex+ GpiQueryRegionBox - Exit.\n");

       if ( lErrorCount )
           { /* BEGIN IF--LERRORCOUNT */
               sprintf(error_message,"ErrorCount = %ld.\n", lErrorCount);
               CWRITELOG(L_HDR,0, error_message);
           CWRITELOG(L_HDR,0,
"$GpiQueryRegionBox Exhaustive Test                              -    FAIL.\n");
           } /* END IF--LERRORCOUNT */
       else
           CWRITELOG(L_HDR,0,
"$GpiQueryRegionBox Exhaustive Test                              -    PASS.\n");

   } /* END ELSE--SELECTION CALL */

} /* END--GPI QUERY REGION BOX EXHAUSTIVE TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionApp2
 *
 * Purpose: This is an entry point for the PTT that causes the Gpi
 *           Region application test to be run.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 10/25/90, PDVT, Gisselle Labault
 *               - initial function template
 *               11/29/90, PDVT, JANET TRENT
 *               - TEST CASE CODE
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *   SelectionCall  // selection parameter
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     CREATE 2 REGIONS AND DISPLAY THEM.
 *
 *     CALL GPICOMBINE REGION AND COMBINE REGION 1 AND 2 IN AN AND-OPERATION
 *     DISPLAY THE RESULTING REGION 3
 *
 *     DISPLAY RECTANGLE IN REGION 2.
 *     CALL GPIRECTINREGION FOR REGION 2.
 *     CHECK THAT VALUE RETURNED == RRGN_INSIDE
 *
 *     DISPLAY A POINT OUTSIDE ANY REGION.
 *     CALL GPIPTINREGION FOR REGION 1.
 *     CHECK THAT VALUE RETURNED == PRGN_OUTSIDE
 *
 *\\end
 ***************************************************************************/
VOID APIENTRY RegionApp2(HPS hPS,HWND hWndClient)
{ /* BEGIN--GPI REGION APPLICATION TEST */

LONG lCombine;                         // GPICOMBINE REGION RETURN VALUE
POINTL ptl, ppt;                       // POINT STRUCTURES
LONG lPtIn,                            // GPIPTIN REGION RETURN VALUE
     lRectIn;                          // GPIRECTIN REGION RETURN VALUE
HRGN hrgn1;                            // REGION HANDLE 1
HRGN hrgn2;                            // REGION HANDLE 2
HRGN hrgn3;                            // REGION HANDLE 3
RECTL rectl[1];                        // RECTANGLE COORDINATES
RECTL rectl1[1];                       // REGION 1 OUTLINE COORDINATES
RECTL rectl2[1];                       // REGION 2 OUTLINE COORDINATES
RECTL arectl1[1];                      // REGION 1 COORDINATES
RECTL arectl2[1];                      // REGION 2 COORDINATES
RECTL arectl3[1];                      // REGION 3 COORDINATES

       CWRITELOG(L_LOTRACE,0, "+ie+ GpiCombineRegion App - Entry.\n");

       //*****GpiCreate and GpiCombine

       arectl1[0].xLeft   = 1000;      // REGION 1 AND
       arectl1[0].yBottom = 2000;
       arectl1[0].xRight  = 6000;
       arectl1[0].yTop    = 5000;
       arectl2[0].xLeft   = 4000;      // REGION 2 AND
       arectl2[0].yBottom = 3000;
       arectl2[0].xRight  = 8000;
       arectl2[0].yTop    = 8000;
       arectl3[0].xLeft   = 0;        // REGION 3 AND
       arectl3[0].yBottom = 0;
       arectl3[0].xRight  = 0;
       arectl3[0].yTop    = 0;

       //***
       rectl1[0].xLeft = 1000;
       rectl1[0].yBottom = 2000;
       rectl1[0].xRight = 6000;
       rectl1[0].yTop = 5000;

       ppt.x = rectl1[0].xLeft;
       ppt.y = rectl1[0].yBottom;         // OUTLINE RECTANGLE
       MapPt(ppt);                         // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl1[0].xRight;
       ppt.y = rectl1[0].yTop;
       MapPt(ppt);                         // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       //***
       rectl2[0].xLeft = 4000;
       rectl2[0].yBottom = 3000;
       rectl2[0].xRight = 8000;
       rectl2[0].yTop = 8000;

       ppt.x = rectl2[0].xLeft;
       ppt.y = rectl2[0].yBottom;         // OUTLINE RECTANGLE
       MapPt(ppt);                         // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl2[0].xRight;
       ppt.y = rectl2[0].yTop;
       MapPt(ppt);                         // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       // *********
       MapRect(arectl1[0]);                      // MAP RECT. TO COOR. SP.
       hrgn1 = GpiCreateRegion( hPS,             // CREATE 1ST REGION
                                 1L,             // OF ONE RECTANGLE USING
                                 &arectl1[0]);   // COORDINATES FROM HERE

       MapRect(arectl2[0]);                      // MAP RECT. TO COOR. SP.
       hrgn2 = GpiCreateRegion( hPS,             // CREATE 2ND REGION
                                 1L,             // OF ONE RECTANGLE USING
                                 &arectl2[0]);   // COORDINATES FROM HERE
       // *********
       GpiSetPattern(hPS, PATSYM_DIAG2);          // SET PATTERN TO DIAG2.
       GpiPaintRegion(hPS, hrgn1);               // PAINT 1ST REGION
            //TSS...was HORIZ change to DIAG3
       GpiSetPattern(hPS, PATSYM_DIAG3);         // SET PATTERN TO HORIZ.
       GpiPaintRegion(hPS, hrgn2);               // PAINT 2ND REGION

       // *********
       MapRect(arectl3[0]);                      // MAP RECT. TO COOR. SP.
       hrgn3 = GpiCreateRegion( hPS,             // CREATE 3RD REGION
                                 1L,             // OF ONE RECTANGLE USING
                                 &arectl3[0]);   // COORDINATES FROM HERE

       // COMBINE THE 1ST AND 2ND REGIONS AS SPECIFIED BY THE OPERATION.
       // THE RESULT OF THE COMBINATION IS PLACED IN THE 3RD REGION.
       lCombine = GpiCombineRegion(hPS, hrgn3, hrgn1, hrgn2, CRGN_AND);

       if ( lCombine != RGN_RECT )     // COMBINED REGION SHOULD BE A RECT.
           { /* BEGIN IF--LCOMBINE */
               lErrorCount++;
               BADERROR("GpiCombineRegion", TRUE, "GpiCombineRegionExh");
               return;
           } /* END IF--LCOMBINE */
       else
           { /* BEGIN ELSE--LCOMBINE */

               GpiSetPattern(hPS, PATSYM_DENSE6);        // SET PATTERN TO 6
               GpiPaintRegion(hPS, hrgn3);               // PAINT 3RD REGION

               MapAndWriteString(hPS, 1000L, 5900L,"REG1:DIAG2.");
               MapAndWriteString(hPS, 1000L, 5600L,"REG2:DIAG3.");
               MapAndWriteString(hPS, 1000L, 5300L,"REG AND_COMBO:CHECKRD");

           } /* END ELSE--LCOMBINE */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiCombineRegion App - Exit.\n");

       //******************POINT OUT OF REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiPtInRegion App - Entry.\n");

       ptl.x = 1000;                          // DRAW POINT
       ptl.y = 7000;
       MapPt(ptl);
       GpiCharStringAt(hPS,&ptl,2L,". ");
                                            // CHECK IF POINT IN REGION
       lPtIn = GpiPtInRegion(hPS, hrgn1, &ptl);

       if ( lPtIn !=  PRGN_OUTSIDE )    // CHECK THAT POINT IS OUT OF REGION
           { /* BEGIN IF--LPTIN */
               lErrorCount++;
               BADERROR("GpiPtInRegion", TRUE, "GpiPtInRegionExh");
               return;
           } /* END IF--LPTIN */
       else
           { /* BEGIN ELSE--lPtIn */
               MapAndWriteString(hPS, 1000L, 7500L,"Pt Out of Region");
           } /* END ELSE--lPtIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiPtInRegion App - Exit.\n");

       //******************RECT IN REGION
       CWRITELOG(L_LOTRACE,0, "+ie+ GpiRectInRegion App - Entry.\n");

       rectl[0].xLeft = 5000;
       rectl[0].yBottom = 6000;        // SET UP RECTANGLE
       rectl[0].xRight = 7000;
       rectl[0].yTop = 7000;

       ppt.x = rectl[0].xLeft;
       ppt.y = rectl[0].yBottom;         // OUTLINE RECTANGLE
       MapPt(ppt);                       // ONE CORNER
       GpiMove(hPS, &ppt);
       ppt.x = rectl[0].xRight;
       ppt.y = rectl[0].yTop;
       MapPt(ppt);                         // OTHER CORNER
       GpiBox(hPS, DRO_OUTLINE, &ppt, 1L, 1L);

       MapRect(rectl[0]);                  // MAP RECTANGLE TO COORD. SP.
       lRectIn = GpiRectInRegion(hPS, hrgn2, rectl);

       if ( lRectIn !=  RRGN_INSIDE )      // CHECK THAT RECT INSIDE REGION
           { /* BEGIN IF--LRECTIN */
               lErrorCount++;
               BADERROR("GpiRectInRegion", TRUE, "GpiRectInRegionExh");
               return;
           } /* END IF--LRECTIN */
       else
           { /* BEGIN ELSE--lRectIn */
               MapAndWriteString(hPS, 8150L, 6000L,"Rect in Region");
           } /* END ELSE--lRectIn */

       CWRITELOG(L_LOTRACE,0, "+ix+ GpiRectInRegion App - Exit.\n");


} /* END--GPI REGION APPLICATION TEST */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionSetTest1
 *
 * Purpose: Tests the function GpiSetRegion for one rectangle region.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 1:
 *         CREATE 1 REGION WITH ONE RECTANGLE
 *         CHECK THAT RETURN CODE WAS != RGN_ERROR
 *
 *\\end
 ***************************************************************************/
INT RegionSetTest1(HPS hPS, HWND hWndClient)

{ /* BEGIN--SET REGION TEST 1 */

BOOL bSet;                         // GpiSetRegion return value
HRGN hrgn;                         // REGION HANDLE
RECTL new_rectl[1];                // SET REGION RECTANGLE STRUCTURE
RECTL rectl[4];                    // CREATE REGION RECTANGLE STRUCTURE

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiSetRegion: 1Rect. - Entry.\n");

   new_rectl[0].xLeft = 1000;      // SET REGION RECTANGLE COORDINATES
   new_rectl[0].yBottom = 5000;
   new_rectl[0].xRight = 2000;
   new_rectl[0].yTop = 6000;

   rectl[0].xLeft = 3700;          // CREATE REGION RECTANGLE COORDINATES
   rectl[0].yBottom = 2700;
   rectl[0].xRight = 5000;
   rectl[0].yTop = 4000;
   rectl[1].xLeft = 4000;
   rectl[1].yBottom = 3000;
   rectl[1].xRight = 7000;
   rectl[1].yTop = 6000;
   rectl[2].xLeft = 3000;
   rectl[2].yBottom = 1000;
   rectl[2].xRight = 3500;
   rectl[2].yTop = 9000;
   rectl[3].xLeft = 7000;
   rectl[3].yBottom = 7000;
   rectl[3].xRight = 9000;
   rectl[3].yTop = 9000;

   MapRect(rectl[0]);               // MAP CREATION COORDINATES
   MapRect(rectl[1]);
   MapRect(rectl[2]);
   MapRect(rectl[3]);
   hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                           4L,       // OF FOUR RECTANGLES USING
                           rectl);   // COORDINATES FROM HERE

   if ( hrgn == RGN_ERROR)             // IF GPI RETURNED ERROR
       { /* BEGIN IF--HRGN */
           lErrorCount++;
           BADERROR("GpiSetRegion", TRUE, "GpiSetRegionExh");
           return(1);
       } /* END IF--HRGN */
   else
       { /* BEGIN ELSE--HRGN */       // ELSE SET REGION OF ONE RECTANGLE
           MapRect(new_rectl[0]);     // MAP SET COORDINATES
           bSet = GpiSetRegion(hPS, hrgn, 1L, new_rectl);

           if ( bSet == FALSE )        // IF GPI RETURNED ERROR
           { /* BEGIN IF--BSET */
               lErrorCount++;
               BADERROR("GpiSetRegion", TRUE, "GpiSetRegionExh");
               return(1);
           } /* END IF--BSET */
           else
               { /* BEGIN ELSE--BSET */    // ELSE DISPLAY NEW REGION
                   MapAndWriteString(hPS, 100L, 6300L,"Dots: Region of 1 Rect.");
                   GpiSetPattern(hPS, PATSYM_DENSE8);   // SET PATTERN DENSE8
                   GpiPaintRegion(hPS, hrgn);          // PAINT REGION
               } /* END ELSE--BSET */

           GpiDestroyRegion(hPS, hrgn);        // DESTROY REGION
       } /* END ELSE--HRGN */

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiSetRegion: 1Rect. - Exit.\n");

   return(1);

} /* END--SET REGION TEST 1 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionSetTest2
 *
 * Purpose: Tests the function GpiSetRegion for a four rectangle region.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *
 * Outputs:
 *
 * Subroutines Required:
 *
 * Limitations:
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 2:
 *         CREATE 1 REGION WITH FOUR RECTANGLES
 *         CHECK THAT RETURN CODE WAS != RGN_ERROR
 *
 *\\end
 ***************************************************************************/
INT RegionSetTest2(HPS hPS, HWND hWndClient)

{ /* BEGIN--SET REGION TEST 2 */

BOOL bSet;                         // GpiSetRegion return value
HRGN hrgn;                         // REGION HANDLE
RECTL new_rectl[4];                // SET REGION RECTANGLE STRUCTURE
RECTL rectl[1];                    // CREATE REGION RECTANGLE STRUCTURE

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiSetRegion: 4Rects. - Entry.\n");

   rectl[0].xLeft = 1000;      // CREATE REGION RECTANGLE COORDINATES
   rectl[0].yBottom = 5000;
   rectl[0].xRight = 2000;
   rectl[0].yTop = 6000;

   new_rectl[0].xLeft = 3700;  // SET REGION RECTANGLE COORDINATES
   new_rectl[0].yBottom = 2700;
   new_rectl[0].xRight = 5000;
   new_rectl[0].yTop = 4000;
   new_rectl[1].xLeft = 4000;
   new_rectl[1].yBottom = 3000;
   new_rectl[1].xRight = 7000;
   new_rectl[1].yTop = 6000;
   new_rectl[2].xLeft = 3000;
   new_rectl[2].yBottom = 1000;
   new_rectl[2].xRight = 3500;
   new_rectl[2].yTop = 9000;
   new_rectl[3].xLeft = 7000;
   new_rectl[3].yBottom = 7000;
   new_rectl[3].xRight = 9000;
   new_rectl[3].yTop = 9000;

   MapRect(rectl[0]);                // MAP RECT POINTS TO COORD. SPACE
   hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                           1L,       // OF ONE RECTANGLE USING
                           rectl);   // COORDINATES FROM HERE

   if ( hrgn == RGN_ERROR)                      // IF GPI RETURNED AN ERROR
       { /* BEGIN IF--HRGN */
           lErrorCount++;
           BADERROR("GpiSetRegion", TRUE, "GpiSetRegionExh");
           return(1);
       } /* END IF--HRGN */
   else
       { /* BEGIN ELSE--HRGN */
           MapRect(new_rectl[0]);      // MAP RECT POINTS TO COORD. SPACE
           MapRect(new_rectl[1]);
           MapRect(new_rectl[2]);
           MapRect(new_rectl[3]);      // SET REGION OF FOUR RECTANGLES
           bSet = GpiSetRegion(hPS, hrgn, 4L, new_rectl);

           if ( bSet == FALSE )        // IF GPI RETURNED AN ERROR
               { /* BEGIN IF--BSET */
                   lErrorCount++;
                   BADERROR("GpiSetRegion", TRUE, "GpiSetRegionExh");
                   return(1);
               } /* END IF--BSET */
           else
               { /* BEGIN ELSE--BSET */    // ELSE DISPLAY NEW REGION
                   MapAndWriteString(hPS, 4500L, 6300L,"Horiz: Region of 4 Rects.");
                   GpiSetPattern(hPS, PATSYM_HORIZ); // SET PATTERN TO DIAG2.
                   GpiPaintRegion(hPS, hrgn);        // PAINT REGION
               } /* END ELSE--BSET */

           GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION
       } /* END ELSE--HRGN */

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiSetRegion: 4Rects. - Exit.\n");

   return(1);

} /* END--SET REGION TEST 2 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionCreateTest1
 *
 * Purpose: Tests the function GpiCreateRegion for one rectangle region.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *
 * Outputs:  NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 1:
 *         CREATE 1 REGION WITH ONE RECTANGLE
 *         CHECK THAT RETURN CODE WAS != RGN_ERROR
 *
 *\\end
 ***************************************************************************/
INT RegionCreateTest1(HPS hPS, HWND hWndClient)

{ /* BEGIN--CREATE REGION TEST 1 */

HRGN hrgn;         // REGION HANDLE
RECTL arectl[1];   // REGION RECTANGLE COORDINATES

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiCreateRegion: 1Rect. - Entry.\n");

   arectl[0].xLeft   = 1000;         // REGION COORDINATES
   arectl[0].yBottom = 5000;
   arectl[0].xRight  = 2000;
   arectl[0].yTop    = 6000;

   MapRect(arectl[0]);
   hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                           1L,       // OF ONE RECTANGLE USING
                           arectl);  // COORDINATES FROM HERE

   if ( hrgn == RGN_ERROR)             // IF GPI RETURNED ERROR
       { /* BEGIN IF--HRGN */
           lErrorCount++;
           BADERROR("GpiCreateRegion", TRUE, "GpiCreateRegionExh");
           return(1);
       } /* END IF--HRGN */
   else
       { /* BEGIN ELSE--HRGN */                    // ELSE DISPLAY REGION

           MapAndWriteString(hPS, 100L, 6300L,"Dots: Region of 1 Rect.");

           GpiSetPattern(hPS, PATSYM_DENSE8);      // SET PATTERN TO DENSE8
           GpiPaintRegion(hPS, hrgn);              // PAINT REGION
           GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION
       } /* END ELSE--HRGN */

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiCreateRegion: 1Rect. - Exit.\n");

   return(1);

} /* END--CREATE REGION TEST 1 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionCreateTest2
 *
 * Purpose: Tests the function GpiCreateRegion for a four rectangle region.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *   hWndClient // client window
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 2:
 *         CREATE 1 REGION WITH FOUR RECTANGLES
 *         CHECK THAT RETURN CODE WAS != RGN_ERROR
 *
 *\\end
 ***************************************************************************/
INT RegionCreateTest2(HPS hPS, HWND hWndClient)

{ /* BEGIN--CREATE REGION TEST 2 */

HRGN hrgn;                                 // REGION HANDLE
RECTL arectl[4];                           // REGION RECTANGLE COORDINATES

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiCreateRegion: 4Rects. - Entry.\n");

   arectl[0].xLeft   = 3700;         // RECT 1
   arectl[0].yBottom = 2700;
   arectl[0].xRight  = 5000;
   arectl[0].yTop    = 4000;

   arectl[1].xLeft   = 4000;         // RECT 2
   arectl[1].yBottom = 3000;
   arectl[1].xRight  = 7000;
   arectl[1].yTop    = 6000;

   arectl[2].xLeft   = 3000;         // RECT 3
   arectl[2].yBottom = 1000;
   arectl[2].xRight  = 3500;
   arectl[2].yTop    = 9000;

   arectl[3].xLeft   = 7000;         // RECT 4
   arectl[3].yBottom = 7000;
   arectl[3].xRight  = 9000;
   arectl[3].yTop    = 9000;

   MapRect(arectl[0]);                 // MAP RECT POINTS TO COORD. SPACE
   MapRect(arectl[1]);
   MapRect(arectl[2]);
   MapRect(arectl[3]);
   hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                           4L,       // OF FOUR RECTANGLES USING
                           arectl);  // COORDINATES FROM HERE

   if ( hrgn == RGN_ERROR)                         // IF GPI RETURNED AN ERROR
       { /* BEGIN IF--HRGN */
           lErrorCount++;
           BADERROR("GpiCreateRegion", TRUE, "GpiCreateRegionExh");
           return(1);
       } /* END IF--HRGN */
   else
       { /* BEGIN ELSE--HRGN */
           MapAndWriteString(hPS, 4300L, 6300L,"Horiz: Region of 4 Rects.");

           GpiSetPattern(hPS, PATSYM_HORIZ);       // SET PATTERN TO DIAG2.
           GpiPaintRegion(hPS, hrgn);              // PAINT REGION
           GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION
       } /* END ELSE--HRGN */

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiCreateRegion: 4Rects. - Exit.\n");

   return(1);

} /* END--CREATE REGION TEST 2 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionBoxTest1
 *
 * Purpose: Tests the function GpiQueryRegionBox for a RGN_RECT return code.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 1:
 *         CREATE 1 REGION WITH VALID COORDINATES
 *         CALL GPI USING HANDLE FROM CREATE REGION AND VALID HPS
 *         CHECK IF RETURN CODE WAS RGN_RECT
 *             IF SO, CHECK THAT GPI COORDINATES EQUAL CREATION COORDINATES.
 *
 *\\end
 ***************************************************************************/
INT RegionBoxTest1(HPS hPS, HWND hWndClient)

{ /* BEGIN--REGION BOX TEST 1 */

RECTL arectl[1];       // REGION COORDINATES
RECTL rect_test;       // RETURN REGION COORDINATES FROM QUERY
HRGN hrgn;             // REGION HANDLE
LONG lQueryBox;        // GPIQUERYREGIONBOX RETURN VALUE

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiQueryRegionBox: Test1 - Entry.\n");

   arectl[0].xLeft = 1000;         // SET UP RECTANGLE COORDINATES
   arectl[0].yBottom = 1000;
   arectl[0].xRight = 3000;
   arectl[0].yTop = 7000;
   MapRect(arectl[0]);
   hrgn = GpiCreateRegion( hPS,      // CREATE REGION IN PRESENTATION SPACE
                           1L,       // OF ONE RECTANGLE USING
                           arectl);  // COORDINATES FROM HERE

   GpiSetPattern(hPS, PATSYM_HORIZ); // SET PATTERN TO HORIZ.
   GpiPaintRegion(hPS, hrgn);        // PAINT REGION

   lQueryBox = GpiQueryRegionBox( hPS,       // QUERY THE REGION TO GET ITS
                                  hrgn,      // COORDINATES WHICH ARE
                               &rect_test);  // RETURNED IN HERE

   if ( lQueryBox == RGN_RECT )    // CHECK IF RETURN CODE EQUALS RGN RECT
       { /* BEGIN IF--LQUERYBOX */ // CHECK CREATION AND RETURNED COORDINATES
           if ( (rect_test.xLeft == arectl[0].xLeft) &&
                (rect_test.xRight == arectl[0].xRight) &&
                (rect_test.yTop == arectl[0].yTop) &&
                (rect_test.yBottom == arectl[0].yBottom) )
                { /* BEGIN IF--RECT */
                   MapAndWriteString(hPS, 1000L, 7300L,"REGION IS RECT");
               } /* END IF--RECT */
           else
               { /* BEGIN ELSE--RECT */
                   lErrorCount++;
                   BADERROR("GpiQueryRegionBox", TRUE, "GpiQueryRegionBoxExh");
                   return(1);
               } /* END ELSE--RECT */
       } /* END IF--LQUERYBOX */
   else
       { /* BEGIN ELSE--LQUERYBOX */
           lErrorCount += BADERROR("GpiQueryRegionBox", FALSE, NULL);
       } /* END ELSE--LQUERYBOX */

   GpiDestroyRegion(hPS, hrgn);            // DESTROY REGION

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiQueryRegionBox: Test1 - Exit.\n");
   return(1);

} /* END--REGION BOX TEST 1 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionBoxTest2
 *
 * Purpose: Tests the function GpiQueryRegionBox for a RGN_NULL return code.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *
 * Outputs: NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *
 *     TEST 2:
 *         CREATE 1 REGION WITH INVALID COORDINATES--0,0,0,0
 *         CALL GPI USING HANDLE FROM CREATE REGION AND VALID HPS
 *         CHECK IF RETURN CODE WAS RGN_NULL
 *             IF SO, CHECK GPI COORDINATES SO
 *                 THAT THE LEFT BOUNDARY EQUALS THE RIGHT BOUNDARY AND
 *                 THAT THE TOP BOUNDARY EQUALS THE BOTTOM BOUNDARY.
 *
 *\\end
 ***************************************************************************/
INT RegionBoxTest2(HPS hPS, HWND hWndClient)

{ /* BEGIN--REGION BOX TEST 2 */

RECTL arectl[1];           // REGION COORDINATES
RECTL rect_test;           // RETURN REGION COORDINATES FROM QUERY
HRGN hrgn;                 // REGION HANDLE
LONG lQueryBox;            // GPIQUERYREGIONBOX RETURN VALUE

   CWRITELOG(L_LOTRACE,0, "+ie+ GpiQueryRegionBox: Test2 - Entry.\n");

   arectl[0].xLeft = 0;         // SET UP RECTANGLE COORDINATES
   arectl[0].xRight = 0;
   arectl[0].yBottom = 0;
   arectl[0].yTop = 0;
   MapRect(arectl[0]);
   hrgn = GpiCreateRegion( hPS,        // CREATE REGION IN PRESENTATION SPACE
                           0L,         // WITH A ZERO COUNT
                           arectl);    // FOR NUMBER OF RECTANGLES

   GpiSetPattern(hPS, PATSYM_DIAG2);  // SET PATTERN TO DIAG2
   GpiPaintRegion(hPS, hrgn);        // PAINT REGION

   lQueryBox = GpiQueryRegionBox( hPS,         // QUERY THE REGION TO GET ITS
                               hrgn,           // COORDINATES WHICH ARE
                               &rect_test);    // RETURNED IN HERE

   if ( lQueryBox == RGN_NULL )    // CHECK IF RETURN CODE EQUALS RGN NULL
       { /* BEGIN IF--LQUERYBOX */ // CHECK THAT RETURNED COORDINATES
           if ( (rect_test.xLeft == rect_test.xRight) &&  // EQUAL EACH
                (rect_test.yTop == rect_test.yBottom) )   // OTHER
                { /* BEGIN IF--RECT */
                   MapAndWriteString(hPS, 3500L, 7300L,"REGION IS NULL");
               } /* END IF--RECT */
           else
               { /* BEGIN ELSE--RECT */
                   lErrorCount++;
                   BADERROR("GpiQueryRegionBox", TRUE, "GpiQueryRegionBoxExh");
                   return(1);
               } /* END ELSE--RECT */
       } /* END IF--LQUERYBOX */
   else
       { /* BEGIN ELSE--LQUERYBOX */
           lErrorCount += BADERROR("GpiQueryRegionBox", FALSE, NULL);
       } /* END ELSE--LQUERYBOX */

   CWRITELOG(L_LOTRACE,0, "+ix+ GpiQueryRegionBox: Test2 - Exit.\n");
   return(1);

} /* END--REGION BOX TEST 2 */

/***************************************************************************
 *\\ddd
 * Routine Name: RegionBoxTest3
 *
 * Purpose: Tests the function GpiQueryRegionBox for a RGN_COMPLEX
 *                                                     return code.
 *
 * Systems Requirements: Section 5.8.2
 *
 * Revision Log: 11/09/90, PDVT, JANET TRENT
 *               - initial
 *
 * Inputs:
 *   hPS        // presentation space
 *
 * Outputs:    NONE
 *
 * Subroutines Required: NONE
 *
 * Limitations: NONE
 *
 *\\end
 ***************************************************************************/

/***************************************************************************
 *\\algorithm
 *
 *     TEST 3:
 *         CREATE 3 REGIONS WITH VALID COORDINATES
 *         CALL GPI USING HANDLE FROM CREATE REGION AND VALID HPS
 *         CHECK IF RETURN CODE WAS RGN_COMPLEX
 *             IF SO, CHECK THAT GPI COORDINATES EQUAL CREATION COORDINATES.
 *
 *
 *\\end
 ***************************************************************************/
INT RegionBoxTest3(HPS hPS, HWND hWndClient)

{ /* BEGIN--REGION BOX TEST 3 */

RECTL arectl[3];                   // REGION COORDINATES
RECTL rect_test;                   // RETURN REGION COORDINATES FROM QUERY
LONG lQueryBox;                    // GPIQUERYREGIONBOX RETURN VALUE
HRGN hrgn;                         // REGION HANDLE

   arectl[0].xLeft = 7000;         // SET UP FIRST RECTANGLE COORDINATES
   arectl[0].yBottom = 1000;
   arectl[0].xRight = 9000;
   arectl[0].yTop = 3000;
   arectl[1].xLeft = 8000;         // SET UP SECOND RECTANGLE COORDINATES
   arectl[1].yBottom = 2000;
   arectl[1].xRight = 10000;
   arectl[1].yTop = 5000;
   arectl[2].xLeft = 6500;         // SET UP THIRD RECTANGLE COORDINATES
   arectl[2].yBottom = 4000;
   arectl[2].xRight = 8500;
   arectl[2].yTop = 6500;

   MapRect(arectl[0]);             // MAP REGION COORD. TO COORD. SP.
   MapRect(arectl[1]);
   MapRect(arectl[2]);
   hrgn = GpiCreateRegion( hPS,    // CREATE REGION IN PRESENTATION SPACE
                           3L,              // OF THREE RECTANGLES USING
                           arectl);  // COORDINATES FROM HERE

   GpiSetPattern(hPS, PATSYM_DENSE6); // SET PATTERN TO 6
   GpiPaintRegion(hPS, hrgn);        // PAINT REGION

   lQueryBox = GpiQueryRegionBox( hPS,         // QUERY THE REGION TO GET ITS
                               hrgn,           // COORDINATES WHICH ARE
                               &rect_test);    // RETURNED IN HERE

   if ( lQueryBox == RGN_COMPLEX ) // CHECK IF RETURN CODE EQUALS RGN COMPLEX
       { /* BEGIN IF--LQUERYBOX*/  // CHECK CREATION AND RETURNED COORDINATES
           MapAndWriteString(hPS, 7000L, 7300L,"REGION IS COMPLEX");
       } /* END IF--LQUERYBOX */
   else
       { /* BEGIN ELSE--LQUERYBOX */
           lErrorCount++;
           BADERROR("GpiQueryRegionBox", TRUE, "GpiQueryRegionBoxExh");
           return(1);
       } /* END ELSE--LQUERYBOX */

   return(1);

} /* END--REGION BOX TEST 3 */

