#define INCL_WIN      /* win function definitions */
#define INCL_GPI      /* gpi definitions */
#define INCL_DEV      /* device definitions */

#include <string.h>
#include <stdio.h>
#include <os2.h>
#include "PTTDLLDF.h" // test case defines
#include "tgraphic.h"
#include "std_util.h"
#include "gpi_grid.h"

VOID EXPENTRY tLabel( HPS hPS )
{
   POINTL ptl;
   LONG   lrow, lcol;

   for (lrow=2; lrow<=6; lrow = lrow+2) {
      for (lcol=1; lcol<=5; lcol = lcol+2) {
         ptl.x = delta_x * lcol;
         ptl.y = delta_y * lrow + (LONG) (delta_y / 8);
         MapPt( ptl );

         switch ((USHORT) lrow) {
         case 2:
            switch ((USHORT) lcol) {
            case 1:
               GpiCharStringAt( hPS, &ptl, 6L,"MARKER" );
               break;
            case 3:
               GpiCharStringAt( hPS, &ptl, 9L,"POLYLINES" );
               break;
            case 5:
               GpiCharStringAt( hPS, &ptl, 10L,"THICKLINES" );
               break;
            } /* endswitch */
             break;

         case 4:
            switch ((USHORT) lcol) {
            case 1:
               GpiCharStringAt( hPS, &ptl, 7L,"CIRCLES" );
               break;
            case 3:
               GpiCharStringAt( hPS, &ptl, 11L,"PARTIALARCS" );
               break;
            case 5:
               GpiCharStringAt( hPS, &ptl, 9L,"POINTARCS" );
               break;
            } /* endswitch */
            break;

         case 6:
            switch ((USHORT) lcol) {
            case 1:
               GpiCharStringAt( hPS, &ptl, 5L,"LINES" );
               break;
            case 3:
               GpiCharStringAt( hPS, &ptl, 5L,"BOXES" );
               break;
            case 5:
               GpiCharStringAt( hPS, &ptl, 4L,"TEXT" );
               break;
            } /* endswitch */
            break;
         } /* endswitch */

      } /* endfor */
   } /* endfor */


}

VOID EXPENTRY tPolySquare(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl, POINTL ptlShape[5] )
{

        ptl.x = delta_x * tX;
        ptl.y = delta_y * tY;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptlShape[0].x = delta_x * tX;
        ptlShape[0].y = delta_y * (tY+1);
        MapPt(ptlShape[0]);

        ptlShape[1].x = delta_x * (tX+1);
        ptlShape[1].y = delta_y * (tY+1);
        MapPt(ptlShape[1]);

        ptlShape[2].x = delta_x * (tX+1);
        ptlShape[2].y = delta_y * tY;
        MapPt(ptlShape[2]);

        ptlShape[3].x = delta_x * tX;
        ptlShape[3].y = delta_y * tY;
        MapPt(ptlShape[3]);

        GpiPolyLine(hPS, 4L, ptlShape );

}


VOID EXPENTRY tLineSquare(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl )
{

        ptl.x = delta_x * tX;
        ptl.y = delta_y * tY;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptl.x = delta_x * tX;
        ptl.y = delta_y * (tY+1);
        MapPt(ptl);
        GpiLine( hPS, &ptl );

        ptl.x = delta_x * (tX+1);
        ptl.y = delta_y * (tY+1);
        MapPt(ptl);
        GpiLine( hPS, &ptl );

        ptl.x = delta_x * (tX+1);
        ptl.y = delta_y * tY;
        MapPt(ptl);
        GpiLine( hPS, &ptl );

        ptl.x = delta_x * tX;
        ptl.y = delta_y * tY;
        MapPt(ptl);
        GpiLine( hPS, &ptl );

}


VOID EXPENTRY tBox(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl )
{

        ptl.x = delta_x * tX;
        ptl.y = delta_y * tY;
        MapPt(ptl);
        GpiMove (hPS, &ptl);

        ptl.x = delta_x * (tX+1);
        ptl.y = delta_y * (tY+1);
        MapPt(ptl);
        GpiBox( hPS, DRO_OUTLINE, &ptl, 0L, 0L );


}


VOID EXPENTRY tFullArc(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl )
{


  POINTL delta_ptl;
  ARCPARAMS arcparam1;


    // Delta x and y initialization

    set_delta (hPS);
    delta_ptl.x = delta_x/8;
    delta_ptl.y = delta_y/8;

    arcparam1.lR = 0L;
    arcparam1.lQ = 4*delta_ptl.y;
    arcparam1.lP = 4*delta_ptl.x;
    arcparam1.lS = 0L;
    MapArc(arcparam1);
        GpiSetArcParams (hPS, &arcparam1);


     ptl.x = delta_x * tX + (LONG) (delta_x / 2);
     ptl.y = delta_y * tY + (LONG) (delta_y / 2);
     MapPt(ptl);
     GpiMove (hPS, &ptl);

     GpiFullArc( hPS, DRO_OUTLINE, FXTOLONG );

}



VOID EXPENTRY tFullArc2(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl )
{


  POINTL delta_ptl;
  ARCPARAMS arcparam1;


    // Delta x and y initialization

    set_delta (hPS);
    delta_ptl.x = delta_x/8;
    delta_ptl.y = delta_y/8;

    arcparam1.lR = 0L;
    arcparam1.lQ = 14*delta_ptl.y;
    arcparam1.lP = 12*delta_ptl.x;
    arcparam1.lS = 0L;
    MapArc(arcparam1);
        GpiSetArcParams (hPS, &arcparam1);


     ptl.x = delta_x * tX + (LONG) (delta_x );
     ptl.y = delta_y * tY + (LONG) (delta_y );
     MapPt(ptl);
     GpiMove (hPS, &ptl);

     GpiFullArc( hPS, DRO_OUTLINE, FXTOLONG );

}

VOID EXPENTRY tPartialArc(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl )
{


  POINTL delta_ptl;
  ARCPARAMS arcparam1;


    // Delta x and y initialization

    set_delta (hPS);
    delta_ptl.x = delta_x/8;
    delta_ptl.y = delta_y/8;

    arcparam1.lR = 0L;
    arcparam1.lQ = 4*delta_ptl.y;
    arcparam1.lP = 4*delta_ptl.x;
    arcparam1.lS = 0L;
    MapArc(arcparam1);
        GpiSetArcParams (hPS, &arcparam1);


     ptl.x = delta_x * tX + (LONG) (delta_x / 2);
     ptl.y = delta_y * tY + (LONG) (delta_y / 2);
     MapPt(ptl);
     GpiMove (hPS, &ptl);

     GpiPartialArc( hPS, &ptl, FXTOLONG, 0L, FXTOLONG*270 );
     GpiLine( hPS, &ptl );


}



VOID EXPENTRY tPointArc(HPS hPS, USHORT tX, USHORT tY,
                                   POINTL ptl, POINTL ptlArc[2])
{


  POINTL delta_ptl;
  ARCPARAMS arcparam1;


    // Delta x and y initialization

    set_delta (hPS);
    delta_ptl.x = delta_x/8;
    delta_ptl.y = delta_y/8;

    arcparam1.lR = 0L;
    arcparam1.lQ = 4*delta_ptl.y;
    arcparam1.lP = 4*delta_ptl.x;
    arcparam1.lS = 0L;
    MapArc(arcparam1);
        GpiSetArcParams (hPS, &arcparam1);


     ptl.x = delta_x * tX;
     ptl.y = delta_y * tY + (LONG) (delta_y / 2);
     MapPt(ptl);
     GpiMove (hPS, &ptl);

     ptlArc[0].x = delta_x * (tX+1);
     ptlArc[0].y = delta_y * tY;
     MapPt( ptlArc[0] );

     ptlArc[1].x = delta_x * tX + (LONG) (delta_x / 2);
     ptlArc[1].y = delta_y * (tY+1);
     MapPt( ptlArc[1] );

     ptlArc[2].x = delta_x * tX;
     ptlArc[2].y = delta_y * (tY+1);
     MapPt( ptlArc[2] );

     GpiPointArc( hPS, ptlArc );

}



VOID EXPENTRY tClipMe(HPS hPS)
{

  POINTL delta_ptl;
  POINTL ptlMisc;
  LONG   lTempY, lTempX;
  USHORT i;
  LONG   lMultiplier;
  POINTL ptlMulti[9];       /* changed for Metawre compiler from 8 - 9 */
  USHORT usCount;
  ARCPARAMS arcparam1;


    set_delta (hPS);
    delta_ptl.x = delta_x/8;
    delta_ptl.y = delta_y/8;

    arcparam1.lR = 0L;
    arcparam1.lQ = 4*delta_ptl.y;
    arcparam1.lP = 4*delta_ptl.x;
    arcparam1.lS = 0L;
    MapArc(arcparam1);
        GpiSetArcParams (hPS, &arcparam1);


 //  Draw the Polylines on upper left

    ptlMulti[0].x = (LONG) (delta_x * 7 / 8);
    ptlMulti[0].y = delta_y * 5 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[1].y = delta_y * 6 + (LONG) (delta_y / 8);
    MapPt( ptlMulti[1] );

    ptlMulti[2].x = delta_x * 2 + (LONG) (delta_x * 1 / 8);
    ptlMulti[2].y = delta_y * 5 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[2] );

    ptlMulti[3].x = delta_x * 1 + (LONG) (delta_x * 1 / 2);
    ptlMulti[3].y = delta_y * 4 + (LONG) (delta_y / 8 * 7);
    MapPt( ptlMulti[3] );

    ptlMulti[4].x = (LONG) (delta_x * 7 / 8);
    ptlMulti[4].y = delta_y * 5 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[4] );

    ptlMulti[5].x = delta_x * 2 + (LONG) (delta_x * 1 / 8);
    ptlMulti[5].y = delta_y * 5 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[5] );

    ptlMulti[6].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[6].y = delta_y * 6 + (LONG) (delta_y / 8);
    MapPt( ptlMulti[6] );

    ptlMulti[7].x = delta_x * 1 + (LONG) (delta_x * 1 / 2);
    ptlMulti[7].y = delta_y * 4 + (LONG) (delta_y / 8 * 7);
    MapPt( ptlMulti[7] );

    GpiMove( hPS, &ptlMulti[0] );
    GpiPolyLine( hPS, 8L, ptlMulti );


  // Draw Lines on bottom middle

    ptlMulti[0].x = delta_x * 2 + (LONG) (delta_x * 7 / 8);
    ptlMulti[0].y = delta_y + (LONG) (delta_y / 2);
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 3 + (LONG) (delta_x / 2);
    ptlMulti[1].y = delta_y * 2 + (LONG) (delta_y / 8);
    MapPt( ptlMulti[1] );

    ptlMulti[2].x = delta_x * 4 + (LONG) (delta_x * 1 / 8);
    ptlMulti[2].y = delta_y + (LONG) (delta_y / 2);
    MapPt( ptlMulti[2] );

    ptlMulti[3].x = delta_x * 3 + (LONG) (delta_x * 1 / 2);
    ptlMulti[3].y = (LONG) (delta_y / 8 * 7);
    MapPt( ptlMulti[3] );

    GpiMove( hPS, &ptlMulti[0] );
    GpiLine( hPS, &ptlMulti[1] );
    GpiLine( hPS, &ptlMulti[2] );
    GpiLine( hPS, &ptlMulti[3] );
    GpiLine( hPS, &ptlMulti[0] );
    GpiLine( hPS, &ptlMulti[2] );
    GpiLine( hPS, &ptlMulti[1] );
    GpiLine( hPS, &ptlMulti[3] );


  // Output text on middle right

    ptlMisc.x = delta_x * 4 + (LONG) (delta_x / 2);
    ptlMisc.y = delta_y * 4 + (LONG) (delta_x / 2);
    lTempX = ptlMisc.x;
    lTempY = ptlMisc.y;

    usCount = 0;

    while( usCount < 10 )
    {
       MapPt( ptlMisc );
       GpiMove( hPS, &ptlMisc );
       GpiCharString( hPS, 40L, "CLIPCLIPCLIPCLIPCLIPCLIPCLIPCLIPCLIPCLIP");
       lTempY = lTempY + (LONG) (delta_y / 4);
       ptlMisc.y = lTempY;
       ptlMisc.x = lTempX;
       usCount += 1;
     }


  // Draw Markers on Lower Left

    ptlMulti[0].x = delta_x * 1;
    ptlMulti[0].y = delta_y * 1;
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 1;
    ptlMulti[1].y = delta_y * 2;
    MapPt( ptlMulti[1] );

    ptlMulti[2].x = delta_x * 2;
    ptlMulti[2].y = delta_y * 2;
    MapPt( ptlMulti[2] );

    ptlMulti[3].x = delta_x * 2;
    ptlMulti[3].y = delta_y * 1;
    MapPt( ptlMulti[3] );

    ptlMulti[4].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[4].y = delta_y * 1 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[4] );

    ptlMulti[5].x = delta_x * 1;
    ptlMulti[5].y = delta_y * 1 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[5] );

    ptlMulti[6].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[6].y = delta_y * 2;
    MapPt( ptlMulti[6] );

    ptlMulti[7].x = delta_x * 2;
    ptlMulti[7].y = delta_y * 1 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[7] );

    ptlMulti[8].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[8].y = delta_y * 1;
    MapPt( ptlMulti[8] );

    GpiSetMarker( hPS, MARKSYM_SOLIDDIAMOND );

    for (i=0; i<=8; i++) {
       GpiMarker( hPS, &ptlMulti[i] );
    } /* endfor */


  // Put boxes on Upper Center


    ptlMulti[0].x = delta_x * 2 + (LONG) (delta_x / 2);
    ptlMulti[0].y = delta_y * 4 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 2 + (LONG) (delta_x / 2);
    ptlMulti[1].y = delta_y * 6 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[1] );

    ptlMulti[2].x = delta_x * 4 + (LONG) (delta_x / 2);
    ptlMulti[2].y = delta_y * 6 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[2] );

    ptlMulti[3].x = delta_x * 4 + (LONG) (delta_x / 2);
    ptlMulti[3].y = delta_y * 4 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[3] );

    ptlMisc.x = delta_x * 3 + (LONG) (delta_x / 2);
    ptlMisc.y = delta_y * 5 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );


    for (i=0; i<=3; i++) {
       GpiBox( hPS, DRO_OUTLINEFILL, &ptlMulti[i], 50L, 50L );
    } /* endfor */



  // Put Full Arcs in Middle Left


    ptlMulti[0].x = delta_x * 1;
    ptlMulti[0].y = delta_y * 3;
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 1;
    ptlMulti[1].y = delta_y * 4;
    MapPt( ptlMulti[1] );

    ptlMulti[2].x = delta_x * 2;
    ptlMulti[2].y = delta_y * 4;
    MapPt( ptlMulti[2] );

    ptlMulti[3].x = delta_x * 2;
    ptlMulti[3].y = delta_y * 3;
    MapPt( ptlMulti[3] );

    ptlMulti[4].x = delta_x * 1 + (LONG) (delta_x / 2);
    ptlMulti[4].y = delta_y * 3 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[4] );

    for (i=0; i<=4; i++) {
       GpiMove( hPS, &ptlMulti[i] );
       GpiFullArc( hPS, DRO_OUTLINEFILL, FXTOLONG/2 );
    } /* endfor */



  // Put Partial Arcs in Middle Middle

    lMultiplier = 0L;

    ptlMisc.x = delta_x * 2 + (LONG) (delta_x / 2);
    ptlMisc.y = delta_y * 2 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );

    while( lMultiplier <= 5 * FXTOLONG ) {
       GpiPartialArc( hPS, &ptlMisc, lMultiplier, FXTOLONG*25, FXTOLONG*40 );
       lMultiplier += (LONG) FXTOLONG / 5;
       }


  // Put Point Arcs in Middle Right


    ptlMulti[0].x = delta_x * 5 + (LONG) (delta_x / 2);
    ptlMulti[0].y = delta_y * 3 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[0] );

    ptlMulti[1].x = delta_x * 5 + (LONG) (delta_x / 2);
    ptlMulti[1].y = delta_y * 4 + (LONG) (delta_y / 2);
    MapPt( ptlMulti[1] );

    ptlMisc.x = delta_x * 4;
    ptlMisc.y = delta_y * 2 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );
    GpiPointArc( hPS, ptlMulti );

    ptlMisc.x = delta_x * 5;
    ptlMisc.y = delta_y * 2 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );
    GpiPointArc( hPS, ptlMulti );

    ptlMisc.x = delta_x * 6;
    ptlMisc.y = delta_y * 2 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );
    GpiPointArc( hPS, ptlMulti );

    ptlMisc.x = delta_x * 7;
    ptlMisc.y = delta_y * 2 + (LONG) (delta_y / 2);
    MapPt( ptlMisc );
    GpiMove( hPS, &ptlMisc );
    GpiPointArc( hPS, ptlMulti );



  // Draw thick line on lower right


        GpiBeginPath(hPS, 1L);
        GpiSetLineWidthGeom( hPS, 4L );

        ptlMulti[0].x = delta_x * 4 + (LONG) (delta_x * 7 / 8);
        ptlMulti[0].y = delta_y * 1 + (LONG) (delta_y / 2);
        MapPt( ptlMulti[0] );

        ptlMulti[1].x = delta_x * 5 + (LONG) (delta_x / 2);
        ptlMulti[1].y = delta_y * 2 + (LONG) (delta_y / 8);
        MapPt( ptlMulti[1] );

        ptlMulti[2].x = delta_x * 6 + (LONG) (delta_x * 1 / 8);
        ptlMulti[2].y = delta_y * 1 + (LONG) (delta_y / 2);
        MapPt( ptlMulti[2] );

        ptlMulti[3].x = delta_x * 5 + (LONG) (delta_x * 1 / 2);
        ptlMulti[3].y = (LONG) (delta_y / 8 * 7);
        MapPt( ptlMulti[3] );

        ptlMulti[4].x = delta_x * 4 + (LONG) (delta_x * 7 / 8);
        ptlMulti[4].y = delta_y * 1 + (LONG) (delta_y / 2);
        MapPt( ptlMulti[4] );

        ptlMulti[5].x = delta_x * 6 + (LONG) (delta_x * 1 / 8);
        ptlMulti[5].y = delta_y * 1 + (LONG) (delta_y / 2);
        MapPt( ptlMulti[5] );

        ptlMulti[6].x = delta_x * 5 + (LONG) (delta_x / 2);
        ptlMulti[6].y = delta_y * 2 + (LONG) (delta_y / 8);
        MapPt( ptlMulti[6] );

        ptlMulti[7].x = delta_x * 5 + (LONG) (delta_x * 1 / 2);
        ptlMulti[7].y = (LONG) (delta_y / 8 * 7);
        MapPt( ptlMulti[7] );

        GpiMove( hPS, &ptlMulti[0] );
        GpiPolyLine( hPS, 8L, ptlMulti );

        GpiCloseFigure(hPS);
        GpiEndPath(hPS);
        GpiStrokePath(hPS, 1L, 0L);


}

