/***************************************************************************
 *
 * Module name:   gpipclip.c
 *
 * Purpose:       This module is called by the PTT to test GpiSetClipPath()
 *
 * Revision Log:  04/04/91, Tim Seevers
 *                - High level design complete
 *                04/05/91, Tim Seevers
 *                - Coding begins
 *
 ***************************************************************************/

#define INCL_WIN      /* win function definitions */
#define INCL_GPI      /* all gpi specific definitions */
#define INCL_ERRORS
#include <string.h>
#include <os2.h>
#include <stdio.h>
#include <malloc.h>
#include "PTTDLLDF.h" // test case defines
#include "gpipclip.h"  // gpi path dll header file
#include "gpi_grid.h" // gpi standard grid functions header file
#include "std_util.h" // standard screen text functions header file
#include "tgraphic.h"

VOID APIENTRY InitTest(PVOID sel, PTESTINITINFO pInitInfo)
  {

    /**** Initialize total number of tests in test case ****/
    pInitInfo->ntests = NTESTS;

    /**** Load test names and entry point addresses ****/
    strcpy(pInitInfo->group_name,"GPI PathClip");
    strcpy(pInitInfo->test_names[0],"GpiSetClipPathPre");
    pInitInfo->test_addrs[0]=GpiSetClipPathPre;
    strcpy(pInitInfo->test_names[1],"GpiSetClipPathApp1");
    pInitInfo->test_addrs[1]=GpiSetClipPathApp1;
    strcpy(pInitInfo->test_names[2],"GpiSetClipPathApp2");
    pInitInfo->test_addrs[2]=GpiSetClipPathApp2;
    strcpy(pInitInfo->test_names[3],"GpiSetClipPathApp3");
    pInitInfo->test_addrs[3]=GpiSetClipPathApp3;
    strcpy(pInitInfo->test_names[4],"GpiSetClipPathExh1");
    pInitInfo->test_addrs[4]=GpiSetClipPathExh1;
    strcpy(pInitInfo->test_names[5],"GpiSetClipPathExh2");
    pInitInfo->test_addrs[5]=GpiSetClipPathExh2;
    strcpy(pInitInfo->test_names[6],"GpiSetClipPathExh3");
    pInitInfo->test_addrs[6]=GpiSetClipPathExh3;
    strcpy(pInitInfo->test_names[7],"GpiSetClipPathExh4");
    pInitInfo->test_addrs[7]=GpiSetClipPathExh4;
    strcpy(pInitInfo->test_names[8],"GpiSetClipPathExh5");
    pInitInfo->test_addrs[8]=GpiSetClipPathExh5;
    strcpy(pInitInfo->test_names[9],"GpiSetClipPathExh6");
    pInitInfo->test_addrs[9]=GpiSetClipPathExh6;

    InitTestSegVars(sel);
  }

 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathPre
 *
 ***************************************************************************/

VOID APIENTRY GpiSetClipPathPre(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL ptlTemp, ptlBox, ptlMove;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathPre - Entry.\n");

     lErrorCount = 0L;

     set_delta(hPS);
     gpi_grid( hPS, (LONG) INCH );

     ptlTemp.x = delta_x * 4 + (LONG) (delta_x / 8);
     ptlTemp.y = delta_y * 3 + (LONG) (delta_y / 2);
     MapPt( ptlTemp );
     GpiCharStringAt( hPS, &ptlTemp, 25L, "1 INCH x 1 INCH CLIP PATH" );

     ptlBox.x = delta_x * 3;
     ptlBox.y = delta_y * 3;
     MapPt( ptlBox );

     ptlMove.x = delta_x * 4;
     ptlMove.y = delta_y * 4;
     MapPt( ptlMove );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathPre");
          return;
        }


     GpiMove( hPS, &ptlMove );
     GpiBox( hPS, DRO_OUTLINE, &ptlBox, 0L, 0L );


        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathPre");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathPre");
           return;
        }

     ptlBox.x = delta_x * 4;
     ptlBox.y = delta_y * 4;
     MapPt( ptlBox );
     ptlMove.x = delta_x * 1;
     ptlMove.y = delta_y * 1;
     MapPt( ptlMove );

     GpiMove( hPS, &ptlMove );
     GpiBox( hPS, DRO_FILL, &ptlBox, 0L, 0L );

     if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathPre                                    -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathPre                                  -    PASS.\n");

      CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathPre - Exit.\n");

      } /* end the ELSE */
} /* end GpiSetClipPathPre */
 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathApp1
 *
 * Revision Log:04/04/91, Tim Seevers
 *              - High level design complete
 *              04/05/91, Tim Seevers
 *              - Coding begins
 *              08/12/91, Vish (Boca)
 *               Added char box sizing.
 *               Changed value of ptl.y in the while statement from 1000 to 3000
 *               1000 was not filling in the clip path for lot of drivers
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathApp1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;
  LONG   lcid=253;
  static  FATTRS Fattr;
  FONTMETRICS *pfm;
  LONG    lIndex;
  LONG    lNumFonts=0;
  SIZEF  sizfCharBox;
  LONG    PubFonts=0;
  LONG    lReturned=0;
  LONG    lMaxBaselineExtent=0;
  LONG    ltop=1000;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {


     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathApp1 - Entry.\n");

     set_delta(hPS);
     lErrorCount = 0L;


  if( DeviceIsPrinter() )
  {
    ltop = MapY( delta_y*8 );

    // Query PUBLIC fonts
    if ((lNumFonts = GpiQueryFonts(hPS,
                                  QF_PUBLIC,
                                  NULL, &PubFonts,
                                  0L, NULL)) == GPI_ALTERROR)
      BADERROR("GpiQueryFonts", TRUE, "GpiSetClipPathApp1");

    // Keep number of PUBLIC fonts
    PubFonts = lNumFonts;



    // Allocate storage for "PubFonts" font metrics
    if ((pfm=(PFONTMETRICS)malloc((SHORT)PubFonts*sizeof(FONTMETRICS)))==NULL)
      BADERROR("malloc", TRUE, "GpiSetClipPathApp1");

    // Call GpiQueryFonts again to request "Number" fonts and their
    // metrics to be returned in the space pointed to by "pfm"
    if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,NULL,
                                  &PubFonts,
                                  (LONG)sizeof(FONTMETRICS),
                                  pfm)) == GPI_ALTERROR){
      BADERROR("GpiQueryFonts", TRUE, "GpiSetClipPathApp1");
      free(pfm);
    }

    for (lIndex=0; lIndex < PubFonts; lIndex++) {

//TSS...increment lIndex if on segment boarder.
    if( (lIndex != 315) && (lIndex != 630) && (lIndex != 945) && (lIndex != 1260) && (lIndex != 0) )
         lIndex += 1;

      // Set up the FATTRS structure with appropriate values
      // that you need to pass to GpiCreateLogFont
      Fattr.usRecordLength = sizeof(Fattr);
      Fattr.lMatch         = pfm[lIndex].lMatch;
      strcpy(Fattr.szFacename,pfm[lIndex].szFacename);

      if( Fattr.lMatch < 0 )  {
        if ((lNumFonts=GpiCreateLogFont(hPS,(PSTR8)"COURIER",lcid,&Fattr))==GPI_ERROR)
        BADERROR("GpiCreateLogFont", TRUE, "GpiSetClipPathApp1");
        lMaxBaselineExtent = pfm->lMaxBaselineExt;
        break;
        }

      }


      // Added char box sizing -- Vish

        sizfCharBox.cx = 8L<<16;
        sizfCharBox.cy = 20L<<16;
        GpiSetCharBox( hPS, &sizfCharBox );


   } // end of if Device is Printer



     tFullArc2( hPS, 1, 3, ptl );
     tFullArc2( hPS, 3, 3, ptl );
     tFullArc2( hPS, 5, 3, ptl );


        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathApp1");
          return;
        }

        tFullArc2( hPS, 1, 3, ptl );
        tFullArc2( hPS, 3, 3, ptl );
        tFullArc2( hPS, 5, 3, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathApp1");
          return;
        }

         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
          BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathApp1");
           return;
        }

        if (!GpiSetCharSet(hPS,lcid))
        BADERROR("GpiSetCharSet", TRUE, "GpiSetClipPathApp1");

        ptl.x = 0;
        ptl.y = 0;
        if( lMaxBaselineExtent == 0 ) lMaxBaselineExtent = 16;


        // Changed value of ptl.y in the while statement from 1000 to 3000
        // 1000 was not filling in the clip path for lot of drivers. -Vish

        while( ptl.y < 3000 ) {
           GpiCharStringAt(hPS, &ptl, 230L, "DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT-DEVICE FONT");
           ptl.y += lMaxBaselineExtent;
           }

        free(pfm);

    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathApp1                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathApp1                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathApp1 - Exit.\n");


  } /* end the ELSE */
} /* end GpiSetClipPathApp1 */

 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathApp2()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathApp2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptlSpline[12], ptl, ptlBox, ptlMv; /* changed for metaware 11 - 12 */
  LONG    uX, uY;
  LONG    uCHS;
  LONG    Y;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathApp2 - Entry.\n");

     set_delta(hPS);

     lErrorCount = 0L;




     for (uX=0; uX<=11; uX++) {
        ptlSpline[uX].x = (LONG) (delta_x / 2 * uX);
     } /* endfor */

     uCHS = 1;


     for (uY=0; uY<=11; uY++) {
        if( (uY==2) || (uY==5) || (uY==8) || (uY==11) ) ptlSpline[uY].y = delta_y * 3;
        else {
        ptlSpline[uY].y = delta_y * 3 + (LONG) (delta_y * uY / 2 * uCHS);
        uCHS *= -1;
        }
     } /* endfor */


        MapPt( ptlSpline[0]);
        MapPt( ptlSpline[1]);
        MapPt( ptlSpline[2]);
        MapPt( ptlSpline[3]);
        MapPt( ptlSpline[4]);
        MapPt( ptlSpline[5]);
        MapPt( ptlSpline[6]);
        MapPt( ptlSpline[7]);
        MapPt( ptlSpline[8]);
        MapPt( ptlSpline[9]);
        MapPt( ptlSpline[10]);
        MapPt( ptlSpline[11]);


        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathApp1");
          return;
        }


        tFullArc( hPS, 1, 5, ptl );
        tFullArc( hPS, 2, 5, ptl );
        tFullArc( hPS, 2, 5, ptl );
        tFullArc( hPS, 3, 5, ptl );
        tFullArc( hPS, 4, 5, ptl );
        tFullArc( hPS, 4, 5, ptl );
        tFullArc( hPS, 5, 5, ptl );
        tFullArc( hPS, 6, 5, ptl );
        tFullArc( hPS, 6, 5, ptl );

        tLineSquare( hPS, 6, 1, ptl );
        tLineSquare( hPS, 6, 2, ptl );
        tLineSquare( hPS, 6, 2, ptl );
        tLineSquare( hPS, 6, 3, ptl );
        tLineSquare( hPS, 6, 4, ptl );
        tLineSquare( hPS, 6, 4, ptl );


        ptl.y = delta_y * 3;
        ptl.x = 0;
        MapPt( ptl );
        GpiMove( hPS, &ptl );

        GpiPolySpline( hPS, 12L, ptlSpline );

        ptlMv.x = (LONG) (delta_x / 2 * 11);
        ptlMv.y = delta_y * 3;
        MapPt( ptlMv );

        ptlBox.x = 0;
        ptlBox.y = delta_y * 1;
        MapPt( ptlBox );

        GpiMove( hPS, &ptlMv );
        GpiBox( hPS, DRO_OUTLINE, &ptlBox, 0L, 0L );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathApp1");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathApp1");
           return;
        }



     ptl.y = 0;
     ptl.x = delta_x * 6;
     MapPt( ptl );
     GpiMove( hPS, &ptl );

     ptlBox.x = delta_x * 7;
     ptlBox.y = delta_y * 5;
     MapPt( ptlBox );
     GpiSetPattern( hPS, PATSYM_DIAG1 );
     GpiBox( hPS, DRO_OUTLINEFILL, &ptlBox, 0L, 0L );
     GpiSetPattern( hPS, PATSYM_DEFAULT );



     ptl.y = 0;
     ptl.x = 0;
     MapPt( ptl );
     GpiMove( hPS, &ptl );

     ptlBox.x = (LONG) (delta_x / 2 * 11);
     ptlBox.y = delta_y * 5;
     MapPt( ptlBox );
     GpiBox( hPS, DRO_OUTLINEFILL, &ptlBox, 0L, 0L );




  for (Y=1; Y<=20; Y++) {

     ptl.x = delta_x * 0;
     ptl.y = delta_y * 5 + (LONG) (delta_y / Y * 3) - (LONG) (delta_y / 8);
     MapPt( ptl );
     GpiMove( hPS, &ptl );

     ptl.x = delta_x * 10;
     ptl.y = delta_y * 5 + (LONG) (delta_y / Y * 3) - (LONG) (delta_y / 8) ;
     MapPt( ptl );
     GpiLine( hPS, &ptl );

  } /* endfor */





    if (lErrorCount != 0) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathApp2                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathApp2                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathApp2 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathApp2 */


 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathApp3
 *
 * Revision Log:04/04/91, Tim Seevers
 *              - High level design complete
 *              04/05/91, Tim Seevers
 *              - Coding begins
 *              08/12/91, Vish (Boca)
 *               Changed value of ptl.y in the while statement from 1000 to 3000
 *               1000 was not filling in the clip path for lot of drivers
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathApp3(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;
  LONG   lcid=253;
  static FATTRS Fattr2;
  FONTMETRICS  *pfm;
  LONG    lIndex;
  LONG    lNumFonts=0;
  LONG    PubFonts=0;
  LONG    lReturned=0;
  LONG    lMaxBaselineExtent=0;
  LONG    ltop=1000;


  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {


     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathApp3 - Entry.\n");

     set_delta(hPS);
     lErrorCount = 0L;

  if( DeviceIsPrinter() )
  {
    ltop = MapY( delta_y*8 );

    // Query PUBLIC fonts
    if ((lNumFonts = GpiQueryFonts(hPS,
                                  QF_PUBLIC,
                                  NULL, &PubFonts,
                                  0L, NULL)) == GPI_ALTERROR)
      BADERROR("GpiQueryFonts", TRUE, "GpiSetClipPathApp3");

    // Keep number of PUBLIC fonts
    PubFonts = lNumFonts;



    // Allocate storage for "PubFonts" font metrics
    if ((pfm=(PFONTMETRICS)malloc((SHORT)PubFonts*sizeof(FONTMETRICS)))==NULL)
      BADERROR("malloc", TRUE, "GpiSetClipPathApp3");



    // Call GpiQueryFonts again to request "Number" fonts and their
    // metrics to be returned in the space pointed to by "pfm"
    if ((lReturned = GpiQueryFonts(hPS,QF_PUBLIC,NULL,
                                  &PubFonts,
                                  (LONG)sizeof(FONTMETRICS),
                                  pfm)) == GPI_ALTERROR){
      BADERROR("GpiQueryFonts", TRUE, "GpiSetClipPathApp3");
      free(pfm);
    }

    for (lIndex=0; lIndex < PubFonts; lIndex++) {

//TSS...increment lIndex if on segment boarder.
    if( (lIndex != 315) && (lIndex != 630) && (lIndex != 945) && (lIndex != 1260) )
         lIndex += 1;

      if( pfm[lIndex].lMatch > 0 )  {

        lIndex += 4;   //skip the first few system fonts

        // Set up the FATTRS structure with appropriate values
        // that you need to pass to GpiCreateLogFont
        Fattr2.usRecordLength = sizeof(Fattr2);
        Fattr2.lMatch         = pfm[lIndex].lMatch;
        strcpy(Fattr2.szFacename,pfm[lIndex].szFacename);

        if ((lNumFonts=GpiCreateLogFont(hPS,(PSTR8)"COURIER",lcid,&Fattr2))==GPI_ERROR)
        BADERROR("GpiCreateLogFont", TRUE, "GpiSetClipPathApp3");
        lMaxBaselineExtent = pfm->lMaxBaselineExt;
        break;
        }

      }

  }  //End of if for Device is Display

     tFullArc2( hPS, 1, 3, ptl );
     tFullArc2( hPS, 3, 3, ptl );
     tFullArc2( hPS, 5, 3, ptl );


        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathApp3");
          return;
        }

        tFullArc2( hPS, 1, 3, ptl );
        tFullArc2( hPS, 3, 3, ptl );
        tFullArc2( hPS, 5, 3, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathApp3");
          return;
        }

         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
          BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathApp3");
           return;
        }

        if (!GpiSetCharSet(hPS,lcid))
        BADERROR("GpiSetCharSet", TRUE, "GpiSetClipPathApp3");

        ptl.x = 0;
        ptl.y = 0;
        if( lMaxBaselineExtent == 0 ) lMaxBaselineExtent = 16;

        // Changed value of ptl.y in the while statement from 1000 to 3000
        // 1000 was not filling in the clip path for lot of drivers. -Vish
        while( ptl.y < 3000 ) {
           GpiCharStringAt(hPS, &ptl, 203L, "SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT-SYSTEM FONT");
           ptl.y += lMaxBaselineExtent;
           }

        free(pfm);

    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathApp3                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathApp3                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathApp3 - Exit.\n");


  } /* end the ELSE */
} /* end GpiSetClipPathApp3 */


 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathExh1()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh1(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh1 - Entry.\n");

     set_delta(hPS);

     lErrorCount = 0L;

        tFullArc( hPS, 1, 1, ptl );
        tFullArc( hPS, 3, 1, ptl );
        tFullArc( hPS, 5, 1, ptl );
        tFullArc( hPS, 1, 3, ptl );
        tFullArc( hPS, 3, 3, ptl );
        tFullArc( hPS, 5, 3, ptl );
        tFullArc( hPS, 1, 5, ptl );
        tFullArc( hPS, 3, 5, ptl );
        tFullArc( hPS, 5, 5, ptl );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 22L, "PATH WITH NINE CIRCLES" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh1");
          return;
        }

        tFullArc( hPS, 1, 1, ptl );
        tFullArc( hPS, 3, 1, ptl );
        tFullArc( hPS, 5, 1, ptl );
        tFullArc( hPS, 1, 3, ptl );
        tFullArc( hPS, 3, 3, ptl );
        tFullArc( hPS, 5, 3, ptl );
        tFullArc( hPS, 1, 5, ptl );
        tFullArc( hPS, 3, 5, ptl );
        tFullArc( hPS, 5, 5, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh1");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh1");
           return;
        }


        tClipMe( hPS );




    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh1                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh1                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh1 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh1 */
 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathExh2()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh2(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh2 - Entry.\n");

     set_delta(hPS);

     lErrorCount = 0L;


        tPartialArc( hPS, 1, 1, ptl );
        tPartialArc( hPS, 3, 1, ptl );
        tPartialArc( hPS, 5, 1, ptl );
        tPartialArc( hPS, 1, 3, ptl );
        tPartialArc( hPS, 3, 3, ptl );
        tPartialArc( hPS, 5, 3, ptl );
        tPartialArc( hPS, 1, 5, ptl );
        tPartialArc( hPS, 3, 5, ptl );
        tPartialArc( hPS, 5, 5, ptl );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 27L, "PATH WITH NINE PARTIAL ARCS" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh2");
          return;
        }

        tPartialArc( hPS, 1, 1, ptl );
        tPartialArc( hPS, 3, 1, ptl );
        tPartialArc( hPS, 5, 1, ptl );
        tPartialArc( hPS, 1, 3, ptl );
        tPartialArc( hPS, 3, 3, ptl );
        tPartialArc( hPS, 5, 3, ptl );
        tPartialArc( hPS, 1, 5, ptl );
        tPartialArc( hPS, 3, 5, ptl );
        tPartialArc( hPS, 5, 5, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh2");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh2");
           return;
        }


         tClipMe( hPS );


    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh2                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh2                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh2 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh2 */

 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathExh3()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh3(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl, ptlArc[3];
  CHAR    out_string[50];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh3 - Entry.\n");

     set_delta(hPS);

     lErrorCount = 0L;


        tPointArc( hPS, 1, 1, ptl, ptlArc );
        tPointArc( hPS, 3, 1, ptl, ptlArc );
        tPointArc( hPS, 5, 1, ptl, ptlArc );
        tPointArc( hPS, 1, 3, ptl, ptlArc );
        tPointArc( hPS, 3, 3, ptl, ptlArc );
        tPointArc( hPS, 5, 3, ptl, ptlArc );
        tPointArc( hPS, 1, 5, ptl, ptlArc );
        tPointArc( hPS, 3, 5, ptl, ptlArc );
        tPointArc( hPS, 5, 5, ptl, ptlArc );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 25L, "PATH WITH NINE POINT ARCS" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh3");
          return;
        }

        tPointArc( hPS, 1, 1, ptl, ptlArc );
        tPointArc( hPS, 3, 1, ptl, ptlArc );
        tPointArc( hPS, 5, 1, ptl, ptlArc );
        tPointArc( hPS, 1, 3, ptl, ptlArc );
        tPointArc( hPS, 3, 3, ptl, ptlArc );
        tPointArc( hPS, 5, 3, ptl, ptlArc );
        tPointArc( hPS, 1, 5, ptl, ptlArc );
        tPointArc( hPS, 3, 5, ptl, ptlArc );
        tPointArc( hPS, 5, 5, ptl, ptlArc );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh3");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh3");
           return;
        }



       tClipMe( hPS );


    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh3                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh3                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh3 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh3 */


 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathExh4()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh4(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;
  CHAR    out_string[50];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh4 - Entry.\n");

     set_delta(hPS);

        tBox( hPS, 1, 1, ptl );
        tBox( hPS, 3, 1, ptl );
        tBox( hPS, 5, 1, ptl );
        tBox( hPS, 1, 3, ptl );
        tBox( hPS, 3, 3, ptl );
        tBox( hPS, 5, 3, ptl );
        tBox( hPS, 1, 5, ptl );
        tBox( hPS, 3, 5, ptl );
        tBox( hPS, 5, 5, ptl );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 20L, "PATH WITH NINE BOXES" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh4");
          return;
        }

        tBox( hPS, 1, 1, ptl );
        tBox( hPS, 3, 1, ptl );
        tBox( hPS, 5, 1, ptl );
        tBox( hPS, 1, 3, ptl );
        tBox( hPS, 3, 3, ptl );
        tBox( hPS, 5, 3, ptl );
        tBox( hPS, 1, 5, ptl );
        tBox( hPS, 3, 5, ptl );
        tBox( hPS, 5, 5, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh4");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh4");
           return;
        }


        tClipMe( hPS );



    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh4                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh4                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh4 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh4 */


 /****************************************************************************
 *
 * Routine name:  GpiSetClipPathExh5()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh5(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl;
  CHAR    out_string[50];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh5 - Entry.\n");

     set_delta(hPS);

     lErrorCount = 0L;



        tLineSquare( hPS, 1, 1, ptl );
        tLineSquare( hPS, 3, 1, ptl );
        tLineSquare( hPS, 5, 1, ptl );
        tLineSquare( hPS, 1, 3, ptl );
        tLineSquare( hPS, 3, 3, ptl );
        tLineSquare( hPS, 5, 3, ptl );
        tLineSquare( hPS, 1, 5, ptl );
        tLineSquare( hPS, 3, 5, ptl );
        tLineSquare( hPS, 5, 5, ptl );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 25L, "PATH WITH NINE LINE BOXES" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh5");
          return;
        }

        tLineSquare( hPS, 1, 1, ptl );
        tLineSquare( hPS, 3, 1, ptl );
        tLineSquare( hPS, 5, 1, ptl );
        tLineSquare( hPS, 1, 3, ptl );
        tLineSquare( hPS, 3, 3, ptl );
        tLineSquare( hPS, 5, 3, ptl );
        tLineSquare( hPS, 1, 5, ptl );
        tLineSquare( hPS, 3, 5, ptl );
        tLineSquare( hPS, 5, 5, ptl );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh5");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh5");
           return;
        }


        tClipMe( hPS );


    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh5                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh5                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh5 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh5 */


 /***************************************************************************
 *
 * Routine name:  GpiSetClipPathExh6()
 *
 ***************************************************************************/
VOID APIENTRY GpiSetClipPathExh6(HPS hPS,HWND hWndClient,BOOL SelectionCall)
{
  POINTL  ptl, ptlShape[5];
  CHAR    out_string[50];

  if (SelectionCall) {
    WinSendMsg (hWndClient, WM_PTHREAD_DOES_DEVCALLS, NULL, NULL);
    *pBasisX = 10000;
    *pBasisY = 10000;
  }
  else {
     TEST_SIGNATURE(0,0);
     LOG_SIGNATURE;
     CWRITELOG(L_LOTRACE, 0, "+ee+ GpiSetClipPathExh6 - Entry.\n");

     lErrorCount = 0L;
        set_delta(hPS);

        tPolySquare( hPS, 1, 1, ptl, ptlShape );
        tPolySquare( hPS, 3, 1, ptl, ptlShape );
        tPolySquare( hPS, 5, 1, ptl, ptlShape );
        tPolySquare( hPS, 1, 3, ptl, ptlShape );
        tPolySquare( hPS, 3, 3, ptl, ptlShape );
        tPolySquare( hPS, 5, 3, ptl, ptlShape );
        tPolySquare( hPS, 1, 5, ptl, ptlShape );
        tPolySquare( hPS, 3, 5, ptl, ptlShape );
        tPolySquare( hPS, 5, 5, ptl, ptlShape );
        tLabel( hPS );

        ptl.x = delta_x * 2;
        ptl.y = delta_y * 6 + (LONG) (delta_y / 3);
        MapPt( ptl );
        GpiCharStringAt( hPS, &ptl, 29L, "PATH WITH NINE POLYLINE BOXES" );

        if (GpiBeginPath(hPS, 1L) == FALSE)
        {
          BADERROR("GpiBeginPath", TRUE, "GpiSetClipPathExh6");
          return;
        }

        tPolySquare( hPS, 1, 1, ptl, ptlShape );
        tPolySquare( hPS, 3, 1, ptl, ptlShape );
        tPolySquare( hPS, 5, 1, ptl, ptlShape );
        tPolySquare( hPS, 1, 3, ptl, ptlShape );
        tPolySquare( hPS, 3, 3, ptl, ptlShape );
        tPolySquare( hPS, 5, 3, ptl, ptlShape );
        tPolySquare( hPS, 1, 5, ptl, ptlShape );
        tPolySquare( hPS, 3, 5, ptl, ptlShape );
        tPolySquare( hPS, 5, 5, ptl, ptlShape );

        if (GpiEndPath(hPS) == FALSE)
        {
          BADERROR("GpiEndPath", TRUE, "GpiSetClipPathExh6");
          return;
        }


         if (GpiSetClipPath( hPS, 1L, SCP_ALTERNATE | SCP_AND ) == FALSE) {
           BADERROR("GpiSetClipPath", TRUE, "GpiSetClipPathExh6");
           return;
        }


        tClipMe( hPS );


    if (lErrorCount) {
       sprintf(out_string,"$ERRORCOUNT = %ld.\n",lErrorCount);
       CWRITELOG(L_HDR,0,out_string);
       CWRITELOG(L_HDR,0,
       "$GpiSetClipPathExh6                                   -    FAIL.\n");
    }
    else
       CWRITELOG(L_HDR,0,
         "$GpiSetClipPathExh6                                 -    PASS.\n");

        CWRITELOG(L_LOTRACE, 0, "+ex+ GpiSetClipPathExh6 - Exit.\n");
  } /* end the ELSE */
} /* end GpiSetClipPathExh6 */
