#define INCL_WIN
#define INCL_DEV
#define INCL_GPI
#define INCL_ERRORS    // PM error definitions
#define INCL_DOSMEMMGR
#include <string.h>
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include "PTTDLLDF.h"
#include "std_util.h"

#define LCID_FIXED10   1L

static SHORT sFontSize[6] = {80, 100, 120, 140, 180, 240};
static CHAR *szFacename[4] = {"System Proportional", "Courier", "Helv", "Tms Rmn"};
// static LONG alMatch[4][6]; BSC-Never Used
static LONG MyMatch;
static LONG MyAveCharWidth;
static CHAR MyFacename[FACESIZE];

/***************************************************************************
 *\\ddd
 * Subtask Name:  PDVT
 *
 * Module name:  std_util.c
 *
 * Purpose:  This module contains general purpose text output functions.
 *           This module also sets global variables delta_x, delta_y,
 *           pg_size_x, pg_size_y (and others) for the current device,
 *           to be used by all tests producing output.
 *
 * Revision Log:  10/20/90, PDVT, Kim Cairns
 *                   - Initial creation
 *                01/09/91, PDVT, Kim Cairns
 *                   - added bad_error function
 *                   - added easyfont code
 *                01/11/91, PDVT, Kim Cairns
 *                   - Minor corrections and added line_space variable
 *                01/22/91, PDVT, Donna Williams
 *                   - modified std_util package
 *
 * Contents: MapAndWriteString(),
 *           WriteString()
 *           set_delta()         - sets global variables and returns hDC
 *           MapArrayOfPoints()
 *
 * Design Overview:  The functions contained in this module are used so that
 *              text appears the same on any given printer or output display.
 *              This is done by assuring that, if possible, the same font and
 *              font size is used for every output device.
 *              This module has been designed to be linked with any GPI
 *              or GRE DLL which produces output to the screen or printer.
 *
 * Limitations:  If the device does not support the default output font, then
 *               output may differ for that device.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\ddd
 * Routine Name: MapAndWriteString()
 *
 * Purpose: Map the given points then output the text string.
 *
 * System Requirements: NONE
 *
 * Revision Log: 01/08/91, PDVT, Frederik Johannessen
 *                     - initial function
 *
 * Inputs:   hPS        - presentation space handle
 *           x          - unmapped x coordinate
 *           y          - unmapped y coordinate
 *           out_str    - output string
 *
 * Outputs:  NONE.
 *
 * Subroutines Required: WriteString
 *
 * Limitations:  NONE.
 *
 *\\end
 ***************************************************************************/
/****************************************************************************
 *\\algorithm
 *  Map x coordinate
 *  Map y coordinate
 *  Output string
 *\\end
 ***************************************************************************/
VOID APIENTRY MapAndWriteString(HPS hPS, LONG x, LONG y, char *out_str)
{
  WriteString (hPS, (LONG)(MapX(x)), (LONG)(MapY(y)), out_str);
}

/****************************************************************************
 *\\ddd
 * Routine Name: WriteString()
 *
 * Purpose:  Output a text string using GpiCharStringAt in a standard font.
 *
 * System Requirements: NONE
 *
 * Revision Log: 01/08/91, PDVT, Frederik Johannessen
 *                     - initial function
 *               01/11/91, PDVT, Kim Cairns
 *                     - modified so screen and printer use same font
 *
 * Inputs:   hPS        - presentation space handle
 *           x          - x coordinate
 *           y          - y coordinate
 *           out_str    - output string
 *
 * Outputs:  NONE.
 *
 * Subroutines Required:  GpiCharStringAt
 *
 * Limitations:  If the device does not support the default output font
 *               (10 point Courier) then output may differ for this device.
 *
 *\\end
 ***************************************************************************/

/****************************************************************************
 *\\algorithm
 *  Search for 10 point Courier font on this device
 *  If font does not exist, then
 *    search for any 10 point font
 *
 *    If 10 point font does not exist Then
 *       use default font
 *    Endif
 *  Endif
 *
 *  ptl.x = x
 *  ptl.y = y
 *  GpiCharStringAt(hPS, &ptl, strlen(out_str), out_str);
 *\\end
 ***************************************************************************/
VOID APIENTRY WriteString(HPS hPS, LONG x, LONG y, char *out_str)
{
  POINTL ptl;



//  Added to ensure that default is selected
  GpiSetCharSet(hPS, LCID_DEFAULT);

  ptl.x = x;
  ptl.y = y;
  GpiCharStringAt (hPS, &ptl, (LONG) strlen(out_str), out_str);

  GpiSetCharSet(hPS, LCID_DEFAULT);
}

 /***************************************************************************
 *\\ddd
 * Routine name:  QueryCourFonts
 *
 * Purpose:  This is a function to query available fonts in order to find a
 *           standard fixed 10 pitch font.
 *
 * System Requirements:  None
 *
 * Revision Log:  01/16/91, PDVT, Kim Cairns
 *                - modified EzfQueryFonts to create standard font routine
 *
 * Inputs:     hPS            - presentation space handle
 *
 * Outputs:    TRUE if useable font(s) available
 *             FALSE if all font(s) too large
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 * for all fonts
 *   query font information
 *   if resolution is compatible
 *      if type is fixed
 *         if no special options (italic, bold, ...)
 *            if AveCharWidth closer to 1/10in than previous value
 *               set appropriate global variables to use in CreateCourFont
 * return TRUE
 *
 *\\end
 ***************************************************************************/
BOOL QueryCourFonts (HPS hps)
{
  FONTMETRICS  *pfm;
//  void         *pmem; BSC-Never Used
  HDC         hdc;
  LONG        lHorzRes, lVertRes, lRequestFonts, lNumberFonts, lPelsPerInch;
  SHORT       sIndex;
  SHORT       sTemp;

  hdc = GpiQueryDevice(hps);
  DevQueryCaps(hdc, CAPS_HORIZONTAL_FONT_RES, 1L, &lHorzRes);
  DevQueryCaps(hdc, CAPS_VERTICAL_FONT_RES, 1L, &lVertRes);

  lPelsPerInch = hori_pels_per_m * 254 / 10000;  // # of pels per hori. inch
  MyAveCharWidth = 99L;                          // initialize to high value

  MyFacename[0] = '\0'; // initialize face name to null string
                        // per Vish.
  lRequestFonts = 0;
  lNumberFonts = GpiQueryFonts(hps, QF_PUBLIC, NULL,
                                  &lRequestFonts, 0L, NULL);


  pfm = malloc ((SHORT) lNumberFonts*sizeof(FONTMETRICS));



  if (pfm == NULL)
     return FALSE;
  GpiQueryFonts(hps, QF_PUBLIC, NULL, &lNumberFonts,
                   (LONG) sizeof (FONTMETRICS), pfm);

  /*
   * Loop through all the fontmetrics structures, searching each record
   * for the desired attributes.
   */
  for (sIndex = 0; sIndex < (SHORT) lNumberFonts; sIndex++)
     /*
      * Compatible resolution
      */
//TSS...increment sIndex if on segment boarder.
    if( (sIndex == 315) || (sIndex == 630) || (sIndex == 945) || (sIndex == 1260) )
         sTemp = sIndex - 1;
    else
         sTemp = sIndex;

     if (pfm[sTemp].sXDeviceRes == (SHORT) lHorzRes &&
         pfm[sTemp].sYDeviceRes == (SHORT) lVertRes)
         {
            /*
             * Fixed space
             */
            if (pfm[sTemp].fsType == FM_TYPE_FIXED)
            {
              /*
               * No special options (italic, bold,...)
               */
              if (pfm[sTemp].fsSelection == 0x0000)
              {
                 /*
                  * AveCharWidth closer to 1/10in than previous value
                  */
                 if (abs((SHORT) (pfm[sTemp].lAveCharWidth - lPelsPerInch/10))
                     < abs((SHORT) (MyAveCharWidth - lPelsPerInch/10)))
                 {
                    /*
                     * Set values to create logical font with
                     */
                    MyMatch = pfm[sTemp].lMatch;
                    MyAveCharWidth = pfm[sTemp].lAveCharWidth;
                    strcpy (MyFacename, pfm[sTemp].szFacename);
                 } /* endif */
              } /* endif */
           } /* endif */
         } /* endif */
  free(pfm);
  return TRUE;
}
 /***************************************************************************
 *\\ddd
 * Routine name:  CreateCourFont
 *
 * Purpose:  This is a function to create a fixed 10 pitch logical font
 *
 * System Requirements:  None
 *
 * Revision Log:  01/16/91, PDVT, Kim Cairns
 *                - modified EzfCreateLogFont to create standard font
 *
 * Inputs:     hPS            - presentation space handle
 *             lcid           - font id
 *
 * Outputs:    The lcid of the selected font.
 *
 * Subroutines Required: None
 *
 * Limitations: None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   set FATTRS value from global variables set by QueryCourFonts
 *   GpiCreateLogFont for desired criteria and return lcid
 *
 *\\end
 ***************************************************************************/
LONG CreateCourFont(HPS hps, LONG lcid)
{
  static FATTRS fat;

  /*
   * Use values set in QueryCourFonts
   */
  fat.lMatch = MyMatch;
  fat.usRecordLength = sizeof(FATTRS);
  fat.lAveCharWidth = MyAveCharWidth;
  strcpy(fat.szFacename, MyFacename);

  return GpiCreateLogFont(hps, NULL, lcid, &fat);
}
 /***************************************************************************
 *\\ddd
 * Routine name:  bad_error
 *
 * Purpose:  This is a function to report unexpected errors.
 *
 * System Requirements:  None
 *
 * Revision Log:  01/04/91, PDVT, Kim Cairns
 *                - initial function design
 *                01/09/91, PDVT, Kim Cairns
 *                - enhanced and made common code
 *
 * Inputs:
 *             hWndClient     - client window handle
 *             func_name      - failing function name
 *             do_return      - boolean value for exiting test:
 *                              TRUE  - write exiting statement to log
 *                              FALSE - return 1L to increment error count
 *             entry_point    - entry point where failure occurred
 *
 * Outputs:
 *             0L if do_return == TRUE
 *             1L if do_return == FALSE
 *
 * Subroutines Required:
 *             REPORTSETUPERROR()
 *             CWRITELOG()
 *
 * Limitations:
 *             None
 *
 *\\end
 ***************************************************************************/
/***************************************************************************
 *\\algorithm
 *
 *   REPORTSETUPERROR
 *   Write pertinent information to log
 *
 *   If test will be exiting, write exit info to log
 *   Else return 1L to be added to lErrorCount
 *
 *\\end
 ***************************************************************************/
LONG bad_error(HWND hWndClient,
                        CHAR *func_name, BOOL do_return, CHAR *entry_point)
{
  char  error_string[80];

  REPORTSETUPERROR(func_name);


  if (do_return)
  {
    sprintf(error_string, "+ex+ %s - Exit\n", entry_point);
    CWRITELOG(L_LOTRACE,0, error_string);
  }
  else
  {
    return(1L);
  }

  return(0L);

} /* end bad_error */
